
//-----------------------------------------初始化方法及页面加载方法-------------------------------------------
function Initialization(name) {
    //先清除对应div中的html代码
    $(name).empty();

    var main = '<div class="container-fluid" style="background:#edededa1;"><div class="row">';
    main += leftToolbar();
    main += centerMain();
    main += rightAttribute();
    main += '</div></div><div class="dragControl"></div>';
    main += '<div class="previewMain"></div>';

    //添加基本的界面布局
    $(name).append(main);

    $(".interval").css("height",document.body.offsetHeight+"px");//初始化高度，跟浏览器可视高度一致
}

//左侧工具栏
function leftToolbar() {
    //<!--左侧工具栏-->
    var str = '<div class="col-lg-3 mainbackground">';
    str += '<div class="interval">';
    str += '<p class="questionnaireTitle">工具栏</p><div class="aaa" style="display:none;">预览</div>';
    str += '<div class="row">';
    //文本框
    str += '<div class="col-lg-6">';
    str += '<div class="controlName" data-type="text">';
    str += '<div class="controlImgName"><img src="../images/icon_ps.png" alt="图片"></div>';
    str += '<div class="controlRealName">文本框</div>';
    str += '</div></div>';
    //多行文本框
    str += '<div class="col-lg-6">';
    str += '<div class="controlName" data-type="multiple">';
    str += '<div class="controlImgName"><img src="../images/icon_ps.png" alt="图片"></div>';
    str += '<div class="controlRealName">多行文本框</div>';
    str += '</div></div>';
    //时间框
    str += '<div class="col-lg-6">';
    str += '<div class="controlName" data-type="date">';
    str += '<div class="controlImgName"><img src="../images/icon_ps.png" alt="图片"></div>';
    str += '<div class="controlRealName">时间框</div>';
    str += '</div></div>';
    //单选框
    str += '<div class="col-lg-6">';
    str += '<div class="controlName" data-type="radio">';
    str += '<div class="controlImgName"><img src="../images/icon_ps.png" alt="图片"></div>';
    str += '<div class="controlRealName">单选框</div>';
    str += '</div></div>';
    //复选框
    str += '<div class="col-lg-6">';
    str += '<div class="controlName" data-type="checkbox">';
    str += '<div class="controlImgName"><img src="../images/icon_ps.png" alt="图片"></div>';
    str += '<div class="controlRealName">复选框</div>';
    str += '</div></div>';
    //下拉框
    str += '<div class="col-lg-6">';
    str += '<div class="controlName" data-type="dropdown">';
    str += '<div class="controlImgName"><img src="../images/icon_ps.png" alt="图片"></div>';
    str += '<div class="controlRealName">下拉框</div>';
    str += '</div></div>';
    //文本下拉框
    str += '<div class="col-lg-6">';
    str += '<div class="controlName" data-type="textdropdown">';
    str += '<div class="controlImgName"><img src="../images/icon_ps.png" alt="图片"></div>';
    str += '<div class="controlRealName">文本下拉框</div>';
    str += '</div></div>';
    //图片上传
    str += '<div class="col-lg-6">';
    str += '<div class="controlName" data-type="img">';
    str += '<div class="controlImgName"><img src="../images/icon_ps.png" alt="图片"></div>';
    str += '<div class="controlRealName">图片上传</div>';
    str += '</div></div>';
    //文件上传
    str += '<div class="col-lg-6">';
    str += '<div class="controlName" data-type="file">';
    str += '<div class="controlImgName"><img src="../images/icon_ps.png" alt="图片"></div>';
    str += '<div class="controlRealName">文件上传</div>';
    str += '</div></div>';
    str += '</div></div></div>';
    return str;
}


//中部控件主体
function centerMain() {
    //<!--中间内容区域-->
    var str = '<div class="col-lg-6 mainbackground ">';
    str += '<div class="interval centerMain">';
    str += '<p class="questionnaireTitle tableTitle">新建调查问卷</p>';
    //<!--主体部分-->
    str += '<div class="questionnaireSubject">';
    str += '<form class="questionnaireSubjectForm"></form>';
    str += '</div></div></div>';
    return str;
}


//右侧属性栏
function rightAttribute() {
    //<!--右侧属性框-->
    var str = '<div class="col-lg-3 mainbackground">';
    str += '<div class="interval">';
    str += '<p class="questionnaireTitle">属性栏</p>';
    //<!--文本属性-->
    str += '<div class="questionnaireAttribute" data-type="text">                             <div class="form-group">                                 <label>控件名称</label>                                 <input type="text" class="form-control controlAttributeName">                             </div>                             <div class="form-group">                                 <label>默认值</label>                                 <input type="text" class="form-control textDetailsName">                             </div>                             <div class="form-group">                                 <label>限制</label>                                 <select class="form-control limitSelect">                                     <option value="">无</option>                                     <option value="'+numberRegExp+'">数字</option>                                     <option value="'+ letterRegExp +'">字母</option>                                     <option value="'+chineseRegExp+'">中文</option>                                     <option value="'+emailRegExp+'">邮箱</option>                                     <option value="'+mobileRegExp+'">手机号</option>                                     <option value="'+idRegExp+'">身份证</option>                                     <option value="auto">自定义</option>                                 </select>                                 <input type="text" class="form-control textRegularCustom" name=""                                     placeholder="请输入正则表达式">                             </div>                             <div class="form-group">                                 <label>此题</label>                                 <div class="row">                                     <div class="col-lg-6">                                         <div class="form-check">                                             <label class="form-check-label">                                                 <input type="radio" class="form-check-input" name="ChoiceRadio"                                                     value="0" >                                                 必填                                             </label>                                         </div>                                     </div>                                     <div class="col-lg-6">                                         <div class="form-check">                                             <label class="form-check-label">                                                 <input type="radio" class="form-check-input" name="ChoiceRadio"                                                     value="1">                                                 选填                                             </label>                                         </div>                                     </div>                                 </div>                             </div>                         </div>';
    //<!--多行文本属性-->
    str += '<div class="questionnaireAttribute" data-type="multiple">                             <div class="form-group">                                 <label>控件名称</label>                                 <input type="text" class="form-control controlAttributeName">                             </div>                             <div class="form-group">                                 <label>默认值</label>                                 <input type="text" class="form-control textDetailsName">                             </div>                             <div class="form-group">                                 <label>高度</label>                                 <input type="number" class="form-control multipleHeight">                             </div>                             <div class="form-group">                                 <label>此题</label>                                 <div class="row">                                     <div class="col-lg-6">                                         <div class="form-check">                                             <label class="form-check-label">                                                 <input type="radio" class="form-check-input" name="ChoiceRadio"                                                     value="0" >                                                 必填                                             </label>                                         </div>                                     </div>                                     <div class="col-lg-6">                                         <div class="form-check">                                             <label class="form-check-label">                                                 <input type="radio" class="form-check-input" name="ChoiceRadio"                                                     value="1">                                                 选填                                             </label>                                         </div>                                     </div>                                 </div>                             </div>                         </div>';
    //<!--时间属性-->
    str += '<div class="questionnaireAttribute" data-type="date">                     <div class="form-group">                         <label>控件名称</label>                         <input type="text" class="form-control controlAttributeName">                     </div>                     <div class="form-group">                         <label>默认值</label>                         <input type="date" class="form-control textDetailsName">                     </div>                     <div class="form-group">                         <label>此题</label>                         <div class="row">                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="0" >                                         必填                                     </label>                                 </div>                             </div>                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="1">                                         选填                                     </label>                                 </div>                             </div>                         </div>                     </div>                 </div>';
    //<!--单选属性-->
    str += '<div class="questionnaireAttribute" data-type="radio">                     <div class="form-group">                         <label>控件名称</label>                         <input type="text" class="form-control controlAttributeName">                     </div>                     <div class="form-group">                         <label>单选框选项（一行一个选项）</label>                         <textarea class="form-control selectAttr" rows="5"></textarea>                     </div>                     <div class="form-group">                         <label>此题</label>                         <div class="row">                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="0" >                                         必填                                     </label>                                 </div>                             </div>                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="1">                                         选填                                     </label>                                 </div>                             </div>                         </div>                     </div>                 </div>';
    //<!--复选属性-->
    str += '<div class="questionnaireAttribute" data-type="checkbox">                     <div class="form-group">                         <label>控件名称</label>                         <input type="text" class="form-control controlAttributeName">                     </div>                     <div class="form-group">                         <label>复选框选项（一行一个选项）</label>                         <textarea class="form-control selectAttr" rows="5"></textarea>                     </div>                     <div class="form-group">                         <label>此题</label>                         <div class="row">                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="0" >                                         必填                                     </label>                                 </div>                             </div>                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="1">                                         选填                                     </label>                                 </div>                             </div>                         </div>                     </div>                 </div>';
    //<!--下拉框属性-->
    str += '<div class="questionnaireAttribute" data-type="dropdown">                     <div class="form-group">                         <label>控件名称</label>                         <input type="text" class="form-control controlAttributeName">                     </div>                     <div class="form-group">                         <label>下拉框选项（一行一个选项）</label>                         <textarea class="form-control selectAttr" rows="5"></textarea>                     </div>                     <div class="form-group">                         <label>此题</label>                         <div class="row">                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="0" >                                         必填                                     </label>                                 </div>                             </div>                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="1">                                         选填                                     </label>                                 </div>                             </div>                         </div>                     </div>                 </div>';
    //<!--文本下拉框属性-->
    str += '<div class="questionnaireAttribute" data-type="textdropdown">                     <div class="form-group">                         <label>控件名称</label>                         <input type="text" class="form-control controlAttributeName">                     </div>                     <div class="form-group">                         <label>文本下拉框选项（一行一个选项）</label>                         <textarea class="form-control selectAttr" rows="5"></textarea>                     </div>                     <div class="form-group">                         <label>此题</label>                         <div class="row">                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="0" >                                         必填                                     </label>                                 </div>                             </div>                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="1">                                         选填                                     </label>                                 </div>                             </div>                         </div>                     </div>                 </div>';
    //<!--图片框属性-->
    str += '<div class="questionnaireAttribute" data-type="img">                     <div class="form-group">                         <label>控件名称</label>                         <input type="text" class="form-control controlAttributeName">                     </div>                     <div class="form-group">                         <label>上传数量</label>                         <input type="number" class="form-control uploadNum">                     </div>                     <div class="form-group">                         <label>此题</label>                         <div class="row">                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="0" >                                         必填                                     </label>                                 </div>                             </div>                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="1">                                         选填                                     </label>                                 </div>                             </div>                         </div>                     </div>                 </div> ';
    //<!--文件框属性-->
    str += '<div class="questionnaireAttribute" data-type="file">                     <div class="form-group">                         <label>控件名称</label>                         <input type="text" class="form-control controlAttributeName">                     </div>                     <div class="form-group">                         <label>上传数量</label>                         <input type="number" class="form-control uploadNum">                     </div>                     <div class="form-group">                         <label>此题</label>                         <div class="row">                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="0" >                                         必填                                     </label>                                 </div>                             </div>                             <div class="col-lg-6">                                 <div class="form-check">                                     <label class="form-check-label">                                         <input type="radio" class="form-check-input" name="ChoiceRadio"                                             value="1">                                         选填                                     </label>                                 </div>                             </div>                         </div>                     </div>                 </div>';
    str += '</div></div>';
    return str;
}



//-----------------------------------------中部控件的显示方法-------------------------------------------
//文本框
function getText() {
    var str = '<!--具体的表单控件 文本框-->';
    str += '<div class="row"><div class="questionnaireItem" data-type="text" data-choice="true" data-limit="" data-limiterror="" >';
    //'<!--表单控件的头部-->';
    str += '<div class="questionnaireItemHead">';
    //'<!--表单控件的名称-->';
    str += '<div class="required">*</div><div class="questionnaireItemName">文本框</div>';
    //'<!--表单控件的功能按钮-->';
    str += '<div class="questionnaireItemGroupButton">';
    str += '<button type="button" class="btn btn-primary controlMove">移动</button>';
    str += '<button type="button" class="btn btn-primary controlDelete">删除</button>';
    str += '</div></div>';
    //'<!--控件-->';
    str += '<div class="questionnaireItemContent">';
    str += '<div class="form-group hidMargin">';
    str += '<input type="text" class="form-control formVal">';
    str += '</div><div class="errorMain"></div></div></div></div>';
    return str;
}

//多行文本
function getMultiple() {
    //<!--具体的表单控件 多行文本框-->
    var str = '<div class="row"><div class="questionnaireItem" data-type="multiple" data-choice="true" >';
    //<!--表单控件的头部-->
    str += '<div class="questionnaireItemHead">';
    //<!--表单控件的名称-->
    str += '<div class="required">*</div><div class="questionnaireItemName">多行文本框</div>';
    //<!--表单控件的功能按钮-->
    str += '<div class="questionnaireItemGroupButton">';
    str += '<button type="button" class="btn btn-primary controlMove">移动</button>';
    str += '<button type="button" class="btn btn-primary controlDelete">删除</button>';
    str += '</div></div>';
    //<!--控件-->
    str += '<div class="questionnaireItemContent">';
    str += '<div class="form-group hidMargin">';
    str += '<textarea name="" class="form-control formVal" cols="30" rows="5" style="resize: none;"></textarea>';
    str += '</div><div class="errorMain"></div></div></div></div>';
    return str;
}

//时间框
function getDate() {
    //<!--具体的表单控件 时间框-->
    var str = '<div class="row"><div class="questionnaireItem" data-type="date" data-choice="true" >';
    //<!--表单控件的头部-->
    str += '<div class="questionnaireItemHead">';
    //<!--表单控件的名称-->
    str += '<div class="required">*</div><div class="questionnaireItemName">时间框</div>';
    //<!--表单控件的功能按钮-->
    str += '<div class="questionnaireItemGroupButton">';
    str += '<button type="button" class="btn btn-primary controlMove">移动</button>';
    str += '<button type="button" class="btn btn-primary controlDelete">删除</button>';
    str += '</div></div>';
    //<!--控件-->
    str += '<div class="questionnaireItemContent">';
    str += '<div class="form-group hidMargin">';
    str += '<input type="date" class="form-control formVal" name="" placeholder="">';
    str += '</div><div class="errorMain"></div></div></div></div>';
    return str;
}

//单选框
function getRadio() {
    //<!--具体的表单控件 单选框-->
    var str = '<div class="row"><div class="questionnaireItem" data-type="radio" data-choice="true" >';
    //<!--表单控件的头部-->
    str += '<div class="questionnaireItemHead">';
    //<!--表单控件的名称-->
    str += '<div class="required">*</div><div class="questionnaireItemName">单选框</div>';
    //<!--表单控件的功能按钮-->
    str += '<div class="questionnaireItemGroupButton">';
    str += '<button type="button" class="btn btn-primary controlMove">移动</button>';
    str += '<button type="button" class="btn btn-primary controlDelete">删除</button>';
    str += '</div></div>';
    //<!--控件-->
    str += '<div class="questionnaireItemContent">';
    str += '<div class="form-group hidMargin">';
    str += '<div class="form-check">';
    str += '<label class="form-check-label">';
    str += '<input type="radio" class="form-check-input checkMargin" name="selectName" value="选项一">选项一</label></div>';
    str += '<div class="form-check">';
    str += '<label class="form-check-label">';
    str += '<input type="radio" class="form-check-input checkMargin" name="selectName" value="选项二">选项二</label></div>';
    str += '</div><div class="errorMain"></div></div></div></div>';
    return str;
}

//多选框
function getCheckbox() {
    //<!--具体的表单控件 复选框-->
    var str = '<div class="row"><div class="questionnaireItem" data-type="checkbox" data-choice="true" >';
    //<!--表单控件的头部-->
    str += '<div class="questionnaireItemHead">';
    //<!--表单控件的名称-->
    str += '<div class="required">*</div><div class="questionnaireItemName">复选框</div>';
    //<!--表单控件的功能按钮-->
    str += '<div class="questionnaireItemGroupButton">';
    str += '<button type="button" class="btn btn-primary controlMove">移动</button>';
    str += '<button type="button" class="btn btn-primary controlDelete">删除</button>';
    str += '</div></div>';
    //<!--控件-->
    str += '<div class="questionnaireItemContent">';
    str += '<div class="form-group hidMargin">';
    str += '<div class="form-check">';
    str += '<label class="form-check-label">';
    str += '<input type="checkbox" class="form-check-input checkMargin" name="selectName" value="选项一">选项一</label></div>';
    str += '<div class="form-check">';
    str += '<label class="form-check-label">';
    str += '<input type="checkbox" class="form-check-input checkMargin" name="selectName" value="选项二">选项二</label></div>';
    str += '</div><div class="errorMain"></div></div></div></div>';
    return str;
}

//下拉框
function getDropdown() {
    //<!--具体的表单控件 下拉框-->
    var str = '<div class="row"><div class="questionnaireItem" data-type="dropdown" data-choice="true" >';
    //<!--表单控件的头部-->
    str += '<div class="questionnaireItemHead">';
    //<!--表单控件的名称-->
    str += '<div class="required">*</div><div class="questionnaireItemName">下拉框</div>';
    //<!--表单控件的功能按钮-->
    str += '<div class="questionnaireItemGroupButton">';
    str += '<button type="button" class="btn btn-primary controlMove">移动</button>';
    str += '<button type="button" class="btn btn-primary controlDelete">删除</button>';
    str += '</div></div>';
    //<!--控件-->
    str += '<div class="questionnaireItemContent">';
    str += '<div class="form-group hidMargin">';
    str += '<select class="form-control">';
    str += '<option>选项一</option>';
    str += '<option>选项二</option>';
    str += '<option>选项三</option>';
    str += '</select>';
    str += '</div><div class="errorMain"></div></div></div></div>';
    return str;
}

//文本下拉框
function getTextDropdown() {
    //<!--具体的表单控件 文本下拉框-->
    var str = '<div class="row"><div class="questionnaireItem" data-type="textdropdown" data-choice="true" >';
    //<!--表单控件的头部-->
    str += '<div class="questionnaireItemHead">';
    //<!--表单控件的名称-->
    str += '<div class="required">*</div><div class="questionnaireItemName">文本下拉框</div>';
    //<!--表单控件的功能按钮-->
    str += '<div class="questionnaireItemGroupButton">';
    str += '<button type="button" class="btn btn-primary controlMove">移动</button>';
    str += '<button type="button" class="btn btn-primary controlDelete">删除</button>';
    str += '</div></div>';
    //<!--控件-->
    str += '<div class="questionnaireItemContent">';
    str += '<div class="form-group hidMargin">';
    str += '<input type="text" class="form-control selectInput">';
    str += '<div class="selectInputDiv" title="下拉菜单">';
    str += '<p class="selectInputDivP">选项一</p>';
    str += '<p class="selectInputDivP">选项二</p>';
    str += '</div>';
    str += '</div><div class="errorMain"></div></div></div></div>';
    return str;
}

//图片
function getImg() {
    //<!--具体的表单控件 图片-->
    var str = '<div class="row"><div class="questionnaireItem" data-type="img" data-choice="true" data-num="1" >';
    //<!--表单控件的头部-->
    str += '<div class="questionnaireItemHead">';
    //<!--表单控件的名称-->
    str += '<div class="required">*</div><div class="questionnaireItemName">上传图片</div>';
    //<!--表单控件的功能按钮-->
    str += '<div class="questionnaireItemGroupButton">';
    str += '<button type="button" class="btn btn-primary controlMove">移动</button>';
    str += '<button type="button" class="btn btn-primary controlDelete">删除</button>';
    str += '</div></div>';
    //<!--控件-->
    str += '<div class="questionnaireItemContent">';
    str += '<div class="form-group hidMargin">';
    str += '<div class="img-box full">';
    str += '<section class="img-section">';
    str += '<div class="z_photo upimg-div clear">';
    str += '<section class="z_file fl">';
    str += '<div class="z_fileImgDel">删除</div>';
    str += '<img src="../images/a11.png" class="add-img" />';
    str += '<input type="file" name="file" class="file imgFile" value="" accept="image/jpg,image/jpeg,image/png,image/bmp" leipiplugins="imgupload" title="图片上传" />';
    str += '</section></div></section>';
    str += '<div class="imgExplain">支持jpg、jpeg、png、bmp等图片格式</div>';
    str += '<div class="errerClass imgErrer"></div>';
    str += '</div>';
    str += '</div><div class="errorMain"></div></div></div></div>';
    return str;
}

//文件
function getFile() {
    //<!--具体的表单控件 图片-->
    var str = '<div class="row"><div class="questionnaireItem" data-type="file" data-choice="true" data-num="1" >';
    //<!--表单控件的头部-->
    str += '<div class="questionnaireItemHead">';
    //<!--表单控件的名称-->
    str += '<div class="required">*</div><div class="questionnaireItemName">上传文件</div>';
    //<!--表单控件的功能按钮-->
    str += '<div class="questionnaireItemGroupButton">';
    str += '<button type="button" class="btn btn-primary controlMove">移动</button>';
    str += '<button type="button" class="btn btn-primary controlDelete">删除</button>';
    str += '</div></div>';
    //<!--控件-->
    str += '<div class="questionnaireItemContent">';
    str += '<div class="form-group hidMargin">';
    str += '<div class="message">';
    str += '<div class="messagedel">删除</div>';
    str += '<input type="text" name="txt" class="input fileUpload form-control" value="" disabled="disabled" />';
    str += '<input type="button" value="上传文件" size="30" class="liulan fileUploadBtn">';
    str += '<input type="file" name="f" style="height:26px;" class="files leipiplugins fileUploadReal" size="1" leipiplugins="uploadfile" title="文件上传" hidefocus></div>';
    str += '<div class="fileTips">';
    str += '<p>1.上传文档不超过100MB</p>';
    str += '<p>2.为了保证文档能正常使用，我们支持以下格式的文档上传：</p>';
    str += '<p>MS Office文档： doc,docx,ppt,pptx,xls,xlsx,vsd,pot,pps,rtf</p>';
    str += '<p>压缩文档： rar,zip,tar,gz,tgz</p>';
    str += '<p>图片： jpg,jpeg,gif,bmp,png</p>';
    str += '<p>WPS office系列： wps,et,dps</p>';
    str += '<p>PDF： pdf</p>';
    str += '<p>纯文本： txt</p>';
    str += '<p>EPUB： epub</p></div>';
    str += '<div class="errerClass FileErrer"></div>';
    str += '</div><div class="errorMain"></div></div></div></div>';
    return str;
}

function switchType(type) {
    var str;
    switch (type) {
        case "text":
            str = getText();
            break;
        case "multiple":
            str = getMultiple();
            break;
        case "date":
            str = getDate();
            break;
        case "radio":
            str = getRadio();
            break;
        case "checkbox":
            str = getCheckbox();
            break;
        case "dropdown":
            str = getDropdown();
            break;
        case "textdropdown":
            str = getTextDropdown();
            break;
        case "img":
            str = getImg();
            break;
        case "file":
            str = getFile();
            break;
        default :
            str = ""; 
            break;
    }
    return str;
}


//-----------------------------------------全局变量-------------------------------------------
var mouseX ;//鼠标的位置
var mouseY ;//鼠标的位置
var controlHtml;//被选中的控件
var isCanBePlaced = false;//是否可以放置
var isDownControl = false;//是否按下了控件
var formLeft = 0;//form表单的坐标
var formTop = 0;
var formRight = 0;
var formBottom = 0;
var object;//中部控件
var numberRegExp = "^[0-9]+$";//纯数字表达式
var letterRegExp = "^[a-zA-Z]+$";//纯字母
var chineseRegExp = "^[\u4e00-\u9fa5]{0,}$";//中文
var emailRegExp = "^[a-z0-9A-Z]+[- | a-z0-9A-Z . _]+@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-z]{2,}$";//邮箱
var mobileRegExp = "^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|166|198|199|(147))\\d{8}$";//手机号码
var idRegExp = "^((\d{18})|([0-9x]{18})|([0-9X]{18}))$";//身份证



//-----------------------------------------左侧工具栏事件-------------------------------------------
//左侧工具栏鼠标按下控件事件
$("body").on("mousedown", ".controlName", function (e) {
	e.preventDefault();
    mouseX = e.clientX;//获取鼠标所在的x坐标
    mouseY = e.clientY;//获取鼠标所在的y坐标
    controlHtml = $(this).parent().html();
    var style = 'class="controlName controlNameMove" ';
    style += 'style="width:'+$(this).width()+'px;';
    style += 'position: absolute;';
    style += 'background: #fff;';
    style += 'z-index: 100;';
    style += 'top: '+new Number(mouseY - $(this).height()/2)+'px;';
    style += 'left: '+new Number(mouseX- $(this).width()/2)+'px;';
    style += '"';
    controlHtml = controlHtml.replace('class="controlName"',style);
    $(".dragControl").append(controlHtml);
    //获取form的坐标
    var questionnaireSubjectForm = $(".questionnaireSubject");
    formLeft = getRealLocationLeft(questionnaireSubjectForm,0);
    formTop = getRealLocationTop(questionnaireSubjectForm,0);
    formRight = formLeft + questionnaireSubjectForm.width();
    formBottom = formTop + questionnaireSubjectForm.height();
    //按下了控件,触发滑动事件里的效果
    isDownControl = true;
});

//左侧工具栏鼠标松开控件事件
$("body").on("mouseup", ".controlName", function (e) {
	e.preventDefault();
    //松开了控件，不触发滑动事件里的效果
    isDownControl = false;
    var type = $(this).data("type");
    //处于放置的位置才能在中部区域增加控件
    if(isCanBePlaced){
		isCanBePlaced = false;
        var str = switchType(type);

        //获取当前中部控件，删除放置效果及处理单选框多选框name相同的问题
        var item = $(".questionnaireSubjectForm").find(".row");
        var nameArray = new Array();
        var newName = "selectName";
        //单选框和多选框的name重复问题处理
        if(type == "checkbox" || type == "radio"){
            for(var i = 0 ; i < item.length ; i ++){
                if(item.eq(i).find(".questionnaireItem").data("type") == "radio" || item.eq(i).find(".questionnaireItem").data("type") == "checkbox"){
                    var checkMargin = item.eq(i).find(".checkMargin");
                    if(checkMargin!=null && checkMargin.length > 0){
                        var name = checkMargin.eq(0).attr("name");
                        nameArray.push(name);
                    }
                }
            }
            var num = 0;
            while(true){
                num++;
                var indexnum = $.inArray(newName+num, nameArray);
                if(indexnum < 0){
                    newName = newName+num;
                    break;
                }
            }
            str = str.replace(new RegExp('name="selectName"','g'),'name="'+ newName +'"');
        }
        if(item.length > 0){
            //判断是否位置放好了，有时候没有放置在控件上，就放置到最底层
            var isSelectPosition = false;
            for(var i = 0 ; i < item.length ; i ++){
                if(item.eq(i).hasClass("placeLocationBottom")){
                    item.eq(i).after(str);
                    item.eq(i).removeClass("placeLocationBottom");
                    isSelectPosition = true;
                }else if(item.eq(i).hasClass("placeLocationTop")){
                    item.eq(i).before(str);
                    item.eq(i).removeClass("placeLocationTop");
                    isSelectPosition = true;
                }
            }
            if(!isSelectPosition){
                $(".questionnaireSubjectForm").append(str);
            }
        }else{
            $(".questionnaireSubjectForm").append(str);
        }
        $(".questionnaireSubjectForm").removeClass("placeLocationBottom");
        $(".questionnaireSubjectForm").removeClass("placeLocationTop");
    }
    $(".dragControl").empty();
});


//-----------------------------------------中部区域事件-------------------------------------------
//中部控件删除事件
$("body").on("click",".controlDelete",function(){
    var index = $(this).index(".controlDelete");
    $(".questionnaireSubjectForm").children().eq(index).remove();
});

//中部控件按下事件
$("body").on("mousedown",".controlMove",function(e){
	e.preventDefault();
    mouseX = e.clientX;//获取鼠标所在的x坐标
    mouseY = e.clientY;//获取鼠标所在的y坐标
    controlHtml = $(this).parents(".row").html();
    var style = 'class="questionnaireItem questionnaireItemMove" ';
    style += 'style="width:'+$(this).parents(".row").width()+'px;';
    style += 'position: absolute;';
    style += 'background: #fff;';
    style += 'z-index: 100;';
    style += 'top: '+new Number(mouseY - $(this).parents(".row").height()/2)+'px;';
    style += 'left: '+new Number(mouseX- $(this).parents(".row").width()/2)+'px;';
    style += '"';
    controlHtml = controlHtml.replace('class="questionnaireItem"',style);
    controlHtml = '<div class="row">' + controlHtml + '</div>';
    $(".dragControl").append(controlHtml);
    //获取form的坐标
    var questionnaireSubjectForm = $(".questionnaireSubject");
    formLeft = getRealLocationLeft(questionnaireSubjectForm,0);
    formTop = getRealLocationTop(questionnaireSubjectForm,0);
    formRight = formLeft + questionnaireSubjectForm.width();
    formBottom = formTop + questionnaireSubjectForm.height();
    //按下了控件,触发滑动事件里的效果
    isDownControl = true;

    var index = $(this).index(".controlMove");
    $(".questionnaireSubjectForm").children().eq(index).remove();
});

//中部控件松开事件
$("body").on("mouseup",".questionnaireItemMove",function(e){
	e.preventDefault();
    $(this).removeAttr("style");
    var str = $(".questionnaireItemMove").parents(".dragControl").html();
    str = str.replace(" questionnaireItemMove","");

    //获取当前中部控件，删除放置效果
    var item = $(".questionnaireSubjectForm").find(".row");

    //处于放置的位置才能在中部区域增加控件
    if(isCanBePlaced && isDownControl){
        
        if(item.length > 0){
            //判断是否位置放好了，有时候没有放置在控件上，就放置到最底层
            var isSelectPosition = false;
            for(var i = 0 ; i < item.length ; i ++){
                if(item.eq(i).hasClass("placeLocationBottom")){
                    item.eq(i).after(str);
                    item.eq(i).removeClass("placeLocationBottom");
                    isSelectPosition = true;
                }else if(item.eq(i).hasClass("placeLocationTop")){
                    item.eq(i).before(str);
                    item.eq(i).removeClass("placeLocationTop");
                    isSelectPosition = true;
                }
            }
            if(!isSelectPosition){
                $(".questionnaireSubjectForm").append(str);
            }
        }else{
            $(".questionnaireSubjectForm").append(str);
        }
    }else{
        //放置在其他地区时，直接删除样式，添加到最后一个位置
        if(item.length > 0){
            //删除样式
            for(var i = 0 ; i < item.length ; i ++){
                item.eq(i).removeClass("placeLocationBottom");
                item.eq(i).removeClass("placeLocationTop");
            }
        }
        $(".questionnaireSubjectForm").append(str);
    }

    $(".questionnaireSubjectForm").removeClass("placeLocationBottom");
    $(".questionnaireSubjectForm").removeClass("placeLocationTop");
    //松开了控件，不触发滑动事件里的效果
    isDownControl = false;
    $(".dragControl").empty();
});

//中间控件点击事件（显示右侧属性栏）
$("body").on("click",".questionnaireItem",function(){
    object = $(this);
    AttributeShow($(this));
});


//-----------------------------------------右侧属性栏事件-------------------------------------------
//显示属性框的方法
function AttributeShow(object){
    var attribute = $(".questionnaireAttribute");
    for(var i = 0 ; i < attribute.length ; i ++){
        if(attribute.eq(i).data("type") == object.data("type")){
            attribute.eq(i).show();
            //显示控件名称
            $(".controlAttributeName").eq(i).val(object.find(".questionnaireItemName").text());
            //显示默认值
            if(object.data("type") == "text" || object.data("type") == "multiple" || object.data("type") == "date" ){
                attribute.eq(i).find(".textDetailsName").val(object.find(".formVal").val());
            }
            //显示限制条件
            if(object.data("type") == "text"){
                var limit = object.data("limit");
                var optionss = attribute.eq(i).find(".limitSelect option");
                var auto = true;//自定义正则表达式
                for(var k = 0 ; k < optionss.length ; k ++){
                    var op = optionss.eq(k).val();  
                    if(op == limit){
                        optionss.eq(k).prop("selected","selected");
                        auto = false;
                    }else{
                        optionss.eq(k).prop("selected",false);
                    }
                }
                //是自定义表达式
                if(auto){
                    optionss.eq(optionss.length - 1).prop("selected","selected");
                    $(".textRegularCustom").show().text(limit);
                }else{
                    $(".textRegularCustom").hide().text("");
                }
            }
            //显示文件可上传数量
            if(object.data("type") == "img" || object.data("type") == "file"){
                attribute.eq(i).find(".uploadNum").val(object.data("num"));
            }
            //显示下拉框值
            if(object.data("type") == "radio" || object.data("type") == "checkbox" ){
                var inputs = object.find("input");
                var inputval = "";
                for(var j = 0 ; j < inputs.length ; j ++){
                    inputval += inputs.eq(j).val() + "\n";
                }
                attribute.eq(i).find(".selectAttr").val(inputval);
            }else if(object.data("type") == "dropdown"){
                var inputs = object.find("option");
                var inputval = "";
                for(var j = 0 ; j < inputs.length ; j ++){
                    inputval += inputs.eq(j).val() + "\n";
                }
                attribute.eq(i).find(".selectAttr").val(inputval);
            }else if(object.data("type") == "textdropdown"){
                var inputs = object.find(".form-group").find("p");
                var inputval = "";
                for(var j = 0 ; j < inputs.length ; j ++){
                    inputval += inputs.eq(j).text() + "\n";
                }
                attribute.eq(i).find(".selectAttr").val(inputval);
            }
            //显示是否必选
            if(object.data("choice") == true){
                attribute.eq(i).find("input[name='ChoiceRadio']").eq(0).prop("checked","checked");
                object.find(".required").removeClass("requiredHiddle");
            }else{
                attribute.eq(i).find("input[name='ChoiceRadio']").eq(1).prop("checked","checked");
                object.find(".required").addClass("requiredHiddle");
            }
        }else{
            attribute.eq(i).hide();
        }
    }
}

//修改控件名称
$("body").on("change",".controlAttributeName",function(){
    object.find(".questionnaireItemName").text($(this).val());
});

//修改此题是否必选
$("body").on("change","input[name='ChoiceRadio']",function(){
    if($(this).val() == "0"){
        object.find(".required").removeClass("requiredHiddle");
        object.attr("data-choice",true);
        object.data("choice",true)
    }else{
        object.find(".required").addClass("requiredHiddle");
        object.attr("data-choice",false);
        object.data("choice",false)
    }
});

//修改默认值
$("body").on("change",".textDetailsName",function(){
    var val = $(this).val();
    object.find(".formVal").val(val);
});

//修改单选框、复选框、下拉框、文本下拉框的选项值
$("body").on("change",".selectAttr",function(){
    var val = $(this).val();
    if(val!=""){
        var spilts = val.split("\n");
        var inputName = "selectName";
        if(object.data("type") == "radio" || object.data("type") == "checkbox"){
            var checkMargin = object.find(".checkMargin");
            if(checkMargin!=null && checkMargin.length > 0){
                inputName = checkMargin.eq(0).attr("name");
            }
        }
        object.find(".form-group").children().remove();
        var str = '';
        if(object.data("type") == "dropdown"){
            str += '<select class="form-control">';
        }else if(object.data("type") == "textdropdown"){
            str += '<input type="text" class="form-control"><div class="selectInputDiv" title="下拉菜单">';
        }
        for(var i = 0 ; i < spilts.length ; i ++){
            if(spilts[i]!=""){
                str += getMoreHtml(object.data("type"),spilts[i],inputName);
            }
        }
        if(object.data("type") == "dropdown"){
            str += '</select>';
        }else if(object.data("type") == "textdropdown"){
            str += '</div>';
        }
        object.find(".form-group").append(str);
    }
});

//文本框的限制条件
$("body").on("change",".limitSelect",function(){
    var val = $(this).val();
    object.attr("data-limit",val);
    object.data("limit",val);
    var errorTips = RegExpErrorTips(val);
    object.attr("data-limiterror",errorTips);
    object.data("limiterror",errorTips);
    if(val == "auto"){
        $(".textRegularCustom").show();
    }else{
        $(".textRegularCustom").hide();
    }
});

//自定义正则表达式
$("body").on("change",".textRegularCustom",function(){
    object.attr("data-limit",$(this).val());
    object.data("limit",$(this).val());
});

//多行文本框高度
$("body").on("change",".multipleHeight",function(){
    var height = $(this).val();
    object.find(".formVal").height(height);
});

//上传图片和文件的数量
$("body").on("change",".uploadNum",function(){
    object.attr("data-num",$(this).val());
    object.data("num",$(this).val());
});


//-----------------------------------------全局事件-------------------------------------------
//鼠标移动事件
document.onmousemove = function(e){
	e.preventDefault();
    if(isDownControl){
		mouseX = e.clientX;//获取鼠标所在的x坐标
		mouseY = e.clientY;//获取鼠标所在的y坐标
        //让鼠标在控件的中心位置
        var width = $(".controlNameMove").width()/2;
        var height = $(".controlNameMove").height()/2;
        $(".controlNameMove").css("top",mouseY - height + "px").css("left",mouseX - width+"px");
        var widthItem = $(".questionnaireItemMove").width()/2;
        var heightItem = $(".questionnaireItemMove").height()/2;
        $(".questionnaireItemMove").css("top",mouseY - heightItem + "px").css("left",mouseX - widthItem+"px");
        if(formLeft < mouseX && mouseX < formRight && formTop < mouseY && mouseY < formBottom){
            //是否可以放置
            isCanBePlaced = true;
    
            //获取中部的控件
            var item = $(".questionnaireSubjectForm").find(".row");
            if(item.length > 0){
                //先删除放置的位置样式
                for(var i = 0 ; i < item.length ; i ++){
                    item.eq(i).removeClass("placeLocationBottom");
                    item.eq(i).removeClass("placeLocationTop");
                }
                $(".questionnaireSubjectForm").removeClass("placeLocationBottom");
                $(".questionnaireSubjectForm").removeClass("placeLocationTop");

                //判断是否位置放好了，有时候没有放置在控件上，就放置到最底层
                var isSelectPosition = false;
                for(var i = 0 ; i < item.length ; i ++){
                    var itemTop = getRealLocationTop(item.eq(i),0);
                    var itemCenter = itemTop + item.eq(i).height()/2;
                    var itemBottom = itemTop + item.eq(i).height();
                    //根据鼠标和控件的位置，判断是在哪个控件上
                    if(itemTop < mouseY && mouseY < itemCenter){
                        //处于该控件上半部分
                        item.eq(i).addClass("placeLocationTop");
                        isSelectPosition = true;
                    }else if(itemCenter < mouseY && mouseY < itemBottom){
                        //处于该控件下半部分
                        item.eq(i).addClass("placeLocationBottom");
                        isSelectPosition = true;
                    } 
                }
                if(!isSelectPosition){
                    $(".questionnaireSubjectForm").addClass("placeLocationBottom");
                }
            }else{
                $(".questionnaireSubjectForm").addClass("placeLocationTop");
            }
        }else{
            isCanBePlaced = false;
        }
    }
    
}

//获取控件在整个页面中的真实位置X
function getRealLocationLeft(val,left){
    if(val[0].nodeName != "#document"){
        left += val.position().left;
        left = getRealLocationLeft(val.parent(),left);
    }
    return left;
}

//获取控件在整个页面中的真实位置Y
function getRealLocationTop(val,top){
    if(val[0].nodeName != "#document"){
        top += val.position().top;
        top = getRealLocationTop(val.parent(),top);
    }
    return top;
}

//获取中部页面的html
function getCenterHtml(){
    var html = $(".centerMain").html();
    return html;
}

//获取单选框、复选框、下拉框、文本下拉框的html
function getMoreHtml(type,inputval,inputName){
    var str = '';
    if(type == "radio")
    {
        str += '<div class="form-check"><label class="form-check-label"><input type="radio" class="form-check-input checkMargin" name="'+ inputName +'" value="'+ inputval +'">'+inputval+'</label></div>';
    }
    else if(type == "checkbox")
    {
        str += '<div class="form-check"><label class="form-check-label"><input type="checkbox" class="form-check-input checkMargin" name="'+ inputName +'" value="'+inputval+'">'+inputval+'</label></div>';
    }
    else if(type == "dropdown")
    {
        str += '<option>'+ inputval +'</option>';
    }
    else if(type == "textdropdown")
    {
        str += '<p>'+ inputval +'</p>';
    }
    return str;
}

//正则表达式错误提示
function RegExpErrorTips(val){
    var str = "";
    if(val == numberRegExp){
        str = "只能输入纯数字";
    }else if(val == letterRegExp){
        str = "只能输入纯字母";
    }else if(val == emailRegExp){
        str = "只能输入邮箱";
    }else if(val == mobileRegExp){
        str = "只能输入手机号码";
    }else if(val == idRegExp){
        str = "只能输入身份证号码";
    }else if(val == chineseRegExp){
        str = "只能输入中文";
    }
    return str;
}

//预览
$("body").on("click",".aaa",function(){
    var html = getCenterHtml();
    var ch = '<div class="questionnaireItemGroupButton"><button type="button" class="btn btn-primary controlMove">移动</button><button type="button" class="btn btn-primary controlDelete">删除</button></div>';
    html = html.replace(new RegExp(ch,'g'),'');
    $(".previewMain").show();
    $(".previewMain").empty();
    html += '<div style="width:100%;height:70px;line-height:70px;float:left;text-align: center;z-index:100;"><button type="button" class="btn btn-primary btnOk">提交</button><button type="button" class="btn btn-primary btnNo">关闭</button></div>';
    $(".previewMain").append(html);
});

//关闭预览界面
$("body").on("click",".btnNo",function(){
    $(".previewMain").hide();
});