;(function($, window, document, undefined){
	let Upload = function(el, options){
		/* 默认参数设置 */
		this._default = {
		data:[],/* 图片数组 */
		device:null,/* 设备  */
		file_text:true,/* 是否展示图片链接 */
		maxcount:5,/* 最大上传个数 */
		maxSize:5,/* 图片的最大上传大小 */
		ajaxtype:"POST",
		allow:'jpg|jpef|png|image|gif|bmp',
		accept:null,/* image/*, video/*, audio/* 限制file选择 */
		multiple:null,/* 多选上传 */
		capture:false,/* 是否直接打开摄像头  */
		extra:null,/* 其他参数，上传图片时 */
		header:null,/* ajax Header参数 */
		icon:null,/* 自定义上传图标 */
		}
		/* 合并对象 */
		this._options = $.extend(this._default,options);
		
		this.el = el;
		/* 初始化uploadDOM */
		this._container = null;
		/* 初始化input_file */
		this.inputfile = null;
		this._ul = null;
		this._lastli = null;
		this._currentli = null;
		this._self = null;
		this._init();
		
	}
	Upload.prototype = {
		_init:function(){
			let _this = this;
			
			if(!$(_this.el)){
				alert("属性不存在！请检查");
				return false
			}
			_this._self = $(_this.el);
			
			
			_this._container = $('<div class="upload_container"></div>');
			_this._inputfile = $('<input type="file" style="display:none" />');
			/* 配置file上传内容限制 */
			if(_this._options.accept){
				_this._inputfile.attr("accept",_this._options.accept);
			}
			/* 配置是否打开摄像头 */
			if(_this._options.capture){
				_this._inputfile.attr("capture",'camera');
			}
			/* 配置是否多选 */
			if(_this._options.multiple){
				_this._inputfile.attr("multiple",'multiple');
			}
			
			_this._inputfile.appendTo(_this._container);
			
			_this._ul = $('<ul class="upload_ul"></ul>');
			_this.setValue(_this._options.data);
			
			_this._inputfile.off("change").on('change',function(e){
				let files = e.target.files || e.dataTransfer.files;
				let file_len = _this._options.maxcount - _this.filecount();
				let file_num = files.length;
				if(_this._options.multiple){
					file_num = file_len>files.length?files.length:file_len;
				}
				if(file_len > 0){
					for(let i = 0; i < file_num; i++ ){
						if(!_this._options.url){
							alert("请配置上传路由");
							src = window.URL.createObjectURL(files[i]);
							_this.insertli(src);
						}else{
							let image = new Image();
							image.src = window.URL.createObjectURL(files[i])
							image.onload = function(){
								if(_this.validate(files[i],image)){
									let formData = new FormData();
									formData.append('file',files[i]);
									if(_this._options.extra != null && _this._options.extra != undefined){
										for (var j in _this._options.extra) {
										    formdata.append(j, _this._options.extra[j])
										}
									}
									$.ajax({
										url:_this._options.url,
										type:_this._options.ajaxtype,
										data:formData,
										header:header,
										contentType:false,
										processData:false,
										dataType:'json',
										success:function(res){
											_this.callback(res);
										}
									})
								}
							}
						}
					}
				}else{
					alert("上传数量不能超过"+_this._options.maxcount);
				}
			})
		},
		validate:function(file,image){
			let _this = this;
			
			var allow = file.name.substring(file.name.lastIndexOf('.')+1).toLowerCase();
			if(file == null || file  == undefined){
				alert("文件不能为空");
				return false
			}
			if(file.size > _this._options.maxsize){
				alert("上传文件不能超过"+_this._options.maxsize);
				return false
			}
			if(_this._options.allow.indexOf(allow) < 0){
				alert("只允许"+_this._options.allow+"格式文件");
				return false
			}
			if(_this._options.width || _this._options.height){
				if(_this._options.width){
					if(_this._options.width <image.width){
						alert("图片宽度不符合标准")
						return false;
					}
				}
				if(_this._options.height){
					if(_this._options.height <image.height){
						alert("图片高度不符合标准")
						return false;
					}
				}
				if(_this._options.width && _this._options.height){
					if(_this._options.width == _this._options.height){
						if(image.width/image.height !=1){
							alert("请上传宽高一致的图片")
							return false;
						}
					}
					if(_this._options.width != image.width || _this._options.height != image.height){
						alert("请上传宽高符合标准的图片")
						return false;
					}
				}
			}
			return true;
		},
		getValue:function(){
			let _this = this;
			return _this._options.data;
		},
		setValue:function(arr){
			let _this = this;
			if(arr == null || arr == undefined){
				alert("参数不能为空");
				return false
			}
			_this._ul.empty();
			if(arr && arr.length>0){
				for(let i = 0; i< arr.length; i++){
					_this._insertli(arr[i]);
				}
			}
			if(!_this._options.device || _this._options.device === null || _this._options.device === undefined){
				let _upload_bind = $('<div class="upload_bind"></div>');
				if(_this._options.file_text){
					let upload_file_text = $('<input type="text" /> ');
					_upload_bind.append(upload_file_text);
					upload_file_text.off('change').on('change',function(){
						_this.insertli($(this).val());
					})
				}
				let upload_bind_btn = $('<div class="upload_bind_btn">上传图片</div>');
				upload_bind_btn.bind('click',function(){
					_this._inputfile.click()
				})
				_upload_bind.append(upload_bind_btn);
				_upload_bind.appendTo(_this._container);
			}else{
				let upload_li = $('<li class="mobile_upload_bind_btn">上传图片</li>');
				if(_this._options.icon){
					upload_li.html(_this._options.icon);
				}
				upload_li.bind('click',function(){
					_this._inputfile.click()
				})
				upload_li.appendTo(_this._ul);
			}
			_this._ul.appendTo(_this._container);
			
			_this._container.appendTo(_this._self);
			return _this;
		},
		_insertli:function(src){
			let _this = this;
			let li = $('<li></li>');
			let img = new Image();
			img.src = src;
			li.off('click').on('click',function(){
				_this._options.data.splice($(this).index(),1)
				$(this).remove();
			})
			li.append(img);
			_this._ul.append(li);
		},
		insertli:function(src,res){
			let _this = this;
			let li = $('<li></li>');
			let img = new Image();
			img.src = src;
			li.append(img);
			if( _this._options.device){
				_this._ul.find(".mobile_upload_bind_btn").before(li);
			}else{
				_this._ul.append(li);
			}
			_this._options.data.push(src);
			if(_this._options.file_text){
				_this._container.find("div.upload_bind").find("input").val(src);
			}
			li.off('click').on('click',function(){
				_this._options.data.splice($(this).index(),1)
				$(this).remove();
			})
		},
		filecount:function(){
			return this._options.device?$(this._ul).find("li").length-1:$(this._ul).find("li").length;
		},
		callback:function(res){
			let _this = this;
			if(res.code == 0){
				_this.insertli(res.data.url,res.data);
			}else{
				alert(res.message?res.message:'文件上传失败！');
			}
		}
	}
	window.Upload = Upload
})(jQuery, window, document, undefined) 