/* 检测ip类型的输入框的基本操作， 适合dns subnet gateway*/
/**
 * by ljh
 * keyCode对照表
 * A	65	J	74	S	83	1	49
 * B	66	K	75	T	84	2	50
 * C	67	L	76	U	85	3	51
 * D	68	M	77	V	86	4	52
 * E	69	N	78	W	87	5	53
 * F	70	O	79	X	88	6	54
 * G	71	P	80	Y	89	7	55
 * H	72	Q	81	Z	90	8	56
 * I	73	R	82	0	48	9	57
 * 0	96	8	104	F1	112	F7	118
 * 1	97	9	105	F2	113	F8	119
 * 2	98	*	106	F3	114	F9	120
 * 3	99	+	107	F4	115	F10	121
 * 4	100	Enter	108	F5	116	F11	122
 * 5	101	-	109	F6	117	F12	123
 * 6	102	.	110	 	 	 	 
 * 7	103	/	111
 * BackSpace	8	Esc	27	Right Arrow	39	-_	189
 * Tab	9	Spacebar	32	Down Arrow	40	.>	190
 * Clear	12	Page Up	33	Insert	45	/?	191
 * Enter	13	Page Down	34	Delete	46	`~	192
 * Shift	16	End	35	Num Lock	144	[{	219
 * Control	17	Home	36	;:	186	/|	220
 * Alt	18	Left Arrow	37	=+	187	]}	221
 * Cape Lock	20	Up Arrow 38
 */

// 目标样式， 这里是上面的className
var goal = ".IPInput";
// ip输入框的最大值
var ip_max = 255;

// 监听键盘输入事件
$(goal).bind("keydown", function (event) {
    //console.log($(this).attr("id"))
    var code = event.keyCode;
    // 只能输入数字键、删除键、小数点，tab键，其他的都不能输入
    if ((code < 48 && 8 != code && 37 != code && 39 != code && 9 != code) ||
        (code > 57 && code < 96) ||
        (code > 105 && 110 != code && 190 != code)) {
        return false;
    }
    // 如果输入了点，右键 (.)，则直接跳转到下一个输入框并选中值
    if (code == 110 || code == 190 || code == 39 || code == 40) {
        $(this).next().focus()
                      .select();
        return false;
    }
    if (code == 37 || code == 38) {
        $(this).prev().focus()
                      .select();
        return false;
    }
})
// 监听键盘离开事件
$(goal).bind("keyup", function (event) {
    // 判断当前输入框的值
    var code = event.keyCode;
    var value = $(this).val();
    // 如果输入的值大于ip最大值，则去掉最后一位数字
    // if (value != null && value != '' && parseInt(value) > ip_max) {
    //     value = value.substring(0, value.length - 1);
    //     $(this).val(value);
    //     return false;
    // }
    // 如果输入的值大于ip最大值，则默认设置为255
    if (value != null && value != '' && parseInt(value) > ip_max) {
        $(this).val("255");
        return false;
    }
    // 如果输入框的值大于100并且按键不为上下左右点，并且符合规则，则跳转到下一个输入框并选中值
    if ((code !== 9 && code !== 110 && code !== 190 && code !== 39 && code!== 37 && code !== 38 && code !== 40) && value != null && value != '' && parseInt(value) >= 100 && parseInt(value) <= ip_max) {
        $(this).next().focus()
                      .select();
        return false;
    }
    // 判断是否是0开头的不规范数字
    if (value != null && value != '' && parseInt(value) != 0) {
        // 如果当前输入的是0开头，则把0去掉,方法是直接转数字即可
        value = parseInt(value);
        if (isNaN(value)) {
            $(this).val("");
        } else {
            $(this).val("" + value);
        }
    }
})
// 失去焦点事件
$(goal).bind("blur", function () {
    var value = $(this).val();
    // 如果失去焦点，当前的值为0，则加上红色边框，否则去掉红色边框
    if (value == null || value == '' || value == undefined) {
        $(this).css("border-color", "#F08080");
    } else {
        $(this).css("border-color", "");
    }
})