


var vm = new Vue({
    el:'#app',
    data:{
        initList:[],//初始化数据
        initNum:0,//初始化数据总数
        targetList:[],//目标数据
        targetNum:0,//目标数据总数
        leftSelectNum:0,//左侧选中数据
        rightSelectNum:0,//右侧选中数据
        traLeftInput:'',//左边输入框数值
        traRightInput:'',//右边输入框数值
        leftEmpty:false,//左侧数据为空
        rightEmpty:false,//左侧数据为空
        selectIconLeft:"fa fa-square-o",
        selectIconRight:"fa fa-square-o",
        leftDisabled:true,
        rightDisabled:true,
        leftActive:1,
        rightActive:1
    },
    mounted:function(){
        this.init();
    },
    watch:{
        traLeftInput:function (newVal,oldVal) {
            this.initList.map((item)=>{
                if(item.name.indexOf(newVal)!=-1){
                item.isSearch=true
            }else{
                item.isSearch=false
            }
        })

        },
        traRightInput:function (newVal,oldVal) {
            this.targetList.map((item)=>{
                if(item.name.indexOf(newVal)!=-1){
                item.isSearch=true
            }else{
                item.isSearch=false
            }
        })
        },
        initList:{
            handler:function (newVal,oldVal) {
                var len=newVal.filter(item=>item.type);
                if(len.length>0){
                    this.leftDisabled=false;
                }else{
                    this.leftDisabled=true;
                }

                //计算初始化数据长度
                this.initNum=newVal.length;

                //计算选中数据长度
                this.leftSelectNum=newVal.filter(item=>item.type).length;

                //判断数据是否为空
                if(newVal.length>0){
                    this.leftEmpty=false
                }else{
                    this.leftEmpty=true
                }

            },
            deep:true
        },
        targetList:{
            handler:function (newVal,oldVal) {
                var len=newVal.filter(item=>item.type);
                if(len.length>0){
                    this.rightDisabled=false;
                }else{
                    this.rightDisabled=true;
                }

                //计算初始化数据长度
                this.targetNum=newVal.length;

                //计算选中数据长度
                this.rightSelectNum=newVal.filter(item=>item.type).length;

                //判断数据是否为空
                if(newVal.length>0){
                    this.rightEmpty=false;
                }else{
                    this.rightEmpty=true;
                }
            },
            deep:true
        }

    },
    methods: {
        init:function(){
            this.getInitList();
        },
        allInitSelect:function () {
            if(this.selectIconLeft=="fa fa-square-o"){
                this.selectIconLeft="fa fa-check-square-o";
                this.initList.map(item=>{item.type=true})
            }else{
                this.selectIconLeft="fa fa-square-o";
                this.initList.map(item=>{item.type=false});
            }
        },//左侧全选
        allTargetSelect:function () {
            if(this.selectIconRight=="fa fa-square-o"){
                this.selectIconRight="fa fa-check-square-o";
                this.targetList.map(item=>{item.type=true})
            }else{
                this.selectIconRight="fa fa-square-o";
                this.targetList.map(item=>{item.type=false});
            }
        },//右侧全选
        getInitList:function () {
            this.initList=[{id:1,name:'俺6',type:false,isSearch:true,number:6},{id:2,name:'报10',type:false,isSearch:true,number:10},{id:3,name:'菜9',type:false,isSearch:true,number:9},{id:4,name:'名5',type:false,isSearch:true,number:5}];
            // this.initList=[];
            this.targetList=[];
            this.initList=this.sortByName(this.initList,'name');
        },
        selectLeft:function (id) {
            this.initList.map((item)=>{
                if(item.id==id){
                item.type=!item.type
            }
        })
        },
        selectRight:function (id) {
            this.targetList.map((item)=>{
                if(item.id==id){
                item.type=!item.type
            }
        })
        },
        toRight:function () {
            var selArr=this.initList.filter(item=>item.type);
            var noSelArr=this.initList.filter(item=>!item.type);
            this.initList=noSelArr;
            this.targetList=this.targetList.concat(selArr);

            //对目标数据进行重新排序
            if(this.rightActive==1){
                this.targetList=this.sortByName(this.targetList,'name');
            }else{
                this.targetList=this.sortByNumber(this.targetList,'number');
            }

            //将目标数据设置为未选中
            this.targetList.map(item=>{(item.type=false)})


        },
        toLeft:function () {
            var selArr=this.targetList.filter(item=>item.type);
            var noSelArr=this.targetList.filter(item=>!item.type);
            this.targetList=noSelArr;
            this.initList=this.initList.concat(selArr);

            //对初始数据进行重新排序，并将设置为未选中
            if(this.leftActive==1){
                this.initList=this.sortByName(this.initList,'name');
            }else{
                this.initList=this.sortByNumber(this.initList,'number');
            }

            //将初始数据设置为未选中
            this.initList.map(item=>{(item.type=false)})

        },
        changeLeftTab:function (num) {
            this.leftActive=num;
            if(num==1){
                this.initList=this.sortByName(this.initList,'name');
            }else{
                this.initList=this.sortByNumber(this.initList,'number');
            }
        },
        changeRightTab:function (num) {
            this.rightActive=num;
            if(num==1){
                this.targetList=this.sortByName(this.targetList,'name');
            }else{
                this.targetList=this.sortByNumber(this.targetList,'number');
            }
        },
        sortByName:function (arr,type) {
            return arr.sort((a,b)=>{
                return (a[type].localeCompare(b[type]))
            })
        },
        sortByNumber:function (arr,type) {
            return arr.sort((a,b)=>{
                return (a[type]-b[type]>0)
            })
        },
        save:function(){
            if(this.targetList.length){
                let result=[];
                this.targetList.map(item=>{
                    return result.push(item.name)
                })
                alert('获取的值为:'+result.join(','))
            }else{
                alert("获取值为空")
            }
        }
    }


});





