;(function (win, doc) {

    math.config({
        number: 'BigNumber'
    });

    function Stack() {
        var stackArr = [];

        this.push = function (item) {
            stackArr.push(item);
        };

        this.pop = function () {
            return stackArr.pop();
        };
        this.top = function () {
            return stackArr[stackArr.length - 1];
        };
        this.isEmpty = function () {
            return stackArr.length === 0;
        };
        this.size = function () {
            return stackArr.length;
        };
        this.clear = function () {
            stackArr = [];
        }
    }

    win.Stack = Stack;

    /**
     * 判断括号是否成对出现
     * @param str
     * @returns {*}
     */
    function isLegal(str) {


        var stack = new Stack();

        for (var i = 0; i < str.length; i++) {
            var s = str[i];
            if (s === "(") {
                stack.push(s);
            } else if (s === ")") {
                if (stack.isEmpty()) {
                    return false;
                } else {
                    stack.pop();
                }
            }
        }
        return stack.isEmpty();
    }


    /**
     * 计算逆波兰表达式
     * @param exp
     * @returns {*}
     */
    function computeBoLan(exp) {

        var stack = new Stack();
        var res = 0;
        for (var i = 0; i < exp.length; i++) {
            var item = exp[i];
            if (item === "+" || item === "-" || item === "*" || item === "/") {

                var num1 = stack.pop();
                var num2 = stack.pop();


                // if(item==="+"){
                //     res = math.add(num2 , num1);
                // }else if(item==="-"){
                //     res = math.subtract(num2 , num1);
                // }else if(item==="*"){
                //     res = math.multiply(num2 , num1);
                // }else{
                //     res = math.divide(num2 , num1);
                // }

                res = math.parser().eval(num2+item+num1);



                console.log(`计算结果：`+res);

                stack.push(res);
            } else {
                stack.push(item);
            }

        }

        return stack.pop();

    }

    /**
     * 将字符串表达式切割为数组表达式
     */
    function splitExp(str) {
        var res = [];

        if (typeof str !== "string") {
            return str;
        }

        str = str.replace(/0*\./,"0.");
        console.log(str);

        console.log(str.replace(/((^|[^\d\)])-\d+)/g, "$1@"));

        var arr = str.replace(/((^|[^\d\)])-\d+)/g,"$1@").match(/\(|\)|\+|-([0-9\.]+(?=@))?|\*|\/|([0-9\.]+)/g);

        console.log(arr);


        return arr;
    }

    /**
     * 中缀转后缀
     * @param exp
     * @returns {Array}
     */
    function zhongzhui2houzhui(exp) {

        var res = [];
        var stack = new Stack();
        if (!isLegal(exp)) {
            throw new Error("非法中缀表达式");
        }

        exp = splitExp(exp);

        for (var i = 0; i < exp.length; i++) {
            var item = exp[i];


            if (["(", "+", "-", "*", "/", ")"].indexOf(item) >= 0) {//若为符号则走此逻辑

                if (item === "(") {//遇到左括号直接入栈
                    stack.push(item);
                } else if (["+", "-"].indexOf(item) >= 0) {//遇到加号和减号，若栈顶是+-*/中的一个，则直接出栈(原因是运算优先级和先来后到原则)并加入结果数组，直到栈顶元素不再是+-*/中的一个时结束循环

                    while (["*", "/", "+", "-"].indexOf(stack.top()) >= 0) {
                        res.push(stack.pop());
                    }
                    //将当前符号加入栈中
                    stack.push(item);

                } else if (["/", "*"].indexOf(item) >= 0) {
                    //遇到乘号或者除号时将栈顶为同一优先级的符号，即乘号或除号弹出，直至栈顶元素优先级不再与当前运算符优先级相同
                    while (["*", "/"].indexOf(stack.top()) >= 0) {
                        res.push(stack.pop());
                    }
                    //将当前元素压入栈中
                    stack.push(item);
                } else if (item === ")") {
                    //遇到右括号时，弹出栈顶元素，直至遇到左括号为止
                    while (stack.top() !== "(") {
                        res.push(stack.pop());
                    }
                    //将栈顶的左括号弹出后
                    stack.pop();

                }

            } else {//若为数字则直接加入结果数组中
                item = parseFloat(item);
                res.push(item);
            }

        }

        //若栈不为空，则将栈中所有元素弹出加入结果数组
        while (!stack.isEmpty()) {
            res.push(stack.pop());
        }

        return res;

    }

    function KinerCalc() {
        this.result = 0;
    }

    KinerCalc.prototype = {
        constructor: KinerCalc,
        zhongzhui2houzhui: zhongzhui2houzhui,
        computeBoLan: computeBoLan,
        isLegal: isLegal,
        calc: function (str) {



            var res = this.computeBoLan(zhongzhui2houzhui(str));

            return res;
        }
    };


    win.KinerCalc = KinerCalc;

})(window, document);