function cube(cube_class, offset, cube_index) {

	var class_name = "." + cube_class;
	var box_height = $("." + cube_class).height() * 0.5;
	var box_width = $("." + cube_class).width() * 0.5;
	var box_offset = offset;
	var cube_index_num = cube_index;

	var x = 0;
	y = 0;
	z = 0;
	if(box_width != box_height) {
		x = box_height * 2;
		y = x;
		z = (box_width * 2 - box_height * 2) / 2;
	} else {
		y = box_width * 2;
		x = box_height * 2;
	}
	console.log(cube_index_num);
	$(class_name).css({
		"transform-style": "preserve-3d"
	})
	$(class_name + ">div:nth-child(1)").css({
		"transform": "translateZ(" + (box_height + box_offset) + "px) rotateZ(0deg) rotateY(0deg)",

	})
	$(class_name + ">div:nth-child(2)").css({
		"transform": "translateX(" + (box_width + box_offset) + "px) rotateX(0deg) rotateZ(0deg) rotateY(90deg)",
		"width": y + "px",
		"height": x + "px",
		"left": z + "px"

	})
	$(class_name + ">div:nth-child(3)").css({
		"transform": "translateZ(-" + (box_height + box_offset) + "px) rotateZ(0deg) rotateY(180deg)"
	})
	$(class_name + ">div:nth-child(4)").css({
		"transform": "translateX(-" + (box_width + box_offset) + "px) rotateX(0deg) rotateZ(0deg) rotateY(-90deg)",
		"width": y + "px",
		"height": x + "px",
		"left": z + "px"

	})
	$(class_name + ">div:nth-child(5)").css({

		"transform": "translateY(" + (box_height + box_offset) + "px) rotateX(90deg) rotateZ(-180deg) rotateY(180deg)"
	})

	$(class_name + ">div:nth-child(6)").css({
		"transform": "translateY(-" + (box_height + box_offset) + "px) rotateX(90deg) rotateZ(0deg) rotateY(0deg)"
	})

	$(class_name).css("transition", "1s all");
	switch(cube_index_num) {
		case 1:
			$(class_name).css("transform", "rotateX(0deg) rotateY(0deg) rotateZ(0deg)");
			break;
		case 2:
			$(class_name).css("transform", "rotateX(0deg) rotateY(-90deg) rotateZ(0deg)");
			break;
		case 3:
			$(class_name).css("transform", "rotateX(0deg) rotateY(-180deg) rotateZ(0deg)");
			break;
		case 4:
			$(class_name).css("transform", "rotateX(0deg) rotateY(-270deg) rotateZ(0deg)");
			break;
		case 5:
			$(class_name).css("transform", "rotateX(90deg) rotateY(0deg) rotateZ(0deg)");
			break;
		case 6:
			$(class_name).css("transform", "rotateX(-90deg) rotateY(0deg) rotateZ(0deg)");
			break;
		default:
			break;
	}

}