/*
  存储所有地图数据 [[楼层1[背景层],[前景层],[事件层]]]
  背景层：1，fill填充 图块ID 2，图块ID 图块x坐标 图块y坐标
  前景层：图块ID 图块坐标x 图块坐标y
  事件层：Hero 朝向 Hero坐标x Hero坐标y Item 物品ID 物品坐标x 物品坐标y Door 门类型 门坐标x 门坐标y Stair 楼梯上下 楼梯坐标x 楼梯坐标y 传送到的楼层坐标x 传送到的楼层坐标y 传到的楼层朝向 传送到的楼层 是否为传送上楼或下楼时的默认楼梯 0上楼 1下楼
  前景层每个方块第三个参数：0 正常(可破可震不可门) 1 不允许破和震且不允许门 2 允许门且允许破和震 3 允许门但不允许破和震
  怪物事件456参数，4：接触怪物触发 5:战斗完成后触发 6:战斗失败后触发
  1.StartFloor:初始楼层
  2.MapSet:地图变量里面的每个元素都是一层
  3.MapSet=[[[],[],{}]]:这里面包含了一层，每一层又有三个元素，分别是背景数据 前景数据 事件数据(是个对象)
  4.背景数据:有两种形式一种是fill一种是一个个指定，fill就是["fill",5] 这代表用5号terrain元素(这个元素数据记载在IconsData.js中)来填充整个背景，一个个就是[5,0,0],[5,1,0],[5,2,0]....，其实是一个个数组，0号元素代表用几号terrain元素 1号元素代表坐标X 2号元素代表坐标Y
  5.前景数据:与背景数据第二种是同理的， 0号元素代表用几号terrain元素 1号元素代表坐标X 2号元素代表坐标Y，但3号元素有这些含义0 正常(可破可震不可门) 1 不允许破和震且不允许门 2 允许门且允许破和震 3 允许门但不允许破和震
  6.事件数据:
    *ID是按顺序排的
    <1>Floor:代表当前楼层(比如负三楼就是-3) 参数:n
    <2>Name:这层楼的名字 参数:xxxx层
    <3>Arrive:已到达这层楼 参数:true|false
    <4>Animate:绘制动画(如岩浆、星辰) 参数:["Name-Pass",[x,y],[x,y],[x,y]....](Name是资源名 如Lava、Star，Pass是是否允许通过1不允许 0允许，[x,y]x坐标和y坐标数组，代表使用前面指定的资源来绘制到地图中的对应坐标)
    <5>Item:存放该楼层物品数据 参数:[ID,ItemID,X,Y] ID是在该层这些物品数据中的ID ItemID是在所有物品中的ID X和Y代表绘制到那个坐标位置
    <6>Door:门数据 参数:[DoorID,X,Y,Pass(可选)] DoorID就是在所有门里面的ID，Pass是可选的 为1不允许通过 其它允许
    <7>Stair:楼梯数据 参数:[StairType,X,Y,ToX,ToY,ToHead,ToFloor,UporDown(可选)] StairType是楼梯类型(0为上楼梯 1为下楼梯)，ToX和ToY代表传送过去后勇士会在哪个坐标，Head代表勇士传送过去后面向哪里，ToFloor 要传送到哪个楼层(比如-2到负二层)，UporDown通过传送器到这个楼层时判定你会在哪个楼梯口(如果你在这一层的上方传送到这你将会到这个参数为1的楼梯口，如果你在这一层的下面你将会到达这个参数为0的楼梯口)
    <8>Enemy:该层怪物数据 参数:[ID,EnemyID,X,Y,Event1(可选),Event2(可选，但前一个参数不能为空，不想启用前面一个参数请将前一个参数设为-1),Event3(可选，同理前两个参数不能为空，不想启用他们请设-1)] ID 在本层所有怪物中的ID EnemyID 在所有怪物中的ID 除去坐标剩下的后面三个参数可选，一号是触碰怪物后触发，二号是战斗胜利后触发，三号是战斗失败触发 参数为事件列表ID
    <9>Npc:NPC数据 参数:[ID,NpcID,X,Y,EventID] ID是该层NPC的ID NpcID是这个Npc在所有Npc中的ID EventID是和Npc碰撞后触发的事件
    <10>No:该层不允许使用的道具 参数:[ToolsName1,ToolsName2,ToolsName3..] ToolsName:道具名称(在Items.js中记载)
*/
var StartFloor = 1;
var MapSet = [
	[
	  ["fill",5],
	  [[1,4,0,1],[1,6,0,1],[1,4,1,1],[1,6,1,1],[1,4,2,1],[1,6,2,1],[1,3,2,1],[1,7,2,1],[1,3,3,1],[1,7,3,1],[1,3,4,1],[1,7,4,1],[1,7,5,1],[1,3,6,1],[1,7,6,1],[1,4,6,1],[1,6,6,1],[1,4,7,1],[1,6,7,1],[1,4,8,1],[1,6,8,1],[1,4,9,1],[1,6,9,1],[1,4,10,1],[1,6,10,1],[1,5,0,2],[1,5,1,2]],
{"Floor":"Unknown","Name":"未知楼层","Arrive":"No","Animate":["Lava-1",[0,0],[0,1],[0,2],[0,3],[0,4],[0,5],[0,6],[0,7],[0,8],[0,9],[0,10],[1,0],[1,1],[1,2],[1,3],[1,4],[1,5],[1,6],[1,7],[1,8],[1,9],[1,10],[2,0],[2,1],[2,2],[2,3],[2,4],[2,5],[2,6],[2,7],[2,8],[2,9],[2,10],[3,0],[3,1],[3,7],[3,8],[3,9],[3,10],[7,0],[7,1],[7,7],[7,8],[7,9],[7,10],[8,0],[8,1],[8,2],[8,3],[8,4],[8,5],[8,6],[8,7],[8,8],[8,9],[8,10],[9,0],[9,1],[9,2],[9,3],[9,4],[9,5],[9,6],[9,7],[9,8],[9,9],[9,10],[10,0],[10,1],[10,2],[10,3],[10,4],[10,5],[10,6],[10,7],[10,8],[10,9],[10,10]],"Item":[],"Door":[[15,3,5,1],[7,5,6],[3,5,2,1]],"Stair":[[2,5,0,5,10,2,"C",0]],"Enemy":[[0,39,5,5,-1,29],[1,40,5,4,-1,29],[2,41,5,3,-1,29],[3,42,4,3,-1,29],[4,43,6,3,-1,29],[5,44,4,4,-1,29],[6,45,6,4,-1,29],[7,46,4,5,-1,29],[8,47,6,5,-1,29]],"Npc":[],"Event":[],"No":["GoFloor"]}
	],
	[
	  ["fill",5],
	  [],
{"Floor":-1,"Name":"主塔负一层","Arrive":"No","Animate":[],"Item":[],"Door":[],"Stair":[],"Enemy":[[0,48,5,5,31,32]],"Npc":[],"Event":[],"No":["GoFloor"]}
	],
  [
    ["fill",5],
    [[2,1,2],[2,2,1],[2,3,1],[2,4,1],[2,5,1],[2,6,1],[2,7,1],[2,8,1],[2,9,2],[2,1,3],[2,1,4],[2,1,5],[2,1,6],[2,1,7],[2,1,8],[2,2,9],[2,3,9],[2,4,9],[2,5,9],[2,6,9],[2,7,9],[2,8,9],[2,9,8],[2,9,7],[2,9,6],[2,9,5],[2,9,4],[2,9,3],[2,2,2],[2,8,2],[2,8,8],[2,2,8],[2,2,5],[2,3,5],[2,4,5],[2,5,5],[2,6,5],[2,7,5],[2,8,5],[2,5,2],[2,5,3],[2,5,4],[2,5,6],[2,5,7],[2,5,8]],
{"Floor":0,"Name":"主塔零层","Arrive":"No","Animate":[],"Item":[[0,22,3,3],[1,27,7,3],[2,11,3,2],[3,11,4,2],[4,11,2,3],[5,11,2,4],[6,7,4,3],[7,7,4,4],[8,7,3,4],[9,8,6,4],[10,8,6,3],[11,8,7,4],[12,12,6,2],[13,12,7,2],[14,12,8,3],[15,12,8,4],[16,2,4,6],[17,2,6,6],[18,1,3,6],[19,1,4,7],[20,1,7,6],[21,1,6,7],[22,"A6",3,7],[23,"A5",7,7],[24,11,2,6],[25,11,2,7],[26,11,3,8],[27,11,4,8],[28,12,8,6],[29,12,8,7],[30,12,7,8],[31,12,6,8]],"Door":[],"Stair":[[0,0,0,5,10,2,1,1]],"Enemy":[],"Npc":[],"Event":[],"No":["GoFloor"],"Start":-1}
  ],
  [
    ["fill",5],
    [[2,4,0],[2,6,0],[2,4,1],[2,6,1],[2,4,2],[2,6,2],[2,3,2],[2,7,2],[2,3,3],[2,7,3],[2,3,4],[2,7,4],[2,3,5],[2,7,5],[2,3,6],[2,7,6],[2,4,6],[2,6,6],[2,4,7],[2,6,7],[2,4,8],[2,6,8],[2,4,9],[2,6,9],[2,4,10],[2,6,10]],
{"Floor":1,"Name":"主塔一层","Arrive":false,"Animate":["Star-1",[0,0],[0,1],[0,2],[0,3],[0,4],[0,5],[0,6],[0,7],[0,8],[0,9],[0,10],[1,0],[1,1],[1,2],[1,3],[1,4],[1,5],[1,6],[1,7],[1,8],[1,9],[1,10],[2,0],[2,1],[2,2],[2,3],[2,4],[2,5],[2,6],[2,7],[2,8],[2,9],[2,10],[3,0],[3,1],[3,2],[3,7],[3,8],[3,9],[3,10],[7,0],[7,1],[7,2],[7,7],[7,8],[7,9],[7,10],[8,0],[8,1],[8,2],[8,3],[8,4],[8,5],[8,6],[8,7],[8,8],[8,9],[8,10],[9,0],[9,1],[9,2],[9,3],[9,4],[9,5],[9,6],[9,7],[9,8],[9,9],[9,10],[10,0],[10,1],[10,2],[10,3],[10,4],[10,5],[10,6],[10,7],[10,8],[10,9],[10,10]],"Item":[],"Door":[[3,5,2,1]],"Stair":[[0,5,0,5,0,2,2,1],[1,3,5,5,10,2,-1,0]],"Enemy":[[0,0,5,1]],"Npc":[[0,3,5,4,0]],"Event":[],"No":[],"Start":34}
  ],
  [
    ["fill",5],
    [[2,0,1],[2,0,3],[2,2,1],[2,2,3],[2,3,0],[2,3,1],[2,3,2],[2,3,3],[2,4,2],[2,6,2],[2,7,0],[2,7,1],[2,7,2],[2,9,2],[2,9,3],[2,9,4],[2,8,4],[2,7,4],[2,0,5],[2,1,5],[2,2,5],[2,4,5],[2,5,5],[2,5,6],[2,5,7],[2,5,8],[2,5,9],[2,4,9],[2,3,9],[2,1,9],[2,1,8],[2,1,7],[2,1,6],[2,7,6],[2,8,6],[2,10,6],[2,7,7],[2,7,8],[2,8,8],[2,10,8],[2,7,9],[2,7,10],[2,3,7],[2,3,8]],
{"Floor":2,"Name":"主塔二层","Arrive":false,"Animate":[],"Item":[[0,0,8,1,2],[1,1,10,4],[2,0,9,0],[3,12,9,1],[4,11,8,0],[5,8,10,0],[6,7,10,5],[7,0,0,2],[8,11,2,2],[9,7,0,0],[10,8,2,0],[11,1,4,7],[12,8,4,8],[13,1,2,7],[14,7,2,8],[15,0,0,8],[16,26,9,10],[17,11,8,9],[18,11,10,9],[19,8,1,4],[20,12,9,5],[21,11,6,8]],"Door":[[2,5,2],[1,3,5],[0,9,6],[3,9,8,1],[14,2,9],[0,10,2],[0,1,3]],"Stair":[[1,5,0,5,0,2,1,0],[0,0,6,0,5,2,3,1]],"Enemy":[[0,23,8,7,-1,1],[1,23,10,7,-1,1],[2,12,7,5],[3,13,10,1],[4,8,8,3],[5,0,2,10],[6,1,3,10],[7,0,4,10],[8,8,1,2],[9,16,1,1],[10,8,1,0],[11,9,3,6],[12,1,2,4],[13,0,6,7]],"Npc":[[0,0,0,4,3]],"Event":[],"No":[],"Start":-1}
  ],
  [
    ["fill",5],
    [[2,0,4],[2,1,4],[2,2,4],[2,0,6],[6,4,2],[7,6,2],[2,2,3],[2,2,1],[2,4,1],[2,5,1],[2,6,1],[2,7,1],[2,8,1],[2,8,3],[2,8,4],[2,9,4],[2,10,4],[2,3,4],[2,5,4],[2,7,4],[2,5,5],[2,5,6],[2,5,7],[2,5,9],[2,1,6],[2,3,6],[2,3,7],[2,3,8],[2,3,9],[2,3,10],[2,7,6],[2,7,7],[2,7,8],[2,7,9],[2,7,10],[2,9,6],[2,10,6],[2,1,1],[2,9,1],[2,5,0]],
{"Floor":3,"Name":"主塔三层","Arrive":false,"Animate":[],"Item":[[0,21,4,0],[1,"A2",6,0],[2,0,4,6],[3,0,6,6],[4,11,4,7],[5,11,6,7],[6,7,0,9],[7,8,1,10],[8,2,9,10],[9,1,10,9],[10,0,0,2],[11,1,1,3],[12,8,10,2],[13,12,9,3]],"Door":[[7,2,6],[7,8,6],[14,5,8],[14,3,1],[0,2,2],[0,8,2],[1,0,1],[1,10,1],[0,4,4],[1,6,4]],"Stair":[[1,0,5,0,6,2,2,0],[0,10,5,9,9,2,4,1]],"Enemy":[[0,16,1,2],[1,16,9,2],[2,13,2,0],[3,13,8,0],[4,8,3,5],[5,8,7,5],[6,2,4,8],[7,2,6,8],[8,12,5,10],[9,10,2,7],[10,10,8,7],[11,1,5,3]],"Npc":[[0,6,5,2,4],[1,1,0,10,25],[2,2,10,10,26]],"Event":[],"No":[],"Start":-1}
  ],
  [
    ["fill",5],
    [[2,0,2,1],[2,2,2,1],[2,3,0,1],[2,3,1,1],[2,3,2,1],[2,4,2],[2,7,2],[2,7,1],[2,7,0],[2,9,0],[2,9,1],[2,9,2],[2,9,3],[2,9,5],[2,9,6],[2,9,7],[2,10,7],[2,0,4],[2,0,7],[2,2,4],[2,2,7],[2,3,4],[2,3,5],[2,3,6],[2,3,7],[2,3,8],[2,3,9],[2,3,10],[2,5,4],[2,6,4],[2,7,4],[2,7,5],[2,7,6],[2,7,7],[2,7,8],[2,7,10],[2,4,7],[2,5,7],[2,5,8],[2,5,10],[2,0,1],[2,1,0,3],[2,1,1],[2,2,0,3],[2,2,1,3],[2,1,2,1]],
{"Floor":4,"Name":"主塔四层","Arrive":false,"Animate":[],"Item":[[0,0,0,8],[1,0,2,8],[2,2,1,9],[3,11,0,10],[4,11,2,10],[5,12,4,8],[6,12,4,10],[7,7,5,6],[8,8,0,3],[9,11,6,5],[10,7,10,0],[11,12,10,6],[12,0,4,1],[13,0,6,1],[14,12,6,10]],"Door":[[0,1,4],[3,1,7,1],[0,7,9],[0,4,4],[1,8,7],[1,9,4],[1,5,9],[14,6,2]],"Stair":[[1,9,9,10,5,2,3,0],[0,8,0,5,10,2,5,1],[2,2,1,5,10,2,"A"]],"Enemy":[[0,23,0,6,-1,5],[1,23,1,5,-1,5],[2,23,2,6,-1,5],[3,2,8,6],[4,2,6,9],[5,9,4,5],[6,8,4,9],[7,21,5,2],[8,12,6,7],[9,16,8,5],[10,13,8,2],[11,13,3,3],[12,12,10,1],[13,12,10,2],[14,12,10,3],[15,16,10,5]],"Npc":[[0,0,5,0,6]],"Event":[],"No":[],"Start":-1}
  ],
  [
    ["fill",5],
    [[2,4,10],[2,4,9],[2,4,7],[2,4,6],[2,6,10],[2,6,9],[2,6,7],[2,6,6],[2,3,6],[2,1,6],[2,0,6],[2,7,6],[2,9,6],[2,10,6],[2,0,7],[2,0,8],[2,0,9],[2,0,10],[2,1,10],[2,2,10],[2,3,10],[2,7,10],[2,8,10],[2,9,10],[2,10,10],[2,10,9],[2,10,8],[2,10,7],[2,0,0],[2,0,1],[2,0,2],[2,0,3],[2,0,4],[2,1,0],[2,2,0],[2,3,0],[2,4,0],[2,4,1],[2,4,3],[2,4,4],[2,3,4],[2,1,4],[2,6,0],[2,7,0],[2,8,0],[2,9,0],[2,10,0],[2,10,1],[2,10,2],[2,10,3],[2,10,4],[2,9,4],[2,7,4],[2,6,4],[2,6,3],[2,6,1]],
{"Floor":5,"Name":"主塔五层","Arrive":false,"Animate":[],"Item":[],"Door":[[2,5,7],[3,4,8,1],[3,6,8,1],[3,2,6,1],[3,8,6,1],[3,2,4,1],[3,4,2,1],[3,6,2,1],[3,8,4,1]],"Stair":[[1,5,10,8,0,2,4,0],[0,5,0,10,4,2,6,1]],"Enemy":[[1,16,1,8,-1,8],[2,16,2,7,-1,8],[3,16,3,8,-1,8],[4,16,2,9,-1,8],[5,16,1,7,-1,8],[6,16,3,7,-1,8],[7,16,1,9,-1,8],[8,16,3,9,-1,8],[9,16,2,8,-1,8],[10,9,7,7,-1,9],[11,9,8,7,-1,9],[12,9,9,7,-1,9],[13,9,7,8,-1,9],[14,9,8,8,-1,9],[15,9,9,8,-1,9],[16,9,7,9,-1,9],[17,9,8,9,-1,9],[18,9,9,9,-1,9],[19,12,7,1,-1,10],[20,12,8,1,-1,10],[21,12,9,1,-1,10],[22,12,7,2,-1,10],[23,12,8,2,-1,10],[24,12,9,2,-1,10],[25,12,7,3,-1,10],[26,12,8,3,-1,10],[27,12,9,3,-1,10],[28,13,1,1,-1,11],[29,13,2,1,-1,11],[30,13,3,1,-1,11],[31,13,1,2,-1,11],[32,13,2,2,-1,11],[33,13,3,2,-1,11],[34,13,1,3,-1,11],[35,13,2,3,-1,11],[36,13,3,3,-1,11]],"Npc":[],"Event":[[0,5,7,"Npc&12",7]],"No":["GoFloor"],"Start":-1}
  ],
  [
    ["fill",5],
    [[2,0,2],[2,2,2],[2,2,1],[2,3,1],[2,4,1],[2,1,4],[2,2,4],[2,3,4],[2,1,6],[2,2,6],[2,3,6],[2,4,6],[2,1,7],[2,1,8],[2,1,9],[2,1,10],[2,4,8],[2,4,9],[2,4,10],[2,6,0],[2,6,2],[2,6,3],[2,6,4],[2,6,6],[2,6,7],[2,6,8],[2,6,9],[2,7,9,3],[2,8,9],[2,10,9],[2,8,10,3],[2,8,1],[2,8,2],[2,8,3],[2,8,5],[2,8,6],[2,9,2],[2,9,6],[2,10,2],[2,10,6],[2,9,7],[2,3,8],[2,6,1]],
{"Floor":6,"Name":"主塔六层","Arrive":false,"Animate":[],"Item":[[0,"A4",7,10],[1,0,4,0],[2,12,9,10],[3,12,10,10],[4,1,10,0],[5,0,10,1],[6,1,9,1],[7,4,0,0],[8,"A5",2,10],[9,11,3,2],[10,7,1,1],[11,8,2,0],[12,8,3,10],[13,7,2,9],[14,13,3,9],[15,11,8,7],[16,7,7,7],[17,7,8,8],[18,8,7,1],[19,12,1,4],[20,12,1,6],[21,4,2,8]],"Door":[[0,9,9],[1,8,4],[1,8,0],[2,4,7],[1,5,9],[0,1,5],[0,2,5],[0,3,5],[14,1,2],[0,6,5],[14,10,7]],"Stair":[[1,10,4,5,0,2,5,0],[0,0,10,0,6,2,7,1]],"Enemy":[[0,25,6,10],[1,21,9,0],[2,17,3,0],[3,26,3,7],[4,9,9,4],[5,17,7,6],[6,21,2,3],[7,9,1,3],[8,10,1,0],[9,10,0,1],[10,9,3,3],[11,2,5,1],[12,26,2,7],[13,2,0,8],[14,2,0,7],[15,23,7,2],[16,24,5,6],[17,16,4,2]],"Npc":[[0,1,10,7,13],[1,0,9,3,14]],"Event":[],"No":[],"Start":-1}
  ],
  [
    ["fill",5],
    [[2,2,0,1],[2,2,1,1],[2,2,2,1],[2,2,3,1],[2,1,3,1],[2,4,1],[2,4,2],[2,4,3],[2,5,3],[2,6,3],[2,7,3,1],[2,7,2,1],[2,7,1,1],[2,7,0,1],[2,8,3,1],[2,10,3,1],[2,7,4,1],[2,7,5,1],[2,7,6,1],[2,7,7,1],[2,8,8,1],[2,10,8,1],[2,7,8,1],[2,7,9],[2,6,9,1],[2,1,5],[2,1,6],[2,1,7],[2,1,8],[2,1,9],[2,3,5],[2,3,6],[2,3,7],[2,5,7],[2,5,9],[2,3,9],[2,4,9],[2,0,5],[2,4,7]],
{"Floor":7,"Name":"主塔七层","Arrive":false,"Animate":[],"Item":[[0,24,9,6],[1,29,9,1],[2,"A11",5,5],[3,28,6,8],[4,"A8",1,0],[5,13,4,8],[6,2,0,1],[7,2,1,2],[8,11,0,8],[9,0,1,10],[10,8,2,6],[11,8,2,5],[12,12,2,4],[13,11,3,3],[14,7,3,2],[15,7,3,1],[16,12,8,0],[17,12,10,0],[18,12,8,2],[19,12,10,2],[20,8,9,0],[21,8,8,1],[22,8,9,2],[23,8,10,1],[24,11,8,5],[25,11,10,5],[26,11,8,7],[27,11,10,7],[28,7,9,5],[29,7,8,6],[30,7,9,7],[31,7,10,6]],"Door":[[3,9,8,1],[3,9,3,1],[6,5,5,1],[2,0,3],[1,4,0],[0,3,10],[0,7,10],[2,5,8],[1,2,9]],"Stair":[[1,0,6,0,10,2,6,0],[0,5,2,5,10,2,8,1]],"Enemy":[[0,24,8,9,-1,15],[1,24,10,9,-1,15],[2,25,8,4,-1,16],[3,25,10,4,-1,16],[4,29,6,7],[5,30,4,4],[6,30,6,6],[7,30,6,4],[8,30,4,6],[9,26,5,4,-1,17],[10,26,6,5,-1,17],[11,26,5,6,-1,17],[12,26,4,5,-1,17],[13,19,3,8],[14,20,0,2],[15,31,0,0],[16,31,1,1],[17,32,2,7],[18,33,5,10],[19,19,0,9],[20,32,3,0],[21,10,4,10],[22,10,6,10],[23,29,5,1],[24,29,6,2]],"Npc":[[0,0,6,0,18]],"Event":[],"No":[],"Start":-1}
  ],
  [
    ["fill",5],
    [[2,4,1,1],[2,3,2,1],[2,6,1,1],[2,7,2,1],[2,4,3,1],[2,6,3,1],[2,2,3,1],[2,1,4,1],[2,2,4,1],[2,4,4,1],[2,6,4,1],[2,8,3,1],[2,8,4,1],[2,9,4,1],[2,1,6,1],[2,2,6,1],[2,2,7,1],[2,3,7,1],[2,3,8,1],[2,5,8,1],[2,5,7,1],[2,9,6,1],[2,8,6],[2,8,7,1],[2,7,7,1],[2,7,8,1]],
{"Floor":"8","Name":"主塔八层","Arrive":false,"Animate":["Star-1",[5,9],[0,6],[0,7],[0,8],[0,9],[0,10],[1,7],[1,8],[1,9],[1,10],[2,8],[2,9],[2,10],[3,9],[3,10],[10,6],[10,7],[10,8],[10,9],[10,10],[9,7],[9,8],[9,9],[9,10],[8,8],[8,9],[8,10],[7,9],[7,10],[0,0],[0,1],[0,2],[0,3],[0,4],[1,0],[1,1],[1,2],[1,3],[2,0],[2,1],[2,2],[3,0],[3,1],[10,0],[10,1],[10,2],[10,3],[10,4],[9,0],[9,1],[9,2],[9,3],[8,0],[8,1],[8,2],[7,0],[7,1],[4,0],[6,0]],"Item":[],"Door":[[7,4,10],[7,6,10],[3,3,4,1],[3,5,4,1],[3,7,4,1],[3,0,5,1],[3,10,5,1]],"Stair":[[1,5,10,5,2,2,7,0],[0,0,5,10,5,2,"8-1",1],[0,10,5,0,5,2,"8-2",1]],"Enemy":[[0,27,4,8],[1,27,6,8],[2,11,3,3,-1,28],[3,34,7,3,-1,28],[4,35,4,2],[5,35,6,2],[6,31,2,5],[7,18,4,5,-1,27],[8,18,6,5,-1,27],[9,31,8,5],[10,27,4,7],[11,27,6,7],[12,28,5,6,21,22]],"Npc":[[0,13,5,0,19]],"Event":[[0,4,9,"Npc&12",19],[1,6,9,"Npc&12",19],[2,5,2,"Npc&12",20]],"No":["GoFloor"],"Start":-1}
  ],
  [
    ["fill",5],
    [],
{"Floor":"8-1","Name":"主塔八层-左侧层","Arrive":"No","Animate":["Lava-1",[1,4],[2,4],[3,4],[1,5],[3,5],[1,6],[2,6],[3,6],"Star-1",[0,0],[0,1],[0,2],[0,3],[0,4],[0,5],[0,6],[0,7],[0,8],[0,9],[0,10],[1,0],[1,2],[1,3],[1,7],[1,8],[1,10],[2,3],[2,7],[3,0],[3,2],[3,3],[3,7],[3,8],[3,10],[4,0],[4,2],[4,3],[4,4],[4,6],[4,7],[4,8],[4,10],[6,1],[6,2],[6,3],[6,4],[6,5],[6,6],[6,7],[6,8],[6,9],[7,5],[8,2],[8,3],[8,4],[8,5],[8,6],[8,7],[8,8],[10,3],[10,4],[10,6],[10,7],[9,1],[9,9]],"Item":[[0,30,2,5],[1,7,1,1],[2,7,2,0],[2,7,2,2],[3,7,1,9],[4,7,2,8],[5,7,2,10],[6,12,9,0],[7,12,10,0],[8,12,10,1],[9,12,10,10],[10,12,10,9],[13,12,9,10],[14,12,5,1],[15,12,5,2],[16,12,5,9],[17,12,5,8],[18,12,7,4],[19,12,7,6],[20,8,7,3],[21,8,7,7]],"Door":[[3,4,5,1],[1,4,1],[1,4,9],[2,9,5]],"Stair":[[1,10,5,0,5,2,8,0]],"Enemy":[[0,37,6,0],[1,37,6,10],[2,25,5,4,-1,23],[3,25,5,6,-1,23],[4,33,3,1],[5,33,3,9],[6,38,7,2],[7,38,7,8],[8,22,9,7],[9,22,9,3],[10,22,9,4],[11,22,9,6],[12,32,8,1],[13,32,8,9]],"Npc":[],"Event":[],"No":["GoFloor"],"Start":-1}
  ],
  [
    ["fill",5],
    [],
{"Floor":"8-2","Name":"主塔八层-右侧层","Arrive":"No","Animate":["Lava-1",[7,4],[7,5],[7,6],[8,4],[8,6],[9,4],[9,5],[9,6],"Star-1",[0,3],[0,4],[0,6],[0,7],[1,1],[1,9],[2,2],[2,3],[2,4],[2,5],[2,6],[2,7],[2,8],[3,5],[4,1],[4,2],[4,3],[4,4],[4,5],[4,6],[4,7],[4,8],[4,9],[6,0],[6,2],[6,3],[6,4],[6,6],[6,7],[6,8],[6,10],[7,0],[7,2],[7,3],[7,7],[7,8],[7,10],[8,3],[8,7],[9,0],[9,2],[9,3],[9,7],[9,8],[9,10],[10,0],[10,1],[10,2],[10,3],[10,4],[10,5],[10,6],[10,7],[10,8],[10,9],[10,10]],"Item":[[0,31,8,5],[1,8,8,0],[2,8,9,1],[3,8,8,2],[4,8,8,10],[5,8,9,9],[6,8,8,8],[7,12,3,4],[8,12,3,6],[9,12,5,2],[10,12,5,3],[11,12,5,7],[12,12,5,8],[13,7,3,3],[14,7,3,7],[15,12,0,0],[16,12,0,1],[17,12,1,0],[18,12,0,10],[19,12,0,9],[20,12,1,10]],"Door":[[3,6,5,1],[2,1,5],[1,6,9],[1,6,1]],"Stair":[[1,0,5,10,5,2,8,1]],"Enemy":[[0,37,4,0],[1,37,4,10],[2,38,3,2],[3,38,3,8],[4,32,2,1],[5,32,2,9],[6,22,1,4],[7,22,1,3],[8,22,1,6],[9,22,1,7],[10,33,7,1],[11,33,7,9],[12,25,5,4,-1,24],[13,25,5,6,-1,24]],"Npc":[],"Event":[],"No":["GoFloor"],"Start":-1}
  ],
  [
    ["fill",5],
    [],
{"Floor":"A","Name":"未知楼层","Arrive":"No","Animate":["Star-1",[0,7],[0,8],[0,9],[0,10],[1,8],[1,9],[1,10],[2,9],[2,10],[3,10],[10,7],[10,8],[10,9],[10,10],[9,8],[9,9],[9,10],[8,9],[8,10],[7,10]],"Item":[],"Door":[],"Stair":[],"Enemy":[[0,50,5,1],[1,49,5,5],[2,52,4,1],[3,53,6,1],[4,30,4,10],[5,30,3,9],[6,30,2,8],[7,30,1,7],[8,30,0,6],[9,30,6,10],[10,30,7,9],[11,30,8,8],[12,30,9,7],[13,30,10,6]],"Npc":[],"Event":[],"No":["GoFloor"],"Start":33}
  ],
  [
    ["fill",5],
    [[2,3,3],[2,4,3],[2,6,3],[2,7,3],[2,3,4],[2,3,5],[2,3,6],[2,3,7],[2,4,7],[2,5,7],[2,6,7],[2,7,7],[2,7,6],[2,7,5],[2,7,4],[2,5,3],[6,4,5],[7,6,5]],
{"Floor":"B","Name":"未知楼层","Arrive":"No","Animate":["Star-1",[0,7],[0,8],[0,9],[0,10],[1,8],[1,9],[1,10],[2,9],[2,10],[3,10],[10,7],[10,8],[10,9],[10,10],[9,8],[9,9],[9,10],[8,9],[8,10],[7,10],[0,0],[0,1],[0,2],[0,3],[0,4],[0,5],[0,6],[1,0],[1,1],[1,2],[1,3],[1,4],[1,5],[1,6],[1,7],[2,0],[2,1],[3,0],[3,1],[4,0],[4,1],[5,0],[5,1],[6,0],[6,1],[7,0],[7,1],[8,0],[8,1],[9,0],[9,1],[9,2],[9,3],[9,4],[9,5],[9,6],[9,7],[10,0],[10,1],[10,2],[10,3],[10,4],[10,5],[10,6],[10,7]],"Item":[],"Door":[],"Stair":[],"Enemy":[],"Npc":[[0,8,5,5,36]],"Event":[],"No":["GoFloor"],"Start":35}
  ],
  [
    ["fill",5],
    [[2,4,0],[2,6,0],[2,4,1],[2,6,1],[2,4,2],[2,6,2],[2,3,2],[2,7,2],[2,3,3],[2,7,3],[2,3,4],[2,7,4],[2,3,5,2],[2,7,5],[2,3,6],[2,7,6],[2,4,6],[2,6,6],[2,4,7],[2,6,7],[2,4,8],[2,6,8],[2,4,9],[2,6,9],[2,4,10],[2,6,10]],
{"Floor":"C","Name":"未知楼层","Arrive":"No","Animate":["Star-1",[0,0],[0,1],[0,2],[0,3],[0,4],[0,5],[0,6],[0,7],[0,8],[0,9],[0,10],[1,0],[1,1],[1,2],[1,3],[1,4],[1,5],[1,6],[1,7],[1,8],[1,9],[1,10],[2,0],[2,1],[2,2],[2,3],[2,4],[2,5],[2,6],[2,7],[2,8],[2,9],[2,10],[3,0],[3,1],[3,2],[3,7],[3,8],[3,9],[3,10],[7,0],[7,1],[7,2],[7,7],[7,8],[7,9],[7,10],[8,0],[8,1],[8,2],[8,3],[8,4],[8,5],[8,6],[8,7],[8,8],[8,9],[8,10],[9,0],[9,1],[9,2],[9,3],[9,4],[9,5],[9,6],[9,7],[9,8],[9,9],[9,10],[10,0],[10,1],[10,2],[10,3],[10,4],[10,5],[10,6],[10,7],[10,8],[10,9],[10,10]],"Item":[],"Door":[[7,5,2]],"Stair":[[1,3,5,5,10,2,-1,0]],"Enemy":[],"Npc":[[0,3,5,4,38],[1,13,5,0,39]],"Event":[[0,5,9,"Npc&12",30]],"No":["GoFloor"],"Start":-1}
  ],
  [
    ["fill",5],
    [[1,4,0,1],[1,6,0,1],[1,4,1,1],[1,6,1,1],[1,4,2,1],[1,6,2,1],[1,3,2,1],[1,7,2,1],[1,3,3,1],[1,7,3,1],[1,3,4,1],[1,7,4,1],[1,7,5,1],[1,3,6,1],[1,7,6,1],[1,4,6,1],[1,6,6,1],[1,4,7,1],[1,6,7,1],[1,4,8,1],[1,6,8,1],[1,4,9,1],[1,6,9,1],[1,4,10,1],[1,6,10,1],[1,3,5,1]],
{"Floor":"D","Name":"未知楼层","Arrive":"No","Animate":["Lava-1",[0,0],[0,1],[0,2],[0,3],[0,4],[0,5],[0,6],[0,7],[0,8],[0,9],[0,10],[1,0],[1,1],[1,2],[1,3],[1,4],[1,5],[1,6],[1,7],[1,8],[1,9],[1,10],[2,0],[2,1],[2,2],[2,3],[2,4],[2,5],[2,6],[2,7],[2,8],[2,9],[2,10],[3,0],[3,1],[3,2],[3,7],[3,8],[3,9],[3,10],[7,0],[7,1],[7,2],[7,7],[7,8],[7,9],[7,10],[8,0],[8,1],[8,2],[8,3],[8,4],[8,5],[8,6],[8,7],[8,8],[8,9],[8,10],[9,0],[9,1],[9,2],[9,3],[9,4],[9,5],[9,6],[9,7],[9,8],[9,9],[9,10],[10,0],[10,1],[10,2],[10,3],[10,4],[10,5],[10,6],[10,7],[10,8],[10,9],[10,10]],"Item":[],"Door":[],"Stair":[],"Enemy":[[0,56,5,4,-1,43],[1,55,5,0]],"Npc":[],"Event":[[0,5,2,"Npc&12",41]],"No":["GoFloor"],"Start":40}
  ],
  [
    ["fill",5],
    [[2,4,0],[2,6,0],[2,4,1],[2,6,1],[2,4,2],[2,6,2],[2,3,2],[2,7,2],[2,3,3],[2,7,3],[2,3,4],[2,7,4],[2,3,5,2],[2,7,5],[2,3,6],[2,7,6],[2,4,6],[2,6,6],[2,4,7],[2,6,7],[2,4,8],[2,6,8],[2,4,9],[2,6,9],[2,4,10],[2,6,10]],
{"Floor":"E","Name":"主塔一层","Arrive":"No","Animate":["Star-1",[0,0],[0,1],[0,2],[0,3],[0,4],[0,5],[0,6],[0,7],[0,8],[0,9],[0,10],[1,0],[1,1],[1,2],[1,3],[1,4],[1,5],[1,6],[1,7],[1,8],[1,9],[1,10],[2,0],[2,1],[2,2],[2,3],[2,4],[2,5],[2,6],[2,7],[2,8],[2,9],[2,10],[3,0],[3,1],[3,2],[3,7],[3,8],[3,9],[3,10],[7,0],[7,1],[7,2],[7,7],[7,8],[7,9],[7,10],[8,0],[8,1],[8,2],[8,3],[8,4],[8,5],[8,6],[8,7],[8,8],[8,9],[8,10],[9,0],[9,1],[9,2],[9,3],[9,4],[9,5],[9,6],[9,7],[9,8],[9,9],[9,10],[10,0],[10,1],[10,2],[10,3],[10,4],[10,5],[10,6],[10,7],[10,8],[10,9],[10,10]],"Item":[[0,"A12",6,3,46]],"Door":[],"Stair":[[1,3,5,5,10,2,-1,0]],"Enemy":[],"Npc":[[0,3,5,4,38]],"Event":[],"No":["GoFloor"],"Start":44}
  ],
];
/*
[
    //[[0,0,0],[0,1,0],[0,2,0],[0,3,0]],
    ["fill",5],
    [[1,2,3],[1,3,4],[1,4,3],[1,3,2],[1,2,1],[1,1,0],[1,0,1],[1,1,2],[1,6,3],[1,8,3],[1,7,4],[1,3,6],[1,4,7],[1,6,7],[1,7,6],[1,7,2],[1,2,7],[1,8,7],[1,1,8],[1,3,8],[1,7,8],[1,9,8],[1,0,9],[1,2,9],[1,1,10],[1,8,9],[1,10,9],[1,9,10],[1,8,1],[1,9,2],[1,9,0],[1,10,1],[1,2,0],[1,3,0],[1,4,0],[1,6,0],[1,7,0],[1,8,0],[1,0,2],[1,0,3],[1,0,4],[1,0,6],[1,0,7],[1,0,8],[1,2,10],[1,3,10],[1,4,10],[1,6,10],[1,7,10],[1,8,10],[1,10,2],[1,10,3],[1,10,4],[1,10,6],[1,10,7],[1,10,8]],
	{"Name":"地下三层",
	"Animate":["Lava100",[3,7],[2,8],[1,9],[0,10],[7,7],[8,8],[9,9],[10,10],[3,3],[2,2],[1,1],[0,0],[7,3],[8,2],[9,1],[10,0]],
	"Item":[[0,11,1,3],[1,12,1,7],[2,7,3,1],[3,8,7,1],[4,8,3,9],[5,7,7,9],[6,12,9,3],[7,11,9,7]],
	"Door":[[5,5,5,1],[5,5,0],[5,0,5],[5,10,5],[5,5,10],[7,3,5],[7,7,5],[7,5,3],[7,5,7]],
	"Stair":[[0,5,5,5,5,2,2],[1,5,0,0,9,3,2],[1,5,10,0,9,3,2],[1,0,5,0,9,3,2],[1,10,5,0,9,3,2]],
	"Enemy":[[0,22,5,2,1],[1,22,8,5,1],[2,22,2,5,1],[3,22,5,8,1]],
	"Npc":[[0,3,6,6,0]],"Event":[[0,5,4,"Npc&4",2]],"No":["GoFloor","EnemyBook"]}
  ],
"Lava100",[0,8],[0,9],[0,10],[1,10],[1,9],[2,8],[2,9],[2,10],[3,9],[3,10],[4,9],[4,10],[6,9],[6,10],[7,9],[7,10],[8,8],[8,9],[8,10],[9,9],[9,10],[10,8],[10,9],[10,10],"Star100",[1,0],[2,0],[3,0],[4,0],[1,1],[2,1],[3,1],[4,1],[1,2],[2,2],[3,2],[4,2],[1,3],[2,3],[3,3],[4,3],[1,4],[2,4],[3,4],[4,4],[1,5],[2,5],[3,5],[4,5],[1,6],[2,6],[3,6],[4,6],[6,0],[7,0],[8,0],[9,0],[6,1],[7,1],[8,1],[9,1],[6,2],[7,2],[8,2],[9,2],[6,3],[7,3],[8,3],[9,3],[6,4],[7,4],[8,4],[9,4],[6,5],[7,5],[8,5],[9,5],[6,6],[7,6],[8,6],[9,6]
*/