var songContent = '[00:01.92]匆匆那年（电影《匆匆那年》同名主题曲）- 王菲\n[00:28.21]匆匆那年 我们究竟说了几遍\n[00:31.17]再见之后 再拖延\n[00:33.89]可惜谁有没有 爱过不是一场\n[00:36.85]七情上面的雄辩\n[00:39.57]匆匆那年我们 一时匆忙撂下\n[00:42.42]难以承受的诺言\n[00:45.15]只有等别人兑现\n[00:51.00]不怪那吻痕 还没积累成茧\n[00:56.41]拥抱着冬眠 也没能羽化再成仙\n[01:02.01]不怪这一段情没空反复再排练\n[01:07.56]是岁月宽容恩赐 反悔的时间\n[01:18.57]如果再见不能红着眼 是否还能红着脸\n[01:24.49]就像那年匆促刻下\n[01:26.54]永远一起那样美丽的谣言\n[01:29.73]如果过去还值得眷恋 别太快冰释前嫌\n[01:35.78]谁甘心就这样 彼此无挂也无牵\n[01:41.49]我们要互相亏欠 要不然凭何怀缅\n[01:58.26]匆匆那年 我们见过太少世面\n[02:01.22]只爱看同一张脸\n[02:03.93]那么莫名其妙 那么讨人欢喜\n[02:06.78]闹起来又太讨厌\n[02:09.41]相爱那年活该匆匆\n[02:11.47]因为我们不懂顽固的诺言\n[02:15.10]只是分手的前言\n[02:20.96]不怪那天太冷 泪滴水成冰\n[02:26.42]春风也一样没吹进凝固的照片\n[02:31.99]不怪每一个人没能完整爱一遍\n[02:37.69]是岁月善意落下 残缺的悬念\n[02:48.41]如果再见不能红着眼 是否还能红着脸\n[02:54.56]就像那年匆促刻下\n[02:56.51]永远一起那样美丽的谣言\n[02:59.43]如果过去还值得眷恋 别太快冰释前嫌\n[03:05.76]谁甘心就这样 彼此无挂也无牵\n[03:10.66]如果再见不能红着眼 是否还能红着脸\n[03:17.00]就像那年匆促刻下\n[03:19.00]永远一起那样美丽的谣言\n[03:21.87]如果过去还值得眷恋 别太快冰释前嫌\n[03:28.25]谁甘心就这样 彼此无挂也无牵\n[03:33.96]我们要互相亏欠 我们要藕断丝连';
function parseLyric(text) {
  //将文本分隔成一行一行，存入数组
  var lines = text.split('\n'),
    //用于匹配时间的正则表达式，匹配的结果类似[xx:xx.xx]
    pattern = /\[\d{2}:\d{2}.\d{2}\]/g,
    //保存最终结果的数组
    result = [];
  //去掉不含时间的行
  while (!pattern.test(lines[0])) {
    lines = lines.slice(1);
  };
  //上面用'\n'生成生成数组时，结果中最后一个为空元素，这里将去掉
  lines[lines.length - 1].length === 0 && lines.pop();
  lines.forEach(function(v /*数组元素值*/ , i /*元素索引*/ , a /*数组本身*/ ) {
    //提取出时间[xx:xx.xx]
    var time = v.match(pattern),
      //提取歌词
      value = v.replace(pattern, '');
    //因为一行里面可能有多个时间，所以time有可能是[xx:xx.xx][xx:xx.xx][xx:xx.xx]的形式，需要进一步分隔
    time.forEach(function(v1, i1, a1) {
      //去掉时间里的中括号得到xx:xx.xx
      var t = v1.slice(1, -1).split(':');
      //将结果压入最终数组
      result.push([parseInt(t[0], 10) * 60 + parseFloat(t[1]), value]);
    });
  });
  //最后将结果数组中的元素按时间大小排序，以便保存之后正常显示歌词
  result.sort(function(a, b) {
    return a[0] - b[0];
  });
  return result;
}