(function($) {
	//默认参数
	let defaults = {
		defaultsStyle: "error-color",
		border: {
			color: "",
			size: "1px",
			radius: "5px",
		},
		background: {
			color: "",
		},
		showLocation: {
			top: "0px",
			right: "0px",
			left: "0px",
			bottom: "0px"
		},
		hideMilliSeconds: 5000,
	};
	let is = 0;
	$.extend({
		/* 追加消息数据 */
		addSmallBellInfo(arr, index) {
			for (let [i, item] of arr.entries()) {
				let val = `<div class="msg-content centerSpace msg-content_${i} ${item.type==0 ? 'weiDu' : 'yiDu'}" title="${item.type==0 ? '未读' : '已读'}">
							<div class="msg-content-time">${item.time}</div>
							<div class="msg-content-text" title="${item.text}">${item.text}</div>
							<div class="which3">
								<ul>
									<li class="li_yidu">标记已读</li>
									<li class="li_del">删除消息</li>
								</ul>
							</div>
						</div>`;
				if (index == 0) {
					$(".smallBell-msg-info-content").prepend(val);
				} else {
					$(".smallBell-msg-info-content").append(val);
				}

				$(`.msg-content_${i}`).click(function() {
					$(".which3").css({
						"display": "none"
					});
					item.callback(item.time, item.text, i);
					event.stopPropagation();
				});
			}
			L_MSGTOOL.SetSpanVal();
			$(".msg-content").mousedown(function(e) {
				if (e.which == 3) {
					$(".which3").css({
						"display": "none"
					});
					let left = document.body.scrollLeft + event.pageX + 10;
					let top = document.body.scrollLeft + event.pageY + 10;
					$(this).find(".which3").css({
						"display": "block",
						"left": left,
						"top": top
					});
				}
				event.stopPropagation();
			});
			$(".li_yidu").click(function() {
				let that = $(this).parent().parent().parent();
				that.attr('class', that.attr('class').replace(/weiDu/, "yiDu"));
				that.attr('title', "已读");
				L_MSGTOOL.SetSpanVal();
				$(".which3").css({
					"display": "none"
				});
				event.stopPropagation();
			});
			$(".li_del").click(function() {
				if (confirm("你确定删除该条消息吗？")) {
					let that = $(this).parent().parent().parent();
					that.remove();
					that.find("span").html("");
					L_MSGTOOL.SetSpanVal();
					$(".which3").css({
						"display": "none"
					});
				}
				event.stopPropagation();
			});


		},

		/* 显示消息框 */
		showPopup(item, opt) {
			//console.log(opt);
			let settings = {};
			if (opt != null && opt != "" && opt != undefined) {
				settings = $.extend(defaults, opt);
			} else {
				settings = defaults;
			}
			if ($(".popup").length == 0) {
				$("body").append(`<div class="popup"></div>`);
			}
			if (settings.showLocation.left != "0px" || settings.showLocation.top != "0px" || settings
				.showLocation.right != "0px" || settings.showLocation.bottom != "0px") {
				$(".popup").css({
					"left": settings.showLocation.left,
					"top": settings.showLocation.top,
					"right": settings.showLocation.right,
					"bottom": settings.showLocation.bottom,
				});
			}

			let time = L_MSGTOOL.getDataTime();
			let times = time.replace(/-/g, "_").replace(/ /g, "_").replace(/:/g, "_");
			let val = `<div class="msg-popup ${settings.defaultsStyle} id_${times}">
						<div class="msg-times" style="cursor: pointer;">&times;</div>
						<div class="centerSpace msg-title">
							<div>${item.title}</div>
							<div class="msg-date-info">${time}</div>
						</div>
						<div class="popup-msg-content">
							<i class="fa fa-info-circle" aria-hidden="true"></i>
							<span>${item.content}</span>
						</div>
					</div>`;
			$(".popup").prepend(val);
			$(".msg-times").click(function() {
				$(this).parent().remove();
				if ($(".popup").find(".msg-popup").length == 0) {
					$(".popup").remove();
				}
				event.stopPropagation();
			});
			if (settings.defaultsStyle == "custom-color") {
				$(".custom-color").css({
					"border": settings.border.color + " solid" + settings.border.size,
					"border-radius": settings.border.radius,
					"background-color": settings.background.color,
				});
			}
			setTimeout(function() {
				$(`.id_${times}`).remove();
				if ($(".popup").find(".msg-popup").length == 0) {
					$(".popup").remove();
				}
				return;
			}, settings.hideMilliSeconds);
		},

		//初始化
		initMsgPopup(options) {
			let msgCount = options; //div id
			if (msgCount != null && msgCount != "" && msgCount != undefined) {
				//初始化消息记录铃铛
				let smallVal = `<div class="smallBell-icon-info">
									<div class="smallBell-icon">
										<i class="fa fa-bell-o iClass" aria-hidden="true"></i>
									</div>
									<div class="smallBell-msg smallBell-msg-locats"><span></span></div>
								</div>
							<div class="smallBell-msg-info">
								<div class="span-but-msg-info centerSpace">
									<span>消息</span>
									<span id="dateTime">2020-01-05 13:10:12</span>
								</div>
								<div class="boundary"></div>
								<div class="smallBell-msg-info-content">
								</div>
								<div class="span-but-msg-info centerSpace">
									<div>
										共<span class="tiaoShui">xxx</span>条消息
									</div>
									<div>
										<button class="but-msg-info">全部已读</button>
										<button class="but-msg-del">清空所有</button>
									</div>
								</div>
							</div>`;
				$(`${msgCount.id}`).html(smallVal);
				L_MSGTOOL.SetSpanVal();
				$(".smallBell-msg-info").css("margin-left", `${msgCount.leftData}px`);

				setInterval(function() {
					$("#dateTime").html(L_MSGTOOL.getDataTime());
				}, 1000);

				//禁用网页右键菜单
				$(document).bind("contextmenu", function(e) {
					return false;
				});
				//点击显示隐藏消息
				$(`${msgCount.id}`).click(function() {
					if ($(".smallBell-msg-info").is(":hidden")) {
						$(".smallBell-msg-info").css("display", "block");
					} else {
						$(".smallBell-msg-info").css("display", "none");
					}
					event.stopPropagation(); //  阻止事件冒泡
				});
				$(".msg-times").click(function() {
					$(this).parent().remove();
					event.stopPropagation();
				});
				$(".smallBell-msg-info").click(function() {
					$(".which3").css({
						"display": "none"
					});
					event.stopPropagation();
				});
				//全部已读
				$(".but-msg-info").click(function() {
					if ($(".smallBell-msg-info-content").find(".msg-content").length == 0 || $(
							".smallBell-msg").attr("class") == "visibilityHidden smallBell-msg") {
						return alert("已经没有未读消息！");
					}
					$(".smallBell-msg").attr("class", "visibilityHidden smallBell-msg");
					for (let i = 0; i < $(".smallBell-msg-info-content").find(".msg-content")
						.length; i++) {
						let that = $(".smallBell-msg-info-content").find(".msg-content").eq(i);
						that.attr('class', that.attr('class').replace(/weiDu/, "yiDu"));
						that.attr('title', "已读");
						$(".which3").css({
							"display": "none"
						});
					}
					event.stopPropagation();
				});
				//清空所有
				$(".but-msg-del").click(function() {
					if ($(".smallBell-msg-info-content").find(".msg-content").length == 0) {
						return alert("已经没有消息可以清空！");
					}
					if (confirm("你确定清空所有消息吗？")) {
						$(".smallBell-msg-info-content").find("div").remove();
						$(".smallBell-msg").attr("class", "visibilityHidden smallBell-msg");
						$(".smallBell-msg").find("span").html("");
						$(".tiaoShui").html(0);
						$(".which3").css({
							"display": "none"
						});
					}
					event.stopPropagation();
				});

				//注册body事件
				$("body").click(function() {
					$(".smallBell-msg-info").css("display", "none");
					$(".which3").css({
						"display": "none"
					});
				});
			}



			let opt = options.opt;
			if (opt != null && opt != "") {
				settings = $.extend(defaults, opt);
			} else {
				settings = defaults;
			}
		},

	});
})(jQuery);
