function Menus (doc,config) {
	let _this = this;
	this.doc = $(doc); // 控制的dom
	this.type = config.type || 'level'; // 排列方式
	this.activeType = config.activeType; // 选中样式
	this.activeIndex =  config.activeIndex || null; // 默认选中
	this.outRemove = config.outRemove; // 鼠标离开取消选中
	this.back = config.back; // 是否回弹
	this.recordIndex = config.recordIndex || null; // 是否记录当前选中
	let liW = this.doc.find('li').eq(0).width(); // li的宽度 用于设置滑块宽度
	let liH = this.doc.find('li').eq(0).height(); // li 的高度 用于设置滑块的高度
	this.init(liW,liH,_this)
}
Menus.prototype.init = function (liW,liH,_this) {
	this.type == 'level' ? '' : this.doc.addClass('menus-vertical').removeClass('menus-level') // 判断方向
	if(this.recordIndex) {
		this.activeIndex = sessionStorage.getItem(_this.doc.selector+'_recordIndex') || this.activeIndex
	}else {
		sessionStorage.removeItem(_this.doc.selector+'_recordIndex')
	}
	switch(this.activeType.mode) {
		case 'line':
			this.activeTypeMode('line',liW,liH,this.activeIndex,_this);
			break;
		case 'block':
			this.activeTypeMode('block',liW,liH,this.activeIndex,_this);
			break;
		case 'border':
			if(this.type == 'level') {
				this.defaultStyle('border-bottom',this.activeType.textColor,this.activeType.bgColor,this.activeIndex,_this)
			}else {
				this.defaultStyle('border-left',this.activeType.textColor,this.activeType.bgColor,this.activeIndex,_this)
			}
			break;
		default: 
			this.defaultStyle('background',this.activeType.textColor,this.activeType.bgColor,this.activeIndex,_this)
	}
}
Menus.prototype.defaultStyle = function(type,textColor,bgColor,index,_this) { // 边框和背景色样式代码
	var styles = null;
	// 根据 type 设置边框或背景色
	if(type == 'border-bottom' || type == 'border-left') {
		styles = '2px solid '+_this.activeType.bgColor
	}else {
		styles = _this.activeType.bgColor
	}
	// 设置默认选中 ↓
	index == null ? "" : _this.doc.find('li').eq(index).css(type,styles).css('color',_this.activeType.textColor).siblings().css(type,'none').css('color','inherit')
	_this.doc.find('li').bind(_this.activeType.triggerType,function(){
		// 为菜单绑定事件
		$(this).css(type,styles).css('color',_this.activeType.textColor).siblings().css(type,'none').css('color','inherit')
		if(_this.recordIndex && _this.activeType.triggerType == 'click') {
			sessionStorage.setItem(_this.doc.selector+'_recordIndex',$(this).index())
		}

		// 简单的选项卡示例 如果用滑块方式 写在 activeTypeMode 方法对应位置
		var index = $(this).index();
		$('.tabs .content').eq(index).show().siblings().hide();
	})

	// 根据传入设置鼠标离开后菜单状态
	if(_this.activeType.triggerType == 'mouseenter') {
		_this.doc.bind('mouseleave',function(){
			if(_this.outRemove) {
				$(this).find('li').css(type,'none').css('color','inherit')
			}else if (_this.back) {
				_this.doc.find('li').eq(index).css(type,styles).css('color',_this.activeType.textColor).siblings().css(type,'none').css('color','inherit')
			}
		})
	}
}
Menus.prototype.activeTypeMode = function (type,liW,liH,index,_this) { // 滑块样式代码
	var createEle = $('<div></div>');
	createEle.addClass(type);
	if(_this.type == 'level') {
		createEle.css('width',liW+'px').css('background',this.activeType.bgColor)
		index ? createEle.css('left',liW*index+'px') : createEle.css('left','0')
	}else {
		createEle.css('height',liH+'px').css('background',this.activeType.bgColor)
		index ? createEle.css('top',liH*index+'px') : createEle.css('top','0')
	}
	_this.doc.append(createEle)

	_this.doc.find('li').eq(index).css('color',_this.activeType.textColor)
	_this.doc.find('li').bind(_this.activeType.triggerType,function(e){
		$(this).css('color',_this.activeType.textColor).siblings().css('color','inherit')
		if(_this.type == 'level') {
			_this.doc.find('.'+type).css('left',$(this).index() * liW + 'px')
		}else {
			_this.doc.find('.'+type).css('top',$(this).index() * liH + 'px')
		}
		if(_this.recordIndex && _this.activeType.triggerType == 'click') {
			sessionStorage.setItem(_this.doc.selector+'_recordIndex',$(this).index())
		}

		// 可以在这里写东西 0.0
	})
	if(_this.activeType.triggerType == 'mouseenter') {
		_this.doc.bind('mouseleave',function(){
			if(_this.back) {
				if(_this.type == 'level') {
					index ? createEle.css('left',liW*index+'px') : createEle.css('left','0')
				}else {
					index ? createEle.css('top',liH*index+'px') : createEle.css('top','0')
				}
				_this.doc.find('li').eq(index).css('color',_this.activeType.textColor).siblings().css('color','inherit')
			}
			
		})
	}
}