


;(function($){
	"use strict";
	let target = null;
	let opts = {
		facility:'mobile',
		list:[],
		btn:'',
		width:'',
		height:'',
		id:'',
		callBack:null
	}
	let methods = {
		init:function(options){
			target = $(this);
			if(options.facility && options.facility == 'mobile'){
				if(!options.height){
					options.height = window.innerHeight*2;
				}
				if(!options.width){
					options.width = window.innerWidth*2;
				}
			}else{
				if(!options.height){
					options.height = window.innerHeight;
				}
				if(!options.width){
					options.width = window.innerWidth;
				}
			}
			if (options) {
				$.extend(opts, options);
			}
			target.html('<canvas style="display: none;" id="'+options.id+'" height="'+options.height+'" width="'+options.width+'"></canvas><img src="" style="width:100%;height:auto" />')
			let c = document.getElementById(options.id);
			let ctx=c.getContext("2d");
			methods.changeCanvas(ctx,0,c);
		},
		
		canvasInit:function(ctx, option,index,c){
			ctx.rect(option.x,option.y,opts.width,opts.height);
			/* 写入背景颜色 */
			if(option.bg){
				ctx.fillStyle="#"+option.bg;
				ctx.fill();
			}
			/* 写入背景图片 当图片加载完成后将图片写入canvas */
			if(option.image){
				let img = new Image();
				img.src = option.image;
				img.onload = function(){
					ctx.drawImage(img,option.x,option.y);
					methods.changeCanvas(ctx,index+1,c);
				}
			}else{
				ctx.stroke();
				methods.changeCanvas(ctx,index+1,c);
			}
		},
		canvasCircle:function(ctx, option,index,c){
			
			let x = option.x;
			let y = option.y;
			
			if(!x && typeof(x) === 'string' || x == 'center'){
				x = (opts.width)/2
			}
			if(!y && typeof(y) === 'string' || y == 'center'){
				y = (opts.width)/2
			}
			if(option.image){
				let img = new Image();
				img.src = option.image;
				img.onload = function(){
					ctx.beginPath();
					ctx.translate(x/2,y/2);
					ctx.arc(x/2,y/2,option.r,0,2*Math.PI);
					ctx.clip();//次方法下面的部分为待剪切区域，上面的部分为剪切区域
					ctx.drawImage(img,x/2-option.r,y/2-option.r,option.r*2,option.r*2);
					
					methods.changeCanvas(ctx,index+1,c);
				}
			}else{
				ctx.beginPath();
				ctx.arc(x,y,option.r,0,2*Math.PI);
				if(option.bg){
					ctx.fillStyle="#"+option.bg;
					ctx.fill();
				}
				ctx.stroke();
				methods.changeCanvas(ctx,index+1,c)
			}
		},
		canvasFillText:function(ctx,option,index,c){
			let x = option.x;
			let y = option.y;
			
			if(!x && typeof(x) === 'string' || x == 'center'){
				x = (opts.width-(option.text.length*option.fontSize))/2
			}
			if(!y && typeof(y) === 'string' || y == 'center'){
				y = (opts.width)/2
			}
			ctx.font=""+option.fontSize+"px Georgia";
			if(option.color){
				ctx.fillStyle="#"+option.color;
			}
			ctx.fillText(option.text,x,option.y);
			
			ctx.stroke();
			methods.changeCanvas(ctx,index+1,c)
		},
		canvasImg:function(ctx,option,index,c){
			let x = option.x;
			let y = option.y;
			
			if(!x && typeof(x) === 'string' || x == 'center'){
				x = (opts.width-option.width)/2
			}
			if(!y && typeof(y) === 'string' || y == 'center'){
				y = (opts.width-option.height)/2
			}
			let img = new Image();
			img.src = option.image;
			img.onload = function(res){
				ctx.drawImage(img,x,y,option.width,option.height?option.height :option.width);
				
				methods.changeCanvas(ctx,index+1,c);
			}
		},
		changeCanvas:function(ctx,index,c){
		
			if(opts.list.length-index >=1){
				if(opts.list[index].type == 'init'){
					methods.canvasInit(ctx,opts.list[index],index,c)
				}else if(opts.list[index].type == 'circle'){
					methods.canvasCircle(ctx,opts.list[index],index,c)
				}else if(opts.list[index].type == 'fillText'){
					methods.canvasFillText(ctx,opts.list[index],index,c)
				}else if(opts.list[index].type == 'img'){
					methods.canvasImg(ctx,opts.list[index],index,c)
				}
				if(opts.list.length-index == 1){
					methods.convertCanvasToImage(c);
				}
			}
		},
		convertCanvasToImage:function(c){
			let src = c.toDataURL("image/png");
				target.find("img").attr('src',src);
			return src;
		}
	}
	$.fn.canvasPhoto = function (method) {
		if (methods[method]) {
			return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
		} else if (typeof method == 'object' || !method) {
			return methods.init.apply(this, arguments);
		} else {
			$.error('Method ' + method + ' does not exist!');
		}
	}
})(jQuery)