/*!
 * GJ-lm v1.0
 * 最后修改于：2015-12-28
 * zjf: 383975892@qq.com
 */
/**
 * baiduTemplate简单好用的Javascript模板引擎 1.0.6 版本
 * http://baidufe.github.com/BaiduTemplate
 * 开源协议：BSD License
 * 浏览器环境占用命名空间 baidu.template ，nodejs环境直接安装 npm install baidutemplate
 * @param str{String} dom结点ID，或者模板string
 * @param data{Object} 需要渲染的json对象，可以为空。当data为{}时，仍然返回html。
 * @return 如果无data，直接返回编译后的函数；如果有data，返回html。
 * @author wangxiao
 * @email 1988wangxiao@gmail.com
 */
!function(window){
//取得浏览器环境的baidu命名空间，非浏览器环境符合commonjs规范exports出去
//修正在nodejs环境下，采用baidu.template变量名
var baidu="undefined"==typeof module?window.baidu=window.baidu||{}:module.exports;
//模板函数（放置于baidu.template命名空间下）
baidu.template=function(str,data){
//检查是否有该id的元素存在，如果有元素则获取元素的innerHTML/value，否则认为字符串为模板
var fn=function(){
//判断如果没有document，则为非浏览器环境
if(!window.document)return bt._compile(str);
//HTML5规定ID可以由任何不包含空格字符的字符串组成
var element=document.getElementById(str);if(element){
//取到对应id的dom，缓存其编译后的HTML模板函数
if(bt.cache[str])return bt.cache[str];
//textarea或input则取value，其它情况取innerHTML
var html=/^(textarea|input)$/i.test(element.nodeName)?element.value:element.innerHTML;return bt._compile(html)}
//是模板字符串，则生成一个函数
//如果直接传入字符串作为模板，则可能变化过多，因此不考虑缓存
return bt._compile(str)}(),result=bt._isObject(data)?fn(data):fn;return fn=null,result};
//取得命名空间 baidu.template
var bt=baidu.template;
//标记当前版本
bt.versions=bt.versions||[],bt.versions.push("1.0.6"),
//缓存  将对应id模板生成的函数缓存下来。
bt.cache={},
//自定义分隔符，可以含有正则中的字符，可以是HTML注释开头 <! !>
bt.LEFT_DELIMITER=bt.LEFT_DELIMITER||"<%",bt.RIGHT_DELIMITER=bt.RIGHT_DELIMITER||"%>",
//自定义默认是否转义，默认为默认自动转义
bt.ESCAPE=!0,
//HTML转义
bt._encodeHTML=function(source){return String(source).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\\/g,"&#92;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")},
//转义影响正则的字符
bt._encodeReg=function(source){return String(source).replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")},
//转义UI UI变量使用在HTML页面标签onclick等事件函数参数中
bt._encodeEventHTML=function(source){return String(source).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/\\\\/g,"\\").replace(/\\\//g,"/").replace(/\\n/g,"\n").replace(/\\r/g,"\r")},
//将字符串拼接生成函数，即编译过程(compile)
bt._compile=function(str){var funBody="var _template_fun_array=[];\nvar fn=(function(__data__){\nvar _template_varName='';\nfor(name in __data__){\n_template_varName+=('var '+name+'=__data__[\"'+name+'\"];');\n};\neval(_template_varName);\n_template_fun_array.push('"+bt._analysisStr(str)+"');\n_template_varName=null;\n})(_template_object);\nfn = null;\nreturn _template_fun_array.join('');\n";return new Function("_template_object",funBody)},
//判断是否是Object类型
bt._isObject=function(source){return"function"==typeof source||!(!source||"object"!=typeof source)},
//解析模板字符串
bt._analysisStr=function(str){
//取得分隔符
var _left_=bt.LEFT_DELIMITER,_right_=bt.RIGHT_DELIMITER,_left=bt._encodeReg(_left_),_right=bt._encodeReg(_right_);
//支持用户配置默认是否自动转义
return str=String(str).replace(new RegExp("("+_left+"[^"+_right+"]*)//.*\n","g"),"$1").replace(new RegExp("<!--.*?-->","g"),"").replace(new RegExp(_left+"\\*.*?\\*"+_right,"g"),"").replace(new RegExp("[\\r\\t\\n]","g"),"").replace(new RegExp(_left+"(?:(?!"+_right+")[\\s\\S])*"+_right+"|((?:(?!"+_left+")[\\s\\S])+)","g"),function(item,$1){var str="";if($1)for(
//将 斜杠 单引 HTML转义
str=$1.replace(/\\/g,"&#92;").replace(/'/g,"&#39;");/<[^<]*?&#39;[^<]*?>/g.test(str);)
//将标签内的单引号转义为\r  结合最后一步，替换为\'
str=str.replace(/(<[^<]*?)&#39;([^<]*?>)/g,"$1\r$2");else str=item;return str}),str=str.replace(new RegExp("("+_left+"[\\s]*?var[\\s]*?.*?[\\s]*?[^;])[\\s]*?"+_right,"g"),"$1;"+_right_).replace(new RegExp("("+_left+":?[hvu]?[\\s]*?=[\\s]*?[^;|"+_right+"]*?);[\\s]*?"+_right,"g"),"$1"+_right_).split(_left_).join("	"),str=bt.ESCAPE?str.replace(new RegExp("\\t=(.*?)"+_right,"g"),"',typeof($1) === 'undefined'?'':baidu.template._encodeHTML($1),'"):str.replace(new RegExp("\\t=(.*?)"+_right,"g"),"',typeof($1) === 'undefined'?'':$1,'"),str=str.replace(new RegExp("\\t:h=(.*?)"+_right,"g"),"',typeof($1) === 'undefined'?'':baidu.template._encodeHTML($1),'").replace(new RegExp("\\t(?::=|-)(.*?)"+_right,"g"),"',typeof($1)==='undefined'?'':$1,'").replace(new RegExp("\\t:u=(.*?)"+_right,"g"),"',typeof($1)==='undefined'?'':encodeURIComponent($1),'").replace(new RegExp("\\t:v=(.*?)"+_right,"g"),"',typeof($1)==='undefined'?'':baidu.template._encodeEventHTML($1),'").split("	").join("');").split(_right_).join("_template_fun_array.push('").split("\r").join("\\'")}}(window);