(function (factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as anonymous module.
    define(['jquery'], factory);
  } else if (typeof exports === 'object') {
    // Node / CommonJS
    factory(require('jquery'));
  } else {
    // Browser globals.
    factory(jQuery);
  }
}(function ($) {

    'use strict';
    /* Defind Plugin */
    var _PLUGIN_    = 'DNcarousel';
    var _VERSION_   = '1.0.0';
    var _HTML_      =   '<div class="dn-carousel-domain">' +
                          '<div class="dn-carousel-list">' +
                            '<ul>' +
                            '</ul>' +
                          '</div>' +
                          '<div class="dn-carousel-setNon-scroll-main">' +
                            '<div class="dn-carousel-scroll-domain">' +
                              '<ul class="dn-carousel-scroll-main">' +
                              '</ul>' +
                            '</div>' +
                          '</div>' +
                        '</div>';

    if ( $[ _PLUGIN_ ] && $[ _PLUGIN_ ].version > _VERSION_ )
    {
        return;
    }

    /* Init Object */
    $[_PLUGIN_] = function($container,options){
        var self = this ;
        this.container = $container ;
        this.options   = options ;
        this.api       = [ "init", "destroy" ];
        this.init();
        return this ;
    };

    $[_PLUGIN_].version = _VERSION_;

    $[_PLUGIN_].defaults = {
        "data"     : []    ,
        "switch"   : "normal" , //fade
        "isTitle"  : true  , 
        "clickList": null ,
        "mouseInLi"  : null ,
        "mouseOutLi" : null ,
        "mouseIn"  : null,
        "mouseOut" : null 
    }; 

    /* Prototype Function */
    $[_PLUGIN_].prototype = {
        init : function (){

            if(!this.options.data) throw new TypeError(" this is No data.");

            this.defaultDOM();

            this.eachLoadImg();

            this.Popup();

            var _this_ = this ,
                padding = parseFloat(this.li.first().css("paddingLeft").replace("px","")) + parseFloat(this.li.last().css("paddingRight").replace("px","")) ,
                scroll  = ( this.li.width() * this.li.length + padding ) - this.scrollDoMain.width() ,
                mouseCanMove = false ,
                pointX       = 0 ;

            //Events
            //Mousemove START
            this.scrollDoMain.on("mousemove" , function(event){
                setTimeout( function(){
                  mouseCanMove = true ;
                  pointX = event.clientX * scroll / _this_.scrollDoMain.width();
                }, 100 );
            });
            setInterval(function(){
                if(mouseCanMove){
                    _this_.scrollDoMain.scrollLeft(pointX);
                }
            }, 1000/45 );
            //Mousemove END
            this.clickList();

            this.hoverDomain();
            
            $(window).load(function() {

                _this_.scrollsetNonMain.height(_this_.li.height());

                _this_.scrollDoMain.height(_this_.li.height() + 25);
                // PC or Phone
                var isSide = /Android|webOS|iPhone|iPod|BlackBerry/i.test(navigator.userAgent) ; 
                if(isSide) _this_.scrollsetNonMain.css({"overflow":"initial"});

            });

        },
        destroy : function()
        {
            this.container.empty();
            return this;
        },   
        defaultDOM : function(){
            $(_HTML_).appendTo(this.container);
            this.scrollMain   = this.container.find(".dn-carousel-scroll-main");
            this.liHTML();
            this.listTitle();

            this.domain       = this.container.children(".dn-carousel-domain");
            this.listLI       = this.container.find(".dn-carousel-list-li");
            this.scrollsetNonMain   = this.container.find(".dn-carousel-setNon-scroll-main");
            this.scrollDoMain = this.container.find(".dn-carousel-scroll-domain");
        }, 
        liHTML : function(obj){
            var _this_    = this ;
            var Datas     = this.options.data ,
                _default_ = null ,
                Switch    = null ;

            _this_.scrollMain.empty();
            switch (this.options.switch) {
                case 'normal':
                     Switch  =  "normal";
                    break;
                case 'fade':
                    Switch  =  "fade";
                    break;
                case 'rotate':
                    Switch  =  "rotate";
                    break;
                default:
                    Switch  =  "normal";
                    break;
            }
            Datas.forEach(function(e,i){
                _default_ = (_this_.options.data[0].name)?_this_.options.data[0].name:"cars";
                if(e.name !== ( obj || _default_)) return;
                e.data.forEach(function(element){
                var liHtml = '<li class="dn-carousel-li slide-in" target="_blank" data-switch="' + Switch + '" data-menu-title="' + e.name + '">'+
                              '<a class="dn-carousel-url" href="' + element.url + '">'+
                                '<img src="' + element["img-before"] + '" class="hover-before" />'+
                                '<img src="' + element["img-after"] + '" class="hover-after" />'+
                                '<div class="font-small">' + element["as-shown"] + '<span class="dn-tip" data-description="'+ element.description +'" >*1</span></div>'+
                                '<div class="car-description">'+
                                '<h4>' + element.title + '</h4>'+
                                '<small>' + element.price + '</small>'+
                                '<small>' + element.MPG + '</small>'+
                                '</div>'+
                                '<div class="hover-btn">'+
                                  '<span>BUILD</span>'+
                                  '<span>SPECIALS</span>'+
                                '</div>'+
                              '</a>'+
                            '</li>';   
                _this_.scrollMain.append(liHtml);
                _this_.li = _this_.container.find(".dn-carousel-li");
                _this_.tip  = _this_.container.find(".dn-tip");
                });
            });
            return this;
        }, 
        listTitle : function (){
            var _this_ = this ,
                titleArr = this.options.data.map(function(e){return e.name; });

            this.list         = this.container.find(".dn-carousel-list");
            titleArr.forEach(function(e,i){
                var a = (i === 0)? 'dn-carousel-list-li actived' : 'dn-carousel-list-li';
                _this_.list.find("ul").append('<li data-list="'+ e +'" class="'+ a +'">'+ e +'</li>') ;
            });
        },
        hoverDomain : function(){
            var _this_ = this ,
                l      = this.li.length ,
                w      = this.li.width() ,
                m      = this.scrollDoMain.width() ,
                left   = (m > l * w) ? null : 'dn-carousel-hide-btn-left'  ,
                right  = (m > l * w) ? null : 'dn-carousel-hide-btn-right' ;
            this.li.hover(function() {
                var i = $(this).index() ;
                if( i === 0 ){
                    _this_.scrollsetNonMain.addClass(left);
                }else if( i === l - 1){
                    _this_.scrollsetNonMain.addClass(right);
                }
                (_this_.options.mouseInLi)? _this_.options.mouseInLi.call(this,i) : null ;
            }, function() {
                var i = $(this).index() ;
                if( i === 0 ){
                    _this_.scrollsetNonMain.removeClass(left);
                }else if( i === l - 1){
                    _this_.scrollsetNonMain.removeClass(right);
                }
                (_this_.options.mouseOutLi)? _this_.options.mouseOutLi.call(this,i) : null ;
            });
            _this_.scrollDoMain.hover(function() {
                (_this_.options.mouseIn)? _this_.options.mouseIn() : null ;
            }, function() {
                (_this_.options.mouseOut)? _this_.options.mouseOut() : null ;
            });
            return this ;
        },
        eachLoadImg : function(){
            var _this_ = this ;
            this.hoverBefore  = this.container.find(".hover-before");
            var imgArr  = (this.hoverBefore) ? this.hoverBefore.map(function(){ return this.src; }) : null;

            $.each(imgArr,function(i,src){
                var image = new Image();
                image.onload = function(){
                    (function(i){
                        setTimeout(function(){
                            _this_.hoverBefore.eq(i).parents(".dn-carousel-li").removeClass().addClass('dn-carousel-li done');
                        }, i * 50 );              
                    })(i);
                };
                image.src = imgArr[i];
            });

            return this;
        },
        clickList : function(){
            var _this_ = this ;
            this.listLI.off().on('click',  function(event) {
                var _this = this ;
                event.stopPropagation();
                var dataList = $(this).attr("data-list");
                _this_.li.each(function(i) {
                    var self = $(this);
                    (function(index){
                        setTimeout(function(){
                            self.removeClass("done").addClass('slide-out');
                            if(i  === _this_.li.length - 1){
                                setTimeout(function(){
                                    _this_.list.find("li").removeClass('actived');
                                    $(_this).addClass('actived');
                                    _this_.liHTML(dataList).eachLoadImg().Popup().hoverDomain();
                                }, 80 );
                            }
                        }, index * 50);
                    })(i);
                });
            });
            (_this_.options.clickList)? _this_.options.clickList() : null ;
        },
        Popup : function(){
            var _this_ = this ;
            this.tip.off().on('click', function(event) {
                event.stopPropagation();
                var description = $(this).attr("data-description");
                var popupHTML = '<div class="popup-div"> <div class="popup">' + description + '</div> </div>';
                $("body").append(popupHTML).find(".popup-div").fadeIn();
                _this_.PopupClose();
            });
            return this;
        },
        PopupClose : function(){
            var popupDIV = $(".popup-div");
            popupDIV.off().on('click', function(event) {
                event.stopPropagation();
                if($(event.target).hasClass('popup-div')){
                    popupDIV.fadeOut( 400, function(){ 
                        $(this).remove(); 
                    });  
                } 
            });
            return this;
        },
        _api_: function()
        {
            var self_ = this,
                api = {};

            $.each( this.api,
                function( i )
                {
                    var fn = this;
                    api[ fn ] = function()
                    {   
                        var re = self_[ fn ].apply( self_, arguments );
                        return ( typeof re == 'undefined' ) ? api : re;
                    };
                }
            );
            return api;
        }
    };

    /* The jQuery plugin */
    $.fn[_PLUGIN_] = function(options){
        options = $.extend( true, {} , $[_PLUGIN_].defaults , options );

        return this.each(function(){
            $(this).data( _PLUGIN_, new $[_PLUGIN_]( $(this), options )._api_() );
        });

    };

}));