<!DOCTYPE html>
<html>

	<head>
		<meta charset="UTF-8">
		<title></title>
	</head>
	<style type="text/css">
		body,
		html {
			margin: 0;
			width: 100%;
			overflow: hidden;
			background: #000000;
		}
		
		canvas {
			position: absolute;
			width: 100%;
		}
		
		.control {
			position: absolute;
		}
		
		.control input {
			border: 0;
			margin: 0;
			padding: 15px;
			outline: none;
			text-align: center;
		}
		
		.control button {
			border: 0;
			margin: 0;
			padding: 15px;
			outline: none;
			background: #333;
			color: #fff;
		}
		
		.control button:focus,
		.control button:hover {
			background: #222
		}
	</style>
	<script src="js/jquery.min.js" type="text/javascript" charset="utf-8"></script>

	<body>
		<div class="control" style="position:absolute">
		</div>
	</body>
	<script type="text/javascript">
		var can = document.createElement("canvas");
		document.body.appendChild(can);
		var ctx = can.getContext('2d');
		var Fireworks = function() {
			var self = this;
			var rand = function(rMi, rMa) { return ~~((Math.random() * (rMa - rMi + 1)) + rMi); }
			var hitTest = function(x1, y1, w1, h1, x2, y2, w2, h2) { return !(x1 + w1 < x2 || x2 + w2 < x1 || y1 + h1 < y2 || y2 + h2 < y1); };
			self.init = function() {
				self.canvas = document.createElement('canvas');
				self.canvas.width = self.cw = $(window).innerWidth();
				self.canvas.height = self.ch = $(window).innerHeight();
				self.particles = [];
				self.partCount = 150;
				self.fireworks = [];
				self.mx = self.cw / 2;
				self.my = self.ch / 2;
				self.currentHue = 30;
				self.partSpeed = 5;
				self.partSpeedVariance = 10;
				self.partWind = 50;
				self.partFriction = 5;
				self.partGravity = 1;
				self.hueMin = 0;
				self.hueMax = 360;
				self.fworkSpeed = 4;
				self.fworkAccel = 10;
				self.hueVariance = 30;
				self.flickerDensity = 25;
				self.showShockwave = true;
				self.showTarget = false;
				self.clearAlpha = 25;
				$(document.body).append(self.canvas);
				self.ctx = self.canvas.getContext('2d');
				self.ctx.lineCap = 'round';
				self.ctx.lineJoin = 'round';
				self.lineWidth = 1;
				self.bindEvents();
				self.canvasLoop();
				self.canvas.onselectstart = function() {
					return false;
				};
			};
			self.createFireworks = function(startX, startY, targetX, targetY) {
				var newFirework = {
					x: startX,
					y: startY,
					startX: startX,
					startY: startY,
					hitX: false,
					hitY: false,
					coordLast: [
						{ x: startX, y: startY },
						{ x: startX, y: startY },
						{ x: startX, y: startY }
					],
					targetX: targetX,
					targetY: targetY,
					speed: self.fworkSpeed,
					angle: Math.atan2(targetY - startY, targetX - startX),
					shockwaveAngle: Math.atan2(targetY - startY, targetX - startX) + (90 * (Math.PI / 180)),
					acceleration: self.fworkAccel / 100,
					hue: self.currentHue,
					brightness: rand(50, 80),
					alpha: rand(50, 100) / 100,
					lineWidth: self.lineWidth
				};
				self.fireworks.push(newFirework);
			};
			self.canvasLoop = function() {
				window.requestAnimationFrame(self.canvasLoop, self.canvas);
				self.ctx.globalCompositeOperation = 'destination-out';
				self.ctx.fillStyle = 'rgba(0,0,0,' + self.clearAlpha / 100 + ')';
				self.ctx.fillRect(0, 0, self.cw, self.ch);
				self.updateFireworks();
				self.updateParticles();
				self.drawFireworks();
				self.drawParticles();
			};
			self.drawParticles = function() {
				var i = self.particles.length;
				while(i--) {
					var p = self.particles[i];
					var coordRand = (rand(1, 3) - 1);
					self.ctx.beginPath();
					self.ctx.moveTo(Math.round(p.coordLast[coordRand].x), Math.round(p.coordLast[coordRand].y));
					self.ctx.lineTo(Math.round(p.x), Math.round(p.y));
					self.ctx.closePath();
					self.ctx.strokeStyle = 'hsla(' + p.hue + ', 100%, ' + p.brightness + '%, ' + p.alpha + ')';
					self.ctx.stroke();
					if(self.flickerDensity > 0) {
						var inverseDensity = 50 - self.flickerDensity;
						if(rand(0, inverseDensity) === inverseDensity) {
							self.ctx.beginPath();
							self.ctx.arc(Math.round(p.x), Math.round(p.y), rand(p.lineWidth, p.lineWidth + 3) / 2, 0, Math.PI * 2, false)
							self.ctx.closePath();
							var randAlpha = rand(50, 100) / 100;
							self.ctx.fillStyle = 'hsla(' + p.hue + ', 100%, ' + p.brightness + '%, ' + randAlpha + ')';
							self.ctx.fill();
						}
					}
				};
			};
			self.drawFireworks = function() {
				var i = self.fireworks.length;
				self.ctx.globalCompositeOperation = 'lighter';
				while(i--) {
					var f = self.fireworks[i];
					self.ctx.lineWidth = f.lineWidth;
					var coordRand = (rand(1, 3) - 1);
					self.ctx.beginPath();
					self.ctx.moveTo(Math.round(f.coordLast[coordRand].x), Math.round(f.coordLast[coordRand].y));
					self.ctx.lineTo(Math.round(f.x), Math.round(f.y));
					self.ctx.closePath();
					self.ctx.strokeStyle = 'hsla(' + f.hue + ', 100%, ' + f.brightness + '%, ' + f.alpha + ')';
					self.ctx.stroke();
					if(self.showTarget) {
						self.ctx.save();
						self.ctx.beginPath();
						self.ctx.arc(Math.round(f.targetX), Math.round(f.targetY), rand(1, 8), 0, Math.PI * 2, false)
						self.ctx.closePath();
						self.ctx.lineWidth = 1;
						self.ctx.stroke();
						self.ctx.restore();
					}
					if(self.showShockwave) {
						self.ctx.save();
						self.ctx.translate(Math.round(f.x), Math.round(f.y));
						self.ctx.rotate(f.shockwaveAngle);
						self.ctx.beginPath();
						self.ctx.arc(0, 0, 1 * (f.speed / 5), 0, Math.PI, true);
						self.ctx.strokeStyle = 'hsla(' + f.hue + ', 100%, ' + f.brightness + '%, ' + rand(25, 60) / 100 + ')';
						self.ctx.lineWidth = f.lineWidth;
						self.ctx.stroke();
						self.ctx.restore();
					}
				};
			};
			self.updateFireworks = function() {
				var i = self.fireworks.length;
				while(i--) {
					var f = self.fireworks[i];
					self.ctx.lineWidth = f.lineWidth;
					vx = Math.cos(f.angle) * f.speed,
						vy = Math.sin(f.angle) * f.speed;
					f.speed *= 1 + f.acceleration;
					f.coordLast[2].x = f.coordLast[1].x;
					f.coordLast[2].y = f.coordLast[1].y;
					f.coordLast[1].x = f.coordLast[0].x;
					f.coordLast[1].y = f.coordLast[0].y;
					f.coordLast[0].x = f.x;
					f.coordLast[0].y = f.y;
					if(f.startX >= f.targetX) {
						if(f.x + vx <= f.targetX) {
							f.x = f.targetX;
							f.hitX = true;
						} else {
							f.x += vx;
						}
					} else {
						if(f.x + vx >= f.targetX) {
							f.x = f.targetX;
							f.hitX = true;
						} else {
							f.x += vx;
						}
					}
					if(f.startY >= f.targetY) {
						if(f.y + vy <= f.targetY) {
							f.y = f.targetY;
							f.hitY = true;
						} else {
							f.y += vy;
						}
					} else {
						if(f.y + vy >= f.targetY) {
							f.y = f.targetY;
							f.hitY = true;
						} else {
							f.y += vy;
						}
					}
					if(f.hitX && f.hitY) {
						self.createParticles(f.targetX, f.targetY, f.hue);
						self.fireworks.splice(i, 1);
					}
				};
			};
			self.createParticles = function(x, y, hue) {
				var countdown = self.partCount;
				while(countdown--) {
					var newParticle = {
						x: x,
						y: y,
						coordLast: [
							{ x: x, y: y },
							{ x: x, y: y },
							{ x: x, y: y }
						],
						angle: rand(0, 360),
						speed: rand(((self.partSpeed - self.partSpeedVariance) <= 0) ? 1 : self.partSpeed - self.partSpeedVariance, (self.partSpeed + self.partSpeedVariance)),
						friction: 1 - self.partFriction / 100,
						gravity: self.partGravity / 2,
						hue: rand(hue - self.hueVariance, hue + self.hueVariance),
						brightness: rand(50, 80),
						alpha: rand(40, 100) / 100,
						decay: rand(10, 50) / 1000,
						wind: (rand(0, self.partWind) - (self.partWind / 2)) / 25,
						lineWidth: self.lineWidth
					};
					self.particles.push(newParticle);
				}
			};
			self.updateParticles = function() {
				var i = self.particles.length;
				while(i--) {
					var p = self.particles[i];
					var radians = p.angle * Math.PI / 180;
					var vx = Math.cos(radians) * p.speed;
					var vy = Math.sin(radians) * p.speed;
					p.speed *= p.friction;
					p.coordLast[2].x = p.coordLast[1].x;
					p.coordLast[2].y = p.coordLast[1].y;
					p.coordLast[1].x = p.coordLast[0].x;
					p.coordLast[1].y = p.coordLast[0].y;
					p.coordLast[0].x = p.x;
					p.coordLast[0].y = p.y;
					p.x += vx;
					p.y += vy;
					p.y += p.gravity;
					p.angle += p.wind;
					p.alpha -= p.decay;
					if(!hitTest(0, 0, self.cw, self.ch, p.x - p.radius, p.y - p.radius, p.radius * 2, p.radius * 2) || p.alpha < .05) {
						self.particles.splice(i, 1);
					}
				};
			};
			self.bindEvents = function() {
				$(self.canvas).on('mousedown', function(e) {
					self.mx = e.pageX - self.canvas.offsetLeft;
					self.my = e.pageY - self.canvas.offsetTop;
					self.currentHue = rand(self.hueMin, self.hueMax);
					self.createFireworks(self.cw / 2, self.ch, self.mx, self.my);
				});
				$(self.canvas).on('mouseup', function(e) {
					$(self.canvas).off('mousemove.fireworks');
				});
			};
			self.init();
		}

		function resize() {
			can.width = window.innerWidth;
			can.height = window.innerHeight;
		}
		const max_radius = 3;
		const min_radius = 1;
		//粒子大小
		const drag = 50;
		window.onresize = function() {
			resize();
		};

		function cfill() {
			ctx.fillStyle = "#000";
			ctx.fillRect(0, 0, can.width, can.height);
			ctx.fill();
		}
		resize();
		cfill();
		class Particle {
			constructor(pos, target, vel, color, radius) {
				this.pos = pos;
				this.target = target;
				this.vel = vel;
				this.color = color;
				this.radius = radius;
				this.direction = 0;
			}
			set(type, value) {
				this[type] = value;
			}

			update() {
				this.radius = 2;
				this.vel.x = (this.pos.x - this.target.x) / drag;
				this.vel.y = (this.pos.y - this.target.y) / drag;
				this.pos.x -= this.vel.x;
				this.pos.y -= this.vel.y;
			}
			draw() {
				ctx.beginPath();
				ctx.fillStyle = this.color;
				ctx.arc(this.pos.x, this.pos.y, this.radius, 0, Math.PI * 2);
				ctx.fill();
			}
		}
		var particles = [];
		var colors = ["#bf1337", "#f3f1f3", "#084c8d", "#f2d108", "#efd282"];
		var bool = true;
		var current = 0,
			i;

		function changeText(text) {
			var current = 0,
				temp, radius, color;
			ctx.fillStyle = "#fff";
			ctx.font = "160px 楷体";
			ctx.fillText(text, can.width * 0.5 - ctx.measureText(text).width * 0.5, can.height * 0.5 + 60);
			var data = ctx.getImageData(0, 0, can.width, can.height).data;
			cfill();
			for(i = 0; i < data.length; i += 12) {
				if(data[i] !== 0 && (Math.random() * 10) >= 8.8) {
					radius = max_radius - Math.random() * min_radius;
					temp = { x: (i / 4) % can.width, y: ((i / 4) / can.width) };
					color = colors[0];
					var p = new Particle(
						temp, { x: (i / 4) % can.width, y: ((i / 4) / can.width) }, { x: 0, y: 0 },
						color,
						radius);
					particles.push(p);
					++current;
				}
			}
			particles.splice(current, particles.length - current);
		}

		function draw(obj) {
			ctx.beginPath();
			ctx.arc(obj.target.x, obj.target.y, obj.radius, 0, 2 * Math.PI);
			ctx.fillStyle = obj.color;
			ctx.fill();
		}
		changeText("新年好");
		var t = 0;
		var id;
		var fworks = new Fireworks();

		function init() {
			id = window.requestAnimationFrame(init)
			if(t >= particles.length - 1) {
				window.cancelAnimationFrame(id)
			}
			draw(particles[t])
			t++;
			var rand = function(rMi, rMa) { return ~~((Math.random() * (rMa - rMi + 1)) + rMi); }
			if(t % 5 == 0) {
				fworks.currentHue = rand(0, 360);
				fworks.createFireworks($(window).innerWidth() / 2, $(window).innerHeight(), particles[t].pos.x, particles[t].pos.y);
			}
		}
		init();
	</script>

</html>