/**
 * Created by Administrator on 2017/12/13.
 * author 375361172@qq.com
 * 相对于HGAME.js扩展了多个类型
 * 扩展类
 */




/**
 * 用户操作类型
 * 一定的属性:
 * speed 左右移动速度
 * maxSpeed 左右移动的最大速度
 * moveType 左右移动的类型
 * speedT 跳跃和下落的移动速度
 * maxSpeedT 跳跃和下落的最大速度
 * moveTypeT 跳跃和下落的类型
 * jumpNum 可以拥有的跳跃次数
 * isBottom 是否在地上
 * colObj 碰撞对象
 *
 * 一定的方法:
 * changeCamera 改变镜头函数
 * colFunDx 和地形碰撞该做的处理函数
 * moveLeftRight 左右移动函数
 * moveTopBottom 跳跃下落移动函数
 *
 * */
HGAME.userObj=function(Obj){
    var THIS = this;
    //PH相关
    this.PH=100;//当前血量
    this.showPH=true;//是否显示生命值

    //伤害相关
    this.hurt=25;//每一发子弹的伤害
    this.isHurt=true;//是否接受伤害
    this.isHurtInt=0;
    this.hurtTnterval=1200;//伤害间隔
    this.hurtAnimate=new HGAME.animate({action:function(){}});//间隔动画
    this.isA=true;//是否可以攻击
    this.hurtDestance=150;//攻击距离
    this.fyl=5;//防御力


    //武器相关
    this.wuqiPointer=0;//武器图片
    this.wuqiImg=new Image();//武器图片对象

    //死亡相关
    this.death=false;//死亡
    this.removeThis=false;//是否可以从场景中移除
    this.dropNum=0.23;//怪物死亡掉落物品的概率
    this.deathGoods=new Array();
    //移动相关
    this.speed=0;//左右移动速度
    this.maxSpeed=5;//左右移动最大速度
    this.moveType="stop";  //left 左移动   right stop
    this.speedT=0;//初始向上速度
    this.maxSpeedT=11;//最大向上速度
    this.moveTypeT="bottom";//top 跳跃  bottom 下落 stop
    this.jumpNum=0;//可以跳跃的次数
    this.isBottom=false;//是否在地上
    this.frame=3;//帧数

    //方向相关
    this.isBack=false;//是否是倒退
    this.hurtDirection="";//死亡被伤害方向

    HGAME.Object2D.call(this,Obj);//继承
    this._struct="userObj";//构造类
    this.bufPH=this.PH;//备份ph 数据劫持
    this.allPH=this.PH;//总血量
    if(this.showPH){//是否显示血条默认为true
        this.phCanvas=new HGAME.canvas({
            w:this.w+22,
            h:8+2+5,//8 血条高度 2 边框 5 攻击间隔高度
            x:-11,//相对于当前对象的x
            y:-13//相对与当前对象的y
        });
        this.changePH=function(){//血条发生改变触发函数
            this.phCanvas.txt.clearRect(0,0,this.phCanvas.w,8);
            this.phCanvas.txt.beginPath();
            this.phCanvas.txt.strokeStyle="#333333";
            this.phCanvas.txt.lineWidth=1;
            this.phCanvas.txt.strokeRect(0,0,this.phCanvas.w,8);
            this.phCanvas.txt.fillStyle="#cccccc";
            this.phCanvas.txt.fillRect(1,1,this.phCanvas.w-2,6);
            this.phCanvas.txt.fillStyle="#00ff00";
            this.phCanvas.txt.fillRect(1,1,(this.phCanvas.w-2)*(this.PH/this.allPH),6);
            this.phCanvas.txt.closePath();
        };
        /*劫持PH这个属性 与其说是劫持还不如说是重写等号运算符*/

        this.add(this.phCanvas);
        this.changePH();
    }
    Object.defineProperty(this,"PH",{
        get:function(){
            return THIS.bufPH
        },
        set:function(v){

            if(THIS.bufPH-v>0){
                THIS.say("-"+(THIS.bufPH-v),{
                    color:"#ff0000"
                });
                if(THIS._struct=="userObj"){
                    THIS.isHurt=false;
                    THIS.isHurtInt=3;
                }

            }else if(THIS.bufPH-v<0){
                THIS.say("+"+(v-THIS.bufPH),{
                    color:"#00ff00"
                });
            }
            THIS.bufPH=v;
            if(v>THIS.allPH){
                THIS.bufPH=THIS.allPH;
            }
            if(THIS.bufPH<=0){
                if(THIS.death!=true){
                    THIS.death=true;
                    THIS.deathFunNow&&THIS.deathFunNow.call(THIS);
                    THIS.speedT=0;
                    THIS.speed=0;
                    THIS.bufPH=0;
                    THIS.isBack=true;
                    var num=80;
                    if(THIS.hurtDirection=="left"){
                        num=-num;
                    }
                    THIS.animate.startPoint={
                        x:THIS.x,
                        y:THIS.y
                    };
                    THIS.animate.endPoint={
                        x:THIS.x+num,
                        y:THIS.y
                    };
                    THIS.animate.centerPoint={
                        x:THIS.x,
                        y:THIS.y-40
                    };
                    if(Math.random()<THIS.dropNum){
                        if(typeof THIS.deathGoods!="undefined"){
                            for(var i = 0;i<THIS.deathGoods.length;i++){
                                THIS.deathGoods[i].x=THIS.x;
                                THIS.deathGoods[i].y=THIS.y;
                                var buf=new HGAME.Goods(THIS.deathGoods[i]);
                                THIS.parent.add(buf);
                                HGAME.goodsArr.push(buf);
                            }
                        }
                    }

                    THIS.animate.t=0;
                    THIS.deathFun();
                }
            }
            if(THIS.showPH){
                THIS.changePH();
            }

        }
    });
    this.animate=new HGAME.animate({
        time:30,
        action:function(){

        },
        frequency:10,
        lastAction:function(){

        }
    });
    //死亡动画
    function deathAnimateLast(){
        THIS.speedT=0;
        THIS.speed=0;
        this.action=function(){
            THIS.y+=10;
            if(THIS.y>800){
                THIS.removeThis=true;
                this.stop();
            }
        };
        this.frequency=-1;
        this.run();
    }
    function deathAnimate(){
        THIS.x=bezierCurve({
            t:this.t,
            P0:this.startPoint.x,
            P1:this.centerPoint.x,
            P2:this.endPoint.x
        });
        THIS.y=bezierCurve({
            t:this.t,
            P0:this.startPoint.y,
            P1:this.centerPoint.y,
            P2:this.endPoint.y
        });
        this.t+=0.1
    }
    THIS.deathFun=function(){
        THIS.animate.stop();
        THIS.animate.action=deathAnimate;
        THIS.animate.lastAction=deathAnimateLast;
        THIS.animate.run();
    };

    //改变帧
    this.changeFrame=function(){
        var buf=this.frame;
        if(this.isHurt==false){
            buf=buf+1;
        }
        if(this.W_INT>=buf-1){
            this.W_INT=0;
        }else{
            this.W_INT++;
        }
    };
    //左右移动函数
    this.moveLeftRight=function(){
        if(this.death)return;
        if(this.speed<=this.maxSpeed&&this.speed>=-this.maxSpeed){
            switch (this.moveType){
                case "left":{
                    this.speed++;
                    break;
                }
                case "right":{
                    this.speed--;
                    break;
                }
            }
        }
        if(this.moveType=='stop'){
            if(this.speed<0){
                this.speed++;
            }else if(this.speed>0){
                this.speed--;
            }
        }
        this.x=this.speed+this.x;
    };
    //跳跃下落函数
    this.moveTopBottom=function(){
        if(this.death)return;
        if(this.jumpNum==0){
            if(this.speedT<=this.maxSpeedT&&this.speedT>=-this.maxSpeedT){
                this.speedT--;
            }
            if(this.moveTypeT=="bottom"){
                if(this.speedT<=this.maxSpeedT&&this.speedT>=-this.maxSpeedT){
                    this.speedT--;
                }
            }
            this.y=this.y-this.speedT;
        }

    };
    //碰撞对象
    this.colObj=new HGAME.collision();
    this.moveLeftCon=0;
    //碰撞函数
    //bufCol 地形拥有这个属性就不会判断碰撞 且会调用一个这个对象的回调方法
    this.colFunDx=function(dxArr){
        if(this.death)return;
            var bool=false;
            for(var i =0;i<dxArr.length;i++){
                if(typeof dxArr[i].bufCol!="undefined" && dxArr[i].bufCol ==true){
                    typeof  dxArr[i].notCol=="undefined"&&dxArr[i].notCol(dxArr[i],this);
                    continue;
                }
                var zf=this.colObj.test(this,dxArr[i]);


                if(zf=="pzRB"||zf=="pzLB"||zf=="jhpzRT"||zf=="jhpzLT"){

                    if(this.moveTypeT=="top"&&this.speedT>0||this.y+this.h/2>dxArr[i].y&&this.x>dxArr[i].x+dxArr[i].w-this.w/2||this.y+this.h/2>dxArr[i].y&&this.x+this.w/2<dxArr[i].x){

                    }else{

                        if((zf=="pzRB"||zf=="jhpzLT")&&(this.y+this.h/2>dxArr[i].y&&this.x+this.w/2<dxArr[i].x)){

                        }else if((zf=="jhpzRT"||zf=="pzLB")&&(this.y+this.h/2>dxArr[i].y&&this.x+this.w/2<dxArr[i].x)){

                        }else{
                            this.y=dxArr[i].y-this.h;
                            this.jumpNum=1;
                        }

                    }
                    if(this.moveTypeT=="bottom"&&!(this.y+this.h/2>dxArr[i].y&&this.x>dxArr[i].x+dxArr[i].w-this.w/2)&&!(this.y+this.h/2>dxArr[i].y&&this.x+this.w/2<dxArr[i].x)){
                        this.jumpNum=1;
                    }
                    if((this.y+this.h/2>dxArr[i].y&&this.x>dxArr[i].x+dxArr[i].w-this.w/2)&&(zf=="pzRB"||zf=="jhpzLT")){
                        this.speed=0;
                        this.x=dxArr[i].x+dxArr[i].w;
                        this.moveLeftCon=-1;
                    }
                    if((zf=="jhpzRT"||zf=="pzLB")&&(this.y+this.h/2>dxArr[i].y&&this.x+this.w/2<dxArr[i].x)){
                        this.speed=0;
                        this.x=dxArr[i].x-this.w;
                        this.moveLeftCon=1;
                    }
                    bool=true;
                }else if(zf=="pzBT"){
                    bool=true;
                }else if(zf=="pzLT"||zf=="pzRT"){
                    if(this.speedT>0){
                        this.speedT=-this.speedT;
                    }


                    if(zf=="pzRT"&&this.y+this.h/2>dxArr[i].y&&this.x>dxArr[i].x+dxArr[i].w-this.w/2){

                        this.speed=0;
                        this.x=dxArr[i].x+dxArr[i].w;

                        this.moveLeftCon=-1;
                    }
                    if(zf=="pzLT"&&this.y+this.h/2>dxArr[i].y&&this.x+this.w/2<dxArr[i].x){
                        this.speed=0;
                        this.x=dxArr[i].x-this.w;
                        this.moveLeftCon=1;
                    }
                    bool=true;
                }else if((zf=="pzRB"||zf=="pzRT")&&this.y+this.h/2>dxArr[i].y&&this.x>dxArr[i].x+dxArr[i].w-this.w/2){
                    this.speed=0;
                    this.x=dxArr[i].x+dxArr[i].w;
                    bool=true;
                }else if(zf!="pzNO"){
                    bool=true;
                }
            }
        if(bool==false){
            this.jumpNum=0;
        }


    };
    //镜头改变函数
    this.changeCamera=function(camera){
        if(this.death)return;
        if(this.CONST_BUF_X>camera.w/2-camera.x+60){
            if(Math.abs(camera.x)+camera.w<camera.srcCanvas.w){
                camera.x-=5;
            }else{
                camera.x=-camera.srcCanvas.w+camera.w;
            }
        }else if(this.CONST_BUF_X<camera.w/2-camera.x-60){
            if( camera.x<0){
                camera.x+=5;
            }else{
                camera.x=0;
            }

        }
    };
    /*
    *
    *  this.hurtTnterval=1200;//伤害间隔
     this.hurtAnimate=new HGAME.animate();//间隔动画
     this.isA=true;
    * */
    //A间隔动画
    this.changeHurt=function(num){
        if(num>1){
            num=1;
        }
        if(typeof this.phCanvas=="undefined")return;
        this.phCanvas.txt.clearRect(0,8,this.phCanvas.w,5);
        this.phCanvas.txt.beginPath();
        this.phCanvas.txt.strokeStyle="#666666";
        this.phCanvas.txt.lineWidth=1;
        this.phCanvas.txt.moveTo(this.phCanvas.w-8,8);
        this.phCanvas.txt.lineTo(this.phCanvas.w-8,8+5);
        this.phCanvas.txt.lineTo(0,13);
        this.phCanvas.txt.lineTo(0,8);
        this.phCanvas.txt.stroke();
    //    this.phCanvas.txt.strokeRect(0,9,this.phCanvas.w-8,5);
        this.phCanvas.txt.fillStyle="#0000ff";
        this.phCanvas.txt.fillRect(1,9,(this.phCanvas.w-10)*num,3);
        this.phCanvas.txt.closePath();
    };
    this.changeHurt(1);
    //A
    this.A=function(wqArr,img,num,canvas,Obj){
        if(this.isA!=true)return;
        if(this.death)return;
        var O2d=new HGAME.Bullet({
            showPH:false,
            img:img,//图片文件
            x:Obj.x,
            y:Obj.y,
            w:Obj.w,
            h:Obj.h,
            hurt:this.hurt,//伤害
            belong:this,//属于
            startX:Obj.x,//开始的X
            JL:this.hurtDestance,//移动距离
            frame:typeof Obj=="undefined"?4:typeof Obj.jl =="undefined"?4:Obj.jl,//子弹图片的帧数量
            left:  this.H_INT==2?1:0//方向
        });
        wqArr.push(O2d);
        canvas.add(O2d);
        this.isA=false;
        var nums=Math.ceil(this.hurtTnterval/30);
        this.hurtAnimate.action=function(){
            THIS.changeHurt(1-this.frequency/nums);
        };
        this.hurtAnimate.frequency=nums;
        this.hurtAnimate.lastAction=function(){
            THIS.isA=true;
        };
        THIS.hurtAnimate.run();
    };
    //对话
    this.say=function(text,Obj){
        if(typeof Obj== "undefined"){
            Obj={};
        }
        this.sayObj=new HGAME.sayObj({
            belong:this,
            text:text,
            animateDeath:true,
            fontOption:{
                color:typeof Obj.color=="undefined"?"#ffffff":Obj.color
            },
            moveArgument:{
                start:{
                    x:-5,
                    y:(typeof Obj.pc=="undefined"?0:Obj.pc)
                },
                end:{
                    x:-5,
                    y:-40+(typeof Obj.pc=="undefined"?0:Obj.pc)
                }
            }
        });
        this.sayObj.animate.run();
        if(typeof Obj.align !="undefined"){
            if( Obj.align=="center"){
                this.sayObj.moveArgument.start.x=-Math.abs((this.sayObj.w-this.w))/2;
                this.sayObj.moveArgument.end.x=-Math.abs((this.sayObj.w-this.w))/2;

            }else if(Obj.align=="left"){
                this.sayObj.moveArgument.start.x=0;
                this.sayObj.moveArgument.end.x=0;
            }

        }else{
            this.sayObj.moveArgument.start.x=-Math.abs((this.sayObj.w-this.w))/2;
            this.sayObj.moveArgument.end.x=-Math.abs((this.sayObj.w-this.w))/2
        }
        this.sayObj.x= this.sayObj.moveArgument.end.x;
    };
    //获得物品
    this.getGoods=function(attr,val){
        switch (attr){
            case "hurtTnterval":{
                if(THIS.isSXJ==true){
                    THIS.hurtTnterval+=Math.abs(val);
                    THIS.bufHurt=parseInt(THIS.bufHurt)+parseInt(val);
                }
                    THIS.say("攻击间隔"+val);
                break;
            }
            case "hurt":{
                THIS.say("攻击力:+"+val);
                break;
            }
            case "fyl":{
                THIS.say("防御力:+"+val);
                break;
            }
            case "allPH":{
                THIS.say("生命上限:+"+val,{pc:20});
                break;
            }
            case "hurtDestance":{
                THIS.say("攻击距离:+"+val);
                    break;
                }
        }
    }
};
HGAME.userObj.prototype.THJinfo=5;

HGAME.userObj.prototype.THJtime=10;//持续时间
HGAME.userObj.prototype.THJnowTime=0;//持续时间

HGAME.userObj.prototype.THJInterTime=20;//释放技能间隔时间
HGAME.userObj.prototype.THJnowInterTime=0;//当前冷却时间
HGAME.userObj.prototype.isSkyfire=function(){//技能天火决
    if(this.THJnowInterTime>0){
        return;
    }
    if(this.THJinfo<=0){
        this.THJinfo=0;
        this.say("火源石不足");
    }else{
        this.say("天火决");
        this.THJinfo--;
    }
    this.THJnowTime=this.THJtime;
    this.THJnowInterTime=this.THJInterTime
};
HGAME.userObj.prototype.createTHJ=function(O,img){
    var buf = new HGAME.Bullet({
        x: (O.camera.w)*Math.random()-O.camera.x,
        y:-70,
        img:img,
        method:["changeFrame","changeY","colFun"],
        JLy:O.camera.w+50,
        frame:5,
        showPH:false,
        belong:this,
        w:26,
        h:62,
        hurt:this.hurt*2.5
    });
    O.bgCanvas.add(buf);
    HGAME.wqArr.push(buf);
};

HGAME.userObj.prototype.SXJtime=20;//持续时间
HGAME.userObj.prototype.SXJnowTime=0;//持续时间

HGAME.userObj.prototype.bufHurt=0;//备份当前攻速
HGAME.userObj.prototype.isSXJ=false;
HGAME.userObj.prototype.SXJInterTime=30;//释放技能间隔时间
HGAME.userObj.prototype.SXJnowInterTime=0;//当前冷却时间
HGAME.userObj.prototype.SXJ=function(){
    this.isSXJ=true;
    this.SXJnowTime=this.SXJtime;
    this.SXJnowInterTime=this.SXJInterTime;
    this.PH=this.PH-this.PH/4;
    this.bufHurt=this.hurtTnterval;
    this.say("碎心决");
};
/**
 * 电梯型地形 (与其说它是一个方法 不如说是一个对Object2d的扩展)
 * arr 保存了需要这种效果的Object2D对象
 * camera 镜头对象 当前的镜头对象
 * fx 方向 表示电梯是向上运动还是向下运动 patrolType 巡逻类型
 *
 *
 * 被保存对象
 * yChangeSpeed 如果被保存的对象拥有这个属性那么被保存对象的Y值改变就是它
 * patrolType
 * patrolTypeArgu start end 巡逻类型的开始点和结束点
 * bufPatrolType 0
 * xChangeSpeed 巡逻类型的x改变熟读
 *
 * */
HGAME.dxElevator=function(arr,camera,fx){
    var O=new Object();
    O.arr=arr;
    O.fx=fx;
    this._struct="dxElevator";
    O.changeY=function(){
        for(var i=0;i< O.arr.length;i++){
            if(O.fx=="top"){
                if(O.arr[i].y<=-O.arr[i].h){
                    O.arr[i].y=camera.srcCanvas.h;
                }else{
                    O.arr[i].y-= (typeof O.arr[i].yChangeSpeed=="undefined"?2:O.arr[i].yChangeSpeed);
                }

            }else if(O.fx=="bottom"){
                if(O.arr[i].y>=camera.srcCanvas.h){
                    O.arr[i].y=-O.arr[i].h;
                }else{
                    O.arr[i].y+=(typeof O.arr[i].yChangeSpeed=="undefined"?2:O.arr[i].yChangeSpeed);
                }
            }else if(O.fx=="patrolType"){
                if(O.arr[i].x>= O.arr[i].patrolTypeArgu.end.x){
                    O.arr[i].bufPatrolType=1;
                }else if(O.arr[i].x<= O.arr[i].patrolTypeArgu.start.x){
                    O.arr[i].bufPatrolType=0;
                }
                if(O.arr[i].bufPatrolType==0){
                    O.arr[i].x+=(typeof O.arr[i].xChangeSpeed=="undefined"?1:O.arr[i].xChangeSpeed);
                }else{
                    O.arr[i].x-=(typeof O.arr[i].xChangeSpeed=="undefined"?1:O.arr[i].xChangeSpeed);
                }

            }
        }
    };
    return O;
};

/**
 * 基本怪物类型
 * changeGs //改变关数触发函数
 *
 * */
HGAME.Object2DMonster=function(Obj){
    var THIS = this;
    Object.defineProperty(this,"x",{
        set:function(v){
            if(v>THIS.bufX){
                if(THIS.isBack){
                    THIS.H_INT=1;
                }else{
                    THIS.H_INT=2;
                }

            }else if(v<THIS.bufX){
                if(THIS.isBack){
                    THIS.H_INT=2;
                }else{
                    THIS.H_INT=1;
                }

            }
            THIS.bufX=v;
        },
        get:function(){
            return THIS.bufX;
        }
    });
    this.deathFunNow=function(){

    }; //死亡触发函数
    this.removeCarmeFun=function(){

    }; //移除触发函数
    HGAME.userObj.call(this,Obj);
    this._struct="Object2DMonster";
    this.moveLeft=1;
    this.moveLeftRight=function(){
        if(this.death)return;
        if(this.moveLeftCon==-1){
            this.moveLeft=1;
        }else if(this.moveLeftCon==1){
            this.moveLeft=0;
        }
        if(this.moveLeft==1){
            this.x++;
        }else{
            this.x--;
        }
    };
    this.patrolLeft=1;
    this.colHurt=function(Obj){
        if(this.death==true)return;
        var str=this.colObj.test(this,Obj);
        if(str!="pzNO"&&Obj.isHurt==true){

                Obj.PH-=(this.hurt-Obj.fyl>0?this.hurt-Obj.fyl:1);

                /*Obj.animate.action=function(){};
                Obj.animate.frequency=80;
                Obj.animate.lastAction=function(){
                    Obj.isHurt=true;
                };
                Obj.animate.run();*/
        }
    };
    this.patrol=function(){
        if(this.death)return;
        var argumentObj=this["patrolArguments"];
        if(this.x>=argumentObj.endX){
            this.patrolLeft=0;
        }else if(this.x<=argumentObj.startX){
            this.patrolLeft=1;
        }
        if(this.patrolLeft==1){

            this.x=this.x+(typeof argumentObj.speed=="undefined"?1:argumentObj.speed);
        }else if(this.patrolLeft==0){

            this.x=this.x-(typeof argumentObj.speed=="undefined"?1:argumentObj.speed);
        }
        argumentObj.callback&& argumentObj.callback.call(this,argumentObj);
    };
    this.monA=function(wqArr,img,num,canvas,Obj,user){
        if(Math.abs(user.x-this.x)<this.hurtDestance&&Math.abs(user.y-this.y)<=64)
        this.A(wqArr,img,num,canvas,Obj);
    };
    this.moveLeft02=function(dxArr){
        if(this.speed<this.maxSpeed){
            this.speed++;
        }
        this.x+=this.speed;
        var str="";
        if(Math.random()<0.25){
            if(this.jumpNum>0){
                this.jumpNum--;
                this.speedT=this.maxSpeedT;
                this.moveTypeT="top";
                this.behaviorEnd=true;
            }
        }
        for(var i = 0;i<dxArr.length;i++){
            str=this.colObj.test(this,dxArr[i]);
            //console.log(str);
            if(str=="pzLT"||str=="pzLB"){
                this.behaviorEnd=true;
            }
        }
    };
    this.moveRight=function(dxArr){
        if(this.speed>-this.maxSpeed){
            this.speed--;
        }
        this.x+=this.speed;
        var str="";
        if(Math.random()<0.25){
            if(this.jumpNum>0){
                this.jumpNum--;
                this.speedT=this.maxSpeedT;
                this.moveTypeT="top";
                this.behaviorEnd=true;
            }
        }
        for(var i = 0;i<dxArr.length;i++){
            str=this.colObj.test(this,dxArr[i]);
            if(str=="pzRT"||str=="pzRB"){
                this.behaviorEnd=true;
            }
        }
    }
    this.znHT=function(u){
        if(Math.abs(u.x-this.x)>this.hurtDestance)return;
        if(u.x+30>this.x){
            this.nowBehavior=0;
        }else if(u.x-30<this.x){
            this.nowBehavior=1;
        }
    }
};
/*
* 怪物扩展方法
* 行为
*
*
* */

HGAME.Object2DMonster.prototype.nowBehavior=0;
HGAME.Object2DMonster.prototype.behaviorEnd=true;
HGAME.Object2DMonster.prototype.behavior=function(O){
    if(this.behaviorEnd){
        this.behaviorEnd=false;
        this.nowBehavior=parseInt(Math.random()*2);
    }
    switch (this.nowBehavior){
        case 0:{
            this.moveLeft02(HGAME.dxArr);
            break;
        }
        case 1:{
            this.moveRight(HGAME.dxArr);
            break;
        }
    }
};




/**
 * 子弹类型
 * startX
 * JL
 *
 *
 *
 * */
HGAME.Bullet=function(Obj){
    this.left=1;
    this.top=1;
    this.frame=4;
    this.hurt=5;
    this.startY=0;
    this.JLy=150;
    this.method=["changeFrame","changeX","colFun"];
    HGAME.userObj.call(this,Obj);

    this.death=false;
    this._struct="Bullet";
    this.changeFrame=function(){
        if(this.W_INT>=this.frame-1){
            this.W_INT=0;
        }else{
            this.W_INT++;
        }
    };
    this.changeX=function(){
        if(Math.abs(this.x-this.startX)>this.JL){
            this.death=true;
        }else{
            if(this.left==1){
                this.x+=5;
            }else{
                this.x-=5;
            }
        }
    };
    this.changeY=function(){
        if(Math.abs(this.y-this.startY)>this.JLy){
            this.death=true;
        }else{
            if(this.top==1){
                this.y+=5;
            }else{
                this.x-=5;
            }
        }
    };
    this.colObj=new HGAME.collision();

    this.colFun=function(Obj){
        var user=typeof  Obj.user=="undefined"?[]:Obj.user;
        var dxArr=typeof  Obj.dxArr=="undefined"?[]:Obj.dxArr;
        var monArr=typeof  Obj.monArr=="undefined"?[]:Obj.monArr;
        var strUser=this.colObj.test(this,user);
        if(strUser!="pzNO"){

            if((strUser.indexOf("L")!=-1&&strUser.indexOf("jh")==-1)||(strUser.indexOf("R")!=-1&&strUser.indexOf("jh")!=-1)){
                user.hurtDirection="right";
            }else{
                user.hurtDirection="left";
            }
            if(user.isHurt&&this.belong!=user){
                if(this.hurt<=user.fyl){
                    user.PH-=1;
                }else{
                    user.PH-=(this.hurt-user.fyl);
                }

                this.death=true;
            }

        }
        for(var i = 0;i<monArr.length;i++){
            var str=this.colObj.test(this,monArr[i]);
            if((str.indexOf("L")!=-1&&str.indexOf("jh")==-1)||(str.indexOf("R")!=-1&&str.indexOf("jh")!=-1)){
                monArr[i].hurtDirection="right";
            }else{
                monArr[i].hurtDirection="left";
            }
            if(str!="pzNO"&&monArr[i].isHurt){
                if(monArr[i].death==true)return;
                if(this.belong==user){
                    if(monArr[i].fyl>this.hurt){
                        monArr[i].PH-=1;
                    }else{
                        monArr[i].PH-=(this.hurt-monArr[i].fyl);
                    }

                    this.death=true;
                }

            }
        }
        for( i = 0;i<dxArr.length;i++){
            if(this.colObj.test(this,dxArr[i])!="pzNO"){
                this.death=true;
            }
        }
    };
};

/**
 * 物品类型
 *
 *
 * */
HGAME.Goods=function(Obj){
    this.Y_INT=0;
    this.bufY=2;
    this.addY=true;
    this.death=false;
    this.attr="hurtDestance=>-10";
    HGAME.Object2D.call(this,Obj);
    this.img=new Image();
    this.img.src=this.imgSrc;
    this.colObj=new HGAME.collision();
    this.colMethod=function(Obj){
        if( this.colObj.test(Obj,this)!="pzNO"){
            if(this.death==true)return;
            var buf=this.attr.split("&");
            this.death=true;
            for(var i =0;i<buf.length;i++){
                var bufs=buf[i].split("=>");
                Obj[bufs[0]]=Obj[bufs[0]]+parseInt(bufs[1]);
                Obj.getGoods(bufs[0],bufs[1]);
            }
        }
    };
    this.animate=function(){
        if(this.Y_INT>this.bufY){
            this.addY=!this.addY;
            this.Y_INT=0;
        }
        this.Y_INT++;
        if(this.addY){
            this.y++;
        }else{
            this.y--;
        }
    }
};

/**
* 对话类型
* */
HGAME.sayObj=function(Obj){
    if(typeof Obj=="undefined"){
        Obj={};
    }
    var THIS = this;

    this.animateDeath=false;
    this.moveArgument={
        start:{
            x:-5,
            y:0
        },
        end:{
            x:-5,
            y:-40
        }
    };
    this.fontOption={
        fontSize:16,
        color:"#ffffff",
        lineHeight:30,
        bgColor:"rgba(0,0,0,0)"
    };
    this.belong=null;//属于
    this.buffer="normal normal {size}/{line} arial";

    this.animateInt=0;
    this.animateIntBuf=0;

    extend(this.moveArgument,Obj.moveArgument);
    extend(this.fontOption,Obj.fontOption);
    if(typeof Obj.moveArgument!="undefined")delete Obj.moveArgument;
    if(typeof Obj.fontOption!="undefined")delete Obj.fontOption;
    this.text="my name";


    this.changeText=function(){
        this.txt.font=this.buffer.replace("{size}",this.fontOption.fontSize+"px").replace("{line}",this.fontOption.lineHeight+"px");

        this.w=this.txt.measureText(this.text).width;
        this.h=this.fontOption.lineHeight;
        this.txt.beginPath();

        this.txt.clearRect(0,0,this.w,this.h);
        this.txt.fillStyle=this.fontOption.bgColor;
        this.txt.fillRect(0,0,this.w,this.h);
        this.txt.font=this.buffer.replace("{size}",this.fontOption.fontSize+"px").replace("{line}",this.fontOption.lineHeight+"px");

        this.txt.fillStyle=this.fontOption.color;
        this.txt.textBaseline="top";
        this.txt.textAlign="left";

       this.txt.fillText(this.text,0,0);
        this.txt.closePath();
    };
    this.changeInfo=1;
    this.time=30;
    HGAME.canvas.call(this,Obj);
    this._struct="sayObj";
    defineEx(this,"text",this.text,function(){
        this.changeText();
    });

    this.x=this.moveArgument.start.x;
    this.y=this.moveArgument.start.y;

    this.animate=new HGAME.animate({
        action:function(){
            THIS.transition();
        },
        time:this.time
    });
    this.transition=function(){
        if(this.animateIntBuf>=this.animateInt){
            if(THIS.animateDeath){
                THIS.belong.remove(THIS);
                THIS.animate.stop();
            }
            this.animateIntBuf=0;
            this.x=this.moveArgument.start.x;
            this.y=this.moveArgument.start.y;
        }else{
          //  debugger;
            if(this.moveArgument.end.x>0){
                if(this.x<this.moveArgument.end.x){
                    this.x=this.x+this.changeInfo;
                }
            }else{
                if(this.x>this.moveArgument.end.x){
                    this.x=this.x-this.changeInfo;
                }
            }

            if(this.moveArgument.end.y>0){
                if(this.y<this.moveArgument.end.y){
                    this.y=this.y+this.changeInfo;
                }
            }else{
                if(this.y>this.moveArgument.end.y){
                    this.y=this.y-this.changeInfo;
                }
            }

            this.animateIntBuf++;
        }
    };
    this.initAnimateInt=function(){
        this.animateInt= Math.abs((this.moveArgument.start.x-this.moveArgument.end.x)/this.changeInfo);
        var buf = Math.abs((this.moveArgument.start.y-this.moveArgument.end.y)/this.changeInfo);
        if(!(this.animateInt-buf>0)){
            this.animateInt=buf;
        }
        this.animateInt=Math.abs(this.animateInt);
    };
    this.changeText();
    this.initAnimateInt();
    this.belong.add(this);
};



