function startMove(obj, from, to, fn) {
  var startTime = nowTime();
  var Tween = Math.tween || window.Tween;
  var method = 'Expo.easeInOut';
  var interval = 1000;
  var tweenKey = method.split('.');
  var fnGetValue = null;
  var getIE = ifIe();

  if (tweenKey.length === 1) {
    fnGetValue = Tween[tweenKey[0]];
  } else {
    fnGetValue = Tween[tweenKey[0]][tweenKey[1]];
  }

  var step = function () {
    var changeTime = nowTime();
    var time = interval - Math.max(0, startTime - changeTime + interval);
    var value = fnGetValue(time, from, to - from, interval);

    if (getIE) {
      obj.style.top = value + '%';
    } else {
      obj.style.transform = 'translate3d(0px, '+value+'%, 0px)';
    }

    if (time === interval) {
      cancelAnimationFrame(step);

      fn && fn.call(obj);
    } else {
      requestAnimationFrame(step);
    }
  };
  step();
};

function getStyle(obj, name) {
  return obj.currentStyle ? obj.currentStyle[name] : getComputedStyle(obj, false)[name];
};

function nowTime() {
  return new Date().getTime();
};

function ifIe() { // IE10 以下
  if(navigator.appName == "Microsoft Internet Explorer"&&parseInt(navigator.appVersion.split(";")[1].replace(/[ ]/g, "").replace("MSIE",""))<10){
      return true;
    }
};