(function($) {
    $.fn.clockTimePicker = function(K) {
        var L = $.extend({
            afternoonHoursInOuterCircle: false,
            colors: {
                buttonTextColor: '#0797FF',
                clockFaceColor: '#EEEEEE',
                clockInnerCircleTextColor: '#888888',
                clockOuterCircleTextColor: '#000000',
                hoverCircleColor: '#DDDDDD',
                popupBackgroundColor: '#FFFFFF',
                popupHeaderBackgroundColor: '#0797FF',
                popupHeaderTextColor: '#FFFFFF',
                selectorColor: '#0797FF',
                selectorNumberColor: '#FFFFFF'
            },
            fonts: {
                fontFamily: 'Arial',
                clockOuterCircleFontSize: 14,
                clockInnerCircleFontSize: 12,
                buttonFontSize: 20
            },
            i18n: {
                okButton: 'OK',
                cancelButton: 'Cancel'
            },
            modeSwitchSpeed: 500,
            onChange: function(a, b) {},
            onClose: function() {},
            onModeSwitch: function() {},
            onOpen: function() {},
            popupWidthOnDesktop: 200,
            vibrate: true
        }, K);
        if (isMobile()) {
            var M = '.clock-timepicker input::selection { background:rgba(255,255,255,0.6); }' + '.clock-timepicker input::-moz-selection { background:rgba(255,255,255,0.6); }';
            var N = document.createElement('style');
            N.type = 'text/css';
            if (N.styleSheet) N.styleSheet.cssText = M;
            else N.appendChild(document.createTextNode(M));
            (document.head || document.getElementsByTagName('head')[0]).appendChild(N)
        }
        return this.each(function() {
            if (!('vibrate' in navigator)) L.vibrate = false;
            var j = $(this);
            j.val(formatTime(j.val()));
            var k = j.val();
            var l = j[0].onchange;
            j[0].onchange = '';
            var n = 'HOUR';
            var o = false;
            var p = false;
            var q = isMobile() ? $(document).width() - 80 : L.popupWidthOnDesktop;
            var r = q - (isMobile() ? 50 : 20);
            var t = parseInt(r / 2);
            var u = parseInt(r / 2);
            var v = parseInt(r / 2);
            var w = t - 16;
            var z = w - 29;
            j.wrap('<div class="clock-timepicker" style="display:inline-block; position:relative">');
            var A;
            if (isMobile()) {
                A = $('<div>');
                A.css('zIndex', 99998).css('display', 'none').css('position', 'fixed').css('top', '0px').css('left', '0px').css('width', '100%').css('height', '100%').css('backgroundColor', 'rgba(0,0,0,0.6)');
                A.on('touchmove', function(a) {
                    a.preventDefault()
                });
                A.on('click', function(a) {
                    a.preventDefault();
                    a.stopImmediatePropagation();
                    if (n == 'HOUR') selectHourOnInputElement();
                    else selectMinuteOnInputElement();
                    return false
                });
                $('body').append(A)
            }
            var B = $('<div>');
            B.css('display', 'none').css('zIndex', 99999).css('cursor', 'default').css('position', 'absolute').css('width', q + 'px').css('backgroundColor', L.colors.popupBackgroundColor).css('box-shadow', '0 4px 20px 0px rgba(0, 0, 0, 0.14)').css('border-radius', '5px');
            if (isMobile()) {
                B.css('position', 'fixed').css('left', '40px').css('top', '40px')
            }
            if (isMobile()) {
                B.on('touchmove', function(a) {
                    a.preventDefault()
                });
                B.on('click', function(a) {
                    a.stopImmediatePropagation();
                    if (n == 'HOUR') selectHourOnInputElement();
                    else selectMinuteOnInputElement();
                    return false
                })
            }
            j.parent().append(B);
            $(window).on('click', function(a) {
                if (!isMobile() && B.css('display') != 'none' && !($(a.target)[0] == C[0] || $.contains(C.parent()[0], $(a.target)[0]))) {
                    hideTimePicker()
                }
            });
            var C = j;
            if (isMobile()) {
                C = $('<input type="text">');
                C.css('display', 'inline-block').css('width', '100%').css('border', '0px').css('outline', '0px').css('fontSize', isMobile() ? '40px' : '20px').css('padding', '10px 0px').css('textAlign', 'center').css('color', L.colors.popupHeaderTextColor).css('backgroundColor', L.colors.popupHeaderBackgroundColor);
                C.prop('readonly', true);
                B.append(C)
            }
            C.on('dragenter', function(a) {
                a.stopImmediatePropagation();
                a.preventDefault();
                return false
            });
            C.on('dragover', function(a) {
                a.stopImmediatePropagation();
                a.preventDefault();
                return false
            });
            C.on('drop', function(a) {
                a.stopImmediatePropagation();
                a.preventDefault();
                return false
            });
            C.on('keyup', function(a) {
                var b = formatTime(C.val());
                if ((a.keyCode >= 48 && a.keyCode <= 57) && (C[0].selectionStart == 2 || (new RegExp('^[0-9]{2}:$').test(C.val())) || C.val().length == 5)) {
                    C.val(b);
                    switchToMinuteMode();
                    selectMinuteOnInputElement()
                } else if ((a.keyCode == 8 || a.keyCode == 46) && C.val() && C.val()[C.val().length - 1] == ':') {
                    b = formatTime(C.val() + '00');
                    C.val(b);
                    selectMinuteOnInputElement()
                } else if ((a.keyCode == 8 || a.keyCode == 46) && C.val() && C.val()[0] == ':') {
                    b = formatTime('00' + C.val());
                    C.val(b);
                    selectHourOnInputElement()
                }
                if (k != b) {
                    repaintClock();
                    L.onChange(b, k);
                    if (l) l(a)
                }
            });
            C.on('keydown', function(a) {
                k = formatTime(C.val());
                if (a.keyCode >= 48 && a.keyCode <= 57) {
                    if (C.val().length == 5 && C[0].selectionStart == 5 && a.keyCode != 8) {
                        a.preventDefault();
                        return false
                    }
                } else if (a.keyCode == 9) {} else if (a.keyCode == 13) {
                    hideTimePicker();
                    C.trigger('blur')
                } else if (a.keyCode == 27) {
                    hideTimePicker();
                    C.trigger('blur')
                } else if (a.keyCode == 8 || a.keyCode == 46) {
                    if (C[0].selectionStart == 0 && C[0].selectionEnd == 2) {
                        a.preventDefault();
                        if (C.val().substring(0, 2) == '00') {
                            C.val('');
                            switchToHourMode()
                        } else {
                            C.val('00:' + C.val().substring(3));
                            selectHourOnInputElement()
                        }
                    } else if (C[0].selectionStart == 3 && C[0].selectionEnd == 5) {
                        a.preventDefault();
                        if (C.val().substring(3) == '00') {
                            if (C.val() == '00:00') C.val('');
                            switchToHourMode();
                            selectHourOnInputElement()
                        } else {
                            C.val(C.val().substring(0, 2) + ':00');
                            selectMinuteOnInputElement()
                        }
                    }
                } else if ((a.keyCode == 36 || a.keyCode == 37) && C.val() != '') {
                    C.val(formatTime(C.val()));
                    selectHourOnInputElement();
                    switchToHourMode()
                } else if ((a.keyCode == 35 || a.keyCode == 39) && C.val() != '') {
                    C.val(formatTime(C.val()));
                    selectMinuteOnInputElement();
                    switchToMinuteMode()
                } else if (a.keyCode == 190) {
                    a.preventDefault();
                    if (C.val().length == 0) C.val('0');
                    C.val(formatTime(C.val()));
                    selectMinuteOnInputElement();
                    switchToMinuteMode()
                } else if (a.keyCode == 38 || a.keyCode == 40) {
                    a.preventDefault();
                    if (k == '') return;
                    (new RegExp('^([0-9]{1,2})(:([0-9]{1,2}))?$')).test(C.val());
                    var h = parseInt(RegExp.$1);
                    var m = RegExp.$3 ? parseInt(RegExp.$3) : 0;
                    if (n == 'HOUR') {
                        if (a.keyCode == 38) h -= 1;
                        else h += 1; if (h == -1) h = 23;
                        if (h == 24) h = 0
                    } else {
                        if (a.keyCode == 38) m -= 1;
                        else m += 1; if (m == -1) m = 59;
                        if (m == 60) m = 0
                    }
                    C.val((h < 10 ? '0' : '') + h + ':' + (m < 10 ? '0' : '') + m);
                    repaintClock();
                    if (n == 'HOUR') selectHourOnInputElement();
                    else selectMinuteOnInputElement()
                } else {
                    a.preventDefault()
                }
            });
            j.on('mousewheel', function(a) {
                processMouseWheelEvent(a)
            });
            j.on('blur', function(a) {
                setTimeout(function() {
                    if ($(document.activeElement)[0] != $('body')[0] && !$.contains(j.parent()[0], $(document.activeElement)[0])) {
                        hideTimePicker()
                    }
                }, 1)
            });
            j.on('focus', function(a) {
                if (B.css('display') == 'none') {
                    p = true;
                    setTimeout(function() {
                        p = false
                    }, 500);
                    showTimePicker();
                    selectHourOnInputElement()
                }
            });
            j.on('change', function(a) {
                if (B.css('display') == 'none') return;
                repaintClock();
                if (n == 'HOUR') selectHourOnInputElement();
                else selectMinuteOnInputElement()
            });
            C.on('click', function(a) {
                processClick(a)
            });
            C.on('contextmenu', function(a) {
                a.stopImmediatePropagation();
                a.preventDefault();
                processClick(a);
                return false
            });
            var D = $('<div>');
            D.css('position', 'relative').css('width', r + 'px').css('height', r + 'px').css('margin', '10px ' + (isMobile() ? 25 : 10) + 'px');
            B.append(D);
            var E = $('<canvas>');
            E.css('cursor', 'default').css('position', 'absolute').css('top', '0px').css('left', '0px');
            E.attr('width', r);
            E.attr('height', r);
            registerDraggingEventsOnCanvas(E);
            D.append(E);
            var F = $('<canvas>');
            F.css('cursor', 'default').css('position', 'absolute').css('top', '0px').css('left', '0px').css('display', 'none');
            F.attr('width', r);
            F.attr('height', r);
            registerDraggingEventsOnCanvas(F);
            D.append(F);
            if (isMobile()) {
                var G = $('<div>');
                G.css('text-align', 'right').css('padding', '15px 30px');
                G.html('<div id="log"></div>');
                var H = '<a style="text-decoration:none; color:' + L.colors.buttonTextColor + '; font-family:Arial; font-size:' + L.fonts.buttonFontSize + 'px; padding-left:30px">';
                var I = $(H);
                I.html(L.i18n.cancelButton);
                I.on('click', function() {
                    hideTimePicker()
                });
                G.append(I);
                var J = $(H);
                J.html(L.i18n.okButton);
                J.on('click', function() {
                    if (isMobile()) j.val(C.val());
                    if (L.vibrate) navigator.vibrate(10);
                    hideTimePicker()
                });
                G.append(J);
                B.append(G)
            }

            function registerDraggingEventsOnCanvas(b) {
                if (!isMobile()) {
                    b.on('mousedown', function(a) {
                        var x = a.pageX - $(this).offset().left;
                        var y = a.pageY - $(this).offset().top;
                        processTimeSelection(x, y);
                        o = true
                    });
                    b.on('mouseup', function(a) {
                        o = false;
                        var x = a.pageX - $(this).offset().left;
                        var y = a.pageY - $(this).offset().top;
                        if (!processTimeSelection(x, y, true)) return false;
                        if (n == 'MINUTE') {
                            hideTimePicker()
                        } else {
                            switchToMinuteMode();
                            selectMinuteOnInputElement()
                        }
                    });
                    b.on('mousemove', function(a) {
                        var x = a.pageX - $(this).offset().left;
                        var y = a.pageY - $(this).offset().top;
                        processTimeSelection(x, y)
                    });
                    b.on('mouseleave', function(a) {
                        if (n == 'HOUR') repaintClockHourCanvas();
                        else repaintClockMinuteCanvas()
                    });
                    b.on('mousewheel', function(a) {
                        processMouseWheelEvent(a)
                    })
                } else {
                    b.on('touchstart', function(a) {
                        a.preventDefault();
                        var x = a.originalEvent.touches[0].pageX - $(this).offset().left;
                        var y = a.originalEvent.touches[0].pageY - $(this).offset().top;
                        processTimeSelection(x, y);
                        o = true
                    });
                    b.on('touchend', function(a) {
                        a.preventDefault();
                        o = false;
                        switchToMinuteMode();
                        selectMinuteOnInputElement()
                    });
                    b.on('touchmove', function(a) {
                        a.preventDefault();
                        if (o) {
                            var x = a.originalEvent.touches[0].pageX - $(this).offset().left;
                            var y = a.originalEvent.touches[0].pageY - $(this).offset().top;
                            processTimeSelection(x, y)
                        }
                    })
                }
            }

            function processClick(a) {
                if (p) return;
                if (C[0].selectionStart >= 3) {
                    if (n == 'HOUR' && L.vibrate) navigator.vibrate(10);
                    switchToMinuteMode();
                    selectMinuteOnInputElement()
                } else {
                    if (n == 'MINUTE' && L.vibrate) navigator.vibrate(10);
                    switchToHourMode();
                    selectHourOnInputElement()
                }
            }

            function processMouseWheelEvent(a) {
                if (!((C[0].selectionStart == 0 && C[0].selectionEnd == 2) || (C[0].selectionStart == 3 && C[0].selectionEnd == 5))) return;
                var e = window.event || a;
                var b = Math.max(-1, Math.min(1, (e.wheelDelta || -e.detail)));
                (new RegExp('^([0-9]{1,2})(:([0-9]{1,2}))?$')).test(C.val());
                var h = parseInt(RegExp.$1);
                var m = RegExp.$3 ? parseInt(RegExp.$3) : 0;
                if (n == 'HOUR') {
                    h += b;
                    if (h == -1) h = 23;
                    if (h == 24) h = 0
                } else {
                    m += b;
                    if (m == -1) m = 59;
                    if (m == 60) m = 0
                }
                C.val((h < 10 ? '0' : '') + h + ':' + (m < 10 ? '0' : '') + m);
                repaintClock();
                if (n == 'HOUR') selectHourOnInputElement();
                else selectMinuteOnInputElement()
            }

            function processTimeSelection(x, y, a) {
                var b = (360 * Math.atan((y - v) / (x - u)) / (2 * Math.PI)) + 90;
                var c = Math.sqrt(Math.pow(Math.abs(x - u), 2) + Math.pow(Math.abs(y - v), 2));
                var d = 0;
                var e = 0;
                if ((new RegExp('^([0-9]{2}):([0-9]{2})$')).test(C.val())) {
                    d = parseInt(RegExp.$1);
                    e = parseInt(RegExp.$2)
                }
                if (n == 'HOUR') {
                    b = Math.round(b / 30);
                    var h = -1;
                    if (c < t + 10 && c > t - 28) {
                        if (x - u >= 0) {
                            if (b == 0) h = 12;
                            else h = b
                        } else if (x - u < 0) {
                            h = b + 6
                        }
                    } else if (c < t - 28 && c > t - 65) {
                        if (x - u >= 0) {
                            if (b != 0) h = b + 12;
                            else h = 0
                        } else if (x - u < 0) {
                            h = b + 18;
                            if (h == 24) h = 0
                        }
                    }
                    if (h > -1) {
                        var f = (h < 10 ? '0' : '') + h + ':' + (e < 10 ? '0' : '') + e;
                        if (o || a) {
                            var g = C.val();
                            if (f != g && L.vibrate) navigator.vibrate(10);
                            C.val(f);
                            if (f != g) {
                                setTimeout(function() {
                                    L.onChange(f, g);
                                    if (l) l(event)
                                }, 10)
                            }
                        }
                        repaintClockHourCanvas(h == 0 ? 24 : h);
                        return true
                    } else {
                        repaintClockHourCanvas();
                        return false
                    }
                } else if (n == 'MINUTE') {
                    b = Math.round(b / 6);
                    var m = -1;
                    if (c < t + 10 && c > t - 40) {
                        if (x - u >= 0) {
                            m = b
                        } else if (x - u < 0) {
                            m = b + 30;
                            if (m == 60) m = 0
                        }
                    }
                    if (m > -1) {
                        var f = (d < 10 ? '0' : '') + d + ':' + (m < 10 ? '0' : '') + m;
                        if (o || a) {
                            var g = C.val();
                            if (f != g && L.vibrate) navigator.vibrate(10);
                            C.val(f);
                            if (f != g) {
                                setTimeout(function() {
                                    L.onChange(f, g);
                                    if (l) l(event)
                                }, 10)
                            }
                        }
                        repaintClockMinuteCanvas(m == 0 ? 60 : m);
                        return true
                    } else {
                        repaintClockMinuteCanvas();
                        return false
                    }
                }
            }

            function repaintClock() {
                if (n == 'HOUR') {
                    repaintClockHourCanvas()
                } else {
                    repaintClockMinuteCanvas()
                }
            }

            function repaintClockHourCanvas(a) {
                var b = E.get(0).getContext('2d');
                (new RegExp('^([0-9]{1,2}):([0-9]{1,2})$')).test(C.val());
                var c = parseInt(RegExp.$1);
                if (c == 0) c = 24;
                if (!C.val()) c = -1;
                b.clearRect(0, 0, r, r);
                b.beginPath();
                b.arc(u, v, t, 0, 2 * Math.PI, false);
                b.fillStyle = L.colors.clockFaceColor;
                b.fill();
                if (!isMobile() && a) {
                    b.beginPath();
                    b.arc(u + Math.cos(Math.PI / 6 * ((a % 12) - 3)) * (a > 12 ? (L.afternoonHoursInOuterCircle ? w : z) : (L.afternoonHoursInOuterCircle ? z : w)), v + Math.sin(Math.PI / 6 * ((a % 12) - 3)) * (a > 12 ? (L.afternoonHoursInOuterCircle ? w : z) : (L.afternoonHoursInOuterCircle ? z : w)), 15, 0, 2 * Math.PI, false);
                    b.fillStyle = L.colors.hoverCircleColor;
                    b.fill()
                }
                b.beginPath();
                b.arc(u, v, 3, 0, 2 * Math.PI, false);
                b.fillStyle = L.colors.selectorColor;
                b.fill();
                if (c > -1) {
                    b.beginPath();
                    b.moveTo(u, v);
                    b.lineTo(u + Math.cos(Math.PI / 6 * ((c % 12) - 3)) * (c > 12 ? (L.afternoonHoursInOuterCircle ? w : z) : (L.afternoonHoursInOuterCircle ? z : w)), v + Math.sin(Math.PI / 6 * ((c % 12) - 3)) * (c > 12 ? (L.afternoonHoursInOuterCircle ? w : z) : (L.afternoonHoursInOuterCircle ? z : w)));
                    b.lineWidth = 1;
                    b.strokeStyle = L.colors.selectorColor;
                    b.stroke();
                    b.beginPath();
                    b.arc(u + Math.cos(Math.PI / 6 * ((c % 12) - 3)) * (c > 12 ? (L.afternoonHoursInOuterCircle ? w : z) : (L.afternoonHoursInOuterCircle ? z : w)), v + Math.sin(Math.PI / 6 * ((c % 12) - 3)) * (c > 12 ? (L.afternoonHoursInOuterCircle ? w : z) : (L.afternoonHoursInOuterCircle ? z : w)), 15, 0, 2 * Math.PI, false);
                    b.fillStyle = L.colors.selectorColor;
                    b.fill()
                }
                b.font = L.fonts.clockOuterCircleFontSize + 'px ' + L.fonts.fontFamily;
                for (i = 1; i <= 12; i++) {
                    var d = Math.PI / 6 * (i - 3);
                    var s = i;
                    if (L.afternoonHoursInOuterCircle) {
                        s = i + 12;
                        if (c == i + 12) b.fillStyle = L.colors.selectorNumberColor;
                        else b.fillStyle = L.colors.clockInnerCircleTextColor; if (s == 24) s = '00'
                    } else {
                        if (c == i) b.fillStyle = L.colors.selectorNumberColor;
                        else b.fillStyle = L.colors.clockOuterCircleTextColor
                    }
                    b.fillText(s, u + Math.cos(d) * w - (b.measureText(s).width / 2), v + Math.sin(d) * w + (L.fonts.clockOuterCircleFontSize / 3))
                }
                b.font = L.fonts.clockInnerCircleFontSize + 'px ' + L.fonts.fontFamily;
                for (i = 1; i <= 12; i++) {
                    var d = Math.PI / 6 * (i - 3);
                    var s = i;
                    if (!L.afternoonHoursInOuterCircle) {
                        s = i + 12;
                        if (c == i + 12) b.fillStyle = L.colors.selectorNumberColor;
                        else b.fillStyle = L.colors.clockInnerCircleTextColor; if (s == 24) s = '00'
                    } else {
                        if (c == i) b.fillStyle = L.colors.selectorNumberColor;
                        else b.fillStyle = L.colors.clockOuterCircleTextColor
                    }
                    b.fillText(s, u + Math.cos(d) * z - (b.measureText(s).width / 2), v + Math.sin(d) * z + (L.fonts.clockInnerCircleFontSize / 3))
                }
            }

            function repaintClockMinuteCanvas(a) {
                var b = F.get(0).getContext('2d');
                (new RegExp('^([0-9]{1,2}):([0-9]{1,2})$')).test(C.val());
                var c = parseInt(RegExp.$2);
                if (!C.val()) c = -1;
                b.clearRect(0, 0, r, r);
                b.beginPath();
                b.arc(u, v, t, 0, 2 * Math.PI, false);
                b.fillStyle = L.colors.clockFaceColor;
                b.fill();
                if (!isMobile() && a) {
                    if (a == 60) a = 0;
                    b.beginPath();
                    b.arc(u + Math.cos(Math.PI / 6 * ((a / 5) - 3)) * w, v + Math.sin(Math.PI / 6 * ((a / 5) - 3)) * w, 15, 0, 2 * Math.PI, false);
                    b.fillStyle = L.colors.hoverCircleColor;
                    b.fill()
                }
                b.beginPath();
                b.arc(u, v, 3, 0, 2 * Math.PI, false);
                b.fillStyle = L.colors.selectorColor;
                b.fill();
                if (c > -1) {
                    b.beginPath();
                    b.moveTo(u, v);
                    b.lineTo(u + Math.cos(Math.PI / 6 * ((c / 5) - 3)) * w, v + Math.sin(Math.PI / 6 * ((c / 5) - 3)) * w);
                    b.lineWidth = 1;
                    b.strokeStyle = L.colors.selectorColor;
                    b.stroke();
                    b.beginPath();
                    b.arc(u + Math.cos(Math.PI / 6 * ((c / 5) - 3)) * w, v + Math.sin(Math.PI / 6 * ((c / 5) - 3)) * w, 15, 0, 2 * Math.PI, false);
                    b.fillStyle = L.colors.selectorColor;
                    b.fill()
                }
                b.font = L.fonts.clockOuterCircleFontSize + 'px ' + L.fonts.fontFamily;
                for (i = 1; i <= 12; i++) {
                    var d = Math.PI / 6 * (i - 3);
                    if (c == i * 5 || (c == 0 && i == 12)) b.fillStyle = L.colors.selectorNumberColor;
                    else b.fillStyle = L.colors.clockOuterCircleTextColor;
                    var s = i * 5 == 5 ? '05' : i * 5;
                    if (s == 60) s = '00';
                    b.fillText(s, u + Math.cos(d) * w - (b.measureText(s).width / 2), v + Math.sin(d) * w + (L.fonts.clockOuterCircleFontSize / 3))
                }
                if (c > -1 && c % 5 != 0) {
                    b.beginPath();
                    b.arc(u + Math.cos(Math.PI / 6 * ((c / 5) - 3)) * w, v + Math.sin(Math.PI / 6 * ((c / 5) - 3)) * w, 2, 0, 2 * Math.PI, false);
                    b.fillStyle = 'white';
                    b.fill()
                }
            }

            function showTimePicker() {
                C.val(j.val());
                repaintClockHourCanvas();
                switchToHourMode(true);
                B.css('display', 'block');
                if (isMobile()) {
                    A.stop().css('opacity', 0).css('display', 'block').animate({
                        opacity: 1
                    }, 300)
                } else {
                    if (B.outerWidth() > j.outerWidth()) {
                        var a = parseInt((B.outerWidth() - j.outerWidth()) / 2);
                        if (a < j.offset().left) {
                            B.css('left', -a + 'px')
                        }
                    }
                    var b = j.offset().top - $(window).scrollTop();
                    var c = window.innerHeight - b - j.outerHeight();
                    if (c < B.outerHeight() && j.offset().top > B.outerHeight()) {
                        if (b < B.outerHeight()) {
                            if (b > c + j.outerHeight()) {
                                B.css('top', -B.outerHeight() + 'px')
                            } else {
                                B.css('top', j.outerHeight() + 'px')
                            }
                        } else {
                            B.css('top', -B.outerHeight() + 'px')
                        }
                    } else {
                        B.css('top', j.outerHeight() + 'px')
                    }
                }
                L.onOpen()
            }

            function hideTimePicker() {
                B.css('display', 'none');
                if (isMobile()) {
                    A.stop().animate({
                        opacity: 0
                    }, 300, function() {
                        A.css('display', 'none')
                    })
                } else {
                    j.val(formatTime(j.val()))
                }
                L.onClose()
            }

            function switchToHourMode(a) {
                if (n == 'HOUR') return;
                repaintClockHourCanvas();
                if (a) {
                    F.css('display', 'none')
                } else {
                    F.css('zIndex', 2).stop().animate({
                        opacity: 0,
                        zoom: '80%',
                        left: '10%',
                        top: '10%'
                    }, L.modeSwitchSpeed, function() {
                        F.css('display', 'none')
                    })
                }
                E.stop().css('zoom', '100%').css('left', '0px').css('top', '0px').css('display', 'block').css('opacity', 1).css('zIndex', 1);
                n = 'HOUR';
                L.onModeSwitch(n)
            }

            function switchToMinuteMode() {
                if (n == 'MINUTE') return;
                repaintClockMinuteCanvas();
                F.stop().css('display', 'block').css('zoom', '80%').css('left', '10%').css('top', '10%').css('opacity', 0).css('zIndex', 1).animate({
                    opacity: 1,
                    zoom: '100%',
                    left: '0px',
                    top: '0px'
                });
                n = 'MINUTE';
                L.onModeSwitch(n)
            }

            function selectHourOnInputElement() {
                C.focus();
                setTimeout(function() {
                    C.get(0).setSelectionRange(0, 2)
                }, 1)
            }

            function selectMinuteOnInputElement() {
                C.focus();
                setTimeout(function() {
                    C.get(0).setSelectionRange(3, 5)
                }, 1)
            }

            function formatTime(a) {
                if (a == '') return a;
                if ((new RegExp('^([0-9]{1,2})(:([0-9]{1,2}))?')).test(a)) {
                    var b = parseInt(RegExp.$1);
                    var c = parseInt(RegExp.$3);
                    if (b >= 24) b = b % 24;
                    if (c >= 60) c = c % 60;
                    a = (b < 10 ? '0' : '') + b + ':' + (RegExp.$3 ? (c < 10 ? '0' : '') + c : '00')
                } else if ((new RegExp('^:([0-9]{1,2})')).test(a)) {
                    var c = parseInt(RegExp.$1);
                    if (c >= 60) c = c % 60;
                    a = '00:' + (c < 10 ? '0' : '') + c
                } else {
                    a = '00:00'
                }
                return a
            }
        });

        function isMobile() {
            var b = false;
            (function(a) {
                if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) b = true
            })(navigator.userAgent || navigator.vendor || window.opera);
            return b
        }
    }
}(jQuery));