$.fn.extend({
    mouseMenu: function(set){
        var ul;
        if(set.options !== undefined && set.options instanceof Array){
            var skin = set.skin || 'black';
            ul = $('<ul class="auto-show contextmenu contextmenu-default '+skin+'"></ul>');
            $(this).children('.contextmenu').remove();

            var func = function(f){
                return typeof f === 'function';
            }
            var hideUl = function(){
                ul.hide();
            };
            var elem = $(this).contextmenu({id:0},function(e){
                ul.css({
                    top: e.pageY,
                    left: e.pageX
                }).show();
                if(func(set.onHandMenu)){
                    set.onHandMenu(ul,e);
                }
                return false;
            }).click(hideUl);

            for (var i in set.options) {
                var li = $('<li ind="'+i+'"><a>'+set.options[i].title+'</a></li>');
                if(set.options[i].icon){
                    li.children('a').prepend(set.options[i].icon);
                }
                if(set.size){
                    li.addClass(set.size);
                }
                if(set.options[i].disabled === true){
                    li.children('a').addClass('disabled');
                }else{
                    if(func(set.options[i].click)){
                        li.children().click(set.options[i].click);
                    }
                }
                var child = set.options[i].child;
                if(child && child.length > 0){
                    var childDiv = $('<ul p-ind="'+i+'" class="child-ul contextmenu-default '+skin+'"></ul>');
                    for (var j in child) {
                        var li2 = $('<li><a>'+child[j].title+'</a></li>');
                        if(child[j].icon){
                            li2.children('a').prepend(child[j].icon);
                        }
                        if(child[j].disabled === true || set.options[i].disabled === true){
                            li2.children('a').addClass('disabled');
                        }else{
                            if(func(child[j].click)){
                                li2.children().click(child[j].click);
                            }
                        }
                        childDiv.append(li2);
                    }
                    $('<div class="child-box"></div>').append(childDiv).appendTo(li);
                    li.children('a').append("<span><i class='fa fa-angle-right'></i></span>");
                }
                ul.append(li);
            }
            elem.append(ul);
            $(window).click(hideUl);
            if(func(set.afterInit)){
                set.afterInit(ul);
            }
        }
        return ul;
    }
})