
window.onload = function (){
			var oDivs = document.getElementsByClassName('SortItem');
			var oParent = document.getElementById('parent');
			var item = document.getElementById('drag1');
			var sent1 = {
					l : 0,
					r : oParent.offsetWidth - item.offsetWidth,
					t : 0,
					b : oParent.offsetHeight - item.offsetHeight,
					n : 10,
					grid : true,
					grid_num_x : 2,
					grid_num_y : 3,
					space:10,
					x:0,
					y:1,
				}
			init(oParent,item,sent1);
			for(var i = 0;i < oDivs.length;i++){
				var oDiv = oDivs[i];
				var sent = {
					l : 0,
					r : oParent.offsetWidth - oDiv.offsetWidth,
					t : 0,
					b : oParent.offsetHeight - oDiv.offsetHeight,
					n : 10,
					grid : true,
					grid_num_x : 2,
					grid_num_y : 3,
					space:10,
					x:0,
					y:1,
				}
				drag(oDiv,sent);
			}
			
		}



function drag(obj,sent){
			var oParent = document.getElementById('parent');
			oParent.setAttribute("data-config",sent);
			var dmW = document.documentElement.clientWidth || document.body.clientWidth;
			var dmH = document.documentElement.clientHeight || document.body.clientHeight;


			var sent = sent || {};
			var l = sent.l || 0;
			var r = sent.r || dmW - obj.offsetWidth;
			var t = sent.t || 0;
			var b = sent.b || dmH - obj.offsetHeight;
			var n = sent.n || 10;
			var grid = sent.grid || true;
			var space = sent.space || 0;
			var num_x = sent.grid_num_x > 3 || 3;
			var num_y = sent.grid_num_y > 3 || 3;
			var x = sent.x || 0;
			var y = sent.y || 0;
				
				if(grid){
					//设置父类大小
					oParent.style.width = space * (num_x+1) + obj.clientWidth * num_x + 'px';
					oParent.style.height = space * (num_y+1) + obj.clientHeight * num_y + 'px';
					//设置obj初始位置
					//obj.style.left = space + 'px';
					//obj.style.top = space + 'px';
					obj.style.left = x *  obj.clientWidth + (x+1)*space + 'px';
					obj.style.top = y *  obj.clientHeight + (y+1)*space + 'px';
					oParent.style.backgroundSize=(obj.clientWidth+space)+"px "+(obj.clientHeight+space)+"px";
					oParent.style.backgroundPosition=(space/2)+"px "+(space/2)+"px";
					//background-position: 5px 5px;
				}
			
			
			
			obj.onmousedown = function (ev){
				var oEvent = ev || event;
				var sentX = oEvent.clientX - obj.offsetLeft;
				var sentY = oEvent.clientY - obj.offsetTop;
				document.onmousemove = function (ev){
					var oEvent = ev || event;

					var slideLeft = oEvent.clientX - sentX;
					var slideTop = oEvent.clientY - sentY;

					if(slideLeft <= l){
						slideLeft = l;
					}
					if(slideLeft >= r){
						slideLeft = r;
					}
					if(slideTop <= t){
						slideTop = t;
					}
					if(slideTop >= b){
						slideTop = b;
					}

					obj.style.left = slideLeft + 'px';
					obj.style.top = slideTop + 'px';
					
					
				}
				
				

				document.onmouseup = function (){
					document.onmousemove = null;
					document.onmouseup = null;
					
					//吸附
					adsorbent(oParent,obj,sent);
				}

				return false;
			}
		}

//吸附
function adsorbent(oParent,obj,sent){
		var dmW = document.documentElement.clientWidth || document.body.clientWidth;
		var dmH = document.documentElement.clientHeight || document.body.clientHeight;


		var sent = sent || {};
		var l = sent.l || 0;
		var r = sent.r || dmW - obj.offsetWidth;
		var t = sent.t || 0;
		var b = sent.b || dmH - obj.offsetHeight;
		var n = sent.n || 10;
		var grid = sent.grid || true;
		var space = sent.space || 0;
		var num_x = sent.grid_num_x > 3 || 3;
			var num_y = sent.grid_num_y > 3 || 3;
		var x = sent.x || 0;
		var y = sent.y || 0;
	if(grid){
		var centerx = parseFloat(obj.style.left) + obj.clientWidth/2;
		var centery = parseFloat(obj.style.top) + obj.clientHeight/2;
		console.log(centerx);
		var left_num = Math.floor(centerx / obj.clientWidth);
		var top_num = Math.floor(centery / obj.clientHeight);
		if(left_num>num_x-1){
			left_num = num_x-1;
		}
		if(top_num>num_y-1){
			top_num = num_y-1;
		}
		if(left_num==num_x-1){
			//oParent.style.width = parseFloat(oParent.style.width) + obj.clientWidth+'px';
		}
		
		if(top_num==num_y-1){
			//oParent.style.height = parseFloat(oParent.style.height) + obj.clientHeight+'px';
		}
		
		obj.style.left = left_num *  obj.clientWidth + (left_num+1)*space + 'px';
		obj.style.top = top_num *  obj.clientHeight + (top_num+1)*space + 'px';
	}
}
function init(oParent,item,sent){
	oParent.ondrop = function(ev){
		console.log(ev.offsetX);
		ev.preventDefault();
		var data=ev.dataTransfer.getData("Text");
		var itemEle = document.getElementById(data);
		itemEle.removeAttribute("class");
		itemEle.removeAttribute("id");
		itemEle.classList.add("SortItem");
		drag(itemEle,sent)
		
		console.log(itemEle);
		ev.target.appendChild(itemEle);
		var oEvent = ev || event;
		itemEle.style.left = oEvent.layerX + 'px';
		itemEle.style.top = oEvent.layerY + 'px';
		adsorbent(document.getElementById('parent'),itemEle,sent);
		
		//还原拖拽item
		var old = document.createElement('div');
		old.classList.add('editItem');
		old.setAttribute('draggable','true'); 
		old.setAttribute('id','drag1'); 
		old.ondragstart = function(ev){
			ev.dataTransfer.setData("Text",ev.target.id);
		}
		document.getElementById('edit').appendChild(old);
		console.log('drop');
	}
	
	oParent.ondragover = function(ev){
		ev.preventDefault();
	}
	item.onmousedown = function(ev){
		console.log(ev.offsetX);
		console.log(ev.offsetY);
	}
	item.ondragstart = function(ev){
		ev.dataTransfer.setData("Text",ev.target.id);
		console.log(ev);
	}
	
}