$(function() {
	var $slidingBlock = $(".nav-list-wrap").find("p:last-child"); //滑块对象
	var resizeTimer = null; //定时器
	var navItemInfo = null; //缓存数据
	var $navItem = null; //导航项对象
	var navItemIndex = null; //被点击导航项的索引

	slidingBlockInfo();

	$(".nav-list-wrap").find("p").click(function() { //点击移动滑块
		$slidingBlock.css("transition", ".5s ease"); //添加过渡动画
		sessionStorage.setItem("NavItemIndex", $(this).index());//将点击对象的索引缓存到小程序中
		slidingBlockInfo();
	});

	$(window).resize(function() { //监听窗口大小变化,每隔100ms执行一次
		if(resizeTimer) {
			clearTimeout(resizeTimer);
		}
		resizeTimer = setTimeout(function() {
			$slidingBlock.css("transition", ".5s ease"); //添加过渡动画
			slidingBlockInfo();
		}, 100);
	})

	function slidingBlockInfo() { //设置滑块对应信息
		navItemIndex = sessionStorage.getItem("NavItemIndex"); //获取缓存数据
		if(!navItemIndex) { //判读缓存数据是否存在
			$navItem = $(".nav-list-wrap").find("p").eq(0);
		} else {
			$navItem = $(".nav-list-wrap").find("p").eq(navItemIndex);
		}
		$slidingBlock.css({ //设置滑块样式
			width: $navItem.width(),
			height: $navItem.height(),
			left: $navItem.offset().left,
			top: $navItem.offset().top
		});
	}

});