function getPinyin() {
	var value = document.getElementById('test').value;
	var type = document.querySelector('[name="pinyin_type"]:checked').value;
	var polyphone = document.querySelector('[name="polyphone"]').checked;
	var result = '';
	if (value) {
		switch (type) {
			case '0':
				result = pinyinUtil.getPinyin(value, ' ', true, polyphone);
				break;
			case '1':
				result = pinyinUtil.getPinyin(value, ' ', false, polyphone);
				break;
			case '2':
				result = pinyinUtil.getFirstLetter(value, polyphone);
				break;
			default:
				break;
		}
	}
	var html = result;
	if (result instanceof Array) {
		html = '<ol>';
		result.forEach(function(val) {
			html += '<li>' + val + '</li>';
		});
		html += '</ol>';
	}
	document.getElementById('result').innerHTML = html;
}
document.getElementById('test').addEventListener('input', getPinyin);
document.getElementsByName('polyphone')[0].addEventListener('change', function(e) {
	getPinyin();
});
document.addEventListener('change', function(e) {
	if (e.target.name === 'pinyin_type') {
		getPinyin();
	}
});
getPinyin();
