var imageVerify = {
    param: {
        lang: 'zh-cn',//cn-zh,en-us
        cnLng: {
            titleA: '请选择下方所有包含“',
            titleB: '”的图片。',
            refresh: '刷新',
            ok: '确定',
            error: '验证失败'
        },
        enLng: {
            titleA: 'Please select all pictures below that contain "',
            titleB: '".',
            refresh: 'Refresh',
            ok: 'Verify',
            error: 'Verification failed'
        },
        outError: ''
    },
    res: {
        choose: []
    },
    init: function (param, okCallback, refreshCallback, lang = "zh-cn") {
        if ($("#image-verify").length <= 0) {
            imageVerify.param.lang = lang;
            imageVerify.CreateHtml(param.key, param.imgArr);
            imageVerify.onOk(okCallback);
            imageVerify.onRefresh(refreshCallback);
            imageVerify.onClose();
            imageVerify.onImg();
        }
    },
    CreateHtml: function (key, imgArr) {
        var lng = imageVerify.param.lang == "en-us" ? imageVerify.param.enLng : imageVerify.param.cnLng;
        var innerHtml = `<div id="image-verify" class="image-verify">
        <div class="close"><span id="btn-close">×</span></div>
        <div class="head">${lng.titleA}<span id="image-verify-key">${key}</span>${lng.titleB}</div>
        <div id="image-verify-main" class="main">`;
        for (var i = 0; i < imgArr.length; i++) {
            innerHtml += '<div class="img" data-id="' + i + '" ><img src="' + imgArr[i] + '" alt="image"></div>';
        }
        innerHtml += `</div>
        <div class="foot">
            <span id="image-verify-error" style="display:none;">${lng.error}</span>
            <input type="button" id="btn-refresh" class="refresh" value="${lng.refresh}"/>
            <input type="button" id="btn-ok" class="ok" value="${lng.ok}"/>
        </div>
        </div>`;
        $("body").append(innerHtml);
    },
    onOk: function (okCallback) {
        $("#image-verify").on("click", "#btn-ok", function () {
            if (typeof okCallback == 'function') {
                $("#image-verify-main").addClass("loading");
                $("#btn-ok").prop("disabled", true);
                okCallback(imageVerify.res);
            }
        });
    },
    onRefresh: function(refreshCallback) {
        $("#image-verify").on("click", "#btn-refresh", function () {
            if (typeof refreshCallback == 'function') {
                refreshCallback();
            }
        });
    },
    onClose: function() {
        $("#image-verify").on("click", "#btn-close", function () {
            imageVerify.close();
        });
    },
    onImg: function () {
        $("#image-verify").on("click", "#image-verify-main .img", function () {
            var id = $(this).data("id");
            if ($(this).hasClass("choose")) {
                $(this).removeClass("choose");
                var arr = imageVerify.res.choose;
                var arrNew = [];
                for (var i = 0; i < arr.length; i++) {
                    if (arr[i] != id) {
                        arrNew.push(arr[i]);
                    }
                }
                imageVerify.res.choose = arrNew;
            } else {
                $(this).addClass("choose");
                imageVerify.res.choose.push(id);
            }
        });
    },
    refresh: function (param) {
        var innerHtml = '';
        for (var i = 0; i < param.imgArr.length; i++) {
            innerHtml += '<div class="img" data-id="' + i + '" ><img src="' + param.imgArr[i] + '" alt="image"></div>';
        }
        $("#image-verify-key").text(param.key);
        $("#image-verify-main").empty();
        $("#image-verify-main").html(innerHtml);
        $("#image-verify-error").hide();
        $("#btn-ok").prop("disabled", false);
        imageVerify.res.choose = [];
    },
    close: function () {
        $("#image-verify").remove();
    },
    showErrorMsg: function (error) {
        if (error != '') {
            $("#image-verify-error").text(error);
        }
        $("#image-verify-error").show();
    }
}