/**
 * 自定义弹窗
 * @param {Object} $
 */
(function($){
	
	/**
	 * 确认框js插件逻辑处理代码
	 * @param {Object} title
	 * @param {Object} fnConfirm
	 * @param {Object} fnCancel
	 */
	function _confirm(title, type, fnConfirm, fnCancel) {
		_createDom(title, type, fnConfirm, fnCancel);
	}
	
	/**
	 * 创建弹框id
	 */
	function _createGuid() {
		var _guid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx';
		_guid = _guid.replace(/[xy]/g, function(c) {
			var r = Math.random() * 16 | 0, v = c == 'x' ? r : r & 0x3 | 0x8;
			return v.toString(16);
		});
		return _guid.toUpperCase();
	}
	
	/**
	 * 创建弹窗内容并添加到body
	 * @param {Object} title
	 * @param {Object} fnConfirm
	 * @param {Object} fnCancel
	 */
	function _createDom(title, type, fnConfirm, fnCancel) {
		
		/**
		 * 弹窗层id
		 */
		var guid = _createGuid();
		/**
		 * div最外层
		 */
		var $jqwrapper = $('<div id="'+guid+'">').addClass('jq-confirm-wrapper');
		
		/**
		 * 遮罩层
		 */
		var $fade = $('<div>').addClass('jq-confirm-fade');
		
		/**
		 * 弹窗框
		 */
		var $jqbox = $('<div>').addClass('jq-confirm-box');
		
		/**
		 * 弹窗填充的内容文本
		 */
		var $jqTextp = $('<p>').addClass('jq-confirm-p').html(title);
		var $jqcontent = $('<div>').addClass('jq-confirm-content');
		
		/**
		 * 弹窗按钮[确认、取消]
		 */
		var $jqbtnbox = $('<div>').addClass('jq-confirm-btnbox');
		var $confrimBtn = $('<button id="jqConfrimBtn">').addClass('jq-confirm-btn jq-confirm-btn-confirm').html('确定');
		var $cancelBtn = $('<button id="jqCancelBtn">').addClass('jq-confirm-btn jq-confirm-btn-cancel').html('取消');
		
		/**
		 * 拼接div层
		 */
		$jqcontent.append($jqTextp);
		
		$jqbtnbox.append($confrimBtn);
		if(type==2) {
			$jqbtnbox.append($cancelBtn);		
		}
		$jqbox.append($jqcontent);
		$jqbox.append($jqbtnbox);
		
		$jqwrapper.append($fade);
		$jqwrapper.append( $jqbox );
		
		$('body').append($jqwrapper);
		
		/**
		 * 添加事件
		 */
		_btnEvent(guid, fnConfirm, fnCancel);
	}
	
	/**
	 * 按钮事件绑定
	 * @param {Object} guid
	 * @param {Object} fnConfirm
	 * @param {Object} fnCancel
	 */
	function _btnEvent(guid, fnConfirm, fnCancel) {
		$('#jqConfrimBtn').on('click', function(){
			if( $.isFunction(fnConfirm) ){
				fnConfirm();	
			}
			$('#'+guid).remove();
		});
		$('#jqCancelBtn').on('click', function(){
			if($.isFunction(fnCancel) ){
				fnCancel();
			}
			$('#'+guid).remove();
		});
	}
	
	function _checkMessage(message) {
		if( !!message )  {
			if( message.length >= 120) {
				throw new Error('confirm message too long.');		
			}
			return;
		}
		throw new Error('confirm message cat not empty');
	}
	
	/**
	 * 扩展jquery拥有一个confirm方法
	 */
	$.extend({
		alert: function(message, fnConfirm) {
			_confirm(message, 1, fnConfirm, null);
		}, confirm: function(message, fnConfirm, fnCancel) {
			_checkMessage(message);
			_confirm(message, 2, fnConfirm, fnCancel);
		}
	});
	
})(jQuery);