
/* cytoscape.min.js */

/**
 * This file is part of cytoscape.js 2.0.4.
 * 
 * Cytoscape.js is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 * 
 * Cytoscape.js is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License along with
 * cytoscape.js. If not, see <http://www.gnu.org/licenses/>.
 */
 
var cytoscape;(function(){var a=cytoscape=function(){return cytoscape.init.apply(cytoscape,arguments)};a.init=function(b){if(b===undefined){b={}}if(a.is.plainObject(b)){return new a.Core(b)}else{if(a.is.string(b)){return a.extension.apply(a.extension,arguments)}}};a.fn={};if(typeof exports!=="undefined"){exports=module.exports=cytoscape}window.cytoscape=cytoscape})();(function(a){a.is={string:function(b){return b!=null&&typeof b==typeof""},fn:function(b){return b!=null&&typeof b===typeof function(){}
},array:function(b){return b!=null&&b instanceof Array},plainObject:function(b){return b!=null&&typeof b===typeof{}&&!a.is.array(b)&&b.constructor===Object},number:function(b){return b!=null&&typeof b===typeof 1&&!isNaN(b)},integer:function(b){return a.is.number(b)&&Math.floor(b)===b},color:function(b){return b!=null&&typeof b===typeof""&&$.Color(b).toString()!==""},bool:function(b){return b!=null&&typeof b===typeof true},elementOrCollection:function(b){return a.is.element(b)||a.is.collection(b)},element:function(b){return b instanceof a.Element&&b._private.single
},collection:function(b){return b instanceof a.Collection&&!b._private.single},core:function(b){return b instanceof a.Core},style:function(b){return b instanceof a.Style},stylesheet:function(b){return b instanceof a.Stylesheet},event:function(b){return b instanceof a.Event},emptyString:function(b){if(!b){return true}else{if(a.is.string(b)){if(b===""||b.match(/^\s+$/)){return true}}}return false},nonemptyString:function(b){if(b&&a.is.string(b)&&b!==""&&!b.match(/^\s+$/)){return true}return false},domElement:function(b){if(typeof HTMLElement==="undefined"){return false
}else{return b instanceof HTMLElement}}}})(cytoscape);(function(a){a.util={extend:function(){var l,d,b,c,h,j,g=arguments[0]||{},f=1,e=arguments.length,k=false;if(typeof g==="boolean"){k=g;g=arguments[1]||{};f=2}if(typeof g!=="object"&&!a.is.fn(g)){g={}}if(e===f){g=this;--f}for(;f<e;f++){if((l=arguments[f])!=null){for(d in l){b=g[d];c=l[d];if(g===c){continue}if(k&&c&&(a.is.plainObject(c)||(h=a.is.array(c)))){if(h){h=false;j=b&&a.is.array(b)?b:[]}else{j=b&&a.is.plainObject(b)?b:{}}g[d]=a.util.extend(k,j,c)
}else{if(c!==undefined){g[d]=c}}}}}return g},error:function(b){if(console){if(console.error){console.error(b)}else{if(console.log){console.log(b)}else{throw b}}}else{throw b}},clone:function(d){var c={};for(var b in d){if(d.hasOwnProperty(b)){c[b]=d[b]}}return c},copy:function(b){if(b==null){return b}if(a.is.array(b)){return b.slice()}else{if(a.is.plainObject(b)){return a.util.clone(b)}else{return b}}},mapEmpty:function(d){var c=true;if(d!=null){for(var b in d){c=false;break}}return c},pushMap:function(b){var c=a.util.getMap(b);
if(c==null){a.util.setMap($.extend({},b,{value:[b.value]}))}else{c.push(b.value)}},setMap:function(c){var g=c.map;var e;var f=c.keys;var b=f.length;for(var d=0;d<b;d++){var e=f[d];if(a.is.plainObject(e)){a.util.error("Tried to set map with object key")}if(d<f.length-1){if(g[e]==null){g[e]={}}g=g[e]}else{g[e]=c.value}}},getMap:function(c){var g=c.map;var f=c.keys;var b=f.length;for(var e=0;e<b;e++){var d=f[e];if(a.is.plainObject(d)){a.util.error("Tried to get map with object key")}g=g[d];if(g==null){return g
}}return g},deleteMap:function(k){var e=k.map;var j=k.keys;var d=j.length;var c=k.keepChildren;for(var f=0;f<d;f++){var g=j[f];if(a.is.plainObject(g)){a.util.error("Tried to delete map with object key")}var h=f===k.keys.length-1;if(h){if(c){for(var b in e){if(!c[b]){delete e[b]}}}else{delete e[g]}}else{e=e[g]}}},capitalize:function(b){if(a.is.emptyString(b)){return b}return b.charAt(0).toUpperCase()+b.substring(1)},camel2dash:function(h){var e=[];for(var f=0;f<h.length;f++){var g=h[f];var b=g.toLowerCase();
var d=g!==b;if(d){e.push("-");e.push(b)}else{e.push(g)}}var c=e.length===h.length;if(c){return h}return e.join("")},dash2camel:function(f){var b=[];var e=false;for(var c=0;c<f.length;c++){var d=f[c];var g=d==="-";if(g){e=true}else{if(e){b.push(d.toUpperCase())}else{b.push(d)}e=false}}return b.join("")},trim:function(d){var c,b;for(c=0;c<d.length&&d[c]===" ";c++){}for(b=d.length-1;b>c&&d[b]===" ";b--){}return d.substring(c,b+1)},hex2tuple:function(h){if(!(h.length===4||h.length===7)||h[0]!=="#"){return
}var f=h.length===4;var e,d,c;var j=16;if(f){e=parseInt(h[1]+h[1],j);d=parseInt(h[2]+h[2],j);c=parseInt(h[3]+h[3],j)}else{e=parseInt(h[1]+h[2],j);d=parseInt(h[3]+h[4],j);c=parseInt(h[5]+h[6],j)}return[e,d,c]},hsl2tuple:function(A){var v;var o=a.util.regex.number;var t,B,k,z,c,u,w;var j=new RegExp("^"+a.util.regex.hsla+"$").exec(A);if(j){t=parseInt(j[1]);if(t<0){t=(360-(-1*t%360))%360}else{if(t>360){t=t%360}}t/=360;B=parseFloat(j[2]);if(B<0||B>100){return}B=B/100;k=parseFloat(j[3]);if(k<0||k>100){return
}k=k/100;z=j[4];if(z!==undefined){z=parseFloat(z);if(z<0||z>1){return}}if(B===0){c=u=w=Math.round(k*255)}else{function f(h,g,b){if(b<0){b+=1}if(b>1){b-=1}if(b<1/6){return h+(g-h)*6*b}if(b<1/2){return g}if(b<2/3){return h+(g-h)*(2/3-b)*6}return h}var d=k<0.5?k*(1+B):k+B-k*B;var e=2*k-d;c=Math.round(255*f(e,d,t+1/3));u=Math.round(255*f(e,d,t));w=Math.round(255*f(e,d,t-1/3))}v=[c,u,w,z]}return v},rgb2tuple:function(k){var h;var d=a.util.regex.number;var b=new RegExp("^"+a.util.regex.rgba+"$").exec(k);
if(b){h=[];var l=[];for(var e=1;e<=3;e++){var g=b[e];if(g[g.length-1]==="%"){l[e]=true}g=parseFloat(g);if(l[e]){g=g/100*255}if(g<0||g>255){return}h.push(Math.floor(g))}var f=l[1]||l[2]||l[3];var j=l[1]&&l[2]&&l[3];if(f&&!j){return}var c=b[4];if(c!==undefined){c=parseFloat(c);if(c<0||c>1){return}h.push(c)}}return h},colorname2tuple:function(b){return a.util.colors[b.toLowerCase()]},color2tuple:function(b){return a.util.colorname2tuple(b)||a.util.hex2tuple(b)||a.util.rgb2tuple(b)||a.util.hsl2tuple(b)
},tuple2hex:function(d){var f=d[0];var e=d[1];var c=d[2];function h(b){var g=b.toString(16);if(g.length===1){g="0"+g}return g}return"#"+h(f)+h(e)+h(c)},colors:{transparent:[0,0,0,0],aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],grey:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}};
a.util.regex={};a.util.regex.number="(?:[-]?\\d*\\.\\d+|[-]?\\d+|[-]?\\d*\\.\\d+[eE]\\d+)";a.util.regex.rgba="rgb[a]?\\(("+a.util.regex.number+"[%]?)\\s*,\\s*("+a.util.regex.number+"[%]?)\\s*,\\s*("+a.util.regex.number+"[%]?)(?:\\s*,\\s*("+a.util.regex.number+"))?\\)";a.util.regex.rgbaNoBackRefs="rgb[a]?\\((?:"+a.util.regex.number+"[%]?)\\s*,\\s*(?:"+a.util.regex.number+"[%]?)\\s*,\\s*(?:"+a.util.regex.number+"[%]?)(?:\\s*,\\s*(?:"+a.util.regex.number+"))?\\)";a.util.regex.hsla="hsl[a]?\\(("+a.util.regex.number+")\\s*,\\s*("+a.util.regex.number+"[%])\\s*,\\s*("+a.util.regex.number+"[%])(?:\\s*,\\s*("+a.util.regex.number+"))?\\)";
a.util.regex.hslaNoBackRefs="hsl[a]?\\((?:"+a.util.regex.number+")\\s*,\\s*(?:"+a.util.regex.number+"[%])\\s*,\\s*(?:"+a.util.regex.number+"[%])(?:\\s*,\\s*(?:"+a.util.regex.number+"))?\\)";a.util.regex.hex3="\\#[0-9a-fA-F]{3}";a.util.regex.hex6="\\#[0-9a-fA-F]{6}"})(cytoscape);(function(a){a.math={};a.math.roundRectangleIntersectLine=function(D,C,O,L,c,e,H){var F=this.getRoundRectangleRadius(c,e);var r=c/2;var f=e/2;var d;var k=O-r+F-H;var j=L-f-H;var J=O+r-F+H;var I=j;d=this.finiteLinesIntersect(D,C,O,L,k,j,J,I,false);
if(d.length>0){return d}var G=O+r+H;var E=L-f+F-H;var b=G;var M=L+f-F+H;d=this.finiteLinesIntersect(D,C,O,L,G,E,b,M,false);if(d.length>0){return d}var A=O-r+F-H;var w=L+f+H;var p=O+r-F+H;var o=w;d=this.finiteLinesIntersect(D,C,O,L,A,w,p,o,false);if(d.length>0){return d}var v=O-r-H;var u=L-f+F-H;var t=v;var s=L+f-F+H;d=this.finiteLinesIntersect(D,C,O,L,v,u,t,s,false);if(d.length>0){return d}var q;var m=O-r+F;var l=L-f+F;q=this.intersectLineCircle(D,C,O,L,m,l,F+H);if(q.length>0&&q[0]<=m&&q[1]<=l){return[q[0],q[1]]
}var h=O+r-F;var g=L-f+F;q=this.intersectLineCircle(D,C,O,L,h,g,F+H);if(q.length>0&&q[0]>=h&&q[1]<=g){return[q[0],q[1]]}var N=O+r-F;var K=L+f-F;q=this.intersectLineCircle(D,C,O,L,N,K,F+H);if(q.length>0&&q[0]>=N&&q[1]>=K){return[q[0],q[1]]}var B=O-r+F;var z=L+f-F;q=this.intersectLineCircle(D,C,O,L,B,z,F+H);if(q.length>0&&q[0]<=B&&q[1]>=z){return[q[0],q[1]]}return[]};a.math.roundRectangleIntersectBox=function(h,p,g,o,q,m,k,j,l){var d=this.getRoundRectangleRadius(q,m);var c=k-q/2-l;var b=j-m/2+d-l;var s=k+q/2+l;
var r=j+m/2-d+l;var v=k-q/2+d-l;var t=j-m/2-l;var f=k+q/2-d+l;var e=j+m/2+l;var A=Math.min(h,g);var z=Math.max(h,g);var w=Math.min(p,o);var u=Math.max(p,o);if(z<c){return false}else{if(A>s){return false}}if(u<t){return false}else{if(w>e){return false}}if(c>=A&&c<=z&&b>=w&&b<=u){return true}if(s>=A&&s<=z&&b>=w&&b<=u){return true}if(s>=A&&s<=z&&r>=w&&r<=u){return true}if(c>=A&&c<=z&&r>=w&&r<=u){return true}if(A>=c&&A<=s&&w>=b&&w<=r){return true}if(z>=c&&z<=s&&w>=b&&w<=r){return true}if(z>=c&&z<=s&&u>=b&&u<=r){return true
}if(A>=c&&A<=s&&u>=b&&u<=r){return true}if(v>=A&&v<=z&&t>=w&&t<=u){return true}if(f>=A&&f<=z&&t>=w&&t<=u){return true}if(f>=A&&f<=z&&e>=w&&e<=u){return true}if(v>=A&&v<=z&&e>=w&&e<=u){return true}if(A>=v&&A<=f&&w>=t&&w<=e){return true}if(z>=v&&z<=f&&w>=t&&w<=e){return true}if(z>=v&&z<=f&&u>=t&&u<=e){return true}if(A>=v&&A<=f&&u>=t&&u<=e){return true}if(this.boxIntersectEllipse(A,w,z,u,l,d*2,d*2,v+l,b+l)){return true}if(this.boxIntersectEllipse(A,w,z,u,l,d*2,d*2,f-l,b+l)){return true}if(this.boxIntersectEllipse(A,w,z,u,l,d*2,d*2,f-l,r-l)){return true
}if(this.boxIntersectEllipse(A,w,z,u,l,d*2,d*2,v+l,r-l)){return true}return false};a.math.checkInBoundingCircle=function(c,j,d,h,e,b,g,f){c=(c-g)/(e+h);j=(j-f)/(b+h);return(c*c+j*j)<=d};a.math.checkInBoundingBox=function(m,k,o,l,d,p,h,g){var f=o[0],e=o[1];var c=o[0],b=o[1];for(var j=1;j<o.length/2;j++){if(o[j*2]<f){f=o[j*2]}else{if(o[j*2]>c){c=o[j*2]}}if(o[j*2+1]<e){e=o[j*2+1]}else{if(o[j*2+1]>b){b=o[j*2+1]}}}m-=h;k-=g;m/=d;k/=p;if(m<f){return false}else{if(m>c){return false}}if(k<e){return false
}else{if(k>b){return false}}return true};a.math.boxInBezierVicinity=function(q,j,w,m,s,h,r,g,o,e,p){var l=0.25*s+0.5*r+0.25*o;var k=0.25*h+0.5*g+0.25*e;var z=Math.min(q,w)-p;var u=Math.min(j,m)-p;var v=Math.max(q,w)+p;var t=Math.max(j,m)+p;if(s>=z&&s<=v&&h>=u&&h<=t){return 1}else{if(o>=z&&o<=v&&e>=u&&e<=t){return 1}else{if(l>=z&&l<=v&&k>=u&&k<=t){return 1}else{if(r>=z&&r<=v&&g>=u&&g<=t){return 1}}}}var f=Math.min(s,l,o);var d=Math.min(h,k,e);var c=Math.max(s,l,o);var b=Math.max(h,k,e);if(f>v||c<z||d>t||b<u){return 0
}return 1};a.math.checkBezierInBox=function(g,f,q,m,e,l,d,k,b,j,h){function c(v,u,s,r){return(1-r)*(1-r)*v+2*(1-r)*r*u+r*r*s}function p(s){var r=c(e,d,b,s);var u=c(l,k,j,s);return g<=r&&r<=q&&f<=u&&u<=m}for(var o=0;o<=1;o+=0.25){if(!p(o)){return false}}return true};a.math.checkStraightEdgeInBox=function(e,d,k,j,c,h,b,g,f){return e<=c&&c<=k&&e<=b&&b<=k&&d<=h&&h<=j&&d<=g&&g<=j};a.math.checkStraightEdgeCrossesBox=function(r,k,A,o,t,f,s,c,q){var B=Math.min(r,A)-q;var w=Math.min(k,o)-q;var z=Math.max(r,A)+q;
var v=Math.max(k,o)+q;var g=s-t;var m=t;var u;var d=c-f;var l=f;var p;if(Math.abs(g)<0.0001){return(t>=B&&t<=z&&Math.min(f,c)<=w&&Math.max(f,c)>=v)}var b=(B-m)/g;if(b>0&&b<=1){u=d*b+l;if(u>=w&&u<=v){return true}}var j=(z-m)/g;if(j>0&&j<=1){u=d*j+l;if(u>=w&&u<=v){return true}}var e=(w-l)/d;if(e>0&&e<=1){p=g*e+m;if(p>=B&&p<=z){return true}}var h=(v-l)/d;if(h>0&&h<=1){p=g*h+m;if(p>=B&&p<=z){return true}}return false};a.math.checkBezierCrossesBox=function(w,g,L,A,q,U,l,R,j,O,c){var s=Math.min(w,L)-c;
var p=Math.min(g,A)-c;var T=Math.max(w,L)+c;var Q=Math.max(g,A)+c;if(q>=s&&q<=T&&U>=p&&U<=Q){return true}else{if(j>=s&&j<=T&&O>=p&&O<=Q){return true}}var v=q-2*l+j;var f=-2*q+2*l;var H=q;var B=[];if(Math.abs(v)<0.0001){var M=(s-q)/f;var z=(T-q)/f;B.push(M,z)}else{var E=f*f-4*v*(H-s);var t,r;if(E>0){var F=Math.sqrt(E);t=(-f+F)/(2*v);r=(-f-F)/(2*v);B.push(t,r)}var D=f*f-4*v*(H-T);var o,k;if(D>0){var F=Math.sqrt(D);o=(-f+F)/(2*v);k=(-f-F)/(2*v);B.push(o,k)}}B.sort(function(W,V){return W-V});var u=U-2*R+O;
var d=-2*U+2*R;var G=U;var K=[];if(Math.abs(u)<0.0001){var e=(p-U)/d;var I=(Q-U)/d;K.push(e,I)}else{var m=d*d-4*u*(G-p);var b,S;if(m>0){var F=Math.sqrt(m);b=(-d+F)/(2*u);S=(-d-F)/(2*u);K.push(b,S)}var h=d*d-4*u*(G-Q);var P,N;if(h>0){var F=Math.sqrt(h);P=(-d+F)/(2*u);N=(-d-F)/(2*u);K.push(P,N)}}K.sort(function(W,V){return W-V});for(var C=0;C<B.length;C+=2){for(var J=1;J<K.length;J+=2){if(B[C]<K[J]&&K[J]>=0&&B[C]<=1&&B[C+1]>K[J-1]&&K[J-1]<=1&&B[C+1]>=0){return true}}}return false};a.math.inLineVicinity=function(m,k,g,e,f,d,h){var o=h;
var c=Math.min(g,f);var b=Math.max(g,f);var l=Math.min(e,d);var j=Math.max(e,d);return c-o<=m&&m<=b+o&&l-o<=k&&k<=j+o};a.math.inBezierVicinity=function(j,h,u,d,t,c,s,b,B){var l=0.25*u+0.5*t+0.25*s;var k=0.25*d+0.5*c+0.25*b;var f={x1:Math.min(u,s,l),x2:Math.max(u,s,l),y1:Math.min(d,b,k),y2:Math.max(d,b,k)};if(j<f.x1||j>f.x2||h<f.y1||h>f.y2){return false}else{}var p,o,z,v;var g,e,m;var A=function(D,J,E,C,I,H,F,G){g=(H-C)*(D-E)+(E-I)*(J-C);e=g*g;sideSquared=(H-C)*(H-C)+(E-I)*(E-I);if(G){if(g>0){return false
}}else{if(g<0){return false}}return(e/sideSquared>F)};var r=(l+t)/2;var q=(k+c)/2;var w=true;if(A(r,q,u,d,t,c,0,w)){w=!w}return(!A(j,h,u,d,t,c,B,w)&&!A(j,h,t,c,s,b,B,w)&&!A(j,h,s,b,u,d,B,w))};a.math.solveCubic=function(o,m,l,k,w){m/=o;l/=o;k/=o;var u,f,e,h,v,p,g,j;f=(3*l-(m*m))/9;e=-(27*k)+m*(9*l-2*(m*m));e/=54;u=f*f*f+e*e;w[1]=0;g=(m/3);if(u>0){v=e+Math.sqrt(u);v=((v<0)?-Math.pow(-v,(1/3)):Math.pow(v,(1/3)));p=e-Math.sqrt(u);p=((p<0)?-Math.pow(-p,(1/3)):Math.pow(p,(1/3)));w[0]=-g+v+p;g+=(v+p)/2;
w[4]=w[2]=-g;g=Math.sqrt(3)*(-p+v)/2;w[3]=g;w[5]=-g;return}w[5]=w[3]=0;if(u==0){j=((e<0)?-Math.pow(-e,(1/3)):Math.pow(e,(1/3)));w[0]=-g+2*j;w[4]=w[2]=-(j+g);return}f=-f;h=f*f*f;h=Math.acos(e/Math.sqrt(h));j=2*Math.sqrt(f);w[0]=-g+j*Math.cos(h/3);w[2]=-g+j*Math.cos((h+2*Math.PI)/3);w[4]=-g+j*Math.cos((h+4*Math.PI)/3);return};a.math.sqDistanceToQuadraticBezier=function(q,p,v,j,u,h,t,g){var D=1*v*v-4*v*u+2*v*t+4*u*u-4*u*t+t*t+j*j-4*j*h+2*j*g+4*h*h-4*h*g+g*g;var C=1*9*v*u-3*v*v-3*v*t-6*u*u+3*u*t+9*j*h-3*j*j-3*j*g-6*h*h+3*h*g;
var A=1*3*v*v-6*v*u+v*t-v*q+2*u*u+2*u*q-t*q+3*j*j-6*j*h+j*g-j*p+2*h*h+2*h*p-g*p;var z=1*v*u-v*v+v*q-u*q+j*h-j*j+j*p-h*p;var k=[];this.solveCubic(D,C,A,z,k);var e=1e-7;var B=[];for(var l=0;l<6;l+=2){if(Math.abs(k[l+1])<e&&k[l]>=0&&k[l]<=1){B.push(k[l])}}B.push(1);B.push(0);var f=-1;var w;var o,m,r;for(var s=0;s<B.length;s++){o=Math.pow(1-B[s],2)*v+2*(1-B[s])*B[s]*u+B[s]*B[s]*t;m=Math.pow(1-B[s],2)*j+2*(1-B[s])*B[s]*h+B[s]*B[s]*g;r=Math.pow(o-q,2)+Math.pow(m-p,2);if(f>=0){if(r<f){f=r;w=B[s]}}else{f=r;
w=B[s]}}return f};a.math.sqDistanceToFiniteLine=function(k,g,c,j,b,h){var d=[k-c,g-j];var o=[b-c,h-j];var e=o[0]*o[0]+o[1]*o[1];var m=d[0]*d[0]+d[1]*d[1];var l=d[0]*o[0]+d[1]*o[1];var f=l*l/e;if(l<0){return m}if(f>e){return(k-b)*(k-b)+(g-h)*(g-h)}return(m-f)};a.math.pointInsidePolygon=function(o,l,g,k,h,s,r,A,q){var j=new Array(g.length);var z=Math.asin(A[1]/(Math.sqrt(A[0]*A[0]+A[1]*A[1])));if(A[0]<0){z=z+Math.PI/2}else{z=-z-Math.PI/2}var d=Math.cos(-z);var b=Math.sin(-z);for(var u=0;u<j.length/2;
u++){j[u*2]=s/2*(g[u*2]*d-g[u*2+1]*b);j[u*2+1]=r/2*(g[u*2+1]*d+g[u*2]*b);j[u*2]+=k;j[u*2+1]+=h}var t;if(q>0){var B=this.expandPolygon(j,-q);t=this.joinLines(B)}else{t=j}var w,f,v,e;var c;var m=0;var p=0;for(var u=0;u<t.length/2;u++){w=t[u*2];f=t[u*2+1];if(u+1<t.length/2){v=t[(u+1)*2];e=t[(u+1)*2+1]}else{v=t[(u+1-t.length/2)*2];e=t[(u+1-t.length/2)*2+1]}if(w==o&&v==o){}else{if((w>=o&&o>=v)||(w<=o&&o<=v)){c=(o-w)/(v-w)*(e-f)+f;if(c>l){m++}if(c<l){p++}}else{continue}}}if(m%2==0){return false}else{return true
}};a.math.joinLines=function(l){var k=new Array(l.length/2);var o,m,j,h;var f,e,d,c;for(var g=0;g<l.length/4;g++){o=l[g*4];m=l[g*4+1];j=l[g*4+2];h=l[g*4+3];if(g<l.length/4-1){f=l[(g+1)*4];e=l[(g+1)*4+1];d=l[(g+1)*4+2];c=l[(g+1)*4+3]}else{f=l[0];e=l[1];d=l[2];c=l[3]}var b=this.finiteLinesIntersect(o,m,j,h,f,e,d,c,true);k[g*2]=b[0];k[g*2+1]=b[1]}return k};a.math.expandPolygon=function(p,d){var e=new Array(p.length*2);var o,m,l,k;for(var h=0;h<p.length/2;h++){o=p[h*2];m=p[h*2+1];if(h<p.length/2-1){l=p[(h+1)*2];
k=p[(h+1)*2+1]}else{l=p[0];k=p[1]}var j=(k-m);var g=-(l-o);var f=Math.sqrt(j*j+g*g);var c=j/f;var b=g/f;e[h*4]=o+c*d;e[h*4+1]=m+b*d;e[h*4+2]=l+c*d;e[h*4+3]=k+b*d}return e};a.math.intersectLineEllipse=function(m,l,h,g,e,c){var d=h-m;var b=g-l;d/=e;b/=c;var j=Math.sqrt(d*d+b*b);var f=j-1;if(f<0){return[]}var k=f/j;return[(h-m)*k+m,(g-l)*k+l]};a.math.dotProduct=function(c,b){if(c.length!=2||b.length!=2){throw"dot product: arguments are not vectors"}return(c[0]*b[0]+c[1]*b[1])};a.math.intersectLineCircle=function(u,g,t,e,o,m,h){var w=[t-u,e-g];
var r=[u,g];var A=[o,m];var v=[u-o,g-m];var C=w[0]*w[0]+w[1]*w[1];var B=2*(v[0]*w[0]+v[1]*w[1]);var A=(v[0]*v[0]+v[1]*v[1])-h*h;var z=B*B-4*C*A;if(z<0){return[]}t1=(-B+Math.sqrt(z))/(2*C);t2=(-B-Math.sqrt(z))/(2*C);var j=Math.min(t1,t2);var l=Math.max(t1,t2);var k=[];if(j>=0&&j<=1){k.push(j)}if(l>=0&&l<=1){k.push(l)}if(k.length==0){return[]}var E=k[0]*w[0]+u;var D=k[0]*w[1]+g;if(k.length>1){if(k[0]==k[1]){return[E,D]}else{var q=k[1]*w[0]+u;var p=k[1]*w[1]+g;return[E,D,q,p]}}else{return[E,D]}};a.math.findCircleNearPoint=function(f,e,g,l,k){var c=l-f;
var b=k-e;var d=Math.sqrt(c*c+b*b);var j=c/d;var h=b/d;return[f+j*g,e+h*g]};a.math.findMaxSqDistanceToOrigin=function(e){var b=0.000001;var d;for(var c=0;c<e.length/2;c++){d=e[c*2]*e[c*2]+e[c*2+1]*e[c*2+1];if(d>b){b=d}}return b};a.math.finiteLinesIntersect=function(g,p,e,m,c,l,q,j,o){var h=(q-c)*(p-l)-(j-l)*(g-c);var k=(e-g)*(p-l)-(m-p)*(g-c);var f=(j-l)*(e-g)-(q-c)*(m-p);if(f!=0){var d=h/f;var b=k/f;if(0<=d&&d<=1&&0<=b&&b<=1){return[g+d*(e-g),p+d*(m-p)]}else{if(!o){return[]}else{return[g+d*(e-g),p+d*(m-p)]
}}}else{if(h==0||k==0){if([g,e,q].sort()[1]==q){return[q,j]}if([g,e,c].sort()[1]==c){return[c,l]}if([c,q,e].sort()[1]==e){return[e,m]}return[]}else{return[]}}};a.math.boxIntersectEllipse=function(d,o,b,l,m,c,r,h,f){if(b<d){var e=d;d=b;b=e}if(l<o){var p=o;o=l;l=p}var q=[h-c/2-m,f];var k=[h+c/2+m,f];var g=[h,f-r/2-m];var j=[h,f+r/2+m];if(b<q[0]){return false}if(d>k[0]){return false}if(o>j[1]){return false}if(l<g[1]){return false}if(d<=k[0]&&k[0]<=b&&o<=k[1]&&k[1]<=l){return true}if(d<=q[0]&&q[0]<=b&&o<=q[1]&&q[1]<=l){return true
}if(d<=g[0]&&g[0]<=b&&o<=g[1]&&g[1]<=l){return true}if(d<=j[0]&&j[0]<=b&&o<=j[1]&&j[1]<=l){return true}d=(d-h)/(c/2+m);b=(b-h)/(c/2+m);o=(o-f)/(r/2+m);l=(l-f)/(r/2+m);if(d*d+o*o<=1){return true}if(b*b+o*o<=1){return true}if(b*b+l*l<=1){return true}if(d*d+l*l<=1){return true}return false};a.math.boxIntersectPolygon=function(B,h,z,e,k,s,r,p,m,F,q){if(z<B){var A=B;B=z;z=A}if(e<h){var g=h;h=e;e=g}var o=new Array(k.length);var C=Math.asin(F[1]/(Math.sqrt(F[0]*F[0]+F[1]*F[1])));if(F[0]<0){C=C+Math.PI/2
}else{C=-C-Math.PI/2}var c=Math.cos(-C);var b=Math.sin(-C);for(var w=0;w<o.length/2;w++){o[w*2]=s/2*(k[w*2]*c-k[w*2+1]*b);o[w*2+1]=r/2*(k[w*2+1]*c+k[w*2]*b);o[w*2]+=p;o[w*2+1]+=m}var f=o[0];var l=o[0];var d=o[1];var j=o[1];for(var w=1;w<o.length/2;w++){if(o[w*2]>l){l=o[w*2]}if(o[w*2]<f){f=o[w*2]}if(o[w*2+1]>j){j=o[w*2+1]}if(o[w*2+1]<d){d=o[w*2+1]}}if(z<f-q){return false}if(B>l+q){return false}if(e<d-q){return false}if(h>j+q){return false}var v;if(q>0){var G=a.math.expandPolygon(o,-q);v=a.math.joinLines(G)
}else{v=o}for(var w=0;w<o.length/2;w++){if(B<=o[w*2]&&o[w*2]<=z){if(h<=o[w*2+1]&&o[w*2+1]<=e){return true}}}for(var w=0;w<v.length/2;w++){var u=v[w*2];var t=v[w*2+1];var E;var D;if(w<v.length/2-1){E=v[(w+1)*2];D=v[(w+1)*2+1]}else{E=v[0];D=v[1]}if(a.math.finiteLinesIntersect(u,t,E,D,B,h,z,h,false).length>0){return true}if(a.math.finiteLinesIntersect(u,t,E,D,B,e,z,e,false).length>0){return true}if(a.math.finiteLinesIntersect(u,t,E,D,B,h,B,e,false).length>0){return true}if(a.math.finiteLinesIntersect(u,t,E,D,z,h,z,e,false).length>0){return true
}}return false};a.math.polygonIntersectLine=function(h,g,b,e,c,l,k,j){var u=[];var f;var d=new Array(b.length);for(var q=0;q<d.length/2;q++){d[q*2]=b[q*2]*l+e;d[q*2+1]=b[q*2+1]*k+c}var p;if(j>0){var t=a.math.expandPolygon(d,-j);p=a.math.joinLines(t)}else{p=d}var o,m,s,r;for(var q=0;q<p.length/2;q++){o=p[q*2];m=p[q*2+1];if(q<p.length/2-1){s=p[(q+1)*2];r=p[(q+1)*2+1]}else{s=p[0];r=p[1]}f=this.finiteLinesIntersect(h,g,e,c,o,m,s,r);if(f.length!=0){u.push(f[0],f[1])}}return u};a.math.shortenIntersection=function(g,f,d){var b=[g[0]-f[0],g[1]-f[1]];
var e=Math.sqrt(b[0]*b[0]+b[1]*b[1]);var c=(e-d)/e;if(c<0){return[]}else{return[f[0]+c*b[0],f[1]+c*b[1]]}};a.math.generateUnitNgonPoints=function(c,b){var h=1/c*2*Math.PI;var f=c%2==0?Math.PI/2+h/2:Math.PI/2;f+=b;var k=new Array(c*2);var d;for(var e=0;e<c;e++){d=e*h+f;k[2*e]=Math.cos(d);k[2*e+1]=Math.sin(-d)}var m=0;var l=0;for(var e=0;e<k.length/2;e++){if(Math.abs(k[2*e]>m)){m=Math.abs(k[2*e])}if(Math.abs(k[2*e+1]>l)){l=Math.abs(k[2*e+1])}}var g=0.0005;var j=Math.max(m,l);for(var e=0;e<k.length/2;
e++){if(j>g){k[2*e]*=(1/j);k[2*e+1]*=(1/j)}}return k};a.math.getRoundRectangleRadius=function(c,b){return Math.min(c/2,b/2,10)}})(cytoscape);(function(a){a.instances=[];a.instanceCounter=0;a.lastInstanceTime;a.registerInstance=function(b,g){var j;if(a.is.core(b)){j=b}else{if(a.is.domElement(b)){g=b}}var f=a.getRegistrationForInstance(b,g);if(f){if(!f.cy){f.cy=b;f.domElement=g}else{a.util.error("Tried to register on a pre-existing registration")}return f}else{var e=+new Date;var d;if(!a.lastInstanceTime||a.lastInstanceTime===e){a.instanceCounter=0
}else{++a.instanceCounter}a.lastInstanceTime=e;d=a.instanceCounter;var h="cy-"+e+"-"+d;var c={id:h,cy:j,domElement:g,readies:[]};a.instances.push(c);a.instances[h]=c;return c}};a.removeRegistrationForInstance=function(b,e){var g;if(a.is.core(b)){g=b}else{if(a.is.domElement(b)){e=b}}if(a.is.core(g)){var f=g._private.instanceId;delete a.instances[f];a.instances.splice(f,1)}else{if(a.is.domElement(e)){for(var c=0;c<a.instances.length;c++){var d=a.instances[c];if(d.domElement===e){delete a.instances[d.id];
a.instances.splice(c,1);c--}}}}};a.getRegistrationForInstance=function(b,e){var g;if(a.is.core(b)){if(b.registered()){g=b}}else{if(a.is.domElement(b)){e=b}}if(a.is.core(g)){var f=g._private.instanceId;return a.instances[f]}else{if(a.is.domElement(e)){for(var c=a.instances.length-1;c>=0;c--){var d=a.instances[c];if(d.domElement===e){return d}}}}}})(cytoscape);(function(c){var f={};c.extensions=f;var d={};c.modules=d;function b(k,j,l){var h={};h[j]=l;switch(k){case"core":case"collection":c.fn[k](h)
}return c.util.setMap({map:f,keys:[k,j],value:l})}function g(j,h){return c.util.getMap({map:f,keys:[j,h]})}function e(l,j,k,h,m){return c.util.setMap({map:d,keys:[l,j,k,h],value:m})}function a(l,j,k,h){return c.util.getMap({map:d,keys:[l,j,k,h]})}c.extension=function(){if(arguments.length==2){return g.apply(this,arguments)}else{if(arguments.length==3){return b.apply(this,arguments)}else{if(arguments.length==4){return a.apply(this,arguments)}else{if(arguments.length==5){return e.apply(this,arguments)
}else{$.error("Invalid extension access syntax")}}}}}})(cytoscape);(function(b,a){if(!b){return}b.fn.cytoscape=function(h){var k=b(this);if(h==="get"){var g=a.getRegistrationForInstance(k[0]);return g.cy}else{if(a.is.fn(h)){var f=h;var c=k[0];var g=a.getRegistrationForInstance(c);if(!g){g=a.registerInstance(c)}if(g&&g.cy&&g.cy.ready()){g.cy.trigger("ready",[],f)}else{g.readies.push(f)}}else{if(a.is.plainObject(h)){return k.each(function(){var l=b.extend({},h,{container:b(this)[0]});cytoscape(l)})
}else{var c=k[0];var j=[];var d=[];for(var e=1;e<arguments.length;e++){d[e-1]=arguments[e]}k.each(function(){var m=a.getRegistrationForInstance(c);var p=m.cy;var o=h;if(p&&a.is.fn(p[o])){var l=p[o].apply(p,d);j.push(l)}});if(j.length===1){j=j[0]}else{if(j.length==0){j=b(this)}}return j}}}};b.cytoscape=cytoscape;if(b.fn.cy==null&&b.cy==null){b.fn.cy=b.fn.cytoscape;b.cy=b.cytoscape}})(typeof jQuery!=="undefined"?jQuery:null,cytoscape);(function(a){a.Event=function(e,d){if(!(this instanceof a.Event)){return new a.Event(e,d)
}if(e&&e.type){this.originalEvent=e;this.type=e.type;this.isDefaultPrevented=(e.defaultPrevented||e.returnValue===false||e.getPreventDefault&&e.getPreventDefault())?c:b}else{this.type=e}if(d){a.util.extend(this,d)}this.timeStamp=e&&e.timeStamp||+new Date};function b(){return false}function c(){return true}a.Event.prototype={preventDefault:function(){this.isDefaultPrevented=c;var d=this.originalEvent;if(!d){return}if(d.preventDefault){d.preventDefault()}else{d.returnValue=false}},stopPropagation:function(){this.isPropagationStopped=c;
var d=this.originalEvent;if(!d){return}if(d.stopPropagation){d.stopPropagation()}d.cancelBubble=true},stopImmediatePropagation:function(){this.isImmediatePropagationStopped=c;this.stopPropagation()},isDefaultPrevented:b,isPropagationStopped:b,isImmediatePropagationStopped:b}})(cytoscape);(function(a){a.define={data:function(c){var b={field:"data",bindingEvent:"data",allowBinding:false,allowSetting:false,allowGetting:false,settingEvent:"data",settingTriggersEvent:false,triggerFnName:"trigger",immutableKeys:{},updateMappers:false};
c=a.util.extend({},b,c);return function(e,s){var g=c;var z=this;var f=z.length!==undefined;var t=f?z:[z];var w=f?z[0]:z;if(a.is.string(e)){if(g.allowGetting&&s===undefined){var q;if(w){q=w._private[g.field][e]}return q}else{if(g.allowSetting&&s!==undefined){var d=!g.immutableKeys[e];if(d){for(var o=0,h=t.length;o<h;o++){t[o]._private[g.field][e]=s}if(g.updateMappers){z.updateMappers()}if(g.settingTriggersEvent){z[g.triggerFnName](g.settingEvent)}}}}}else{if(g.allowSetting&&a.is.plainObject(e)){var m=e;
var j,u;for(j in m){u=m[j];var d=!g.immutableKeys[j];if(d){for(var o=0,h=t.length;o<h;o++){t[o]._private[g.field][j]=u}}}if(g.updateMappers){z.updateMappers()}if(g.settingTriggersEvent){z[g.triggerFnName](g.settingEvent)}}else{if(g.allowBinding&&a.is.fn(e)){var r=e;z.bind(g.bindingEvent,r)}else{if(g.allowGetting&&e===undefined){var q;if(w){q=w._private[g.field]}return q}}}}return z}},batchData:function(d){var c={field:"data",event:"data",triggerFnName:"trigger",immutableKeys:{},updateMappers:false};
var b=d=a.util.extend({},c,d);return function(f){var s=this;var h=s.length!==undefined;var u=h?s:s._private.elements;if(u.length===0){return s}var j=h?u[0]._private.cy:s;for(var o=0;o<u.length;o++){var t=u[o];var g=t._private.data.id;var r=f[g];if(r!==undefined&&r!==null){var m=r;var l,p;for(l in m){p=m[l];var e=!b.immutableKeys[l];if(e){t._private[b.field][l]=p}}}}var q=new a.Collection(j,u);if(b.updateMappers){q.updateMappers()}q[b.triggerFnName](b.event);return s}},removeData:function(c){var b={field:"data",event:"data",triggerFnName:"trigger",triggerEvent:false,immutableKeys:{}};
c=a.util.extend({},b,c);return function(q){var g=c;var v=this;var f=v.length!==undefined;var r=f?v:[v];var t=f?v[0]:v;if(a.is.string(q)){var u=q.split(/\s+/);var j=u.length;for(var k=0;k<j;k++){var s=u[k];if(a.is.emptyString(s)){continue}var e=!g.immutableKeys[s];if(e){for(var o=0,h=r.length;o<h;o++){delete r[o]._private[g.field][s]}}}if(g.triggerEvent){v[g.triggerFnName](g.event)}}else{if(q===undefined){for(var o=0,h=r.length;o<h;o++){var m=r[o]._private[g.field];for(var s in m){var d=!g.immutableKeys[s];
if(d){delete m[s]}}}if(g.triggerEvent){v[g.triggerFnName](g.event)}}}return v}},event:{regex:/(\w+)(\.\w+)?/,optionalTypeRegex:/(\w+)?(\.\w+)?/,props:"altKey bubbles button cancelable charCode clientX clientY ctrlKey currentTarget data detail eventPhase metaKey offsetX offsetY originalTarget pageX pageY prevValue relatedTarget screenX screenY shiftKey target view which".split(/\s+/),aliases:"mousedown mouseup click mouseover mouseout mousemove touchstart touchmove touchend grab drag free".split(/\s+/),aliasesOn:function(e){var b=a.define.event.aliases;
for(var d=0;d<b.length;d++){var c=b[d];(function(f){e[f]=function(g,h){if(a.is.fn(h)){this.on(f,g,h)}else{if(a.is.fn(g)){h=g;this.on(f,h)}else{this.trigger(f)}}return this}})(c)}},falseCallback:function(){return false}},on:function(c){var b={unbindSelfOnTrigger:false,unbindAllBindersOnTrigger:false};c=a.util.extend({},b,c);return function(e,u,B,k){var r=this;var d=r.length!==undefined;var f=d?r:[r];var z=d?r[0]:r;var w=a.is.string(e);var s=c;if(a.is.plainObject(u)){k=B;B=u;u=undefined}else{if(a.is.fn(u)||u===false){k=u;
B=undefined;u=undefined}}if(a.is.fn(B)||B===false){k=B;B=undefined}if(!(a.is.fn(k)||k===false)&&w){return r}if(w){var A={};A[e]=k;e=A}for(var l in e){k=e[l];if(k===false){k=a.define.event.falseCallback}if(!a.is.fn(k)){continue}l=l.split(/\s+/);for(var v=0;v<l.length;v++){var q=l[v];if(a.is.emptyString(q)){continue}var m=q.match(a.define.event.regex);if(m){var g=m[1];var o=m[2]?m[2]:undefined;var h={callback:k,data:B,delegated:u?true:false,selector:u,type:g,namespace:o,unbindSelfOnTrigger:s.unbindSelfOnTrigger,unbindAllBindersOnTrigger:s.unbindAllBindersOnTrigger,binders:f};
for(var t=0;t<f.length;t++){f[t]._private.listeners.push(h)}}}}return r}},off:function(c){var b={};c=a.util.extend({},b,c);return function(e,B,l){var t=this;var d=t.length!==undefined;var f=d?t:[t];var F=d?t[0]:t;var E=a.is.string(e);var u=c;if(arguments.length===0){for(var C=0;C<f.length;C++){f[C]._private.listeners=[]}return t}if(a.is.fn(B)||B===false){l=B;B=undefined}if(E){var H={};H[e]=l;e=H}for(var m in e){l=e[m];if(l===false){l=a.define.event.falseCallback}m=m.split(/\s+/);for(var D=0;D<m.length;
D++){var s=m[D];if(a.is.emptyString(s)){continue}var o=s.match(a.define.event.optionalTypeRegex);if(o){var g=o[1]?o[1]:undefined;var r=o[2]?o[2]:undefined;for(var C=0;C<f.length;C++){var v=f[C]._private.listeners;for(var A=0;A<v.length;A++){var k=v[A];var q=!r||r===k.namespace;var w=!g||k.type===g;var z=!l||l===k.callback;var G=q&&w&&z;if(G){v.splice(A,1);A--}}}}}}return t}},trigger:function(c){var b={};c=a.util.extend({},b,c);return function(F,g,A){var q=this;var v=q.length!==undefined;var B=v?q:[q];
var G=v?q[0]:q;var L=a.is.string(F);var h=a.is.plainObject(F);var f=a.is.event(F);var T=c;var C=this._private.cy||this;if(L){var N=F.split(/\s+/);F=[];for(var Y=0;Y<N.length;Y++){var I=N[Y];if(a.is.emptyString(I)){continue}var o=I.match(a.define.event.regex);var ad=o[1];var O=o[2]?o[2]:undefined;F.push({type:ad,namespace:O})}}else{if(h){var aa=F;F=[aa]}}if(g){if(!a.is.array(g)){g=[g]}}else{g=[]}for(var Y=0;Y<F.length;Y++){var r=F[Y];for(var X=0;X<B.length;X++){var M=B[X];var R=M._private.listeners;
var d=a.is.element(M);var E=d;var I;if(f){I=r;I.cyTarget=I.cyTarget||M;I.cy=I.cy||C;I.namespace=I.namespace||r.namespace}else{I=new a.Event(r,{cyTarget:M,cy:C,namespace:r.namespace});var H=a.define.event.props;for(var W=0;W<H.length;W++){var z=H[W];I[z]=r[z]}}if(A){R=[{namespace:I.namespace,type:I.type,callback:A}]}for(var W=0;W<R.length;W++){var e=R[W];var P=!e.namespace||e.namespace===I.namespace;var w=e.type===I.type;var Q=e.delegated?(M!==I.cyTarget&&a.is.element(I.cyTarget)&&I.cyTarget.is(e.selector)):(true);
var J=P&&w&&Q;if(J){var S=[I];S=S.concat(g);if(e.data){I.data=e.data}else{I.data=undefined}if(e.unbindSelfOnTrigger||e.unbindAllBindersOnTrigger){R.splice(W,1);W--}if(e.unbindAllBindersOnTrigger){var u=e.binders;for(var V=0;V<u.length;V++){var t=u[V];if(!t||t===M){continue}var D=t._private.listeners;for(var U=0;U<D.length;U++){var ab=D[U];if(ab===e){D.splice(U,1);U--}}}}var ac=e.delegated?I.cyTarget:M;var K=e.callback.apply(ac,S);if(K===false||I.isPropagationStopped()){E=false;if(K===false){I.stopPropagation();
I.preventDefault()}}}}if(E){var s=M.parent();var Z=s.length!==0;if(Z){s=s[0];s.trigger(I)}else{C.trigger(I)}}}}return q}}}})(cytoscape);(function($$,window){var isTouch=("ontouchstart" in window)||window.DocumentTouch&&document instanceof DocumentTouch;$$.Style=function(cy){if(!(this instanceof $$.Style)){return new $$.Style(cy)}if(!$$.is.core(cy)){$$.util.error("A style must have a core reference");return}this._private={cy:cy,coreStyle:{}};this.length=0;this.addDefaultStylesheet()};$$.style=$$.Style;
$$.styfn=$$.Style.prototype;$$.fn.style=function(fnMap,options){for(var fnName in fnMap){var fn=fnMap[fnName];$$.Style.prototype=fn}};$$.stylesheet=$$.Stylesheet=function(){if(!(this instanceof $$.Stylesheet)){return new $$.Stylesheet()}this.length=0};$$.Stylesheet.prototype.selector=function(selector){var i=this.length++;this[i]={selector:selector,properties:[],animations:[]};return this};$$.Stylesheet.prototype.css=function(name,value){var i=this.length-1;if($$.is.string(name)){this[i].properties.push({name:name,value:value})
}else{if($$.is.plainObject(name)){map=name;for(var j=0;j<$$.style.properties.length;j++){var prop=$$.style.properties[j];var mapVal=map[prop.name];if(mapVal===undefined){mapVal=map[$$.util.dash2camel(prop.name)]}if(mapVal!==undefined){var name=prop.name;var value=mapVal;this[i].properties.push({name:name,value:value})}}}}return this};$$.Stylesheet.prototype.animate=function(ani){var i=this.length-1;this[i].animations.push(ani);return this};$$.style.fromJson=function(cy,json){var style=new $$.Style(cy);
for(var i=0;i<json.length;i++){var context=json[i];var selector=context.selector;var props=context.css;style.selector(selector);for(var name in props){var value=props[name];style.css(name,value)}}return style};$$.styfn.fromJson=function(json){var style=this;style.resetToDefault();for(var i=0;i<json.length;i++){var context=json[i];var selector=context.selector;var props=context.css;style.selector(selector);for(var name in props){var value=props[name];style.css(name,value)}}return style};$$.styfn.json=function(){var json=[];
for(var i=0;i<this.length;i++){var cxt=this[i];var selector=cxt.selector;var props=cxt.properties;var anis=cxt.animations;var css={};for(var i=0;i<props.length;i++){css[prop.name]=prop.strValue}json.push({selector:selector.toString(),css:css,animate:anis})}return json};$$.Stylesheet.prototype.generateStyle=function(cy){var style=new $$.Style(cy);for(var i=0;i<this.length;i++){var context=this[i];var selector=context.selector;var props=context.properties;var anis=context.animations;style.selector(selector);
for(var j=0;j<props.length;j++){var prop=props[j];style.css(prop.name,prop.value)}for(var j=0;j<anis.length;j++){var ani=anis[j];style.animate(ani)}}return style};$$.Stylesheet.prototype.assignToStyle=function(style,addDefaultStylesheet){style.clear();if(addDefaultStylesheet||addDefaultStylesheet===undefined){style.addDefaultStylesheet()}for(var i=0;i<this.length;i++){var context=this[i];var selector=context.selector;var props=context.properties;var anis=context.animations;style.selector(selector);
for(var j=0;j<props.length;j++){var prop=props[j];style.css(prop.name,prop.value)}for(var j=0;j<anis.length;j++){var ani=anis[j];style.animate(ani)}}};(function(){var number=$$.util.regex.number;var rgba=$$.util.regex.rgbaNoBackRefs;var hsla=$$.util.regex.hslaNoBackRefs;var hex3=$$.util.regex.hex3;var hex6=$$.util.regex.hex6;$$.style.types={percent:{number:true,min:0,max:100,units:"%"},zeroOneNumber:{number:true,min:0,max:1,unitless:true},nonNegativeInt:{number:true,min:0,integer:true,unitless:true},size:{number:true,min:0,enums:["auto"]},bgSize:{number:true,min:0,allowPercent:true},color:{color:true},lineStyle:{enums:["solid","dotted","dashed"]},curveStyle:{enums:["bundled","bezier"]},fontFamily:{regex:"^([\\w- ]+(?:\\s*,\\s*[\\w- ]+)*)$"},fontVariant:{enums:["small-caps","normal"]},fontStyle:{enums:["italic","normal","oblique"]},fontWeight:{enums:["normal","bold","bolder","lighter","100","200","300","400","500","600","800","900",100,200,300,400,500,600,700,800,900]},textDecoration:{enums:["none","underline","overline","line-through"]},textTransform:{enums:["none","capitalize","uppercase","lowercase"]},nodeShape:{enums:["rectangle","roundrectangle","ellipse","triangle","square","pentagon","hexagon","heptagon","octagon"]},arrowShape:{enums:["tee","triangle","square","circle","diamond","none"]},display:{enums:["element","none"]},visibility:{enums:["hidden","visible"]},valign:{enums:["top","center","bottom"]},halign:{enums:["left","center","right"]},positionx:{enums:["left","center","right"],number:true,allowPercent:true},positiony:{enums:["top","center","bottom"],number:true,allowPercent:true},bgRepeat:{enums:["repeat","repeat-x","repeat-y","no-repeat"]},cursor:{enums:["auto","crosshair","default","e-resize","n-resize","ne-resize","nw-resize","pointer","progress","s-resize","sw-resize","text","w-resize","wait","grab","grabbing"]},text:{string:true},data:{mapping:true,regex:"^data\\s*\\(\\s*([\\w\\.]+)\\s*\\)$"},mapData:{mapping:true,regex:"^mapData\\(([\\w\\.]+)\\s*\\,\\s*("+number+")\\s*\\,\\s*("+number+")\\s*,\\s*("+number+"|\\w+|"+rgba+"|"+hsla+"|"+hex3+"|"+hex6+")\\s*\\,\\s*("+number+"|\\w+|"+rgba+"|"+hsla+"|"+hex3+"|"+hex6+")\\)$"},url:{regex:"^url\\s*\\(\\s*([^\\s]+)\\s*\\s*\\)|none|(.+)$"}};
var t=$$.style.types;$$.style.properties=[{name:"cursor",type:t.cursor},{name:"text-valign",type:t.valign},{name:"text-halign",type:t.halign},{name:"color",type:t.color},{name:"content",type:t.text},{name:"text-outline-color",type:t.color},{name:"text-outline-width",type:t.size},{name:"text-outline-opacity",type:t.zeroOneNumber},{name:"text-opacity",type:t.zeroOneNumber},{name:"text-decoration",type:t.textDecoration},{name:"text-transform",type:t.textTransform},{name:"font-family",type:t.fontFamily},{name:"font-style",type:t.fontStyle},{name:"font-variant",type:t.fontVariant},{name:"font-weight",type:t.fontWeight},{name:"font-size",type:t.size},{name:"min-zoomed-font-size",type:t.size},{name:"display",type:t.display},{name:"visibility",type:t.visibility},{name:"opacity",type:t.zeroOneNumber},{name:"z-index",type:t.nonNegativeInt},{name:"overlay-padding",type:t.size},{name:"overlay-color",type:t.color},{name:"overlay-opacity",type:t.zeroOneNumber},{name:"background-color",type:t.color},{name:"background-opacity",type:t.zeroOneNumber},{name:"background-image",type:t.url},{name:"background-position-x",type:t.positionx},{name:"background-position-y",type:t.positiony},{name:"background-repeat",type:t.bgRepeat},{name:"background-size-x",type:t.bgSize},{name:"background-size-y",type:t.bgSize},{name:"pie-1-background-color",type:t.color},{name:"pie-2-background-color",type:t.color},{name:"pie-3-background-color",type:t.color},{name:"pie-4-background-color",type:t.color},{name:"pie-5-background-color",type:t.color},{name:"pie-6-background-color",type:t.color},{name:"pie-7-background-color",type:t.color},{name:"pie-8-background-color",type:t.color},{name:"pie-9-background-color",type:t.color},{name:"pie-10-background-color",type:t.color},{name:"pie-11-background-color",type:t.color},{name:"pie-12-background-color",type:t.color},{name:"pie-13-background-color",type:t.color},{name:"pie-14-background-color",type:t.color},{name:"pie-15-background-color",type:t.color},{name:"pie-16-background-color",type:t.color},{name:"pie-1-background-size",type:t.percent},{name:"pie-2-background-size",type:t.percent},{name:"pie-3-background-size",type:t.percent},{name:"pie-4-background-size",type:t.percent},{name:"pie-5-background-size",type:t.percent},{name:"pie-6-background-size",type:t.percent},{name:"pie-7-background-size",type:t.percent},{name:"pie-8-background-size",type:t.percent},{name:"pie-9-background-size",type:t.percent},{name:"pie-10-background-size",type:t.percent},{name:"pie-11-background-size",type:t.percent},{name:"pie-12-background-size",type:t.percent},{name:"pie-13-background-size",type:t.percent},{name:"pie-14-background-size",type:t.percent},{name:"pie-15-background-size",type:t.percent},{name:"pie-16-background-size",type:t.percent},{name:"border-color",type:t.color},{name:"border-opacity",type:t.zeroOneNumber},{name:"border-width",type:t.size},{name:"border-style",type:t.lineStyle},{name:"height",type:t.size},{name:"width",type:t.size},{name:"padding-left",type:t.size},{name:"padding-right",type:t.size},{name:"padding-top",type:t.size},{name:"padding-bottom",type:t.size},{name:"shape",type:t.nodeShape},{name:"source-arrow-shape",type:t.arrowShape},{name:"target-arrow-shape",type:t.arrowShape},{name:"source-arrow-color",type:t.color},{name:"target-arrow-color",type:t.color},{name:"line-style",type:t.lineStyle},{name:"line-color",type:t.color},{name:"control-point-step-size",type:t.size},{name:"curve-style",type:t.curveStyle},{name:"selection-box-color",type:t.color},{name:"selection-box-opacity",type:t.zeroOneNumber},{name:"selection-box-border-color",type:t.color},{name:"selection-box-border-width",type:t.size},{name:"panning-cursor",type:t.cursor},{name:"active-bg-color",type:t.color},{name:"active-bg-opacity",type:t.zeroOneNumber},{name:"active-bg-size",type:t.size}];
var props=$$.style.properties;for(var i=0;i<props.length;i++){var prop=props[i];props[prop.name]=prop}$$.style.pieBackgroundN=16})();$$.styfn.addDefaultStylesheet=function(){var fontFamily="Helvetica"||this.containerPropertyAsString("font-family")||"sans-serif";var fontStyle="normal"||this.containerPropertyAsString("font-style")||"normal";var fontVariant="normal"||this.containerPropertyAsString("font-variant")||"normal";var fontWeight="normal"||this.containerPropertyAsString("font-weight")||"normal";
var color="#000"||this.containerPropertyAsString("color")||"#000";var textTransform="none"||this.containerPropertyAsString("text-transform")||"none";var textDecoration="none"||this.containerPropertyAsString("text-decoration")||"none";var fontSize=16||this.containerPropertyAsString("font-size")||16;this.selector("node, edge").css({cursor:"default","text-valign":"top","text-halign":"center",color:color,content:undefined,"text-outline-color":"#000","text-outline-width":0,"text-outline-opacity":1,"text-opacity":1,"text-decoration":"none","text-transform":textTransform,"font-family":fontFamily,"font-style":fontStyle,"font-variant":fontVariant,"font-weight":fontWeight,"font-size":fontSize,"min-zoomed-font-size":0,visibility:"visible",display:"element",opacity:1,"z-index":0,content:"","overlay-opacity":0,"overlay-color":"#000","overlay-padding":10,"background-color":"#888","background-opacity":1,"background-image":"none","border-color":"#000","border-opacity":1,"border-width":0,"border-style":"solid",height:30,width:30,"padding-top":0,"padding-bottom":0,"padding-left":0,"padding-right":0,shape:"ellipse","pie-1-background-color":"black","pie-1-background-size":"0%","pie-2-background-color":"black","pie-2-background-size":"0%","pie-3-background-color":"black","pie-3-background-size":"0%","pie-4-background-color":"black","pie-4-background-size":"0%","pie-5-background-color":"black","pie-5-background-size":"0%","pie-6-background-color":"black","pie-6-background-size":"0%","pie-7-background-color":"black","pie-7-background-size":"0%","pie-8-background-color":"black","pie-8-background-size":"0%","pie-9-background-color":"black","pie-9-background-size":"0%","pie-10-background-color":"black","pie-10-background-size":"0%","pie-11-background-color":"black","pie-11-background-size":"0%","pie-12-background-color":"black","pie-12-background-size":"0%","pie-13-background-color":"black","pie-13-background-size":"0%","pie-14-background-color":"black","pie-14-background-size":"0%","pie-15-background-color":"black","pie-15-background-size":"0%","pie-16-background-color":"black","pie-16-background-size":"0%","source-arrow-shape":"none","target-arrow-shape":"none","source-arrow-color":"#bbb","target-arrow-color":"#bbb","line-style":"solid","line-color":"#bbb","control-point-step-size":40,"curve-style":"bezier"}).selector("$node > node").css({width:"auto",height:"auto",shape:"rectangle","background-opacity":0.5,"padding-top":10,"padding-right":10,"padding-left":10,"padding-bottom":10}).selector("edge").css({width:1,}).selector(":active").css({"overlay-color":"black","overlay-padding":10,"overlay-opacity":0.25}).selector("core").css({"selection-box-color":"#ddd","selection-box-opacity":0.65,"selection-box-border-color":"#aaa","selection-box-border-width":1,"panning-cursor":"grabbing","active-bg-color":"black","active-bg-opacity":0.15,"active-bg-size":isTouch?40:15})
};$$.styfn.clear=function(){this._private.newStyle=true;for(var i=0;i<this.length;i++){delete this[i]}this.length=0;return this};$$.styfn.resetToDefault=function(){this.clear();this.addDefaultStylesheet();return this};$$.styfn.core=function(){return this._private.coreStyle};$$.styfn.parse=function(name,value,propIsBypass){name=$$.util.camel2dash(name);var property=$$.style.properties[name];var passedValue=value;if(!property){return null}if(value===undefined||value===null){return null}var valueIsString=$$.is.string(value);
if(valueIsString){value=$$.util.trim(value)}var type=property.type;if(!type){return null}if(propIsBypass&&(value===""||value===null)){return{name:name,value:value,bypass:true,deleteBypass:true}}var data,mapData;if(!valueIsString){}else{if(data=new RegExp($$.style.types.data.regex).exec(value)){return{name:name,value:data,strValue:value,mapped:$$.style.types.data,field:data[1],bypass:propIsBypass}}else{if(mapData=new RegExp($$.style.types.mapData.regex).exec(value)){if(!(type.color||type.number)){return false
}var valueMin=this.parse(name,mapData[4]);if(!valueMin||valueMin.mapped){return false}var valueMax=this.parse(name,mapData[5]);if(!valueMax||valueMax.mapped){return false}if(valueMin.value===valueMax.value){return false}else{if(type.color){var c1=valueMin.value;var c2=valueMax.value;var same=c1[0]===c2[0]&&c1[1]===c2[1]&&c1[2]===c2[2]&&(c1[3]===c2[3]||((c1[3]==null||c1[3]===1)&&(c2[3]==null||c2[3]===1)));if(same){return false}}}return{name:name,value:mapData,strValue:value,mapped:$$.style.types.mapData,field:mapData[1],fieldMin:parseFloat(mapData[2]),fieldMax:parseFloat(mapData[3]),valueMin:valueMin.value,valueMax:valueMax.value,bypass:propIsBypass}
}}}if(type.number){var units;var implicitUnit="px";if(type.units){units=type.units}if(!type.unitless){if(valueIsString){var unitsRegex="px|em"+(type.allowPercent?"|\\%":"");if(units){unitsRegex=units}var match=value.match("^("+$$.util.regex.number+")("+unitsRegex+")?$");if(!type.enums){if(!match){return null}value=match[1];units=match[2]||implicitUnit}}else{if(!units){units=implicitUnit}}}value=parseFloat(value);if(isNaN(value)&&type.enums!==undefined){value=passedValue;for(var i=0;i<type.enums.length;
i++){var en=type.enums[i];if(en===value){return{name:name,value:value,strValue:value,bypass:propIsBypass}}}return null}if(type.integer&&!$$.is.integer(value)){return null}if((type.min!==undefined&&value<type.min)||(type.max!==undefined&&value>type.max)){return null}var ret={name:name,value:value,strValue:""+value+(units?units:""),units:units,bypass:propIsBypass,pxValue:type.unitless||units==="%"?undefined:(units==="px"||!units?(value):(this.getEmSizeInPixels()*value))};return ret}else{if(type.color){var tuple=$$.util.color2tuple(value);
return{name:name,value:tuple,strValue:value,bypass:propIsBypass}}else{if(type.enums){for(var i=0;i<type.enums.length;i++){var en=type.enums[i];if(en===value){return{name:name,value:value,strValue:value,bypass:propIsBypass}}}}else{if(type.regex){var regex=new RegExp(type.regex);var m=regex.exec(value);if(m){return{name:name,value:m,strValue:value,bypass:propIsBypass}}else{return null}}else{if(type.string){return{name:name,value:value,strValue:value,bypass:propIsBypass}}else{return null}}}}}};$$.styfn.getEmSizeInPixels=function(){var cy=this._private.cy;
var domElement=cy.container();if(window&&domElement&&window.getComputedStyle){var pxAsStr=window.getComputedStyle(domElement).getPropertyValue("font-size");var px=parseFloat(pxAsStr);return px}else{return 1}};$$.styfn.containerCss=function(propName){var cy=this._private.cy;var domElement=cy.container();if(window&&domElement&&window.getComputedStyle){return window.getComputedStyle(domElement).getPropertyValue(propName)}};$$.styfn.containerProperty=function(propName){var propStr=this.containerCss(propName);
var prop=this.parse(propName,propStr);return prop};$$.styfn.containerPropertyAsString=function(propName){var prop=this.containerProperty(propName);if(prop){return prop.strValue}};$$.styfn.selector=function(selectorStr){var selector=selectorStr==="core"?null:new $$.Selector(selectorStr);var i=this.length++;this[i]={selector:selector,properties:[],animations:[]};return this};$$.styfn.css=function(){var args=arguments;switch(args.length){case 1:var map=args[0];for(var i=0;i<$$.style.properties.length;
i++){var prop=$$.style.properties[i];var mapVal=map[prop.name];if(mapVal===undefined){mapVal=map[$$.util.dash2camel(prop.name)]}if(mapVal!==undefined){this.cssRule(prop.name,mapVal)}}break;case 2:this.cssRule(args[0],args[1]);break;default:break}return this};$$.styfn.cssRule=function(name,value){var property=this.parse(name,value);if(property){var i=this.length-1;this[i].properties.push(property);var currentSelectorIsCore=!this[i].selector;if(currentSelectorIsCore){this._private.coreStyle[property.name]=property
}}return this};$$.styfn.animate=function(ani){var i=this.length-1;this[i].animations.push(ani);return this};$$.styfn.applyParsedProperty=function(ele,parsedProp,context){parsedProp=$$.util.clone(parsedProp);var prop=parsedProp;var style=ele._private.style;var fieldVal,flatProp;var type=$$.style.properties[prop.name].type;var propIsBypass=prop.bypass;var origProp=style[prop.name];var origPropIsBypass=origProp&&origProp.bypass;if((parsedProp.name==="height"||parsedProp.name==="width")&&parsedProp.value==="auto"&&ele.isNode()&&!ele.isParent()){return false
}if(propIsBypass&&prop.deleteBypass){var currentProp=style[prop.name];if(!currentProp){return true}else{if(currentProp.bypass&&currentProp.bypassed){style[prop.name]=currentProp.bypassed;return true}else{return false}}}switch(prop.mapped){case $$.style.types.mapData:fieldVal=ele._private.data[prop.field];if(!$$.is.number(fieldVal)){return false}var percent=(fieldVal-prop.fieldMin)/(prop.fieldMax-prop.fieldMin);if(type.color){var r1=prop.valueMin[0];var r2=prop.valueMax[0];var g1=prop.valueMin[1];
var g2=prop.valueMax[1];var b1=prop.valueMin[2];var b2=prop.valueMax[2];var a1=prop.valueMin[3]==null?1:prop.valueMin[3];var a2=prop.valueMax[3]==null?1:prop.valueMax[3];var clr=[Math.round(r1+(r2-r1)*percent),Math.round(g1+(g2-g1)*percent),Math.round(b1+(b2-b1)*percent),Math.round(a1+(a2-a1)*percent)];flatProp={bypass:prop.bypass,name:prop.name,value:clr,strValue:["rgba(",clr[0],", ",clr[1],", ",clr[2],", ",clr[3],")"].join("")}}else{if(type.number){var calcValue=prop.valueMin+(prop.valueMax-prop.valueMin)*percent;
flatProp=this.parse(prop.name,calcValue,prop.bypass)}else{return false}}if(!flatProp){flatProp=this.parse(prop.name,origProp.strValue,prop.bypass)}flatProp.mapping=prop;prop=flatProp;break;case $$.style.types.data:fieldVal=eval("ele._private.data."+prop.field);flatProp=this.parse(prop.name,fieldVal,prop.bypass);if(!flatProp){flatProp=this.parse(prop.name,origProp.strValue,prop.bypass)}flatProp.mapping=prop;prop=flatProp;break;case undefined:break;default:return false}if(propIsBypass){if(origPropIsBypass){prop.bypassed=origProp.bypassed
}else{prop.bypassed=origProp}style[prop.name]=prop}else{var prevProp;if(origPropIsBypass){prevProp=origProp.bypassed;origProp.bypassed=prop}else{prevProp=style[prop.name];style[prop.name]=prop}if(prevProp&&prevProp.mapping&&prop.mapping&&prevProp.context===context){prevProp=prevProp.prev}if(prevProp&&prevProp!==prop){prop.prev=prevProp}}prop.context=context;return true};$$.styfn.rollBackContext=function(ele,context){for(var j=0;j<context.properties.length;j++){var prop=context.properties[j];var eleProp=ele._private.style[prop.name];
if(eleProp.bypassed){eleProp=eleProp.bypassed}var first=true;var lastEleProp;var l=0;while(eleProp.prev){var prev=eleProp.prev;if(eleProp.context===context){if(first){ele._private.style[prop.name]=prev}else{if(lastEleProp){lastEleProp.prev=prev}}}lastEleProp=eleProp;eleProp=prev;first=false;l++}}};$$.styfn.apply=function(eles){var self=this;for(var ie=0;ie<eles.length;ie++){var ele=eles[ie];if(self._private.newStyle){ele._private.styleCxts=[];ele._private.style={}}for(var i=0;i<this.length;i++){var context=this[i];
var contextSelectorMatches=context.selector&&context.selector.filter(ele).length>0;var props=context.properties;if(contextSelectorMatches){for(var j=0;j<props.length;j++){var prop=props[j];if(!ele._private.styleCxts[i]||prop.mapped){this.applyParsedProperty(ele,prop,context)}}ele._private.styleCxts[i]=context}else{if(ele._private.styleCxts[i]){this.rollBackContext(ele,context)}delete ele._private.styleCxts[i]}}}self._private.newStyle=false};$$.styfn.update=function(){var cy=this._private.cy;var eles=cy.elements();
eles.updateStyle()};$$.styfn.getRenderedStyle=function(ele){var ele=ele[0];if(ele){var rstyle={};var style=ele._private.style;var cy=this._private.cy;var zoom=cy.zoom();for(var i=0;i<$$.style.properties.length;i++){var prop=$$.style.properties[i];var styleProp=style[prop.name];if(styleProp){var val=styleProp.unitless?styleProp.strValue:(styleProp.pxValue*zoom)+"px";rstyle[prop.name]=val;rstyle[$$.util.dash2camel(prop.name)]=val}}return rstyle}};$$.styfn.getRawStyle=function(ele){var ele=ele[0];if(ele){var rstyle={};
var style=ele._private.style;for(var i=0;i<$$.style.properties.length;i++){var prop=$$.style.properties[i];var styleProp=style[prop.name];if(styleProp){rstyle[prop.name]=styleProp.strValue;rstyle[$$.util.dash2camel(prop.name)]=styleProp.strValue}}return rstyle}};$$.styfn.getValueStyle=function(ele){var rstyle,style;if($$.is.element(ele)){rstyle={};style=ele._private.style}else{rstyle={};style=ele}if(style){for(var i=0;i<$$.style.properties.length;i++){var prop=$$.style.properties[i];var styleProp=style[prop.name]||style[$$.util.dash2camel(prop.name)];
if(styleProp!==undefined&&!$$.is.plainObject(styleProp)){styleProp=this.parse(prop.name,styleProp)}if(styleProp){var val=styleProp.value===undefined?styleProp:styleProp.value;rstyle[prop.name]=val;rstyle[$$.util.dash2camel(prop.name)]=val}}}return rstyle};$$.styfn.updateFunctionalProperties=function(eles){for(var i=0;i<eles.length;i++){var ele=eles[i];var style=ele._private.style;for(var j=0;j<$$.style.properties.length;j++){var prop=$$.style.properties[j];var propInStyle=style[prop.name];if(propInStyle&&propInStyle.mapping){var mapping=propInStyle.mapping;
this.applyParsedProperty(ele,mapping)}}}};$$.styfn.applyBypass=function(eles,name,value){var props=[];if(name==="*"||name==="**"){if(value!==undefined){for(var i=0;i<$$.style.properties.length;i++){var prop=$$.style.properties[i];var name=prop.name;var parsedProp=this.parse(name,value,true);if(parsedProp){props.push(parsedProp)}}}}else{if($$.is.string(name)){var parsedProp=this.parse(name,value,true);if(parsedProp){props.push(parsedProp)}}else{if($$.is.plainObject(name)){var specifiedProps=name;for(var i=0;
i<$$.style.properties.length;i++){var prop=$$.style.properties[i];var name=prop.name;var value=specifiedProps[name];if(value===undefined){value=specifiedProps[$$.util.dash2camel(name)]}if(value!==undefined){var parsedProp=this.parse(name,value,true);if(parsedProp){props.push(parsedProp)}}}}else{return false}}}if(props.length===0){return false}var ret=false;for(var i=0;i<eles.length;i++){var ele=eles[i];for(var j=0;j<props.length;j++){var prop=props[j];ret=this.applyParsedProperty(ele,prop)||ret}}return ret
};$$.styfn.removeAllBypasses=function(eles){for(var i=0;i<$$.style.properties.length;i++){var prop=$$.style.properties[i];var name=prop.name;var value="";var parsedProp=this.parse(name,value,true);for(var j=0;j<eles.length;j++){var ele=eles[j];this.applyParsedProperty(ele,parsedProp)}}}})(cytoscape,typeof window==="undefined"?null:window);(function(b){var a=window&&("ontouchstart" in window)||window.DocumentTouch&&document instanceof DocumentTouch;var d={showOverlay:true,hideEdgesOnViewport:false};
var c=b.util.copy(d);b.defaults=function(e){d=b.util.extend({},c,e)};b.fn.core=function(e,g){for(var f in e){var h=e[f];b.Core.prototype[f]=h}};b.Core=function(k){if(!(this instanceof b.Core)){return new b.Core(k)}var l=this;k=b.util.extend({},d,k);var e=k.container;var g=b.getRegistrationForInstance(l,e);if(g&&g.cy){g.domElement.innerHTML="";g.cy.notify({type:"destroy"});b.removeRegistrationForInstance(g.cy,g.domElement)}g=b.registerInstance(l,e);var j=g.readies;var f=k;f.layout=b.util.extend({name:typeof window==="undefined"?"null":"grid"},f.layout);
f.renderer=b.util.extend({name:typeof window==="undefined"?"null":"canvas"},f.renderer);this._private={ready:false,initrender:false,instanceId:g.id,options:f,elements:[],id2index:{},listeners:[],aniEles:[],scratch:{},layout:null,renderer:null,notificationsEnabled:true,minZoom:1e-50,maxZoom:1e+50,zoomEnabled:f.zoomEnabled===undefined?true:f.zoomEnabled,panEnabled:f.panEnabled===undefined?true:f.panEnabled,boxSelectionEnabled:f.boxSelectionEnabled===undefined?true:f.boxSelectionEnabled,zoom:b.is.number(f.zoom)?f.zoom:1,pan:{x:b.is.plainObject(f.pan)&&b.is.number(f.pan.x)?f.pan.x:0,y:b.is.plainObject(f.pan)&&b.is.number(f.pan.y)?f.pan.y:0,},hasCompoundNodes:false};
var h=f.selectionType;if(h===undefined||(h!=="additive"&&h!=="single")){if(a){this._private.selectionType="additive"}else{this._private.selectionType="single"}}else{this._private.selectionType=h}if(b.is.number(f.minZoom)&&b.is.number(f.maxZoom)&&f.minZoom<f.maxZoom){this._private.minZoom=f.minZoom;this._private.maxZoom=f.maxZoom}else{if(b.is.number(f.minZoom)&&f.maxZoom===undefined){this._private.minZoom=f.minZoom}else{if(b.is.number(f.maxZoom)&&f.minZoom===undefined){this._private.maxZoom=f.maxZoom
}}}this._private.style=b.is.stylesheet(f.style)?f.style.generateStyle(this):(b.is.array(f.style)?b.style.fromJson(this,f.style):new b.Style(l));l.initRenderer(b.util.extend({showOverlay:f.showOverlay,hideEdgesOnViewport:f.hideEdgesOnViewport},f.renderer));if(f.initrender){l.on("initrender",f.initrender);l.on("initrender",function(){l._private.initrender=true})}l.load(f.elements,function(){l.startAnimationLoop();l._private.ready=true;if(b.is.fn(f.ready)){l.bind("ready",f.ready)}for(var m=0;m<j.length;
m++){var o=j[m];l.bind("ready",o)}g.readies=[];l.trigger("ready")},f.done)};b.corefn=b.Core.prototype;b.fn.core({ready:function(){return this._private.ready},initrender:function(){return this._private.initrender},registered:function(){if(this._private&&this._private.instanceId!=null){return true}else{return false}},registeredId:function(){return this._private.instanceId},getElementById:function(f){var e=this._private.id2index[f];if(e!==undefined){return this._private.elements[e]}return new b.Collection(this)
},selectionType:function(){return this._private.selectionType},hasCompoundNodes:function(){return this._private.hasCompoundNodes},addToPool:function(f){var k=this._private.elements;var m=this._private.id2index;for(var h=0;h<f.length;h++){var j=f[h];var l=j._private.data.id;var g=m[l];var e=g!==undefined;if(!e){g=k.length;k.push(j);m[l]=g;j._private.index=g}}return this},removeFromPool:function(q){var e=this._private.elements;var h=this._private.id2index;for(var l=0;l<q.length;l++){var p=q[l];var f=p._private.data.id;
var m=h[f];var o=m!==undefined;if(o){delete this._private.id2index[f];e.splice(m,1);for(var k=m;k<e.length;k++){var g=e[k]._private.data.id;h[g]--}}}},container:function(){return this._private.options.container},options:function(){return b.util.copy(this._private.options)},json:function(f){var e={};var g=this;e.elements={};g.elements().each(function(h,j){var k=j.group();if(!e.elements[k]){e.elements[k]=[]}e.elements[k].push(j.json())});e.style=g.style();e.scratch=g.scratch();e.zoomEnabled=g._private.zoomEnabled;
e.panEnabled=g._private.panEnabled;e.layout=g._private.options.layout;e.renderer=g._private.options.renderer;return e}})})(cytoscape);(function(a,b){a.fn.core({add:function(d){var c;var e=this;if(a.is.elementOrCollection(d)){var u=d;if(u._private.cy===e){c=u.restore()}else{var o=[];for(var h=0;h<u.length;h++){var t=u[h];o.push(t.json())}c=new a.Collection(e,o)}}else{if(a.is.array(d)){var o=d;c=new a.Collection(e,o)}else{if(a.is.plainObject(d)&&(a.is.array(d.nodes)||a.is.array(d.edges))){var l=d;var o=[];
var p=["nodes","edges"];for(var h=0,q=p.length;h<q;h++){var r=p[h];var m=l[r];if(a.is.array(m)){for(var f=0,g=m.length;f<g;f++){var s=m[f];var k=a.util.extend({},s,{group:r});o.push(k)}}}c=new a.Collection(e,o)}else{var s=d;c=(new a.Element(e,s)).collection()}}}return c},remove:function(d){if(a.is.elementOrCollection(d)){d=d}else{if(a.is.string(d)){var c=d;d=this.$(c)}}return d.remove()},load:function(g,h,e){var k=this;var d=k.elements();if(d.length>0){d.remove()}k.notifications(false);var c=[];if(g!=null){if(a.is.plainObject(g)||a.is.array(g)){k.add(g)
}}function j(){k.one("layoutready",function(l){k.notifications(true);k.trigger(l);k.notify({type:"load",collection:k.elements(),style:k._private.style});k.one("load",h);k.trigger("load")}).one("layoutstop",function(){k.one("done",e);k.trigger("done")});k.layout(k._private.options.layout)}if(b){function f(m){var l=(document&&(document.readyState==="interactive"||document.readyState==="complete"))?m:f;setTimeout(l,9,m)}f(j)}else{j()}return this}})})(cytoscape,typeof window==="undefined"?null:window);
(function(a){a.fn.core({addToAnimationPool:function(b){var h=this;var c=h._private.aniEles;var e=[];for(var d=0;d<c.length;d++){var g=c[d]._private.data.id;e[g]=true}for(var d=0;d<b.length;d++){var f=b[d];var g=f._private.data.id;if(!e[g]){c.push(f)}}},startAnimationLoop:function(){var g=this;var f=1000/60;var m=false;var j=true;g._private.aniEles=[];var k=typeof window==="undefined"?function(){}:(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame);
if(k==null||!j){k=function(o){window.setTimeout(function(){o(+new Date)},f)}}var c=g.container();function l(){function o(){k(function(p){d(p);l()},c)}if(m){setTimeout(function(){o()},f)}else{o()}}l();function d(s){s=+new Date;var D=g._private.aniEles;for(var z=0;z<D.length;z++){var C=D[z];var A=C._private.animation.current;var w=C._private.animation.queue;if(A.length===0){var p=w;var v=p.length>0?p.shift():null;if(v!=null){v.callTime=+new Date;A.push(v)}}var B=[];for(var u=0;u<A.length;u++){var t=A[u];
e(C,t,s);if(A[u].done){B.push(t);A.splice(u,1);u--}}for(var u=0;u<B.length;u++){var t=B[u];var r=t.params.complete;if(a.is.fn(r)){r.apply(C,[s])}}}if(D.length>0){g.notify({type:"draw",collection:D})}for(var u=0;u<D.length;u++){var C=D[u];var w=C._private.animation.queue;var A=C._private.animation.current;var o=A.length>0||w.length>0;if(!o){D.splice(u,1);u--}}}function e(G,z,t){var p=g._private.style;var D=z.properties;var w=z.params;var u=z.callTime;var C;if(z.duration===0){C=1}else{C=Math.min(1,(t-u)/z.duration)
}if(C<0){C=0}else{if(C>1){C=1}}if(D.delay==null){var B=z.startPosition;var s=D.position;var F=G._private.position;if(s){if(b(B.x,s.x)){F.x=h(B.x,s.x,C)}if(b(B.y,s.y)){F.y=h(B.y,s.y,C)}}if(D.css){var E=a.style.properties;for(var A=0;A<E.length;A++){var o=E[A].name;var v=D.css[o];if(v!==undefined){var r=z.startStyle[o];var q=h(r,v,C);p.applyBypass(G,o,q)}}}}if(a.is.fn(w.step)){w.step.apply(G,[t])}if(C>=1){z.done=true}return C}function b(p,o){if(p==null||o==null){return false}if(a.is.number(p)&&a.is.number(o)){return true
}else{if((p)&&(o)){return true}}return false}function h(q,s,w){if(w<0){w=0}else{if(w>1){w=1}}if(a.is.number(q)&&a.is.number(s)){return q+(s-q)*w}else{if(a.is.number(q[0])&&a.is.number(s[0])){var u=q;var t=s;function p(B,r){var C=r-B;var A=B;return Math.round(w*C+A)}var o=p(u[0],t[0]);var v=p(u[1],t[1]);var z=p(u[2],t[2]);return"rgb("+o+", "+v+", "+z+")"}}return undefined}}})})(cytoscape);(function(a){a.fn.core({data:a.define.data({field:"data",bindingEvent:"data",allowBinding:true,allowSetting:true,settingEvent:"data",settingTriggersEvent:true,triggerFnName:"trigger",allowGetting:true}),removeData:a.define.removeData({field:"data",event:"data",triggerFnName:"trigger",triggerEvent:true}),batchData:a.define.batchData({field:"data",event:"data",triggerFnName:"trigger",immutableKeys:{id:true,source:true,target:true,parent:true},updateMappers:true}),scratch:a.define.data({field:"scratch",allowBinding:false,allowSetting:true,settingTriggersEvent:false,allowGetting:true}),removeScratch:a.define.removeData({field:"scratch",triggerEvent:false}),})
})(cytoscape);(function(a){a.fn.core({on:a.define.on(),one:a.define.on({unbindSelfOnTrigger:true}),once:a.define.on({unbindAllBindersOnTrigger:true}),off:a.define.off(),trigger:a.define.trigger(),});a.corefn.bind=a.corefn.on;a.corefn.unbind=a.corefn.off;a.define.event.aliasesOn(a.corefn)})(cytoscape);(function(a){a.fn.core({png:function(b){var d=this;var c=this._private.renderer;b=b||{};return c.png(b)}})})(cytoscape);(function(a){a.fn.core({layout:function(b){var c=this;if(this._private.layoutRunning){return this
}if(b==null){b=this._private.options.layout}this.initLayout(b);c.trigger("layoutstart");this._private.layoutRunning=true;this.one("layoutstop",function(){this._private.layoutRunning=false});this._private.layout.run();return this},initLayout:function(d){if(d==null){a.util.error("Layout options must be specified to run a layout");return}if(d.name==null){a.util.error("A `name` must be specified to run a layout");return}var c=d.name;var b=a.extension("layout",c);if(b==null){a.util.error("Can not apply layout: No such layout `%s` found; did you include its JS file?",c);
return}this._private.layout=new b(a.util.extend({},d,{renderer:this._private.renderer,cy:this}));this._private.options.layout=d}})})(cytoscape);(function(a){a.fn.core({notify:function(e){if(!this._private.notificationsEnabled){return}var d=this.renderer();var f=this;if(a.is.element(e.collection)){var b=e.collection;e.collection=new a.Collection(f,[b])}else{if(a.is.array(e.collection)){var c=e.collection;e.collection=new a.Collection(f,c)}}d.notify(e)},notifications:function(b){var c=this._private;
if(b===undefined){return c.notificationsEnabled}else{c.notificationsEnabled=b?true:false}},noNotifications:function(b){this.notifications(false);b();this.notifications(true)}})})(cytoscape);(function(a){a.fn.core({renderTo:function(b,d,e){var c=this._private.renderer;c.renderTo(b,d,e);return this},renderer:function(){return this._private.renderer},forceRender:function(){this.notify({type:"draw"});return this},initRenderer:function(c){var d=this;var b=a.extension("renderer",c.name);if(b==null){a.util.error("Can not initialise: No such renderer `%s` found; did you include its JS file?",c.name);
return}this._private.renderer=new b(a.util.extend({},c,{cy:d,style:d._private.style}))}})})(cytoscape);(function(a){a.fn.core({collection:function(b){if(a.is.string(b)){return this.$(b)}else{if(a.is.elementOrCollection(b)){return b.collection()}}return new a.Collection(this)},nodes:function(b){var c=this.$("node");if(b){return c.filter(b)}return c},edges:function(b){var c=this.$("edge");if(b){return c.filter(b)}return c},$:function(c){var b=new a.Collection(this,this._private.elements);if(c){return b.filter(c)
}return b}});a.corefn.elements=a.corefn.filter=a.corefn.$})(cytoscape);(function(a){a.fn.core({style:function(b){return this._private.style}})})(cytoscape);(function(a){a.fn.core({panningEnabled:function(b){if(b!==undefined){this._private.panEnabled=b?true:false}else{return this._private.panEnabled}return this},zoomingEnabled:function(b){if(b!==undefined){this._private.zoomEnabled=b?true:false}else{return this._private.zoomEnabled}return this},boxSelectionEnabled:function(b){if(b!==undefined){this._private.boxSelectionEnabled=b?true:false
}else{return this._private.boxSelectionEnabled}return this},pan:function(){var c=arguments;var g=this._private.pan;var d,f,e,b,h;switch(c.length){case 0:return g;case 1:if(!this._private.panEnabled){return this}else{if(a.is.string(c[0])){d=c[0];return g[d]}else{if(a.is.plainObject(c[0])){e=c[0];b=e.x;h=e.y;if(a.is.number(b)){g.x=b}if(a.is.number(h)){g.y=h}this.trigger("pan")}}}break;case 2:if(!this._private.panEnabled){return this}d=c[0];f=c[1];if((d==="x"||d==="y")&&a.is.number(f)){g[d]=f}this.trigger("pan");
break;default:break}this.notify({type:"viewport"});return this},panBy:function(h){var c=arguments;var g=this._private.pan;var d,f,e,b,j;if(!this._private.panEnabled){return this}switch(c.length){case 1:if(a.is.plainObject(c[0])){e=c[0];b=e.x;j=e.y;if(a.is.number(b)){g.x+=b}if(a.is.number(j)){g.y+=j}this.trigger("pan")}break;case 2:d=c[0];f=c[1];if((d==="x"||d==="y")&&a.is.number(f)){g[d]+=f}this.trigger("pan");break;default:break}this.notify({type:"viewport"});return this},fit:function(g,j){if(a.is.number(g)&&j===undefined){j=g;
g=undefined}if(!this._private.panEnabled||!this._private.zoomEnabled){return this}if(a.is.string(g)){var f=g;g=this.$(f)}else{if(!a.is.elementOrCollection(g)){g=this.elements()}}var k=g.boundingBox();var d=this.style();var b=parseFloat(d.containerCss("width"));var c=parseFloat(d.containerCss("height"));var e;j=a.is.number(j)?j:0;if(!isNaN(b)&&!isNaN(c)&&g.length>0){e=this._private.zoom=Math.min((b-2*j)/k.w,(c-2*j)/k.h);e=e>this._private.maxZoom?this._private.maxZoom:e;e=e<this._private.minZoom?this._private.minZoom:e;
this._private.pan={x:(b-e*(k.x1+k.x2))/2,y:(c-e*(k.y1+k.y2))/2};this.trigger("pan zoom");this.notify({type:"viewport"})}return this},minZoom:function(b){if(b===undefined){return this._private.minZoom}else{if(a.is.number(b)){this._private.minZoom=b}}return this},maxZoom:function(b){if(b===undefined){return this._private.maxZoom}else{if(a.is.number(b)){this._private.maxZoom=b}}return this},zoom:function(d){var k;var l;if(d===undefined){return this._private.zoom}else{if(a.is.number(d)){l=d;k={x:0,y:0}
}else{if(a.is.plainObject(d)){l=d.level;if(d.renderedPosition){var m=d.renderedPosition;var b=this._private.pan;var j=this._private.zoom;k={x:(m.x-b.x)/j,y:(m.y-b.y)/j}}else{if(d.position){k=d.position}}if(k&&!this._private.panEnabled){return this}}}}if(!this._private.zoomEnabled){return this}if(!a.is.number(l)||!a.is.number(k.x)||!a.is.number(k.y)){return this}l=l>this._private.maxZoom?this._private.maxZoom:l;l=l<this._private.minZoom?this._private.minZoom:l;var g=this._private.pan;var h=this._private.zoom;
var f=l;var e={x:-f/h*(k.x-g.x)+k.x,y:-f/h*(k.y-g.y)+k.y};this._private.zoom=l;this._private.pan=e;var c=g.x!==e.x||g.y!==e.y;this.trigger("zoom"+(c?" pan":""));this.notify({type:"viewport"});return this},boundingBox:function(c){var b=this.$(c);return b.boundingBox()},center:function(g){if(!this._private.panEnabled||!this._private.zoomEnabled){return this}if(a.is.string(g)){var b=g;g=cy.elements(b)}else{if(!a.is.elementOrCollection(g)){g=cy.elements()}}var j=g.boundingBox();var e=this.style();var c=parseFloat(e.containerCss("width"));
var d=parseFloat(e.containerCss("height"));var f=this._private.zoom;this.pan({x:(c-f*(j.x1+j.x2))/2,y:(d-f*(j.y1+j.y2))/2});this.trigger("pan");this.notify({type:"viewport"});return this},reset:function(){if(!this._private.panEnabled||!this._private.zoomEnabled){return this}this.pan({x:0,y:0});if(this._private.maxZoom>1&&this._private.minZoom<1){this.zoom(1)}this.notify({type:"viewport"});return this}})})(cytoscape);(function(b){b.fn.collection=b.fn.eles=function(c,e){for(var d in c){var f=c[d];b.Collection.prototype[d]=f
}};var a={prefix:{nodes:"n",edges:"e"},id:{nodes:0,edges:0},generate:function(h,d,g){var c=b.is.element(d)?d._private:d;var e=c.group;var f=g!=null?g:this.prefix[e]+this.id[e];if(h.getElementById(f).empty()){this.id[e]++}else{while(!h.getElementById(f).empty()){f=this.prefix[e]+(++this.id[e])}}return f}};b.Element=function(d,f,h){if(!(this instanceof b.Element)){return new b.Element(d,f,h)}var o=this;h=(h===undefined||h?true:false);if(d===undefined||f===undefined||!b.is.core(d)){b.util.error("An element must have a core reference and parameters set");
return}if(f.group!=="nodes"&&f.group!=="edges"){b.util.error("An element must be of type `nodes` or `edges`; you specified `"+f.group+"`");return}this.length=1;this[0]=this;this._private={cy:d,single:true,data:f.data||{},position:f.position||{},autoWidth:undefined,autoHeight:undefined,listeners:[],group:f.group,style:{},rstyle:{},styleCxts:[],removed:true,selected:f.selected?true:false,selectable:f.selectable===undefined?true:(f.selectable?true:false),locked:f.locked?true:false,grabbed:false,grabbable:f.grabbable===undefined?true:(f.grabbable?true:false),active:false,classes:{},animation:{current:[],queue:[]},rscratch:{},scratch:{},edges:[],children:[]};
if(f.renderedPosition){var p=f.renderedPosition;var j=d.pan();var m=d.zoom();this._private.position={x:(p.x-j.x)/m,y:(p.y-j.y)/m}}if(b.is.string(f.classes)){var e=f.classes.split(/\s+/);for(var g=0,c=e.length;g<c;g++){var k=e[g];if(!k||k===""){continue}o._private.classes[k]=true}}if(h===undefined||h){this.restore()}};b.Collection=function(h,c){if(!(this instanceof b.Collection)){return new b.Collection(h,c)}if(h===undefined||!b.is.core(h)){b.util.error("A collection must have a reference to the core");
return}var d={};var f=[];var p=false;if(!c){c=[]}else{if(c.length>0&&b.is.plainObject(c[0])&&!b.is.element(c[0])){p=true;var s=[];var j={};for(var o=0,g=c.length;o<g;o++){var q=c[o];if(q.data==null){q.data={}}var m=q.data;if(m.id==null){m.id=a.generate(h,q)}else{if(h.getElementById(m.id).length!=0||j[m.id]){continue}}var r=new b.Element(h,q,false);s.push(r);j[m.id]=true}c=s}}for(var o=0,g=c.length;o<g;o++){var k=c[o];if(!k){continue}var e=k._private.data.id;if(!d[e]){d[e]=k;f.push(k)}}for(var o=0,g=f.length;
o<g;o++){this[o]=f[o]}this.length=f.length;this._private={cy:h,ids:d};if(p){this.restore()}};b.elefn=b.elesfn=b.Element.prototype=b.Collection.prototype;b.elesfn.cy=function(){return this._private.cy};b.elesfn.element=function(){return this[0]};b.elesfn.collection=function(){if(b.is.collection(this)){return this}else{return new b.Collection(this._private.cy,[this])}};b.elesfn.json=function(){var g=this.element();if(g==null){return undefined}var h=g._private;var f=b.util.copy({data:h.data,position:h.position,group:h.group,bypass:h.bypass,removed:h.removed,selected:h.selected,selectable:h.selectable,locked:h.locked,grabbed:h.grabbed,grabbable:h.grabbable,classes:""});
var e=[];for(var c in h.classes){e.push(c)}for(var d=0;d<e.length;d++){var c=e[d];f.classes+=c+(d<e.length-1?" ":"")}return f};b.elesfn.restore=function(s){var r=this;var J=[];var f=r.cy();if(s===undefined){s=true}var p=[];var z=[],e=[];var v=0;var d=0;for(var F=0,B=r.length;F<B;F++){var o=r[F];if(o.isNode()){z.push(o);v++}else{e.push(o);d++}}p=z.concat(e);for(var F=0,B=p.length;F<B;F++){var o=p[F];if(!o.removed()){continue}var q=o._private;var K=q.data;if(K.id===undefined){K.id=a.generate(f,o)}else{if(b.is.emptyString(K.id)||!b.is.string(K.id)){continue
}else{if(f.getElementById(K.id).length!=0){continue}}}var t=K.id;if(o.isEdge()){var h=o;var u=["source","target"];var w=u.length;for(var C=0;C<w;C++){var c=u[C];var L=K[c];if(L==null||L===""){continue}else{if(f.getElementById(L).empty()){continue}}}var k=f.getElementById(K.source);var E=f.getElementById(K.target);k._private.edges.push(h);E._private.edges.push(h)}q.ids={};q.ids[K.id]=o;q.removed=false;f.addToPool(o);J.push(o)}for(var F=0;F<v;F++){var A=p[F];var K=A._private.data;var t=K.id;var D=A._private.data.parent;
var g=D!=null;if(g){var m=f.getElementById(D);if(m.empty()){delete K.parent}else{var G=false;var I=m;while(!I.empty()){if(A.same(I)){G=true;delete K.parent;break}I=I.parent()}if(!G){m[0]._private.children.push(A);f._private.hasCompoundNodes=true}}}}J=new b.Collection(f,J);if(J.length>0){var H=J.add(J.connectedNodes()).add(J.parent());H.updateStyle(s);if(s){J.rtrigger("add")}else{J.trigger("add")}}return r};b.elesfn.removed=function(){var c=this[0];return c&&c._private.removed};b.elesfn.inside=function(){var c=this[0];
return c&&!c._private.removed};b.elesfn.remove=function(r){var q=this;var A=[];var C=[];var f={};var c=q._private.cy;if(r===undefined){r=true}function B(E){var l=E._private.edges;for(var D=0;D<l.length;D++){m(l[D])}}function j(E){var D=E._private.children;for(var l=0;l<D.length;l++){m(D[l])}}function m(l){var D=f[l.id()];if(D){return}else{f[l.id()]=true}if(l.isNode()){C.push(l);B(l);j(l)}else{C.unshift(l)}}for(var w=0,s=q.length;w<s;w++){var k=q[w];m(k)}function o(G,F){var l=G._private.edges;for(var D=0;
D<l.length;D++){var E=l[D];if(F===E){l.splice(D,1);break}}}function d(E,F){F=F[0];E=E[0];var D=E._private.children;for(var l=0;l<D.length;l++){if(D[l][0]===F[0]){D.splice(l,1);break}}}for(var w=0;w<C.length;w++){var k=C[w];k._private.removed=true;c.removeFromPool(k);A.push(k);if(k.isEdge()){var g=k.source()[0];var z=k.target()[0];o(g,k);o(z,k)}else{var h=k.parent();if(h.length!==0){d(h,k)}}}var p=c._private.elements;c._private.hasCompoundNodes=false;for(var w=0;w<p.length;w++){var k=p[w];if(k.isParent()){c._private.hasCompoundNodes=true;
break}}var v=new b.Collection(this.cy(),A);if(v.size()>0){if(r){this.cy().notify({type:"remove",collection:v})}v.trigger("remove")}var e={};for(var w=0;w<C.length;w++){var k=C[w];var t=k._private.group==="nodes";var u=k._private.data.parent;if(t&&u!==undefined&&!e[u]){e[u]=true;var h=c.getElementById(u);if(h&&h.length!==0&&!h._private.removed&&h.children().length===0){h.updateStyle()}}}return this}})(cytoscape);(function(a){a.fn.eles({animated:function(){var b=this[0];if(b){return b._private.animation.current.length>0
}},clearQueue:function(){for(var b=0;b<this.length;b++){var c=this[b];c._private.animation.queue=[]}return this},delay:function(c,b){this.animate({delay:c},{duration:c,complete:b});return this},animate:function(k,f){var d=+new Date;var e=this._private.cy;var c=e.style();var b;if(f===undefined){f={}}if(f.duration===undefined){f.duration=400}switch(f.duration){case"slow":f.duration=600;break;case"fast":f.duration=200;break}if(k==null||(k.position==null&&k.css==null&&k.delay==null)){return this}if(k.css){k.css=c.getValueStyle(k.css)
}for(var j=0;j<this.length;j++){var m=this[j];var l=m._private.position;var h={x:l.x,y:l.y};var g=c.getValueStyle(m);if(m.animated()&&(f.queue===undefined||f.queue)){b=m._private.animation.queue}else{b=m._private.animation.current}b.push({properties:k,duration:f.duration,params:f,callTime:d,startPosition:h,startStyle:g})}e.addToAnimationPool(this);return this},stop:function(f,h){for(var e=0;e<this.length;e++){var c=this[e];var b=c._private.animation.current;for(var d=0;d<b.length;d++){var g=b[d];
if(h){g.duration=0}}if(f){c._private.animation.queue=[]}}this.cy().notify({collection:this,type:"draw"});return this}})})(cytoscape);(function(a){a.fn.eles({addClass:function(g){g=g.split(/\s+/);var c=this;var k=[];for(var f=0;f<g.length;f++){var b=g[f];if(a.is.emptyString(b)){continue}for(var d=0;d<c.length;d++){var h=c[d];var e=h._private.classes[b];h._private.classes[b]=true;if(!e){k.push(h)}}}if(k.length>0){new a.Collection(this._private.cy,k).updateStyle()}c.trigger("class");return c},hasClass:function(b){var c=this[0];
return c!=null&&c._private.classes[b]},toggleClass:function(h,g){var b=h.split(/\s+/);var o=this;var e=[];for(var f=0,k=o.length;f<k;f++){var p=o[f];for(var c=0;c<b.length;c++){var m=b[c];if(a.is.emptyString(m)){continue}var d=p._private.classes[m];var l=g||(g===undefined&&!d);if(l){p._private.classes[m]=true;if(!d){e.push(p)}}else{p._private.classes[m]=false;if(d){e.push(p)}}}}if(e.length>0){new a.Collection(this._private.cy,e).updateStyle()}o.trigger("class");return o},removeClass:function(g){g=g.split(/\s+/);
var c=this;var k=[];for(var f=0;f<c.length;f++){var h=c[f];for(var d=0;d<g.length;d++){var b=g[d];if(!b||b===""){continue}var e=h._private.classes[b];delete h._private.classes[b];if(e){k.push(h)}}}if(k.length>0){new a.Collection(c._private.cy,k).updateStyle()}c.trigger("class");return c}})})(cytoscape);(function(a){a.fn.eles({allAre:function(b){return this.filter(b).length===this.length},is:function(b){return this.filter(b).length>0},same:function(b){b=this.cy().collection(b);if(this.length!==b.length){return false
}return this.intersect(b).length===this.length},anySame:function(b){b=this.cy().collection(b);return this.intersect(b).length>0},allAreNeighbors:function(b){b=this.cy().collection(b);return this.neighborhood().intersect(b).length===b.length}})})(cytoscape);(function(b){var a=1.4;var c=1;b.fn.eles({updateStyle:function(d){var f=this._private.cy;var e=f.style();d=d||d===undefined?true:false;e.apply(this);if(d){this.rtrigger("style")}else{this.trigger("style")}return this},updateMappers:function(d){var h=this._private.cy;
var f=h.style();d=d||d===undefined?true:false;for(var e=0;e<this.length;e++){var g=this[e];f.apply(g)}if(d){this.rtrigger("style")}else{this.trigger("style")}return this},data:b.define.data({field:"data",bindingEvent:"data",allowBinding:true,allowSetting:true,settingEvent:"data",settingTriggersEvent:true,triggerFnName:"trigger",allowGetting:true,immutableKeys:{id:true,source:true,target:true,parent:true},updateMappers:true}),removeData:b.define.removeData({field:"data",event:"data",triggerFnName:"trigger",triggerEvent:true,immutableKeys:{id:true,source:true,target:true,parent:true},updateMappers:true}),batchData:b.define.batchData({field:"data",event:"data",triggerFnName:"trigger",immutableKeys:{id:true,source:true,target:true,parent:true},updateMappers:true}),scratch:b.define.data({field:"scratch",allowBinding:false,allowSetting:true,settingTriggersEvent:false,allowGetting:true}),removeScratch:b.define.removeData({field:"scratch",triggerEvent:false}),rscratch:b.define.data({field:"rscratch",allowBinding:false,allowSetting:true,settingTriggersEvent:false,allowGetting:true}),removeRscratch:b.define.removeData({field:"rscratch",triggerEvent:false}),id:function(){var d=this[0];
if(d){return d._private.data.id}},position:b.define.data({field:"position",bindingEvent:"position",allowBinding:true,allowSetting:true,settingEvent:"position",settingTriggersEvent:true,triggerFnName:"rtrigger",allowGetting:true,validKeys:["x","y"]}),positions:function(h){if(b.is.plainObject(h)){this.position(h)}else{if(b.is.fn(h)){var e=h;for(var d=0;d<this.length;d++){var f=this[d];var h=e.apply(f,[d,f]);if(h&&!f.locked()){var g=f._private.position;g.x=h.x;g.y=h.y}}this.rtrigger("position")}}return this
},renderedPosition:function(f){var e=this[0];var k=this.cy();var d=k.zoom();var h=k.pan();if(e&&e.isNode()){var j=e._private.position;var g={x:j.x*d+h.x,y:j.y*d+h.y};if(f===undefined){return g}else{return g[f]}}},renderedCss:function(f){var e=this[0];if(e){var d=e.cy().style().getRenderedStyle(e);if(f===undefined){return d}else{return d[f]}}},css:function(d,h){var f=this.cy().style();if(b.is.plainObject(d)){var e=d;f.applyBypass(this,e);this.rtrigger("style")}else{if(b.is.string(d)){if(h===undefined){var g=this[0];
if(g){return g._private.style[d].strValue}else{return}}else{f.applyBypass(this,d,h);this.rtrigger("style")}}else{if(d===undefined){var g=this[0];if(g){return f.getRawStyle(g)}else{return}}}}return this},removeCss:function(){var f=this.cy().style();var d=this;for(var e=0;e<d.length;e++){var g=d[e];f.removeAllBypasses(g)}this.rtrigger("style")},show:function(){this.css("display","element");return this},hide:function(){this.css("display","none");return this},visible:function(){var m=this[0];if(m){if(m.css("visibility")!=="visible"||m.css("display")!=="element"){return false
}if(m.isNode()){var h=m.parents();for(var g=0;g<h.length;g++){var j=h[g];var k=j.css("visibility");var e=j.css("display");var l=parseFloat(j.css("opacity"));if(k!=="visible"||e!=="element"){return false}}return true}else{if(m.isEdge()){var d=m.source();var f=m.target();return d.visible()&&f.visible()}}}},hidden:function(){var d=this[0];if(d){return !this.visible()}},transparent:function(){var d=this[0];if(d){return parseFloat(this.css("opacity"))===0}},width:function(){var e=this[0];if(e){var d=this._private.style.width;
return d.strValue==="auto"?e._private.autoWidth:d.pxValue}},outerWidth:function(){var g=this[0];if(g){var f=this._private.style;var e=f.width.strValue==="auto"?g._private.autoWidth:f.width.pxValue;var d=f["border-width"]?f["border-width"].pxValue*a+c:0;return e+d}},renderedWidth:function(){var e=this[0];if(e){var d=this.width();return d*this.cy().zoom()}},renderedOuterWidth:function(){var e=this[0];if(e){var d=this.outerWidth();return d*this.cy().zoom()}},height:function(){var e=this[0];if(e&&e.isNode()){var d=this._private.style.height;
return d.strValue==="auto"?e._private.autoHeight:d.pxValue}},outerHeight:function(){var g=this[0];if(g){var f=this._private.style;var d=f.height.strValue==="auto"?g._private.autoHeight:f.height.pxValue;var e=f["border-width"]?f["border-width"].pxValue*a+c:0;return d+e}},renderedHeight:function(){var e=this[0];if(e){var d=this.height();return d*this.cy().zoom()}},renderedOuterHeight:function(){var e=this[0];if(e){var d=this.outerHeight();return d*this.cy().zoom()}},offset:function(){var g=this[0];
if(g&&g.isNode()){var j={x:g._private.position.x,y:g._private.position.y};var d=g.parents();for(var e=0;e<d.length;e++){var f=d[e];var h=f._private.position;j.x+=h.x;j.y+=h.y}return j}},renderedOffset:function(){var e=this[0];if(e&&e.isNode()){var g=this.offset();var h=this.cy();var d=h.zoom();var f=h.pan();return{x:g.x*d+f.x,y:g.y*d+f.y}}},boundingBox:function(e){var J=this;if(!e||(b.is.elementOrCollection(e)&&e.length===0)){J=this}else{if(b.is.string(e)){J=this.filter(e)}else{if(b.is.elementOrCollection(e)){J=e
}}}var p=Infinity;var o=-Infinity;var V=Infinity;var T=-Infinity;for(var R=0;R<J.length;R++){var U=J[R];var B,A,m,l,G,F;if(U.isNode()){var v=U._private.position;G=v.x;F=v.y;var H=U.outerWidth();var C=H/2;var S=U.outerHeight();var L=S/2;B=G-C;A=G+C;m=F-L;l=F+L;p=B<p?B:p;o=A>o?A:o;V=m<V?m:V;T=l>T?l:T}else{var z=U.source()[0]._private.position;var d=U.target()[0]._private.position;var D=U._private.rstyle;G=D.labelX;F=D.labelY;B=z.x;A=d.x;m=z.y;l=d.y;if(B>A){var f=B;B=A;A=f}if(m>l){var f=m;m=l;l=f}p=B<p?B:p;
o=A>o?A:o;V=m<V?m:V;T=l>T?l:T;var k=D.bezierPts||[];var H=U._private.style.width.value;for(var Q=0;Q<k.length;Q++){var P=k[Q];p=P.x-H<p?P.x-H:p;o=P.x+H>o?P.x+H:o;V=P.y-H<V?P.y-H:V;T=P.y+H>T?P.y+H:T}}var O=U._private.style;var N=O.content.value;var q=O["font-size"];var u=O["text-halign"];var I=O["text-valign"];var g=U._private.rstyle.labelWidth;if(N&&q&&g!=undefined&&u&&I){var E=q.value;var t=g;var M,K,s,r;switch(u.value){case"left":M=B-t;K=B;break;case"center":M=G-t/2;K=G+t/2;break;case"right":M=A;
K=A+t;break}if(U.isEdge()){M=G-t/2;K=G+t/2}switch(I.value){case"top":s=m-E;r=m;break;case"center":s=F-E/2;r=F+E/2;break;case"bottom":s=l;r=l+E;break}if(U.isEdge()){s=F-E/2;r=F+E/2}p=M<p?M:p;o=K>o?K:o;V=s<V?s:V;T=r>T?r:T}}return{x1:p,x2:o,y1:V,y2:T,w:o-p,h:T-V}}})})(cytoscape);(function(b){function a(d){return function(){var f=this;if(f.length===0){return}if(f.isNode()&&!f.removed()){var k=0;var j=f[0];var e=j._private.edges;for(var g=0;g<e.length;g++){var h=e[g];k+=d(j,h)}return k}else{return}}}b.fn.eles({degree:a(function(e,d){if(d.source().same(d.target())){return 2
}else{return 1}}),indegree:a(function(e,d){if(d.target().same(e)){return 1}else{return 0}}),outdegree:a(function(e,d){if(d.source().same(e)){return 1}else{return 0}})});function c(e,d){return function(){var g=undefined;var f=this.nodes();for(var h=0;h<f.length;h++){var j=f[h];var k=j[e]();if(k!==undefined&&(g===undefined||d(k,g))){g=k}}return g}}b.fn.eles({minDegree:c("degree",function(e,d){return e<d}),maxDegree:c("degree",function(e,d){return e>d}),minIndegree:c("indegree",function(e,d){return e<d
}),maxIndegree:c("indegree",function(e,d){return e>d}),minOutdegree:c("outdegree",function(e,d){return e<d}),maxOutdegree:c("outdegree",function(e,d){return e>d})});b.fn.eles({totalDegree:function(){var f=0;var d=this.nodes();for(var e=0;e<d.length;e++){f+=d[e].degree()}return f}})})(cytoscape);(function(a){a.fn.eles({on:a.define.on(),one:a.define.on({unbindSelfOnTrigger:true}),once:a.define.on({unbindAllBindersOnTrigger:true}),off:a.define.off(),trigger:a.define.trigger(),rtrigger:function(b,c){this.cy().notify({type:b,collection:this.filter(function(){return !this.removed()
})});this.trigger(b,c);return this}});a.elesfn.bind=a.elesfn.on;a.elesfn.unbind=a.elesfn.off;a.define.event.aliasesOn(a.elesfn)})(cytoscape);(function(a){a.fn.eles({isNode:function(){return this.group()==="nodes"},isEdge:function(){return this.group()==="edges"},isLoop:function(){return this.isEdge()&&this.source().id()===this.target().id()},group:function(){var b=this[0];if(b){return b._private.group}}})})(cytoscape);(function(a){a.fn.eles({each:function(d){if(a.is.fn(d)){for(var c=0;c<this.length;
c++){var e=this[c];var b=d.apply(e,[c,e]);if(b===false){break}}}return this},toArray:function(){var c=[];for(var b=0;b<this.length;b++){c.push(this[b])}return c},slice:function(f,b){var e=[];var c=this.length;if(b==null){b=c}if(f<0){f=c+f}for(var d=f;d>=0&&d<b&&d<c;d++){e.push(this[d])}return new a.Collection(this.cy(),e)},size:function(){return this.length},eq:function(b){return this[b]},empty:function(){return this.length===0},nonempty:function(){return !this.empty()}})})(cytoscape);(function(b){function c(d){return function(){var e=arguments;
if(e.length===2){var j=e[0];var g=e[1];this.bind(d.event,j,g)}else{if(e.length===1){var g=e[0];this.bind(d.event,g)}else{if(e.length===0){for(var f=0;f<this.length;f++){var h=this[f];if(!d.ableField||h._private[d.ableField]){h._private[d.field]=d.value}}this.updateStyle();this.trigger(d.event)}}}return this}}function a(d){b.elesfn[d.field]=function(){var e=this[0];if(e){return e._private[d.field]}};b.elesfn[d.on]=c({event:d.on,field:d.field,ableField:d.ableField,value:true});b.elesfn[d.off]=c({event:d.off,field:d.field,ableField:d.ableField,value:false})
}a({field:"locked",on:"lock",off:"unlock"});a({field:"grabbable",on:"grabify",off:"ungrabify"});a({field:"selected",ableField:"selectable",on:"select",off:"unselect"});a({field:"selectable",on:"selectify",off:"unselectify"});b.elesfn.grabbed=function(){var d=this[0];if(d){return d._private.grabbed}};a({field:"active",on:"activate",off:"unactivate"});b.elesfn.inactive=function(){var d=this[0];if(d){return !d._private.active}}})(cytoscape);(function(b){b.fn.eles({nodes:function(e){return this.filter(function(g,f){return f.isNode()
}).filter(e)},edges:function(e){return this.filter(function(g,f){return f.isEdge()}).filter(e)},filter:function(f){var j=this._private.cy;if(b.is.fn(f)){var h=[];for(var e=0;e<this.length;e++){var g=this[e];if(f.apply(g,[e,g])){h.push(g)}}return new b.Collection(j,h)}else{if(b.is.string(f)||b.is.elementOrCollection(f)){return new b.Selector(f).filter(this)}else{if(f===undefined){return this}}}return new b.Collection(j)},not:function(h){var k=this._private.cy;if(!h){return this}else{if(b.is.string(h)){h=this.filter(h)
}var j=[];for(var g=0;g<this.length;g++){var f=this[g];var e=h._private.ids[f.id()];if(!e){j.push(f)}}return new b.Collection(k,j)}},intersect:function(o){var q=this;var j=this._private.cy;if(b.is.string(o)){var k=o;return this.filter(k)}var e=[];var m=this;var l=o;var p=this.length<o.length;var h=p?m._private.ids:l._private.ids;var g=p?l._private.ids:m._private.ids;for(var f in h){var r=g[f];if(r){e.push(r)}}return new b.Collection(j,e)},add:function(m){var o=this;var g=this._private.cy;if(!m){return this
}if(b.is.string(m)){var h=m;m=g.elements(h)}var e=[];var f={};function l(p){if(!p){return}if(!f[p.id()]){e.push(p);f[p.id()]=true}}for(var k=0;k<o.length;k++){var j=o[k];l(j)}for(var k=0;k<m.length;k++){var j=m[k];l(j)}return new b.Collection(g,e)}});b.fn.eles({breadthFirstSearch:function(m,h){m=m||function(){};var g=this._private.cy;var p=this;var k=[];var s={};var l={};var A={};var z=[];for(var B=0;B<p.length;B++){if(p[B].isNode()){k.unshift(p[B]);s[p[B].id()]=true;l[p[B].id()]=0;z.push(p[B])}}B=0;
while(k.length!==0){var r=k.shift();var E=0;var o=A[r.id()];while(o){E++;o=A[o]}l[r.id()]=E;var D=m.call(r,B,E);B++;if(D===true){return new b.Collection(g,[r])}else{if(D===false){break}}var f=r.connectedEdges(h?'[source = "'+r.id()+'"]':undefined);for(var w=0;w<f.length;w++){var C=f[w];var q=C.connectedNodes('[id != "'+r.id()+'"]');if(q.length!==0){q=q[0];if(!s[q.id()]){s[q.id()]=true;k.unshift(q);A[q.id()]=r.id();z.push(q);z.push(C)}}}}return new b.Collection(g,z)},depthFirstSearch:function(p,j){p=p||function(){};
var h=this._private.cy;var u=this;var k=[];var A=[];var m={};var C={};var F={};var l={};var q={};function f(t){var v=t.id();return m[v]||C[v]||F[v]||l[v]}for(var B=0;B<u.length;B++){if(u[B].isNode()){k.push(u[B]);A[u[B].id()]=true}}while(k.length!==0){var z=k[k.length-1];var E=p.call(z);var o=false;if(E===true){return new b.Collection(h,[z])}var g=z.connectedEdges(j?'[source = "'+z.id()+'"]':undefined);for(var B=0;B<g.length;B++){var D=g[B];if(f(D)){continue}var s=D.connectedNodes('[id != "'+z.id()+'"]');
if(s.length!==0){s=s[0];var r=s.id();if(!A[r]&&!q[r]){l[r]=true;A[r]=true;k.push(s);o=true;break}else{if(A[r]){C[r]=true}else{F[r]=true}}}}if(!o){q[z.id()]=true;k.pop()}}},roots:function(f){var e=this;var g=[];for(var h=0;h<e.length;h++){var k=e[h];if(!k.isNode()){continue}var j=k.connectedEdges('[target = "'+k.id()+'"][source != "'+k.id()+'"]').length>0;if(!j){g.push(k)}}return new b.Collection(this._private.cy,g).filter(f)},kruskal:function(l){l=l||function(){return 1};function m(v){for(var u=0;
u<o.length;u++){var t=o[u];if(t.anySame(v)){return{eles:t,index:u}}}}var g=new b.Collection(this._private.cy,[]);var o=[];var e=this.nodes();for(var k=0;k<e.length;k++){o.push(e[k].collection())}var j=this.edges();var h=j.toArray().sort(function(v,u){var t=l.call(v);var w=l.call(u);return t-w});for(var k=0;k<h.length;k++){var f=h[k];var s=f.source()[0];var q=f.target()[0];var r=m(s);var p=m(q);if(r.eles!==p.eles){g=g.add(f);o[r.index]=r.eles.add(p.eles);o.splice(p.index,1)}}return e.add(g)},dijkstra:function(B,C,f){var e=this._private.cy;
f=!b.is.fn(C)?C:f;f=f===undefined||f;C=b.is.fn(C)?C:function(){return 1};if(this.length===0||!B||!b.is.elementOrCollection(B)||B.length===0){return new b.Collection(e,[])}var q=this[0];B=B[0];var o={};var l={};var p=e.nodes();for(var s=0;s<p.length;s++){o[p[s].id()]=Infinity}o[q.id()]=0;var g=p;var w=function(E){var D=Infinity;var u;for(var v in o){if(o[v]<D&&E.$("#"+v).length!==0){D=o[v];u=v}}return u};var t=function(H,G){var F=H.edgesWith(G);var E=Infinity;var D;for(var I=0;I<F.length;I++){var J=F[I];
var K=C.call(J);if(K<E){E=K;D=J}}return{edge:D,dist:E}};while(g.length!==0){var h=w(g);var k=g.filter("#"+h);if(k.length===0){continue}g=g.not(k);if(k.same(B)){break}if(o[h]===Math.Infinite){break}var r=k.neighborhood().nodes();for(var s=0;s<r.length;s++){var j=r[s];var z=j.id();var m=t(k,j);var A=o[h]+m.dist;if(A<o[z]){o[z]=A;l[z]={node:j,edge:m.edge}}}}}});b.elesfn.bfs=b.elesfn.breadthFirstSearch;b.elesfn.dfs=b.elesfn.depthFirstSearch;b.fn.eles({neighborhood:function(m){var e=[];var l=this._private.cy;
var f=this.nodes();for(var q=0;q<f.length;q++){var k=f[q];var h=k.connectedEdges();for(var p=0;p<h.length;p++){var g=h[p];var o=g.connectedNodes().not(k);if(o.length>0){e.push(o[0])}e.push(g[0])}}return(new b.Collection(l,e)).filter(m)},closedNeighborhood:function(e){return this.neighborhood().add(this).filter(e)},openNeighborhood:function(e){return this.neighborhood(e)}});b.fn.eles({source:d({attr:"source"}),target:d({attr:"target"})});function d(e){return function(f){var h=[];var g=this.edges();
var o=this._private.cy;for(var j=0;j<g.length;j++){var k=g[j];var m=k._private.data[e.attr];var l=o.getElementById(m);if(l.length>0){h.push(l)}}return new b.Collection(o,h).filter(f)}}b.fn.eles({edgesWith:a(),edgesTo:a({thisIs:"source"})});function a(e){return function(r){var f=[];var j=this._private.cy;var g=e||{};if(b.is.string(r)){r=j.$(r)}var l=r.connectedEdges();var s=this._private.ids;for(var m=0;m<l.length;m++){var h=l[m];var o;var q=h._private.data;if(g.thisIs){var k=q[g.thisIs];o=s[k]}else{o=s[q.source]||s[q.target]
}if(o){f.push(h)}}return new b.Collection(j,f)}}b.fn.eles({connectedEdges:function(l){var e=[];var k=this._private.cy;var f=this.nodes();for(var p=0;p<f.length;p++){var h=f[p];var o=h._private.edges;for(var m=0;m<o.length;m++){var g=o[m];e.push(g)}}return new b.Collection(k,e).filter(l)},connectedNodes:function(e){var j=[];var k=this._private.cy;var f=this.edges();for(var g=0;g<f.length;g++){var h=f[g];j.push(h.source()[0]);j.push(h.target()[0])}return new b.Collection(k,j).filter(e)},parallelEdges:c(),codirectedEdges:c({codirected:true}),parallelIndex:function(){var g=this[0];
if(g.isEdge()){var e=g.source()[0];var m=e._private.edges;var l=0;for(var j=0;j<m.length;j++){var h=m[j];var p=h===g;if(p){return l}var o=g._private.data.source===h._private.data.source&&g._private.data.target===h._private.data.target;var f=g._private.data.source===h._private.data.target&&g._private.data.target===h._private.data.source;var k=o||f;if(k){l++}}}},parallelSize:function(){var g=this[0];if(g.isEdge()){var e=g.source()[0];var m=e._private.edges;var j=0;for(var k=0;k<m.length;k++){var h=m[k];
var o=g._private.data.source===h._private.data.source&&g._private.data.target===h._private.data.target;var f=g._private.data.source===h._private.data.target&&g._private.data.target===h._private.data.source;var l=o||f;if(l){j++}}return j}}});function c(f){var e={codirected:false};f=b.util.extend({},e,f);return function(C){var l=this._private.cy;var u=[];var k=this.edges();var v=f;for(var D=0;D<k.length;D++){var t=k[D];var E=t.source()[0];var r=E.id();var A=t.target()[0];var o=A.id();var z=E._private.edges;
for(var B=0;B<z.length;B++){var s=z[B];var g=s._private.data;var m=g.target;var q=g.source;var h=m===o&&q===r;var w=r===m&&o===q;if((v.codirected&&h)||(!v.codirected&&(h||w))){u.push(s)}}}return new b.Collection(l,u).filter(C)}}b.fn.eles({parent:function(e){var f=[];var k=this._private.cy;for(var g=0;g<this.length;g++){var j=this[g];var h=k.getElementById(j._private.data.parent);if(h.size()>0){f.push(h)}}return new b.Collection(k,f).filter(e)},parents:function(f){var g=[];var e=this.parent();while(e.nonempty()){for(var h=0;
h<e.length;h++){var j=e[h];g.push(j)}e=e.parent()}return new b.Collection(this.cy(),g).filter(f)},children:function(e){var g=[];for(var f=0;f<this.length;f++){var h=this[f];g=g.concat(h._private.children)}return new b.Collection(this.cy(),g).filter(e)},siblings:function(e){return this.parent().children().not(this).filter(e)},isParent:function(){var e=this[0];if(e){return e._private.children.length!==0}},isChild:function(){var e=this[0];if(e){return e._private.data.parent!==undefined&&e.parent().length!==0
}},descendants:function(e){var f=[];function g(h){for(var j=0;j<h.length;j++){var k=h[j];f.push(k);if(k.children().nonempty()){g(k.children())}}}g(this.children());return new b.Collection(this.cy(),f).filter(e)}})})(cytoscape);(function($$){$$.fn.selector=function(map,options){for(var name in map){var fn=map[name];$$.Selector.prototype[name]=fn}};$$.Selector=function(onlyThisGroup,selector){if(!(this instanceof $$.Selector)){return new $$.Selector(onlyThisGroup,selector)}if(selector===undefined&&onlyThisGroup!==undefined){selector=onlyThisGroup;
onlyThisGroup=undefined}var self=this;self._private={selectorText:null,invalid:true};function newQuery(){return{classes:[],colonSelectors:[],data:[],group:null,ids:[],meta:[],collection:null,filter:null,parent:null,ancestor:null,subject:null,child:null,descendant:null}}if(!selector||($$.is.string(selector)&&selector.match(/^\s*$/))){if(onlyThisGroup==null){self.length=0}else{self[0]=newQuery();self[0].group=onlyThisGroup;self.length=1}}else{if($$.is.element(selector)){var collection=new $$.Collection(self.cy(),[selector]);
self[0]=newQuery();self[0].collection=collection;self.length=1}else{if($$.is.collection(selector)){self[0]=newQuery();self[0].collection=selector;self.length=1}else{if($$.is.fn(selector)){self[0]=newQuery();self[0].filter=selector;self.length=1}else{if($$.is.string(selector)){var metaChar="[\\!\\\"\\#\\$\\%\\&\\'\\(\\)\\*\\+\\,\\.\\/\\:\\;\\<\\=\\>\\?\\@\\[\\]\\^\\`\\{\\|\\}\\~]";var variable="(?:[\\w-]|(?:\\\\"+metaChar+"))+";var comparatorOp="=|\\!=|>|>=|<|<=|\\$=|\\^=|\\*=";var boolOp="\\?|\\!|\\^";
var string="\"(?:\\\\\"|[^\"])+\"|'(?:\\\\'|[^'])+'";var number=$$.util.regex.number;var value=string+"|"+number;var meta="degree|indegree|outdegree";var separator="\\s*,\\s*";var className=variable;var descendant="\\s+";var child="\\s+>\\s+";var subject="\\$";var id=variable;function cleanMetaChars(str){return str.replace(new RegExp("\\\\("+metaChar+")","g"),"\1")}var ops=comparatorOp.split("|");for(var i=0;i<ops.length;i++){var op=ops[i];comparatorOp+="|@"+op}var currentSubject=null;var exprs={group:{query:true,regex:"(node|edge|\\*)",populate:function(group){this.group=group=="*"?group:group+"s"
}},state:{query:true,regex:"(:selected|:unselected|:locked|:unlocked|:visible|:hidden|:transparent|:grabbed|:free|:removed|:inside|:grabbable|:ungrabbable|:animated|:unanimated|:selectable|:unselectable|:parent|:child|:active|:inactive|:touch)",populate:function(state){this.colonSelectors.push(state)}},id:{query:true,regex:"\\#("+id+")",populate:function(id){this.ids.push(cleanMetaChars(id))}},className:{query:true,regex:"\\.("+className+")",populate:function(className){this.classes.push(cleanMetaChars(className))
}},dataExists:{query:true,regex:"\\[\\s*("+variable+")\\s*\\]",populate:function(variable){this.data.push({field:cleanMetaChars(variable)})}},dataCompare:{query:true,regex:"\\[\\s*("+variable+")\\s*("+comparatorOp+")\\s*("+value+")\\s*\\]",populate:function(variable,comparatorOp,value){this.data.push({field:cleanMetaChars(variable),operator:comparatorOp,value:value})}},dataBool:{query:true,regex:"\\[\\s*("+boolOp+")\\s*("+variable+")\\s*\\]",populate:function(boolOp,variable){this.data.push({field:cleanMetaChars(variable),operator:boolOp})
}},metaCompare:{query:true,regex:"\\{\\s*("+meta+")\\s*("+comparatorOp+")\\s*("+number+")\\s*\\}",populate:function(meta,comparatorOp,number){this.meta.push({field:cleanMetaChars(meta),operator:comparatorOp,value:number})}},nextQuery:{separator:true,regex:separator,populate:function(){self[++i]=newQuery();currentSubject=null}},child:{separator:true,regex:child,populate:function(){var childQuery=newQuery();childQuery.parent=this;childQuery.subject=currentSubject;self[i]=childQuery}},descendant:{separator:true,regex:descendant,populate:function(){var descendantQuery=newQuery();
descendantQuery.ancestor=this;descendantQuery.subject=currentSubject;self[i]=descendantQuery}},subject:{modifier:true,regex:subject,populate:function(){if(currentSubject!=null&&this.subject!=this){$$.util.error("Redefinition of subject in selector `"+selector+"`");return false}currentSubject=this;this.subject=this},}};var j=0;for(var name in exprs){exprs[j]=exprs[name];exprs[j].name=name;j++}exprs.length=j;self._private.selectorText=selector;var remaining=selector;var i=0;function consumeExpr(expectation){var expr;
var match;var name;for(var j=0;j<exprs.length;j++){var e=exprs[j];var n=e.name;if($$.is.fn(expectation)&&!expectation(n,e)){continue}var m=remaining.match(new RegExp("^"+e.regex));if(m!=null){match=m;expr=e;name=n;var consumed=m[0];remaining=remaining.substring(consumed.length);break}}return{expr:expr,match:match,name:name}}function consumeWhitespace(){var match=remaining.match(/^\s+/);if(match){var consumed=match[0];remaining=remaining.substring(consumed.length)}}self[0]=newQuery();consumeWhitespace();
for(;;){var check=consumeExpr();if(check.expr==null){$$.util.error("The selector `"+selector+"`is invalid");return}else{var args=[];for(var j=1;j<check.match.length;j++){args.push(check.match[j])}var ret=check.expr.populate.apply(self[i],args);if(ret===false){return}}if(remaining.match(/^\s*$/)){break}}self.length=i+1;for(j=0;j<self.length;j++){var query=self[j];if(query.subject!=null){for(;;){if(query.subject==query){break}if(query.parent!=null){var parent=query.parent;var child=query;child.parent=null;
parent.child=child;query=parent}else{if(query.ancestor!=null){var ancestor=query.ancestor;var descendant=query;descendant.ancestor=null;ancestor.descendant=descendant;query=ancestor}else{$$.util.error("When adjusting references for the selector `"+query+"`, neither parent nor ancestor was found");break}}}self[j]=query.subject}}if(onlyThisGroup!=null){for(var j=0;j<self.length;j++){if(self[j].group!=null&&self[j].group!=onlyThisGroup){$$.util.error("Group `"+self[j].group+"` conflicts with implicit group `"+onlyThisGroup+"` in selector `"+selector+"`");
return}self[j].group=onlyThisGroup}}}else{$$.util.error("A selector must be created from a string; found "+selector);return}}}}}self._private.invalid=false};$$.selfn=$$.Selector.prototype;$$.selfn.size=function(){return this.length};$$.selfn.eq=function(i){return this[i]};$$.selfn.find=function(){};$$.selfn.filter=function(collection,addLiveFunction){var self=this;var cy=collection.cy();if(self._private.invalid){return new $$.Collection(cy)}var queryMatches=function(query,element){if(query.group!=null&&query.group!="*"&&query.group!=element._private.group){return false
}var allColonSelectorsMatch=true;for(var k=0;k<query.colonSelectors.length;k++){var sel=query.colonSelectors[k];var renderer=cy.renderer();switch(sel){case":selected":allColonSelectorsMatch=element.selected();break;case":unselected":allColonSelectorsMatch=!element.selected();break;case":selectable":allColonSelectorsMatch=element.selectable();break;case":unselectable":allColonSelectorsMatch=!element.selectable();break;case":locked":allColonSelectorsMatch=element.locked();break;case":unlocked":allColonSelectorsMatch=!element.locked();
break;case":visible":allColonSelectorsMatch=element.visible();break;case":hidden":allColonSelectorsMatch=!element.visible();break;case":transparent":allColonSelectorsMatch=!element.transparent();break;case":grabbed":allColonSelectorsMatch=element.grabbed();break;case":free":allColonSelectorsMatch=!element.grabbed();break;case":removed":allColonSelectorsMatch=element.removed();break;case":inside":allColonSelectorsMatch=!element.removed();break;case":grabbable":allColonSelectorsMatch=element.grabbable();
break;case":ungrabbable":allColonSelectorsMatch=!element.grabbable();break;case":animated":allColonSelectorsMatch=element.animated();break;case":unanimated":allColonSelectorsMatch=!element.animated();break;case":parent":allColonSelectorsMatch=element.children().nonempty();break;case":child":allColonSelectorsMatch=element.parent().nonempty();break;case":active":allColonSelectorsMatch=element.active();break;case":inactive":allColonSelectorsMatch=!element.active();break;case":touch":allColonSelectorsMatch=window&&document&&(("ontouchstart" in window)||window.DocumentTouch&&document instanceof DocumentTouch);
break}if(!allColonSelectorsMatch){break}}if(!allColonSelectorsMatch){return false}var allIdsMatch=true;for(var k=0;k<query.ids.length;k++){var id=query.ids[k];var actualId=element._private.data.id;allIdsMatch=allIdsMatch&&(id==actualId);if(!allIdsMatch){break}}if(!allIdsMatch){return false}var allClassesMatch=true;for(var k=0;k<query.classes.length;k++){var cls=query.classes[k];allClassesMatch=allClassesMatch&&element.hasClass(cls);if(!allClassesMatch){break}}if(!allClassesMatch){return false}function operandsMatch(params){var allDataMatches=true;
for(var k=0;k<query[params.name].length;k++){var data=query[params.name][k];var operator=data.operator;var value=data.value;var field=data.field;var matches;if(operator!=null&&value!=null){var fieldStr=""+params.fieldValue(field);var valStr=""+eval(value);var caseInsensitive=false;if(operator.charAt(0)=="@"){fieldStr=fieldStr.toLowerCase();valStr=valStr.toLowerCase();operator=operator.substring(1);caseInsensitive=true}if(operator=="="){operator="=="}switch(operator){case"*=":matches=fieldStr.search(valStr)>=0;
break;case"$=":matches=new RegExp(valStr+"$").exec(fieldStr)!=null;break;case"^=":matches=new RegExp("^"+valStr).exec(fieldStr)!=null;break;default:if(caseInsensitive){var expr="fieldStr "+operator+" valStr";matches=eval(expr)}else{var expr=params.fieldRef(field)+" "+operator+" "+value;matches=eval(expr)}}}else{if(operator!=null){switch(operator){case"?":matches=params.fieldTruthy(field);break;case"!":matches=!params.fieldTruthy(field);break;case"^":matches=params.fieldUndefined(field);break}}else{matches=!params.fieldUndefined(field)
}}if(!matches){allDataMatches=false;break}}return allDataMatches}var allDataMatches=operandsMatch({name:"data",fieldValue:function(field){return element._private.data[field]},fieldRef:function(field){return"element._private.data."+field},fieldUndefined:function(field){return element._private.data[field]===undefined},fieldTruthy:function(field){if(element._private.data[field]){return true}return false}});if(!allDataMatches){return false}var allMetaMatches=operandsMatch({name:"meta",fieldValue:function(field){return element[field]()
},fieldRef:function(field){return"element."+field+"()"},fieldUndefined:function(field){return element[field]()==undefined},fieldTruthy:function(field){if(element[field]()){return true}return false}});if(!allMetaMatches){return false}if(query.collection!=null){var matchesAny=query.collection._private.ids[element.id()]!=null;if(!matchesAny){return false}}if(query.filter!=null&&element.collection().filter(query.filter).size()==0){return false}function confirmRelations(query,elements){if(query!=null){var matches=false;
elements=elements();for(var i=0;i<elements.size();i++){if(queryMatches(query,elements.eq(i))){matches=true;break}}return matches}else{return true}}if(!confirmRelations(query.parent,function(){return element.parent()})){return false}if(!confirmRelations(query.ancestor,function(){return element.parents()})){return false}if(!confirmRelations(query.child,function(){return element.children()})){return false}if(!confirmRelations(query.descendant,function(){return element.descendants()})){return false}return true
};var selectorFunction=function(i,element){for(var j=0;j<self.length;j++){var query=self[j];if(queryMatches(query,element)){return true}}return false};if(self._private.selectorText==null){selectorFunction=function(){return true}}var filteredCollection=collection.filter(selectorFunction);return filteredCollection};$$.selfn.toString=$$.selfn.selector=function(){var str="";function clean(obj){if($$.is.string(obj)){return obj}return""}function queryToString(query){var str="";var group=clean(query.group);
str+=group.substring(0,group.length-1);for(var j=0;j<query.data.length;j++){var data=query.data[j];str+="["+data.field+clean(data.operator)+clean(data.value)+"]"}for(var j=0;j<query.meta.length;j++){var meta=query.meta[j];str+="{"+meta.field+clean(meta.operator)+clean(meta.value)+"}"}for(var j=0;j<query.colonSelectors.length;j++){var sel=query.colonSelectors[i];str+=sel}for(var j=0;j<query.ids.length;j++){var sel="#"+query.ids[i];str+=sel}for(var j=0;j<query.classes.length;j++){var sel="."+query.classes[i];
str+=sel}if(query.parent!=null){str=queryToString(query.parent)+" > "+str}if(query.ancestor!=null){str=queryToString(query.ancestor)+" "+str}if(query.child!=null){str+=" > "+queryToString(query.child)}if(query.descendant!=null){str+=" "+queryToString(query.descendant)}return str}for(var i=0;i<this.length;i++){var query=this[i];str+=queryToString(query);if(this.length>1&&i<this.length-1){str+=", "}}return str}})(cytoscape);(function(a){function b(c){}b.prototype.notify=function(c){};a("renderer","null",b)
})(cytoscape);(function(c){function a(f){a.CANVAS_LAYERS=5;a.SELECT_BOX=0;a.DRAG=2;a.OVERLAY=3;a.NODE=4;a.BUFFER_COUNT=2;this.options=f;this.data={select:[undefined,undefined,undefined,undefined,0],renderer:this,cy:f.cy,container:f.cy.container(),canvases:new Array(a.CANVAS_LAYERS),canvasRedrawReason:new Array(a.CANVAS_LAYERS),canvasNeedsRedraw:new Array(a.CANVAS_LAYERS),bufferCanvases:new Array(a.BUFFER_COUNT)};this.hoverData={down:null,last:null,downTime:null,triggerMode:null,dragging:false,initialPan:[null,null],capture:false};
this.timeoutData={panTimeout:null};this.dragData={possibleDragElements:[]};this.touchData={start:null,capture:false,startPosition:[null,null,null,null,null,null],singleTouchStartTime:null,singleTouchMoved:true,now:[null,null,null,null,null,null],earlier:[null,null,null,null,null,null]};this.zoomData={freeToZoom:false,lastPointerX:null};this.redraws=0;this.bindings=[];for(var g=0;g<a.CANVAS_LAYERS;g++){this.data.canvases[g]=document.createElement("canvas");this.data.canvases[g].style.position="absolute";
this.data.canvases[g].setAttribute("data-id","layer"+g);this.data.canvases[g].style.zIndex=String(a.CANVAS_LAYERS-g);this.data.container.appendChild(this.data.canvases[g]);this.data.canvasRedrawReason[g]=new Array();this.data.canvasNeedsRedraw[g]=false}this.data.canvases[a.NODE].setAttribute("data-id","layer"+a.NODE+"-node");this.data.canvases[a.SELECT_BOX].setAttribute("data-id","layer"+a.SELECT_BOX+"-selectbox");this.data.canvases[a.DRAG].setAttribute("data-id","layer"+a.DRAG+"-drag");this.data.canvases[a.OVERLAY].setAttribute("data-id","layer"+a.OVERLAY+"-overlay");
for(var g=0;g<a.BUFFER_COUNT;g++){this.data.bufferCanvases[g]=document.createElement("canvas");this.data.bufferCanvases[g].style.position="absolute";this.data.bufferCanvases[g].setAttribute("data-id","buffer"+g);this.data.bufferCanvases[g].style.zIndex=String(-g-1);this.data.bufferCanvases[g].style.visibility="hidden";this.data.container.appendChild(this.data.bufferCanvases[g])}var e=document.createElement("div");this.data.container.appendChild(e);this.data.overlay=e;e.style.position="absolute";e.style.zIndex=1000;
if(f.showOverlay){var h=document.createElement("a");e.appendChild(h);this.data.link=h;h.innerHTML="@cytoscape.js";h.style.font="14px helvetica";h.style.position="absolute";h.style.right=0;h.style.bottom=0;h.style.padding="1px 3px";h.style.paddingLeft="5px";h.style.paddingTop="5px";h.style.opacity=0;h.style["-webkit-tap-highlight-color"]="transparent";h.style.background="red";h.href="http://cytoscape.github.io/cytoscape.js@/";h.target="_blank"}this.hideEdgesOnViewport=f.hideEdgesOnViewport;this.load()
}a.panOrBoxSelectDelay=400;a.isTouch=("ontouchstart" in window)||window.DocumentTouch&&document instanceof DocumentTouch;a.prototype.notify=function(e){if(e.type=="destroy"){this.destroy();return}else{if(e.type=="add"||e.type=="remove"||e.type=="load"){this.updateNodesCache();this.updateEdgesCache()}}if(e.type=="viewport"){this.data.canvasNeedsRedraw[a.SELECT_BOX]=true;this.data.canvasRedrawReason[a.SELECT_BOX].push("viewchange")}this.data.canvasNeedsRedraw[a.DRAG]=true;this.data.canvasRedrawReason[a.DRAG].push("notify");
this.data.canvasNeedsRedraw[a.NODE]=true;this.data.canvasRedrawReason[a.NODE].push("notify");this.redraws++;this.redraw()};a.prototype.destroy=function(){this.destroyed=true;for(var f=0;f<this.bindings.length;f++){var g=this.bindings[f];var e=g;e.target.removeEventListener(e.event,e.handler,e.useCapture)}};for(var d in c.math){a.prototype[d]=c.math[d]}var b=function(){};c("renderer","canvas",a)})(cytoscape);(function(c){var b=c("renderer","canvas");var a=b.prototype;var d=b.arrowShapes={};d.arrow={_points:[-0.15,-0.3,0,0,0.15,-0.3],collide:function(l,h,g,f,e,o,j,k){var m=d.arrow._points;
return c.math.pointInsidePolygon(l,h,m,g,f,e,o,j,k)},roughCollide:function(f,m,l,h,g,e,k,j){if(typeof(d.arrow._farthestPointSqDistance)=="undefined"){d.arrow._farthestPointSqDistance=c.math.findMaxSqDistanceToOrigin(d.arrow._points)}return c.math.checkInBoundingCircle(f,m,d.arrow._farthestPointSqDistance,0,g,e,l,h)},draw:function(f){var g=d.arrow._points;for(var e=0;e<g.length/2;e++){f.lineTo(g[e*2],g[e*2+1])}},spacing:function(e){return 0},gap:function(e){return e._private.style.width.value*2}};
d.triangle=d.arrow;d.none={collide:function(f,m,l,h,g,e,k,j){return false},roughCollide:function(f,m,l,h,g,e,k,j){return false},draw:function(e){},spacing:function(e){return 0},gap:function(e){return 0}};d.circle={_baseRadius:0.15,collide:function(p,l,h,g,e,s,m,o){if(e!=s){var f=Math.asin(m[1]/(Math.sqrt(m[0]*m[0]+m[1]*m[1])));var r=Math.cos(-f);var k=Math.sin(-f);var j=[p*r-l*k,l*r+p*k];var q=(s+o)/(e+o);l/=q;g/=q;return(Math.pow(h-p,2)+Math.pow(g-l,2)<=Math.pow((e+o)*d.circle._baseRadius,2))}else{return(Math.pow(h-p,2)+Math.pow(g-l,2)<=Math.pow((e+o)*d.circle._baseRadius,2))
}},roughCollide:function(f,m,l,h,g,e,k,j){return true},draw:function(e){e.arc(0,0,d.circle._baseRadius,0,Math.PI*2,false)},spacing:function(e){return a.getArrowWidth(e._private.style.width.value)*d.circle._baseRadius},gap:function(e){return e._private.style.width.value*2}};d.inhibitor={_points:[-0.25,0,-0.25,-0.1,0.25,-0.1,0.25,0],collide:function(l,h,g,f,e,o,j,k){var m=d.inhibitor._points;return c.math.pointInsidePolygon(l,h,m,g,f,e,o,j,k)},roughCollide:function(f,m,l,h,g,e,k,j){if(typeof(d.inhibitor._farthestPointSqDistance)=="undefined"){d.inhibitor._farthestPointSqDistance=c.math.findMaxSqDistanceToOrigin(d.inhibitor._points)
}return c.math.checkInBoundingCircle(f,m,d.inhibitor._farthestPointSqDistance,0,g,e,l,h)},draw:function(f){var g=d.inhibitor._points;for(var e=0;e<g.length/2;e++){f.lineTo(g[e*2],g[e*2+1])}},spacing:function(e){return 4},gap:function(e){return 4}};d.square={_points:[-0.12,0,0.12,0,0.12,-0.24,-0.12,-0.24],collide:function(l,h,g,f,e,o,j,k){var m=d.square._points;return c.math.pointInsidePolygon(l,h,m,g,f,e,o,j,k)},roughCollide:function(f,m,l,h,g,e,k,j){if(typeof(d.square._farthestPointSqDistance)=="undefined"){d.square._farthestPointSqDistance=c.math.findMaxSqDistanceToOrigin(d.square._points)
}return c.math.checkInBoundingCircle(f,m,d.square._farthestPointSqDistance,0,g,e,l,h)},draw:function(f){var g=d.square._points;for(var e=0;e<g.length/2;e++){f.lineTo(g[e*2],g[e*2+1])}},spacing:function(e){return 0},gap:function(e){return e._private.style.width.value*2}};d.diamond={_points:[-0.14,-0.14,0,-0.28,0.14,-0.14,0,0],collide:function(l,h,g,f,e,o,j,k){var m=d.diamond._points;return c.math.pointInsidePolygon(l,h,m,g,f,e,o,j,k)},roughCollide:function(f,m,l,h,g,e,k,j){if(typeof(d.diamond._farthestPointSqDistance)=="undefined"){d.diamond._farthestPointSqDistance=c.math.findMaxSqDistanceToOrigin(d.diamond._points)
}return c.math.checkInBoundingCircle(f,m,d.diamond._farthestPointSqDistance,0,g,e,l,h)},draw:function(e){e.lineTo(-0.14,-0.14);e.lineTo(0,-0.28);e.lineTo(0.14,-0.14);e.lineTo(0,0)},spacing:function(e){return 0},gap:function(e){return e._private.style.width.value*2}};d.tee=d.inhibitor})(cytoscape);(function(b){var a=b("renderer","canvas");a.prototype.getCachedNodes=function(){var c=this.data;var d=this.data.cy;if(c.cache==undefined){c.cache={}}if(c.cache.cachedNodes==undefined){c.cache.cachedNodes=d.nodes()
}return c.cache.cachedNodes};a.prototype.updateNodesCache=function(){var c=this.data;var d=this.data.cy;if(c.cache==undefined){c.cache={}}c.cache.cachedNodes=d.nodes()};a.prototype.getCachedEdges=function(){var c=this.data;var d=this.data.cy;if(c.cache==undefined){c.cache={}}if(c.cache.cachedEdges==undefined){c.cache.cachedEdges=d.edges()}return c.cache.cachedEdges};a.prototype.updateEdgesCache=function(){var c=this.data;var d=this.data.cy;if(c.cache==undefined){c.cache={}}c.cache.cachedEdges=d.edges()
}})(cytoscape);(function(b){var a=b("renderer","canvas");a.prototype.projectIntoViewport=function(e,c){n=this.data.container;var h=false;var f=this.findContainerPageCoords();var g=f[0];var d=f[1];x=e-g;y=c-d;x-=this.data.cy.pan().x;y-=this.data.cy.pan().y;x/=this.data.cy.zoom();y/=this.data.cy.zoom();return[x,y]};a.prototype.findContainerPageCoords=function(){var c,j;var f=0;var e=0;var h;h=this.data.container;var g=false;while(h!=null){var d=window.getComputedStyle(h);if(d.getPropertyValue("position").toLowerCase()==="fixed"){f=h.offsetLeft+window.scrollX;
e=h.offsetTop+window.scrollY;h=null}else{if(typeof(h.offsetLeft)=="number"){f+=h.offsetLeft;e+=h.offsetTop;if(h==document.body||h==document.header){g=true}if(!g){f-=h.scrollLeft;e-=h.scrollTop}}}if(h){h=h.offsetParent}}return[f,e]};a.prototype.findNearestElement=function(t,s,e){var o=this.data;var f=this.getCachedNodes();var l=this.getCachedEdges();var p=[];var k=a.isTouch;var u=this.data.cy.zoom();var h=(k?256:32)/u;var r=(k?16:0)/u;for(var m=0;m<f.length;m++){if(a.nodeShapes[this.getNodeShape(f[m])].checkPointRough(t,s,f[m]._private.style["border-width"].value/2,this.getNodeWidth(f[m])+r,this.getNodeHeight(f[m])+r,f[m]._private.position.x,f[m]._private.position.y)&&a.nodeShapes[this.getNodeShape(f[m])].checkPoint(t,s,f[m]._private.style["border-width"].value/2,(this.getNodeWidth(f[m])+r),(this.getNodeHeight(f[m])+r),f[m]._private.position.x,f[m]._private.position.y)){if(e){if(f[m]._private.style.opacity.value!=0&&f[m]._private.style.visibility.value=="visible"&&f[m]._private.style.display.value=="element"){p.push(f[m])
}}else{p.push(f[m])}}}var d;for(var m=0;m<l.length;m++){var g=l[m];var j=g._private.rscratch;d=false;if(j.edgeType=="self"){if((b.math.inBezierVicinity(t,s,j.startX,j.startY,j.cp2ax,j.cp2ay,j.selfEdgeMidX,j.selfEdgeMidY,Math.pow(g._private.style.width.value/2,2))&&(Math.pow(l[m]._private.style.width.value/2,2)+h>b.math.sqDistanceToQuadraticBezier(t,s,j.startX,j.startY,j.cp2ax,j.cp2ay,j.selfEdgeMidX,j.selfEdgeMidY)))||(b.math.inBezierVicinity(t,s,j.selfEdgeMidX,j.selfEdgeMidY,j.cp2cx,j.cp2cy,j.endX,j.endY,Math.pow(l[m]._private.style.width.value/2,2))&&(Math.pow(l[m]._private.style.width.value/2,2)+h>b.math.sqDistanceToQuadraticBezier(t,s,j.selfEdgeMidX,j.selfEdgeMidY,j.cp2cx,j.cp2cy,j.endX,j.endY)))){d=true
}}else{if(j.edgeType=="straight"){if(b.math.inLineVicinity(t,s,j.startX,j.startY,j.endX,j.endY,l[m]._private.style.width.value*2)&&Math.pow(l[m]._private.style.width.value/2,2)+h>b.math.sqDistanceToFiniteLine(t,s,j.startX,j.startY,j.endX,j.endY)){d=true}}else{if(j.edgeType=="bezier"){if(b.math.inBezierVicinity(t,s,j.startX,j.startY,j.cp2x,j.cp2y,j.endX,j.endY,Math.pow(l[m]._private.style.width.value/2,2))&&(Math.pow(l[m]._private.style.width.value/2,2)+h>b.math.sqDistanceToQuadraticBezier(t,s,j.startX,j.startY,j.cp2x,j.cp2y,j.endX,j.endY))){d=true
}}}}if(!p.length||p[p.length-1]!=l[m]){if((a.arrowShapes[l[m]._private.style["source-arrow-shape"].value].roughCollide(t,s,l[m]._private.rscratch.arrowStartX,l[m]._private.rscratch.arrowStartY,this.getArrowWidth(l[m]._private.style.width.value),this.getArrowHeight(l[m]._private.style.width.value),[l[m]._private.rscratch.arrowStartX-l[m].source()[0]._private.position.x,l[m]._private.rscratch.arrowStartY-l[m].source()[0]._private.position.y],0)&&a.arrowShapes[l[m]._private.style["source-arrow-shape"].value].collide(t,s,l[m]._private.rscratch.arrowStartX,l[m]._private.rscratch.arrowStartY,this.getArrowWidth(l[m]._private.style.width.value),this.getArrowHeight(l[m]._private.style.width.value),[l[m]._private.rscratch.arrowStartX-l[m].source()[0]._private.position.x,l[m]._private.rscratch.arrowStartY-l[m].source()[0]._private.position.y],0))||(a.arrowShapes[l[m]._private.style["target-arrow-shape"].value].roughCollide(t,s,l[m]._private.rscratch.arrowEndX,l[m]._private.rscratch.arrowEndY,this.getArrowWidth(l[m]._private.style.width.value),this.getArrowHeight(l[m]._private.style.width.value),[l[m]._private.rscratch.arrowEndX-l[m].target()[0]._private.position.x,l[m]._private.rscratch.arrowEndY-l[m].target()[0]._private.position.y],0)&&a.arrowShapes[l[m]._private.style["target-arrow-shape"].value].collide(t,s,l[m]._private.rscratch.arrowEndX,l[m]._private.rscratch.arrowEndY,this.getArrowWidth(l[m]._private.style.width.value),this.getArrowHeight(l[m]._private.style.width.value),[l[m]._private.rscratch.arrowEndX-l[m].target()[0]._private.position.x,l[m]._private.rscratch.arrowEndY-l[m].target()[0]._private.position.y],0))){d=true
}}if(d){if(e){var c=o.cy.getElementById(l[m]._private.data.source);var q=o.cy.getElementById(l[m]._private.data.target);if(l[m]._private.style.opacity.value!=0&&l[m]._private.style.visibility.value=="visible"&&l[m]._private.style.display.value=="element"&&c._private.style.opacity.value!=0&&c._private.style.visibility.value=="visible"&&c._private.style.display.value=="element"&&q._private.style.opacity.value!=0&&q._private.style.visibility.value=="visible"&&q._private.style.display.value=="element"){p.push(l[m])
}}else{p.push(l[m])}}}p.sort(this.zOrderSort);if(p.length>0){return p[p.length-1]}else{return null}};a.prototype.getAllInBox=function(e,q,c,p){var k=this.data;var d=this.getCachedNodes();var h=this.getCachedEdges();var l=[];var o=Math.min(e,c);var g=Math.max(e,c);var r=Math.min(q,p);var m=Math.max(q,p);e=o;c=g;q=r;p=m;var f;for(var j=0;j<d.length;j++){if(a.nodeShapes[this.getNodeShape(d[j])].intersectBox(e,q,c,p,this.getNodeWidth(d[j]),this.getNodeHeight(d[j]),d[j]._private.position.x,d[j]._private.position.y,d[j]._private.style["border-width"].value/2)){l.push(d[j])
}}for(var j=0;j<h.length;j++){if(h[j]._private.rscratch.edgeType=="self"){if((f=b.math.boxInBezierVicinity(e,q,c,p,h[j]._private.rscratch.startX,h[j]._private.rscratch.startY,h[j]._private.rscratch.cp2ax,h[j]._private.rscratch.cp2ay,h[j]._private.rscratch.endX,h[j]._private.rscratch.endY,h[j]._private.style.width.value))&&(f==2||(f==1&&b.math.checkBezierInBox(e,q,c,p,h[j]._private.rscratch.startX,h[j]._private.rscratch.startY,h[j]._private.rscratch.cp2ax,h[j]._private.rscratch.cp2ay,h[j]._private.rscratch.endX,h[j]._private.rscratch.endY,h[j]._private.style.width.value)))||(f=b.math.boxInBezierVicinity(e,q,c,p,h[j]._private.rscratch.startX,h[j]._private.rscratch.startY,h[j]._private.rscratch.cp2cx,h[j]._private.rscratch.cp2cy,h[j]._private.rscratch.endX,h[j]._private.rscratch.endY,h[j]._private.style.width.value))&&(f==2||(f==1&&b.math.checkBezierInBox(e,q,c,p,h[j]._private.rscratch.startX,h[j]._private.rscratch.startY,h[j]._private.rscratch.cp2cx,h[j]._private.rscratch.cp2cy,h[j]._private.rscratch.endX,h[j]._private.rscratch.endY,h[j]._private.style.width.value)))){l.push(h[j])
}}if(h[j]._private.rscratch.edgeType=="bezier"&&(f=b.math.boxInBezierVicinity(e,q,c,p,h[j]._private.rscratch.startX,h[j]._private.rscratch.startY,h[j]._private.rscratch.cp2x,h[j]._private.rscratch.cp2y,h[j]._private.rscratch.endX,h[j]._private.rscratch.endY,h[j]._private.style.width.value))&&(f==2||(f==1&&b.math.checkBezierInBox(e,q,c,p,h[j]._private.rscratch.startX,h[j]._private.rscratch.startY,h[j]._private.rscratch.cp2x,h[j]._private.rscratch.cp2y,h[j]._private.rscratch.endX,h[j]._private.rscratch.endY,h[j]._private.style.width.value)))){l.push(h[j])
}if(h[j]._private.rscratch.edgeType=="straight"&&(f=b.math.boxInBezierVicinity(e,q,c,p,h[j]._private.rscratch.startX,h[j]._private.rscratch.startY,h[j]._private.rscratch.startX*0.5+h[j]._private.rscratch.endX*0.5,h[j]._private.rscratch.startY*0.5+h[j]._private.rscratch.endY*0.5,h[j]._private.rscratch.endX,h[j]._private.rscratch.endY,h[j]._private.style.width.value))&&(f==2||(f==1&&b.math.checkStraightEdgeInBox(e,q,c,p,h[j]._private.rscratch.startX,h[j]._private.rscratch.startY,h[j]._private.rscratch.endX,h[j]._private.rscratch.endY,h[j]._private.style.width.value)))){l.push(h[j])
}}return l};a.prototype.calcCompoundBounds=function(j){var h=j.descendants().not(":removed");var c={x:j._private.position.x,y:j._private.position.y,width:j._private.autoWidth,height:j._private.autoHeight};if(j._private.style.visibility.value!="visible"||j._private.style.display.value!="element"){return c}var d=[];for(var l=0;l<h.size();l++){if(h[l]._private.style.visibility.value=="visible"&&h[l]._private.style.display.value=="element"){d.push(h[l])}}if(d.length==0){return c}h=d;var e=this.borderValue(h,"left");
var m=this.borderValue(h,"right");var k=this.borderValue(h,"top");var g=this.borderValue(h,"bottom");var q=this.getNodePadding(j);var p=(e-q.left+m+q.right)/2;var o=(k-q.top+g+q.bottom)/2;var f=(m-e)+q.left+q.right;var r=(g-k)+q.top+q.bottom;c={x:p,y:o,width:f,height:r};return c};a.prototype.borderValue=function(f,p){var k,e;var q=1/0,m=-1/0;var c=this;var o=function(t){var r={};r.x=t._private.position.x;r.y=t._private.position.y;r.width=t.outerWidth();r.height=t.outerHeight();return r};var h=function(t){var u=String(t._private.style.content.value);
var v=t._private.style["text-transform"].value;if(v=="none"){}else{if(v=="uppercase"){u=u.toUpperCase()}else{if(v=="lowercase"){u=u.toLowerCase()}}}var r=c.data.canvases[4].getContext("2d");return r.measureText(u).width};var s=function(w){var u={};var r=c.getNodeWidth(w);var z=c.getNodeHeight(w);u.height=w._private.style["font-size"].value;u.width=u.height;var v=w._private.style["text-halign"].strValue;if(v=="left"){u.x=w._private.position.x-r/2;u.left=u.x-u.width;u.right=u.x}else{if(v=="right"){u.x=w._private.position.x+r/2;
u.left=u.x;u.right=u.x+u.width}else{u.x=w._private.position.x;u.left=u.x-u.width/2;u.right=u.x+u.width/2}}var t=w._private.style["text-valign"].strValue;if(t=="top"){u.y=w._private.position.y-z/2;u.top=u.y-u.height;u.bottom=u.y}else{if(t=="bottom"){u.y=w._private.position.y+z/2;u.top=u.y;u.bottom=u.y+u.height}else{u.y=w._private.position.y;u.top=u.y-u.height/2;u.bottom=u.y+u.height/2}}return u};for(i=0;i<f.length;i++){k=o(f[i]);e=s(f[i]);if(p=="left"){var d=Math.min(k.x-k.width/2,e.left);if(d<q){q=d
}}else{if(p=="right"){var l=Math.max(k.x+k.width/2,e.right);if(l>m){m=l}}else{if(p=="top"){var j=Math.min(k.y-k.height/2,e.top);if(j<q){q=j}}else{if(p=="bottom"){var g=Math.max(k.y+k.height/2,e.bottom);if(g>m){m=g}}}}}}if((p=="left")||(p=="top")){return q}else{return m}};a.prototype.getNodeWidth=function(c){if(c._private.style.width.value=="auto"||c._private.style.height.value=="auto"){return c._private.autoWidth}else{return c._private.style.width.value}};a.prototype.getNodeHeight=function(c){if(c._private.style.width.value=="auto"||c._private.style.height.value=="auto"){return c._private.autoHeight
}else{return c._private.style.height.value}};a.prototype.getNodeShape=function(d){var c=d._private.style.shape.value;if(d.isParent()){if(c==="rectangle"||c==="roundrectangle"){return c}else{return"rectangle"}}return c};a.prototype.updateAllCompounds=function(f){for(var c=f.length-1;c>=0;c--){if(f[c].isNode()&&(f[c]._private.style.width.value=="auto"||f[c]._private.style.height.value=="auto")&&f[c].children().length>0){var e=f[c];var d=this.calcCompoundBounds(e);e._private.position.x=d.x;e._private.position.y=d.y;
e._private.autoWidth=d.width;e._private.autoHeight=d.height}}};a.prototype.getNodePadding=function(e){var g=e._private.style["padding-left"].value;var d=e._private.style["padding-right"].value;var f=e._private.style["padding-top"].value;var c=e._private.style["padding-bottom"].value;if(isNaN(g)){g=0}if(isNaN(d)){d=0}if(isNaN(f)){f=0}if(isNaN(c)){c=0}return{left:g,right:d,top:f,bottom:c}};a.prototype.zOrderSort=function(f,e){var d=function(j){if(j._private.group=="nodes"){return j.parents().size()
}else{if(j._private.group=="edges"){return Math.max(j.source()[0].parents().size(),j.target()[0].parents().size())}else{return 0}}};var c=f._private.style["z-index"].value-e._private.style["z-index"].value;var h=0;var g=0;if(f.cy().hasCompoundNodes()){h=d(f);g=d(e)}if(h-g===0){if(f._private.group==="nodes"&&e._private.group==="edges"){return 1}else{if(f._private.group==="edges"&&e._private.group==="nodes"){return -1}else{if(c===0){return f._private.index-e._private.index}else{return c}}}}else{return h-g
}return 0};a.prototype.getCachedZSortedEles=function(){var h=this.lastZOrderCachedNodes;var g=this.lastZOrderCachedEdges;var e=this.getCachedNodes();var d=this.getCachedEdges();var c=[];if(!h||!g||h!==e||g!==d){for(var f=0;f<e.length;f++){c.push(e[f])}for(var f=0;f<d.length;f++){c.push(d[f])}c.sort(this.zOrderSort);this.cachedZSortedEles=c}else{c=this.cachedZSortedEles}this.lastZOrderCachedNodes=e;this.lastZOrderCachedEdges=d;return c};a.prototype.findEdgeControlPoints=function(z){var c={};var C=this.data.cy;
var h=[];var t;for(var Q=0;Q<z.length;Q++){if(z[Q]._private.style.display.value==="none"){continue}t=z[Q]._private.data.source>z[Q]._private.data.target?z[Q]._private.data.target+"-"+z[Q]._private.data.source:z[Q]._private.data.source+"-"+z[Q]._private.data.target;if(c[t]==undefined){c[t]=[]}c[t].push(z[Q]);h.push(t)}var D,J;for(var L=0;L<h.length;L++){t=h[L];D=C.getElementById(c[t][0]._private.data.source);J=C.getElementById(c[t][0]._private.data.target);var B=(D._private.position.x+J._private.position.x)/2;
var A=(D._private.position.y+J._private.position.y)/2;var s,r;if(c[t].length>1){s=J._private.position.y-D._private.position.y;r=D._private.position.x-J._private.position.x;var q=Math.sqrt(s*s+r*r);s/=q;r/=q}var o;for(var Q=0;Q<c[t].length;Q++){o=c[t][Q];var k=o._private.rscratch.lastEdgeIndex;var j=Q;var e=o._private.rscratch.lastNumEdges;var d=c[t].length;var I=o._private.rscratch.lastSrcCtlPtX;var H=D._private.position.x;var w=o._private.rscratch.lastSrcCtlPtY;var v=D._private.position.y;var S=o._private.rscratch.lastSrcCtlPtW;
var R=D.outerWidth();var N=o._private.rscratch.lastSrcCtlPtH;var M=D.outerHeight();var P=o._private.rscratch.lastTgtCtlPtX;var O=J._private.position.x;var F=o._private.rscratch.lastTgtCtlPtY;var E=J._private.position.y;var m=o._private.rscratch.lastTgtCtlPtW;var l=J.outerWidth();var g=o._private.rscratch.lastTgtCtlPtH;var f=J.outerHeight();if(I===H&&w===v&&S===R&&N===M&&P===O&&F===E&&m===l&&g===f&&k===j&&e===d){continue}else{var G=o._private.rscratch;G.lastSrcCtlPtX=H;G.lastSrcCtlPtY=v;G.lastSrcCtlPtW=R;
G.lastSrcCtlPtH=M;G.lastTgtCtlPtX=O;G.lastTgtCtlPtY=E;G.lastTgtCtlPtW=l;G.lastTgtCtlPtH=f;G.lastEdgeIndex=j;G.lastNumEdges=d}if(D._private.data.id==J._private.data.id){var K=o._private.style["control-point-step-size"].pxValue;o._private.rscratch.edgeType="self";o._private.rscratch.cp2ax=D._private.position.x;o._private.rscratch.cp2ay=D._private.position.y-(1+Math.pow(this.getNodeHeight(D),1.12)/100)*K*(Q/3+1);o._private.rscratch.cp2cx=D._private.position.x-(1+Math.pow(this.getNodeWidth(D),1.12)/100)*K*(Q/3+1);
o._private.rscratch.cp2cy=D._private.position.y;o._private.rscratch.selfEdgeMidX=(o._private.rscratch.cp2ax+o._private.rscratch.cp2cx)/2;o._private.rscratch.selfEdgeMidY=(o._private.rscratch.cp2ay+o._private.rscratch.cp2cy)/2}else{if(c[t].length%2==1&&Q==Math.floor(c[t].length/2)){o._private.rscratch.edgeType="straight"}else{var K=o._private.style["control-point-step-size"].value;var u=(0.5-c[t].length/2+Q)*K;o._private.rscratch.edgeType="bezier";o._private.rscratch.cp2x=B+s*u;o._private.rscratch.cp2y=A+r*u
}}}}return c};a.prototype.findEndpoints=function(f){var h;var c=f.source()[0];var m=f.target()[0];var s=Math.max(this.getNodeWidth(c),this.getNodeHeight(c));var g=Math.max(this.getNodeWidth(m),this.getNodeHeight(m));s=0;g/=2;var e=[f.source().position().x,f.source().position().y];var j=[f.target().position().x,f.target().position().y];if(f._private.rscratch.edgeType=="self"){var p=[f._private.rscratch.cp2cx,f._private.rscratch.cp2cy];h=a.nodeShapes[this.getNodeShape(m)].intersectLine(m._private.position.x,m._private.position.y,this.getNodeWidth(m),this.getNodeHeight(m),p[0],p[1],m._private.style["border-width"].value/2);
var d=b.math.shortenIntersection(h,p,a.arrowShapes[f._private.style["target-arrow-shape"].value].spacing(f));var o=b.math.shortenIntersection(h,p,a.arrowShapes[f._private.style["target-arrow-shape"].value].gap(f));f._private.rscratch.endX=o[0];f._private.rscratch.endY=o[1];f._private.rscratch.arrowEndX=d[0];f._private.rscratch.arrowEndY=d[1];var p=[f._private.rscratch.cp2ax,f._private.rscratch.cp2ay];h=a.nodeShapes[this.getNodeShape(c)].intersectLine(c._private.position.x,c._private.position.y,this.getNodeWidth(c),this.getNodeHeight(c),p[0],p[1],c._private.style["border-width"].value/2);
var k=b.math.shortenIntersection(h,p,a.arrowShapes[f._private.style["source-arrow-shape"].value].spacing(f));var l=b.math.shortenIntersection(h,p,a.arrowShapes[f._private.style["source-arrow-shape"].value].gap(f));f._private.rscratch.startX=l[0];f._private.rscratch.startY=l[1];f._private.rscratch.arrowStartX=k[0];f._private.rscratch.arrowStartY=k[1]}else{if(f._private.rscratch.edgeType=="straight"){h=a.nodeShapes[this.getNodeShape(m)].intersectLine(m._private.position.x,m._private.position.y,this.getNodeWidth(m),this.getNodeHeight(m),c.position().x,c.position().y,m._private.style["border-width"].value/2);
if(h.length==0){f._private.rscratch.noArrowPlacement=true}else{f._private.rscratch.noArrowPlacement=false}var d=b.math.shortenIntersection(h,[c.position().x,c.position().y],a.arrowShapes[f._private.style["target-arrow-shape"].value].spacing(f));var o=b.math.shortenIntersection(h,[c.position().x,c.position().y],a.arrowShapes[f._private.style["target-arrow-shape"].value].gap(f));f._private.rscratch.endX=o[0];f._private.rscratch.endY=o[1];f._private.rscratch.arrowEndX=d[0];f._private.rscratch.arrowEndY=d[1];
h=a.nodeShapes[this.getNodeShape(c)].intersectLine(c._private.position.x,c._private.position.y,this.getNodeWidth(c),this.getNodeHeight(c),m.position().x,m.position().y,c._private.style["border-width"].value/2);if(h.length==0){f._private.rscratch.noArrowPlacement=true}else{f._private.rscratch.noArrowPlacement=false}var k=b.math.shortenIntersection(h,[m.position().x,m.position().y],a.arrowShapes[f._private.style["source-arrow-shape"].value].spacing(f));var l=b.math.shortenIntersection(h,[m.position().x,m.position().y],a.arrowShapes[f._private.style["source-arrow-shape"].value].gap(f));
f._private.rscratch.startX=l[0];f._private.rscratch.startY=l[1];f._private.rscratch.arrowStartX=k[0];f._private.rscratch.arrowStartY=k[1]}else{if(f._private.rscratch.edgeType=="bezier"){var p=[f._private.rscratch.cp2x,f._private.rscratch.cp2y];var r=e[0]*0.25+j[0]*0.25+p[0]*0.5;var q=e[1]*0.25+j[1]*0.25+p[1]*0.5;h=a.nodeShapes[this.getNodeShape(m)].intersectLine(m._private.position.x,m._private.position.y,this.getNodeWidth(m),this.getNodeHeight(m),p[0],p[1],m._private.style["border-width"].value/2);
var d=b.math.shortenIntersection(h,p,a.arrowShapes[f._private.style["target-arrow-shape"].value].spacing(f));var o=b.math.shortenIntersection(h,p,a.arrowShapes[f._private.style["target-arrow-shape"].value].gap(f));f._private.rscratch.endX=o[0];f._private.rscratch.endY=o[1];f._private.rscratch.arrowEndX=d[0];f._private.rscratch.arrowEndY=d[1];h=a.nodeShapes[this.getNodeShape(c)].intersectLine(c._private.position.x,c._private.position.y,this.getNodeWidth(c),this.getNodeHeight(c),p[0],p[1],c._private.style["border-width"].value/2);
var k=b.math.shortenIntersection(h,p,a.arrowShapes[f._private.style["source-arrow-shape"].value].spacing(f));var l=b.math.shortenIntersection(h,p,a.arrowShapes[f._private.style["source-arrow-shape"].value].gap(f));f._private.rscratch.startX=l[0];f._private.rscratch.startY=l[1];f._private.rscratch.arrowStartX=k[0];f._private.rscratch.arrowStartY=k[1]}else{if(f._private.rscratch.isArcEdge){return}}}}};a.prototype.findEdges=function(g){var d=this.getCachedEdges();var f={};var c=[];for(var e=0;e<g.length;
e++){f[g[e]._private.data.id]=g[e]}for(var e=0;e<d.length;e++){if(f[d[e]._private.data.source]||f[d[e]._private.data.target]){c.push(d[e])}}return c};a.prototype.getArrowWidth=function(c){return Math.max(Math.pow(c*13.37,0.9),29)};a.prototype.getArrowHeight=function(c){return Math.max(Math.pow(c*13.37,0.9),29)}})(cytoscape);(function(c){var b=c("renderer","canvas");b.prototype.drawEdge=function(h,k,l){if(!k.visible()){return}if(this.hideEdgesOnViewport&&(this.dragData.didDrag||this.pinching||this.hoverData.dragging||this.data.wheel||this.swipePanning)){return
}var m,r;m=k.source()[0];r=k.target()[0];if(k._private.style.visibility.value!="visible"||k._private.style.display.value!="element"||m._private.style.visibility.value!="visible"||m._private.style.display.value!="element"||r._private.style.visibility.value!="visible"||r._private.style.display.value!="element"){return}var v=k._private.style["overlay-padding"].value;var t=k._private.style["overlay-opacity"].value;var u=k._private.style["overlay-color"].value;if(l){h.strokeStyle="rgba( "+u[0]+", "+u[1]+", "+u[2]+", "+t+" )";
h.lineCap="round";if(k._private.rscratch.edgeType=="self"){h.lineCap="butt"}}else{h.strokeStyle="rgba("+k._private.style["line-color"].value[0]+","+k._private.style["line-color"].value[1]+","+k._private.style["line-color"].value[2]+","+k._private.style.opacity.value+")"}if(k._private.style.width.value<=0){return}var s=k._private.style.width.value+(l?2*v:0);var p=l?"solid":k._private.style["line-style"].value;h.lineWidth=s;this.findEndpoints(k);if(k._private.rscratch.edgeType=="self"){var f=k._private.rscratch;
this.drawStyledEdge(k,h,[f.startX,f.startY,f.cp2ax,f.cp2ay,f.selfEdgeMidX,f.selfEdgeMidY],p,s);this.drawStyledEdge(k,h,[f.selfEdgeMidX,f.selfEdgeMidY,f.cp2cx,f.cp2cy,f.endX,f.endY],p,s)}else{if(k._private.rscratch.edgeType=="straight"){var j=r._private.position.x-m._private.position.x;var g=r._private.position.y-m._private.position.y;var q=k._private.rscratch.endX-k._private.rscratch.startX;var o=k._private.rscratch.endY-k._private.rscratch.startY;if(j*q+g*o<0){k._private.rscratch.straightEdgeTooShort=true
}else{var f=k._private.rscratch;this.drawStyledEdge(k,h,[f.startX,f.startY,f.endX,f.endY],p,s);k._private.rscratch.straightEdgeTooShort=false}}else{var f=k._private.rscratch;this.drawStyledEdge(k,h,[f.startX,f.startY,f.cp2x,f.cp2y,f.endX,f.endY],p,s)}}if(k._private.rscratch.noArrowPlacement!==true&&k._private.rscratch.startX!==undefined){this.drawArrowheads(h,k,l)}};var e=function(p,k,h){var g=Math.sqrt(Math.pow(p[4]-p[0],2)+Math.pow(p[5]-p[1],2));g+=Math.sqrt(Math.pow((p[4]+p[0])/2-p[2],2)+Math.pow((p[5]+p[1])/2-p[3],2));
var o=Math.ceil(g/k);var f=g/k;var l;if(o>0){l=new Array(o*2)}else{return null}for(var j=0;j<o;j++){var m=j/o;l[j*2]=p[0]*(1-m)*(1-m)+2*(p[2])*(1-m)*m+p[4]*(m)*(m);l[j*2+1]=p[1]*(1-m)*(1-m)+2*(p[3])*(1-m)*m+p[5]*(m)*(m)}return l};var a=function(p,k,h){var g=Math.sqrt(Math.pow(p[2]-p[0],2)+Math.pow(p[3]-p[1],2));var o=Math.ceil(g/k);var l;if(o>0){l=new Array(o*2)}else{return null}var f=[p[2]-p[0],p[3]-p[1]];for(var j=0;j<o;j++){var m=j/o;l[j*2]=f[0]*m+p[0];l[j*2+1]=f[1]*m+p[1]}return l};var d=function(h,f,g){pt1=_genpts(h,f);
pt2=_genpts(h,g)};b.prototype.drawStyledEdge=function(o,j,E,k,v){var h=this.data.cy;var g=h.zoom();function D(H,G,F,p){return(1-p)*(1-p)*H+2*(1-p)*p*G+p*p*F}if(o._private.rstyle.bezierPts===undefined){o._private.rstyle.bezierPts=[]}var z=o._private.rstyle.bezierPts.length;if(o.isLoop()){if(z>=12){o._private.rstyle.bezierPts=[]}else{}}else{o._private.rstyle.bezierPts=[]}var s=o._private.rstyle.bezierPts;if(E.length===6){s.push({x:D(E[0],E[2],E[4],0.05),y:D(E[1],E[3],E[5],0.05)});s.push({x:D(E[0],E[2],E[4],0.25),y:D(E[1],E[3],E[5],0.25)});
s.push({x:D(E[0],E[2],E[4],0.35),y:D(E[1],E[3],E[5],0.35)});s.push({x:D(E[0],E[2],E[4],0.65),y:D(E[1],E[3],E[5],0.65)});s.push({x:D(E[0],E[2],E[4],0.75),y:D(E[1],E[3],E[5],0.75)});s.push({x:D(E[0],E[2],E[4],0.95),y:D(E[1],E[3],E[5],0.95)})}if(k=="solid"){j.beginPath();j.moveTo(E[0],E[1]);if(E.length==3*2){j.quadraticCurveTo(E[2],E[3],E[4],E[5])}else{j.lineTo(E[2],E[3])}j.stroke()}else{if(k=="dotted"){var u;if(E.length==3*2){u=e(E,16,true)}else{u=a(E,16,true)}if(!u){return}var m=Math.max(v*1.6,3.4)*g;
var l=m*2,r=m*2;l=Math.max(l,1);r=Math.max(r,1);var A=this.createBuffer(l,r);var w=A[1];w.setTransform(1,0,0,1,0,0);w.clearRect(0,0,l,r);w.fillStyle=j.strokeStyle;w.beginPath();w.arc(l/2,r/2,m*0.5,0,Math.PI*2,false);w.fill();j.beginPath();for(var B=0;B<u.length/2;B++){j.drawImage(A[0],u[B*2]-l/2/g,u[B*2+1]-r/2/g,l/g,r/g)}}else{if(k=="dashed"){var u;if(E.length==3*2){u=e(E,14,true)}else{u=a(E,14,true)}if(!u){return}var l=v*2*g;var r=7.8*g;l=Math.max(l,1);r=Math.max(r,1);var A=this.createBuffer(l,r);
var w=A[1];w.setTransform(1,0,0,1,0,0);w.clearRect(0,0,l,r);if(j.strokeStyle){w.strokeStyle=j.strokeStyle}w.lineWidth=v*h.zoom();w.beginPath();w.moveTo(l/2,r*0.2);w.lineTo(l/2,r*0.8);w.stroke();var f=false;var q,C;if(E.length==2*2){q=[E[2]-E[0],E[3]-u[1]];C=Math.acos((q[0]*0+q[1]*-1)/Math.sqrt(q[0]*q[0]+q[1]*q[1]));if(q[0]<0){C=-C+2*Math.PI}}else{if(E.length==3*2){f=true}}for(var B=0;B<u.length/2;B++){var t=B/(Math.max(u.length/2-1,1));if(f){q=[2*(1-t)*(E[2]-E[0])+2*t*(E[4]-E[2]),2*(1-t)*(E[3]-E[1])+2*t*(E[5]-E[3])];
C=Math.acos((q[0]*0+q[1]*-1)/Math.sqrt(q[0]*q[0]+q[1]*q[1]));if(q[0]<0){C=-C+2*Math.PI}}j.translate(u[B*2],u[B*2+1]);j.rotate(C);j.translate(-l/2/g,-r/2/g);j.drawImage(A[0],0,0,l/g,r/g);j.translate(l/2/g,r/2/g);j.rotate(-C);j.translate(-u[B*2],-u[B*2+1])}}else{this.drawStyledEdge(o,j,E,"solid",v)}}}};b.prototype.drawArrowheads=function(g,j,k){if(k){return}var h,f;var m=j._private.rscratch.arrowStartX;var l=j._private.rscratch.arrowStartY;h=m-j.source().position().x;f=l-j.source().position().y;g.fillStyle="rgba("+j._private.style["source-arrow-color"].value[0]+","+j._private.style["source-arrow-color"].value[1]+","+j._private.style["source-arrow-color"].value[2]+","+j._private.style.opacity.value+")";
g.lineWidth=j._private.style.width.value;this.drawArrowShape(g,j._private.style["source-arrow-shape"].value,m,l,h,f);var p=j._private.rscratch.arrowEndX;var o=j._private.rscratch.arrowEndY;h=p-j.target().position().x;f=o-j.target().position().y;g.fillStyle="rgba("+j._private.style["target-arrow-color"].value[0]+","+j._private.style["target-arrow-color"].value[1]+","+j._private.style["target-arrow-color"].value[2]+","+j._private.style.opacity.value+")";g.lineWidth=j._private.style.width.value;this.drawArrowShape(g,j._private.style["target-arrow-shape"].value,p,o,h,f)
};b.prototype.drawArrowShape=function(l,g,f,o,k,h){var m=Math.asin(h/(Math.sqrt(k*k+h*h)));if(k<0){m=m+Math.PI/2}else{m=-(Math.PI/2+m)}l.translate(f,o);l.moveTo(0,0);l.rotate(-m);var j=this.getArrowWidth(l.lineWidth);l.scale(j,j);l.beginPath();b.arrowShapes[g].draw(l);l.closePath();l.fill();l.scale(1/j,1/j);l.rotate(m);l.translate(-f,-o)}})(cytoscape);(function(b){var a=b("renderer","canvas");var d={};var c=30*300;a.prototype.getCachedImage=function(f,g){if(d[f]&&d[f].image){d[f].keepTime=c;return d[f].image
}var e=d[f];if(e==undefined){d[f]=new Object();d[f].image=new Image();d[f].image.onload=g;d[f].image.src=f;d[f].keepTime=c;e=d[f]}return e.image};a.prototype.swapCachedImage=function(f){if(d[f]){if(d[f].image&&d[f].image.complete){var g=d[f].image;var e=document.createElement("canvas");e.width=g.width;e.height=g.height;e.getContext("2d").drawImage(g,0,0);d[f].image=e;d[f].swappedWithCanvas=true;return e}else{return null}}else{return null}};a.prototype.updateImageCaches=function(){for(var e in d){if(d[e].keepTime<=0){if(d[e].image!=undefined){d[e].image.src=undefined;
d[e].image=undefined}d[e]=undefined}else{d[e]-=1}}};a.prototype.drawImage=function(e,m,l,j,h,o,g){g.widthScale=0.5;g.heightScale=0.5;g.rotate=o;var k;var f;canvas.drawImage(g,m,l)};a.prototype.drawInscribedImage=function(g,m,k){var e=this;var p=this.data.cy._private.zoom;var j=k._private.position.x;var h=k._private.position.y;var o=this.getNodeWidth(k);var f=this.getNodeHeight(k);g.save();a.nodeShapes[e.getNodeShape(k)].drawPath(g,j,h,o,f);g.clip();var l=[m.width,m.height];g.drawImage(m,j-l[0]/2,h-l[1]/2,l[0],l[1]);
g.restore();if(k._private.style["border-width"].value>0){g.stroke()}}})(cytoscape);(function(b){var a=b("renderer","canvas");a.prototype.drawEdgeText=function(e,f){if(!f.visible()){return}if(this.hideEdgesOnViewport&&(this.dragData.didDrag||this.pinching||this.hoverData.dragging||this.data.wheel||this.swipePanning)){return}var h=f._private.style["font-size"].pxValue*f.cy().zoom();var d=f._private.style["min-zoomed-font-size"].pxValue;if(h<d){return}e.textAlign="center";e.textBaseline="middle";var j,g;
var l,k;if(f._private.rscratch.edgeType=="self"){l=f._private.rscratch.selfEdgeMidX;k=f._private.rscratch.selfEdgeMidY}else{if(f._private.rscratch.edgeType=="straight"){l=(f._private.rscratch.startX+f._private.rscratch.endX)/2;k=(f._private.rscratch.startY+f._private.rscratch.endY)/2}else{if(f._private.rscratch.edgeType=="bezier"){l=0.25*f._private.rscratch.startX+2*0.5*0.5*f._private.rscratch.cp2x+(0.5*0.5)*f._private.rscratch.endX;k=Math.pow(1-0.5,2)*f._private.rscratch.startY+2*(1-0.5)*0.5*f._private.rscratch.cp2y+(0.5*0.5)*f._private.rscratch.endY
}}}j=l;g=k;var c=f._private.rstyle;c.labelX=j;c.labelY=g;this.drawText(e,f,j,g)};a.prototype.drawNodeText=function(e,f){if(!f.visible()){return}var j=f._private.style["font-size"].pxValue*f.cy().zoom();var c=f._private.style["min-zoomed-font-size"].pxValue;if(j<c){return}var k,h;var m=this.getNodeWidth(f);var d=this.getNodeHeight(f);var g=f._private.style["text-halign"].strValue;if(g=="left"){e.textAlign="right";k=f._private.position.x-m/2}else{if(g=="right"){e.textAlign="left";k=f._private.position.x+m/2
}else{if(g=="center"){e.textAlign="center";k=f._private.position.x}else{e.textAlign="center";k=f._private.position.x}}}var l=f._private.style["text-valign"].strValue;if(l=="top"){e.textBaseline="bottom";h=f._private.position.y-d/2}else{if(l=="bottom"){e.textBaseline="top";h=f._private.position.y+d/2}else{if(l=="middle"||l=="center"){e.textBaseline="middle";h=f._private.position.y}else{e.textBaseline="middle";h=f._private.position.y}}}this.drawText(e,f,k,h)};a.prototype.drawText=function(c,g,k,j){var u=1;
var q=g.parents();for(var h=0;h<q.length;h++){var r=q[h];var o=r._private.style.opacity.value;u=o*u;if(o===0){return}}var p=g._private.style["font-style"].strValue;var f=g._private.style["font-size"].value+"px";var t=g._private.style["font-family"].strValue;var m=g._private.style["font-variant"].strValue;var d=g._private.style["font-weight"].strValue;c.font=p+" "+d+" "+f+" "+t;var s=String(g._private.style.content.value);var e=g._private.style["text-transform"].value;if(e=="none"){}else{if(e=="uppercase"){s=s.toUpperCase()
}else{if(e=="lowercase"){s=s.toLowerCase()}}}c.lineJoin="round";c.fillStyle="rgba("+g._private.style.color.value[0]+","+g._private.style.color.value[1]+","+g._private.style.color.value[2]+","+(g._private.style["text-opacity"].value*g._private.style.opacity.value*u)+")";c.strokeStyle="rgba("+g._private.style["text-outline-color"].value[0]+","+g._private.style["text-outline-color"].value[1]+","+g._private.style["text-outline-color"].value[2]+","+(g._private.style["text-opacity"].value*g._private.style.opacity.value*u)+")";
if(s!=undefined){var l=2*g._private.style["text-outline-width"].value;if(l>0){c.lineWidth=l;c.strokeText(s,k,j)}if(isNaN(k)){k=0}if(isNaN(j)){j=0}c.fillText(""+s,k,j);g._private.rstyle.labelWidth=c.measureText(s).width}}})(cytoscape);(function(b){var a=b("renderer","canvas");a.prototype.drawNode=function(f,h,g){var s,e;if(!h.visible()){return}var u=1;var p=h.parents();for(var k=0;k<p.length;k++){var q=p[k];var l=q._private.style.opacity.value;u=l*u;if(l===0){return}}s=this.getNodeWidth(h);e=this.getNodeHeight(h);
f.lineWidth=h._private.style["border-width"].pxValue;if(g===undefined||!g){f.fillStyle="rgba("+h._private.style["background-color"].value[0]+","+h._private.style["background-color"].value[1]+","+h._private.style["background-color"].value[2]+","+(h._private.style["background-opacity"].value*h._private.style.opacity.value*u)+")";f.strokeStyle="rgba("+h._private.style["border-color"].value[0]+","+h._private.style["border-color"].value[1]+","+h._private.style["border-color"].value[2]+","+(h._private.style["border-opacity"].value*h._private.style.opacity.value*u)+")";
var d=h._private.style["background-image"].value[2]||h._private.style["background-image"].value[1];if(d!=undefined){var c=this;var j=this.getCachedImage(d,function(){c.data.canvasNeedsRedraw[a.NODE]=true;c.data.canvasRedrawReason[a.NODE].push("image finished load");c.data.canvasNeedsRedraw[a.DRAG]=true;c.data.canvasRedrawReason[a.DRAG].push("image finished load");c.swapCachedImage(d);c.redraw()});if(j.complete==false){a.nodeShapes[c.getNodeShape(h)].drawPath(f,h._private.position.x,h._private.position.y,s,e);
f.stroke();f.fillStyle="#555555";f.fill()}else{this.drawInscribedImage(f,j,h)}}else{a.nodeShapes[this.getNodeShape(h)].draw(f,h._private.position.x,h._private.position.y,s,e)}this.drawPie(f,h);if(h._private.style["border-width"].value>0){a.nodeShapes[this.getNodeShape(h)].drawPath(f,h._private.position.x,h._private.position.y,s,e);f.stroke()}}else{var t=h._private.style["overlay-padding"].value;var m=h._private.style["overlay-opacity"].value;var o=h._private.style["overlay-color"].value;if(m>0){f.fillStyle="rgba( "+o[0]+", "+o[1]+", "+o[2]+", "+m+" )";
a.nodeShapes[this.getNodeShape(h)].draw(f,h._private.position.x,h._private.position.y,s+t*2,e+t*2)}}};a.prototype.hasPie=function(e){e=e[0];for(var d=1;d<=b.style.pieBackgroundN;d++){var c=e._private.style["pie-"+d+"-background-size"].value;if(c>0){return true}}return false};a.prototype.drawPie=function(d,f){f=f[0];if(!this.hasPie(f)){return}var g=f._private.style.width.value;var t=f._private.style.height.value;var s=f._private.position.x;var p=f._private.position.y;var m=Math.min(g,t)/2;var r=0;
d.save();a.nodeShapes[this.getNodeShape(f)].drawPath(d,s,p,g,t);d.clip();for(var j=1;j<=b.style.pieBackgroundN;j++){var u=f._private.style["pie-"+j+"-background-size"].value;var h=f._private.style["pie-"+j+"-background-color"];var o=u/100;var l=1.5*Math.PI+2*Math.PI*r;var e=2*Math.PI*o;var k=l+e;var c=s+m*Math.cos(l);var q=p+m*Math.sin(l);if(u===0||r>=1||r+o>1){continue}d.beginPath();d.moveTo(s,p);d.arc(s,p,m,l,k);d.closePath();d.fillStyle="rgb("+h.value[0]+","+h.value[1]+","+h.value[2]+")";d.fill();
r+=o}d.restore()}})(cytoscape);(function(b){var a=b("renderer","canvas");a.prototype.getPixelRatio=function(){var c=this.data.canvases[0];var d=c.getContext("2d");var f=d.backingStorePixelRatio||d.webkitBackingStorePixelRatio||d.mozBackingStorePixelRatio||d.msBackingStorePixelRatio||d.oBackingStorePixelRatio||d.backingStorePixelRatio||1;var e=typeof InstallTrigger!=="undefined";if(e){return 1}return(window.devicePixelRatio||1)/f};a.prototype.matchCanvasSize=function(c){var j=this.data;var e=c.clientWidth;
var l=c.clientHeight;var f,g=e,k=l;var d=this.getPixelRatio();g*=d;k*=d;for(var h=0;h<a.CANVAS_LAYERS;h++){f=j.canvases[h];if(f.width!==g||f.height!==k){f.width=g;f.height=k;f.style.width=e+"px";f.style.height=l+"px"}}for(var h=0;h<a.BUFFER_COUNT;h++){f=j.bufferCanvases[h];if(f.width!==g||f.height!==k){f.width=g;f.height=k}}this.data.overlay.style.width=e+"px";this.data.overlay.style.height=l+"px"};a.prototype.redraw=function(A){A=A||{};var v=A.forcedContext;var o=A.drawAllLayers;var j=A.forcedZoom;
var O=A.forcedPan;var K=this;var Q=this.getPixelRatio();if(this.averageRedrawTime===undefined){this.averageRedrawTime=0}var C=1000/60;var s=1000;var k=this.averageRedrawTime;k=Math.max(C,k);k=Math.min(k,s);if(this.lastDrawTime===undefined){this.lastDrawTime=0}var G=+new Date;var N=G-this.lastDrawTime;var S=N>=k;if(!v){if(!S){clearTimeout(this.redrawTimeout);this.redrawTimeout=setTimeout(function(){K.redraw()},k);return}this.lastDrawTime=G}var f=G;var e=100;var z=K.data.cy;var W=K.data;var H=K.getCachedNodes();
var t=K.getCachedEdges();K.matchCanvasSize(W.container);var P=z.zoom();var J=j!==undefined?j:P;var m=z.pan();var B={x:m.x,y:m.y};if(O){B=O}J*=Q;B.x*=Q;B.y*=Q;var g=[];for(var U=0;U<H.length;U++){g.push(H[U])}for(var U=0;U<t.length;U++){g.push(t[U])}if(W.canvasNeedsRedraw[a.DRAG]||W.canvasNeedsRedraw[a.NODE]||o){if(K.hideEdgesOnViewport&&(K.pinching||K.hoverData.dragging||K.data.wheel||K.swipePanning)){}else{K.findEdgeControlPoints(t)}var g=K.getCachedZSortedEles();if(z.hasCompoundNodes()){K.updateAllCompounds(g)
}}var l;var L;var q;if(W.canvasNeedsRedraw[a.NODE]||o){if(!l||!L){l=[];L=[];for(var F=0;F<g.length;F++){q=g[F];if(q._private.rscratch.inDragLayer){l.push(q)}else{L.push(q)}}}var X=v||W.canvases[a.NODE].getContext("2d");X.setTransform(1,0,0,1,0,0);!v&&X.clearRect(0,0,X.canvas.width,X.canvas.height);if(!o){X.translate(B.x,B.y);X.scale(J,J)}if(O){X.translate(O.x,O.y)}if(j){X.scale(j,j)}for(var F=0;F<L.length;F++){q=L[F];if(q._private.group=="nodes"){K.drawNode(X,q)}else{if(q._private.group=="edges"){K.drawEdge(X,q)
}}}for(var F=0;F<L.length;F++){q=L[F];if(q._private.group=="nodes"){K.drawNodeText(X,q)}else{if(q._private.group=="edges"){K.drawEdgeText(X,q)}}if(q._private.group=="nodes"){K.drawNode(X,q,true)}else{if(q._private.group=="edges"){K.drawEdge(X,q,true)}}}if(!o){W.canvasNeedsRedraw[a.NODE]=false;W.canvasRedrawReason[a.NODE]=[]}}if(W.canvasNeedsRedraw[a.DRAG]||o){if(!l||!L){l=[];L=[];for(var F=0;F<g.length;F++){q=g[F];if(q._private.rscratch.inDragLayer){l.push(q)}else{L.push(q)}}}var X=v||W.canvases[a.DRAG].getContext("2d");
if(!o){X.setTransform(1,0,0,1,0,0);!v&&X.clearRect(0,0,X.canvas.width,X.canvas.height);X.translate(B.x,B.y);X.scale(J,J)}if(O){X.translate(O.x,O.y)}if(j){X.scale(j,j)}var q;for(var F=0;F<l.length;F++){q=l[F];if(q._private.group=="nodes"){K.drawNode(X,q)}else{if(q._private.group=="edges"){K.drawEdge(X,q)}}}for(var F=0;F<l.length;F++){q=l[F];if(q._private.group=="nodes"){K.drawNodeText(X,q)}else{if(q._private.group=="edges"){K.drawEdgeText(X,q)}}if(q._private.group=="nodes"){K.drawNode(X,q,true)}else{if(q._private.group=="edges"){K.drawEdge(X,q,true)
}}}if(!o){W.canvasNeedsRedraw[a.DRAG]=false;W.canvasRedrawReason[a.DRAG]=[]}}if(W.canvasNeedsRedraw[a.SELECT_BOX]){var X=v||W.canvases[a.SELECT_BOX].getContext("2d");if(!o){X.setTransform(1,0,0,1,0,0);!v&&X.clearRect(0,0,X.canvas.width,X.canvas.height);X.translate(B.x,B.y);X.scale(J,J)}if(O){X.translate(O.x,O.y)}if(j){X.scale(j,j)}var R=z.style()._private.coreStyle;if(W.select[4]==1){var P=W.cy.zoom();var d=R["selection-box-border-width"].value/P;X.lineWidth=d;X.fillStyle="rgba("+R["selection-box-color"].value[0]+","+R["selection-box-color"].value[1]+","+R["selection-box-color"].value[2]+","+R["selection-box-opacity"].value+")";
X.fillRect(W.select[0],W.select[1],W.select[2]-W.select[0],W.select[3]-W.select[1]);if(d>0){X.strokeStyle="rgba("+R["selection-box-border-color"].value[0]+","+R["selection-box-border-color"].value[1]+","+R["selection-box-border-color"].value[2]+","+R["selection-box-opacity"].value+")";X.strokeRect(W.select[0],W.select[1],W.select[2]-W.select[0],W.select[3]-W.select[1])}}if(W.bgActivePosistion){var P=W.cy.zoom();var E=W.bgActivePosistion;X.fillStyle="rgba("+R["active-bg-color"].value[0]+","+R["active-bg-color"].value[1]+","+R["active-bg-color"].value[2]+","+R["active-bg-opacity"].value+")";
X.beginPath();X.arc(E.x,E.y,R["active-bg-size"].pxValue/P,0,2*Math.PI);X.fill()}if(!o){W.canvasNeedsRedraw[a.SELECT_BOX]=false;W.canvasRedrawReason[a.SELECT_BOX]=[]}}if(K.options.showOverlay&&!v){var X=W.canvases[a.OVERLAY].getContext("2d");X.lineJoin="round";X.font="14px helvetica";X.strokeStyle="#fff";X.lineWidth="4";X.fillStyle="#666";X.textAlign="right";var D="@@cytoscape.js";var I=X.canvas.width;var V=X.canvas.height;var M=4;var T=X.measureText(D).width;var c=14;X.clearRect(0,0,I,V);X.strokeText(D,I-M,V-M);
X.fillText(D,I-M,V-M);W.overlayDrawn=true}var u=+new Date;if(K.averageRedrawTime===undefined){K.averageRedrawTime=u-f}K.averageRedrawTime=K.averageRedrawTime/2+(u-f)/2;if(!v&&!K.initrender){K.initrender=true;z.trigger("initrender")}}})(cytoscape);(function(b){var a=b("renderer","canvas");a.prototype.drawPolygonPath=function(f,d,j,h,c,g){f.translate(d,j);f.scale(h/2,c/2);f.beginPath();f.moveTo(g[0],g[1]);for(var e=1;e<g.length/2;e++){f.lineTo(g[e*2],g[e*2+1])}f.closePath();f.scale(2/h,2/c);f.translate(-d,-j)
};a.prototype.drawPolygon=function(e,d,h,g,c,f){this.drawPolygonPath(e,d,h,g,c,f);e.fill()};a.prototype.drawRoundRectanglePath=function(d,k,j,c,l,g){var e=c/2;var h=l/2;var f=b.math.getRoundRectangleRadius(c,l);d.translate(k,j);d.beginPath();d.moveTo(0,-h);d.arcTo(e,-h,e,0,f);d.arcTo(e,h,0,h,f);d.arcTo(-e,h,-e,0,f);d.arcTo(-e,-h,0,-h,f);d.lineTo(0,-h);d.closePath();d.translate(-k,-j)};a.prototype.drawRoundRectangle=function(f,e,h,g,d,c){this.drawRoundRectanglePath(f,e,h,g,d,c);f.fill()}})(cytoscape);
(function(b){var a=b("renderer","canvas");a.prototype.createBuffer=function(d,e){var c=document.createElement("canvas");c.width=d;c.height=e;return[c,c.getContext("2d")]};a.prototype.png=function(d){var g=this.data;var k=g.cy;var j=k.boundingBox();var f=d.full?Math.ceil(j.w):this.data.container.clientWidth;var c=d.full?Math.ceil(j.h):this.data.container.clientHeight;var h=document.createElement("canvas");h.width=f;h.height=c;h.style.width=f+"px";h.style.height=c+"px";var e=h.getContext("2d");if(f>0&&c>0){e.clearRect(0,0,f,c);
if(d.bg){e.fillStyle=d.bg;e.rect(0,0,f,c);e.fill()}e.globalCompositeOperation="source-over";if(d.full){this.redraw({forcedContext:e,drawAllLayers:true,forcedZoom:1,forcedPan:{x:-j.x1,y:-j.y1}})}else{this.redraw({forcedContext:e,drawAllLayers:true})}}return h.toDataURL("image/png")};a.prototype.renderTo=function(c,d,e){this.redraw({forcedContext:c,forcedZoom:d,forcedPan:e,drawAllLayers:true})}})(cytoscape);(function(b){var a=b("renderer","canvas");a.prototype.registerBinding=function(f,e,d,c){this.bindings.push({target:f,event:e,handler:d,useCapture:c});
f.addEventListener(e,d,c)};a.prototype.load=function(){var p=this;var m=function(D,r,E){if(!r){var B=D.parents();for(var C=0;C<B.size();C++){if(B[C]._private.selected){return}}}var F=D.descendants();function A(H){while(H.parent().nonempty()&&H.parent().id()!==D.id()){parent=H.parent()[0];var G=parent._private.style;if(G.width.value!=="auto"||G.height.value!=="auto"){return true}H=H.parent()}return false}for(var C=0;C<F.size();C++){if((r||!F[C]._private.selected)){F[C]._private.rscratch.inDragLayer=true;
E.push(F[C]);for(var z=0;z<F[C]._private.edges.length;z++){F[C]._private.edges[z]._private.rscratch.inDragLayer=true}}}};var q=function(z,A){z._private.grabbed=true;z._private.rscratch.inDragLayer=true;A.push(z);for(var r=0;r<z._private.edges.length;r++){z._private.edges[r]._private.rscratch.inDragLayer=true}};var v=function(D,B){var C=D;while(C.parent().nonempty()){C=C.parent()[0]}if(C==D&&B){return}var r=C.descendants().add(C);for(var A=0;A<r.size();A++){r[A]._private.rscratch.inDragLayer=B;for(var z=0;
z<r[A]._private.edges.length;z++){r[A]._private.edges[z]._private.rscratch.inDragLayer=B}}};a.prototype.nodeIsDraggable=function(r){if(r._private.style.opacity.value!=0&&r._private.style.visibility.value=="visible"&&r._private.style.display.value=="element"&&!r._private.locked&&r._private.grabbable){return true}return false};p.registerBinding(window,"resize",function(r){p.data.canvasNeedsRedraw[a.NODE]=true;p.data.canvasNeedsRedraw[a.OVERLAY]=true;p.matchCanvasSize(p.data.container);p.redraw()},true);
p.registerBinding(p.data.container,"contextmenu",function(r){r.preventDefault()});p.registerBinding(p.data.container,"mousedown",function(B){B.preventDefault();p.hoverData.capture=true;p.hoverData.which=B.which;var r=p.data.cy;var E=p.projectIntoViewport(B.pageX,B.pageY);var F=p.data.select;var A=p.findNearestElement(E[0],E[1],true);var H=p.hoverData.down;var C=p.dragData.possibleDragElements;var D=new b.Event(B,{type:"grab"});if(B.which==3){if(A){A.activate();A.trigger(new b.Event(B,{type:"cxttapstart"}));
p.hoverData.down=A;p.hoverData.downTime=(new Date()).getTime();p.hoverData.cxtDragged=false}}else{if(B.which==1){if(A){A.activate()}if(A!=null&&p.nodeIsDraggable(A)){if(A._private.group=="nodes"&&A._private.selected==false){C=p.dragData.possibleDragElements=[];q(A,C);A.trigger(D);if(A._private.style.width.value=="auto"||A._private.style.height.value=="auto"){m(A,true,C)}v(A,true)}if(A._private.group=="nodes"&&A._private.selected==true){C=p.dragData.possibleDragElements=[];var I=false;var G=r.$("node:selected");
for(var z=0;z<G.length;z++){if(p.nodeIsDraggable(G[z])){q(G[z],C);if(!I){A.trigger(D);I=true}if(G[z]._private.style.width.value=="auto"||G[z]._private.style.height.value=="auto"){m(G[z],false,C)}v(G[z],true)}}}A.trigger(new b.Event(B,{type:"mousedown"})).trigger(new b.Event(B,{type:"tapstart"})).trigger(new b.Event(B,{type:"vmousedown"}))}else{if(A==null){r.trigger(new b.Event(B,{type:"mousedown"})).trigger(new b.Event(B,{type:"tapstart"})).trigger(new b.Event(B,{type:"vmousedown"}))}}p.hoverData.down=A;
p.hoverData.downTime=(new Date()).getTime();if(A==null||A.isEdge()){F[4]=1;var J=Math.max(0,a.panOrBoxSelectDelay-(+new Date-p.hoverData.downTime));clearTimeout(p.bgActiveTimeout);p.bgActiveTimeout=setTimeout(function(){if(A){A.unactivate()}p.data.bgActivePosistion={x:E[0],y:E[1]};p.data.canvasNeedsRedraw[a.SELECT_BOX]=true;p.data.canvasRedrawReason[a.SELECT_BOX].push("bgactive");p.redraw()},J)}}}F[0]=F[2]=E[0];F[1]=F[3]=E[1];p.redraw()},false);p.registerBinding(window,"mousemove",function(P){var F=false;
var L=p.hoverData.capture;if(!L){var G=p.findContainerPageCoords();if(P.pageX>G[0]&&P.pageX<G[0]+p.data.container.clientWidth&&P.pageY>G[1]&&P.pageY<G[1]+p.data.container.clientHeight){}else{return}}var A=p.data.cy;var E=p.projectIntoViewport(P.pageX,P.pageY);var J=p.data.select;var Q=p.findNearestElement(E[0],E[1],true);var H=p.hoverData.last;var I=p.hoverData.down;var M=[E[0]-J[2],E[1]-J[3]];var K=p.getCachedNodes();var z=p.getCachedEdges();var C=p.dragData.possibleDragElements;var B=P.shiftKey;
F=true;var N=new b.Event(P,{type:"mousemove"});if(Q!=null){Q.trigger(N)}else{if(Q==null){A.trigger(N)}}if(p.hoverData.which===3){var D=new b.Event(P,{type:"cxtdrag"});if(I){I.trigger(D)}else{A.trigger(D)}p.hoverData.cxtDragged=true}else{if(p.hoverData.dragging){F=true;if(A.panningEnabled()){var r={x:M[0]*A.zoom(),y:M[1]*A.zoom()};A.panBy(r)}E=p.projectIntoViewport(P.pageX,P.pageY)}else{if(J[4]==1&&(I==null||I.isEdge())&&(!A.boxSelectionEnabled()||+new Date-p.hoverData.downTime>=a.panOrBoxSelectDelay)&&(Math.abs(J[3]-J[1])+Math.abs(J[2]-J[0])<4)&&A.panningEnabled()){p.hoverData.dragging=true;
J[4]=0}else{if(A.boxSelectionEnabled()&&Math.pow(J[2]-J[0],2)+Math.pow(J[3]-J[1],2)>7&&J[4]){clearTimeout(p.bgActiveTimeout)}if(I&&I.isEdge()&&I.active()){I.unactivate()}if(Q!=H){if(H){H.trigger(new b.Event(P,{type:"mouseout"}))}if(Q){Q.trigger(new b.Event(P,{type:"mouseover"}))}p.hoverData.last=Q}if(I&&I.isNode()&&p.nodeIsDraggable(I)){p.dragData.didDrag=true;var R=[];for(var O=0;O<C.length;O++){if(C[O]._private.group=="nodes"&&p.nodeIsDraggable(C[O])){C[O]._private.position.x+=M[0];C[O]._private.position.y+=M[1];
R.push(C[O])}}(new b.Collection(A,R)).trigger(new b.Event(P,{type:"drag"})).trigger(new b.Event(P,{type:"position"}));if(J[2]==J[0]&&J[3]==J[1]){p.data.canvasNeedsRedraw[a.NODE]=true;p.data.canvasRedrawReason[a.NODE].push("Node(s) and edge(s) moved to drag layer")}p.data.canvasNeedsRedraw[a.DRAG]=true;p.data.canvasRedrawReason[a.DRAG].push("Nodes dragged")}if(A.boxSelectionEnabled()){p.data.canvasNeedsRedraw[a.SELECT_BOX]=true;p.data.canvasRedrawReason[a.SELECT_BOX].push("Mouse moved, redraw selection box")
}F=true}}}J[2]=E[0];J[3]=E[1];p.redraw();if(F){if(P.stopPropagation){P.stopPropagation()}if(P.preventDefault){P.preventDefault()}P.cancelBubble=true;P.returnValue=false;return false}},false);p.registerBinding(window,"mouseup",function(T){var N=p.hoverData.capture;if(!N){return}p.hoverData.capture=false;var z=p.data.cy;var F=p.projectIntoViewport(T.pageX,T.pageY);var L=p.data.select;var U=p.findNearestElement(F[0],F[1],true);var M=p.getCachedNodes();var r=p.getCachedEdges();var C=p.dragData.possibleDragElements;
var H=p.hoverData.down;var B=T.shiftKey;p.data.bgActivePosistion=undefined;clearTimeout(p.bgActiveTimeout);if(H){H.unactivate()}if(p.hoverData.which===3){var D=new b.Event(T,{type:"cxttapend"});if(H){H.trigger(D)}else{z.trigger(D)}if(!p.hoverData.cxtDragged){var K=new b.Event(T,{type:"cxttap"});if(H){H.trigger(K)}else{z.trigger(K)}}p.hoverData.cxtDragged=false;p.hoverData.which=null}else{if((H==null)&&!p.dragData.didDrag&&!(Math.pow(L[2]-L[0],2)+Math.pow(L[3]-L[1],2)>7&&L[4])&&!p.hoverData.dragging){z.$(":selected").unselect();
if(C.length>0){p.data.canvasNeedsRedraw[a.NODE]=true;p.data.canvasRedrawReason[a.NODE].push("De-select")}p.dragData.possibleDragElements=C=[]}if(Math.pow(L[2]-L[0],2)+Math.pow(L[3]-L[1],2)==0){if(U!=null){U.trigger(new b.Event(T,{type:"click"})).trigger(new b.Event(T,{type:"tap"})).trigger(new b.Event(T,{type:"vclick"}))}else{if(U==null){z.trigger(new b.Event(T,{type:"click"})).trigger(new b.Event(T,{type:"tap"})).trigger(new b.Event(T,{type:"vclick"}))}}}if(U!=null){U.trigger(new b.Event(T,{type:"mouseup"})).trigger(new b.Event(T,{type:"tapend"})).trigger(new b.Event(T,{type:"vmouseup"}))
}else{if(U==null){z.trigger(new b.Event(T,{type:"mouseup"})).trigger(new b.Event(T,{type:"tapend"})).trigger(new b.Event(T,{type:"vmouseup"}))}}if(U==H&&!p.dragData.didDrag){if(U!=null&&U._private.selectable){if(z.selectionType()==="additive"){if(U.selected()){U.unselect()}else{U.select()}}else{if(!B){z.$(":selected").unselect()}U.select()}v(U,false);p.data.canvasNeedsRedraw[a.NODE]=true;p.data.canvasRedrawReason[a.NODE].push("sglslct")}}else{if(U==H){if(U!=null&&U._private.grabbed){var O=z.$(":grabbed");
for(var R=0;R<O.length;R++){var I=O[R];I._private.grabbed=false;var J=I._private.edges;for(var Q=0;Q<J.length;Q++){J[Q]._private.rscratch.inDragLayer=false}v(I,false)}var S=new b.Event(T,{type:"free"});O.trigger(S)}}}if(z.boxSelectionEnabled()&&Math.pow(L[2]-L[0],2)+Math.pow(L[3]-L[1],2)>7&&L[4]){var A=[];var G=p.getAllInBox(L[0],L[1],L[2],L[3]);var P=new b.Event(T,{type:"select"});for(var R=0;R<G.length;R++){if(G[R]._private.selectable){C.push(G[R]);A.push(G[R])}}var E=new b.Collection(z,A);if(z.selectionType()==="additive"){E.select()
}else{if(!B){z.$(":selected").unselect()}E.select()}if(G.length>0){p.data.canvasNeedsRedraw[a.NODE]=true;p.data.canvasRedrawReason[a.NODE].push("Selection")}}p.hoverData.dragging=false;if(!L[4]){var S=new b.Event(T,{type:"free"});for(var R=0;R<C.length;R++){if(C[R]._private.group=="nodes"){C[R]._private.rscratch.inDragLayer=false;var J=C[R]._private.edges;for(var Q=0;Q<J.length;Q++){J[Q]._private.rscratch.inDragLayer=false}v(C[R],false)}else{if(C[R]._private.group=="edges"){C[R]._private.rscratch.inDragLayer=false
}}}if(H){H.trigger(S)}p.data.canvasNeedsRedraw[a.DRAG]=true;p.data.canvasRedrawReason[a.DRAG].push("Node/nodes back from drag");p.data.canvasNeedsRedraw[a.NODE]=true;p.data.canvasRedrawReason[a.NODE].push("Node/nodes back from drag")}}L[4]=0;p.hoverData.down=null;p.data.canvasNeedsRedraw[a.SELECT_BOX]=true;p.data.canvasRedrawReason[a.SELECT_BOX].push("Mouse up, selection box gone");p.dragData.didDrag=false;p.redraw()},false);var j=function(A){var C=p.data.cy;var B=p.projectIntoViewport(A.pageX,A.pageY);
var z=[B[0]*C.zoom()+C.pan().x,B[1]*C.zoom()+C.pan().y];if(C.panningEnabled()&&C.zoomingEnabled()){A.preventDefault();var r=A.wheelDeltaY/1000||A.wheelDelta/1000||A.detail/-32||-A.deltaY/500;C.zoom({level:C.zoom()*Math.pow(10,r),position:{x:z[0],y:z[1]}})}};p.registerBinding(p.data.container,"wheel",j,true);p.registerBinding(p.data.container,"mousewheel",j,true);p.registerBinding(p.data.container,"DOMMouseScroll",j,true);p.registerBinding(p.data.container,"MozMousePixelScroll",function(r){},false);
p.registerBinding(p.data.container,"mouseout",function(r){p.data.cy.trigger(new b.Event(r,{type:"mouseout"}))},false);p.registerBinding(p.data.container,"mouseover",function(r){p.data.cy.trigger(new b.Event(r,{type:"mouseover"}))},false);var d,k,s,w;var t;var g,f;var h,u;var l=p.data.container.clientWidth,o=p.data.container.clientHeight;var c;function e(z,B,r,A){return Math.sqrt((r-z)*(r-z)+(A-B)*(A-B))}p.registerBinding(p.data.container,"touchstart",function(T){clearTimeout(this.threeFingerSelectTimeout);
if(T.target!==p.data.link){T.preventDefault()}p.touchData.capture=true;p.data.bgActivePosistion=undefined;var B=p.data.cy;var M=p.getCachedNodes();var A=p.getCachedEdges();var z=p.touchData.now;var Q=p.touchData.earlier;if(T.touches[0]){var E=p.projectIntoViewport(T.touches[0].pageX,T.touches[0].pageY);z[0]=E[0];z[1]=E[1]}if(T.touches[1]){var E=p.projectIntoViewport(T.touches[1].pageX,T.touches[1].pageY);z[2]=E[0];z[3]=E[1]}if(T.touches[2]){var E=p.projectIntoViewport(T.touches[2].pageX,T.touches[2].pageY);
z[4]=E[0];z[5]=E[1]}if(T.touches[1]){function S(V){for(var W=0;W<V.length;W++){V[W]._private.grabbed=false;V[W]._private.rscratch.inDragLayer=false;if(V[W].active()){V[W].unactivate()}}}S(M);S(A);var D=p.findContainerPageCoords();u=D[1];h=D[0];d=T.touches[0].pageX-h;k=T.touches[0].pageY-u;s=T.touches[1].pageX-h;w=T.touches[1].pageY-u;c=0<=d&&d<=l&&0<=s&&s<=l&&0<=k&&k<=o&&0<=w&&w<=o;var L=B.pan();var r=B.zoom();t=e(d,k,s,w);g=[(d+s)/2,(k+w)/2];f=[(g[0]-L.x)/r,(g[1]-L.y)/r];if(t<100){var G=p.findNearestElement(z[0],z[1],true);
var F=p.findNearestElement(z[2],z[3],true);var C=new b.Event(T,{type:"cxttapstart"});if(G&&G.isNode()){G.activate().trigger(C);p.touchData.start=G}else{if(F&&F.isNode()){F.activate().trigger(C);p.touchData.start=F}else{B.trigger(C);p.touchData.start=null}}if(p.touchData.start){p.touchData.start._private.grabbed=false}p.touchData.cxt=true;p.touchData.cxtDragged=false;p.data.bgActivePosistion=undefined;p.redraw();return}}if(T.touches[2]){}else{if(T.touches[1]){}else{if(T.touches[0]){var U=p.findNearestElement(z[0],z[1],true);
if(U!=null){U.activate();p.touchData.start=U;if(U._private.group=="nodes"&&p.nodeIsDraggable(U)){var H=p.dragData.touchDragEles=[];q(U,H);U.trigger(new b.Event(T,{type:"grab"}));if(U.selected()){H=p.dragData.touchDragEles=[];var J=B.$("node:selected");for(var N=0;N<J.length;N++){var R=J[N];if(p.nodeIsDraggable(R)){H.push(R);R._private.rscratch.inDragLayer=true;var I=R._private.edges;for(var O=0;O<I.length;O++){I[O]._private.rscratch.inDragLayer=true}if(R._private.style.width.value=="auto"||R._private.style.height.value=="auto"){m(R,false,H)
}v(R,true)}}}else{if(U._private.style.width.value=="auto"||U._private.style.height.value=="auto"){m(U,true,H)}v(U,true)}}U.trigger(new b.Event(T,{type:"touchstart"})).trigger(new b.Event(T,{type:"tapstart"})).trigger(new b.Event(T,{type:"vmousdown"}))}if(U==null){B.trigger(new b.Event(T,{type:"touchstart"})).trigger(new b.Event(T,{type:"tapstart"})).trigger(new b.Event(T,{type:"vmousedown"}));p.data.bgActivePosistion={x:E[0],y:E[1]};p.data.canvasNeedsRedraw[a.SELECT_BOX]=true;p.data.canvasRedrawReason[a.SELECT_BOX].push("bgactive")
}for(var P=0;P<z.length;P++){Q[P]=z[P];p.touchData.startPosition[P]=z[P]}p.touchData.singleTouchMoved=false;p.touchData.singleTouchStartTime=+new Date;var K=setTimeout(function(){if(p.touchData.singleTouchMoved==false&&(+new Date)-p.touchData.singleTouchStartTime>250){if(p.touchData.start){p.touchData.start.trigger(new b.Event(T,{type:"taphold"}))}else{p.data.cy.trigger(new b.Event(T,{type:"taphold"}));B.$(":selected").unselect()}}},1000)}}}p.redraw()},false);p.registerBinding(window,"touchmove",function(ag){var Z=p.data.select;
var N=p.touchData.capture;N&&ag.preventDefault();var L=p.data.cy;var V=p.getCachedNodes();var F=p.getCachedEdges();var Y=p.touchData.now;var z=p.touchData.earlier;if(ag.touches[0]){var Q=p.projectIntoViewport(ag.touches[0].pageX,ag.touches[0].pageY);Y[0]=Q[0];Y[1]=Q[1]}if(ag.touches[1]){var Q=p.projectIntoViewport(ag.touches[1].pageX,ag.touches[1].pageY);Y[2]=Q[0];Y[3]=Q[1]}if(ag.touches[2]){var Q=p.projectIntoViewport(ag.touches[2].pageX,ag.touches[2].pageY);Y[4]=Q[0];Y[5]=Q[1]}var B=[];for(var ad=0;
ad<Y.length;ad++){B[ad]=Y[ad]-z[ad]}if(N&&p.touchData.cxt){var P=ag.touches[0].pageX-h,C=ag.touches[0].pageY-u;var K=ag.touches[1].pageX-h,r=ag.touches[1].pageY-u;var T=e(P,C,K,r);var ae=T/t;if(ae>=1.5||T>=150){p.touchData.cxt=false;if(p.touchData.start){p.touchData.start.unactivate();p.touchData.start=null}p.data.bgActivePosistion=undefined;p.data.canvasNeedsRedraw[a.SELECT_BOX]=true;var A=new b.Event(ag,{type:"cxttapend"});if(p.touchData.start){p.touchData.start.trigger(A)}else{L.trigger(A)}}}if(N&&p.touchData.cxt){var A=new b.Event(ag,{type:"cxtdrag"});
p.data.bgActivePosistion=undefined;p.data.canvasNeedsRedraw[a.SELECT_BOX]=true;if(p.touchData.start){p.touchData.start.trigger(A)}else{L.trigger(A)}if(p.touchData.start){p.touchData.start._private.grabbed=false}p.touchData.cxtDragged=true}else{if(N&&ag.touches[2]&&L.boxSelectionEnabled()){p.data.bgActivePosistion=undefined;clearTimeout(this.threeFingerSelectTimeout);this.lastThreeTouch=+new Date;p.data.canvasNeedsRedraw[a.SELECT_BOX]=true;p.data.canvasRedrawReason[a.SELECT_BOX].push("Touch moved, redraw selection box");
if(!Z||Z.length===0||Z[0]===undefined){Z[0]=(Y[0]+Y[2]+Y[4])/3;Z[1]=(Y[1]+Y[3]+Y[5])/3;Z[2]=(Y[0]+Y[2]+Y[4])/3+1;Z[3]=(Y[1]+Y[3]+Y[5])/3+1}else{Z[2]=(Y[0]+Y[2]+Y[4])/3;Z[3]=(Y[1]+Y[3]+Y[5])/3}Z[4]=1}else{if(N&&ag.touches[1]&&L.zoomingEnabled()&&L.panningEnabled()){p.data.bgActivePosistion=undefined;p.data.canvasNeedsRedraw[a.SELECT_BOX]=true;var P=ag.touches[0].pageX-h,C=ag.touches[0].pageY-u;var K=ag.touches[1].pageX-h,r=ag.touches[1].pageY-u;var T=e(P,C,K,r);var ae=T/t;if(ae!=1&&c){var ai=P-d;var ah=C-k;
var U=K-s;var S=r-w;var ac=(ai+U)/2;var aa=(ah+S)/2;var E=L.zoom();var D=E*ae;var H=L.pan();var X=f[0]*E+H.x;var W=f[1]*E+H.y;var G={x:-D/E*(X-H.x-ac)+X,y:-D/E*(W-H.y-aa)+W};L._private.zoom=D;L._private.pan=G;L.trigger("pan zoom").notify("viewport");t=T;d=P;k=C;s=K;w=r;p.pinching=true}if(ag.touches[0]){var Q=p.projectIntoViewport(ag.touches[0].pageX,ag.touches[0].pageY);Y[0]=Q[0];Y[1]=Q[1]}if(ag.touches[1]){var Q=p.projectIntoViewport(ag.touches[1].pageX,ag.touches[1].pageY);Y[2]=Q[0];Y[3]=Q[1]}if(ag.touches[2]){var Q=p.projectIntoViewport(ag.touches[2].pageX,ag.touches[2].pageY);
Y[4]=Q[0];Y[5]=Q[1]}}else{if(ag.touches[0]){var O=p.touchData.start;var I=p.touchData.last;if(O!=null&&O._private.group=="nodes"&&p.nodeIsDraggable(O)){var J=p.dragData.touchDragEles;for(var ab=0;ab<J.length;ab++){var M=J[ab];if(p.nodeIsDraggable(M)){p.dragData.didDrag=true;M._private.position.x+=B[0];M._private.position.y+=B[1]}}(new b.Collection(L,J)).trigger(new b.Event(ag,{type:"drag"})).trigger(new b.Event(ag,{type:"position"}));p.data.canvasNeedsRedraw[a.DRAG]=true;p.data.canvasRedrawReason[a.DRAG].push("touchdrag node");
if(p.touchData.startPosition[0]==z[0]&&p.touchData.startPosition[1]==z[1]){p.data.canvasNeedsRedraw[a.NODE]=true;p.data.canvasRedrawReason[a.NODE].push("node drag started")}}if(O!=null){O.trigger(new b.Event(ag,{type:"touchmove"}))}if(O==null){var R=p.findNearestElement(Y[0],Y[1],true);if(R!=null){R.trigger(new b.Event(ag,{type:"touchmove"}))}if(R==null){L.trigger(new b.Event(ag,{type:"touchmove"}))}}if(R!=I){if(I){I.trigger(new b.Event(ag,{type:"touchout"}))}if(R){R.trigger(new b.Event(ag,{type:"touchover"}))
}}p.touchData.last=R;for(var af=0;af<Y.length;af++){if(Y[af]&&p.touchData.startPosition[af]&&Math.abs(Y[af]-p.touchData.startPosition[af])>4){p.touchData.singleTouchMoved=true}}if(N&&(O==null||O.isEdge())&&L.panningEnabled()){if(O){O.unactivate();if(!p.data.bgActivePosistion){p.data.bgActivePosistion={x:Y[0],y:Y[1]}}p.data.canvasNeedsRedraw[a.SELECT_BOX]=true;p.data.canvasRedrawReason[a.SELECT_BOX].push("bgactive")}L.panBy({x:B[0]*L.zoom(),y:B[1]*L.zoom()});p.swipePanning=true;var Q=p.projectIntoViewport(ag.touches[0].pageX,ag.touches[0].pageY);
Y[0]=Q[0];Y[1]=Q[1]}}}}}for(var ad=0;ad<Y.length;ad++){z[ad]=Y[ad]}p.redraw()},false);p.registerBinding(window,"touchend",function(V){var M=p.touchData.capture;if(!M){return}p.touchData.capture=false;V.preventDefault();var J=p.data.select;p.swipePanning=false;var B=p.data.cy;var L=p.getCachedNodes();var A=p.getCachedEdges();var z=p.touchData.now;var S=p.touchData.earlier;var D=p.touchData.start;if(V.touches[0]){var E=p.projectIntoViewport(V.touches[0].pageX,V.touches[0].pageY);z[0]=E[0];z[1]=E[1]
}if(V.touches[1]){var E=p.projectIntoViewport(V.touches[1].pageX,V.touches[1].pageY);z[2]=E[0];z[3]=E[1]}if(V.touches[2]){var E=p.projectIntoViewport(V.touches[2].pageX,V.touches[2].pageY);z[4]=E[0];z[5]=E[1]}if(p.touchData.cxt){ctxTapend=new b.Event(V,{type:"cxttapend"});if(D){D.unactivate();D.trigger(ctxTapend)}else{B.trigger(ctxTapend)}if(!p.touchData.cxtDragged){var K=new b.Event(V,{type:"cxttap"});if(D){D.trigger(K)}else{B.trigger(K)}}if(p.touchData.start){p.touchData.start._private.grabbed=false
}p.touchData.cxt=false;p.touchData.start=null;p.redraw();return}var r=+new Date;if(!V.touches[2]&&B.boxSelectionEnabled()){clearTimeout(this.threeFingerSelectTimeout);var C=[];var G=p.getAllInBox(J[0],J[1],J[2],J[3]);J[0]=undefined;J[1]=undefined;J[2]=undefined;J[3]=undefined;J[4]=0;p.data.canvasNeedsRedraw[a.SELECT_BOX]=true;p.data.canvasRedrawReason[a.SELECT_BOX].push("Touch moved, redraw selection box");var Q=new b.Event(V,{type:"select"});for(var R=0;R<G.length;R++){if(G[R]._private.selectable){C.push(G[R])
}}var F=(new b.Collection(B,C));if(B.selectionType()==="single"){B.$(":selected").unselect()}F.select();if(G.length>0){p.data.canvasNeedsRedraw[a.NODE]=true;p.data.canvasRedrawReason[a.NODE].push("Selection")}}if(!V.touches[1]){p.pinching=false}var P=false;if(D!=null){D._private.active=false;P=true;D.trigger(new b.Event(V,{type:"unactivate"}))}if(V.touches[2]){p.data.bgActivePosistion=undefined}else{if(V.touches[1]){}else{if(V.touches[0]){}else{if(!V.touches[0]){p.data.bgActivePosistion=undefined;
if(D!=null){if(D._private.grabbed==true){D._private.grabbed=false;D.trigger(new b.Event(V,{type:"free"}));D._private.rscratch.inDragLayer=false}var I=D._private.edges;for(var O=0;O<I.length;O++){I[O]._private.rscratch.inDragLayer=false}v(D,false);if(D.selected()){var H=B.$("node:selected");for(var N=0;N<H.length;N++){var T=H[N];T._private.rscratch.inDragLayer=false;var I=T._private.edges;for(var O=0;O<I.length;O++){I[O]._private.rscratch.inDragLayer=false}v(T,false)}}p.data.canvasNeedsRedraw[a.DRAG]=true;
p.data.canvasRedrawReason[a.DRAG].push("touchdrag node end");p.data.canvasNeedsRedraw[a.NODE]=true;p.data.canvasRedrawReason[a.NODE].push("touchdrag node end");D.trigger(new b.Event(V,{type:"touchend"})).trigger(new b.Event(V,{type:"tapend"})).trigger(new b.Event(V,{type:"vmouseup"}));p.touchData.start=null}else{var U=p.findNearestElement(z[0],z[1],true);if(U!=null){U.trigger(new b.Event(V,{type:"touchend"})).trigger(new b.Event(V,{type:"tapend"})).trigger(new b.Event(V,{type:"vmouseup"}))}if(U==null){B.trigger(new b.Event(V,{type:"touchend"})).trigger(new b.Event(V,{type:"tapend"})).trigger(new b.Event(V,{type:"vmouseup"}))
}}if(D!=null&&!p.dragData.didDrag&&D._private.selectable&&(Math.sqrt(Math.pow(p.touchData.startPosition[0]-z[0],2)+Math.pow(p.touchData.startPosition[1]-z[1],2)))<6){if(B.selectionType()==="single"){B.$(":selected").unselect();D.select()}else{if(D.selected()){D.unselect()}else{D.select()}}P=true;p.data.canvasNeedsRedraw[a.NODE]=true;p.data.canvasRedrawReason[a.NODE].push("sglslct")}if(p.touchData.singleTouchMoved==false){if(D){D.trigger(new b.Event(V,{type:"tap"})).trigger(new b.Event(V,{type:"vclick"}))
}else{B.trigger(new b.Event(V,{type:"tap"})).trigger(new b.Event(V,{type:"vclick"}))}}p.touchData.singleTouchMoved=true}}}}for(var O=0;O<z.length;O++){S[O]=z[O]}p.dragData.didDrag=false;if(P&&D){D.updateStyle(false)}p.redraw()},false)}})(cytoscape);(function(g){var e=g("renderer","canvas");var c=e.prototype;var a=e.nodeShapes={};a.ellipse={draw:function(l,p,o,m,k){a.ellipse.drawPath(l,p,o,m,k);l.fill()},drawPath:function(l,p,o,m,k){l.beginPath();l.translate(p,o);l.scale(m/2,k/2);l.arc(0,0,1,0,Math.PI*2*0.999,false);
l.closePath();l.scale(2/m,2/k);l.translate(-p,-o)},intersectLine:function(q,p,o,m,l,s,r){var k=g.math.intersectLineEllipse(l,s,q,p,o/2+r,m/2+r);return k},intersectBox:function(m,s,k,q,l,t,p,o,r){return g.math.boxIntersectEllipse(m,s,k,q,r,l,t,p,o)},checkPointRough:function(l,r,q,m,k,p,o){return true},checkPoint:function(l,r,q,m,k,p,o){l-=p;r-=o;l/=(m/2+q);r/=(k/2+q);return(Math.pow(l,2)+Math.pow(r,2)<=1)}};a.triangle={points:g.math.generateUnitNgonPoints(3,0),draw:function(l,p,o,m,k){c.drawPolygon(l,p,o,m,k,a.triangle.points)
},drawPath:function(l,p,o,m,k){c.drawPolygonPath(l,p,o,m,k,a.triangle.points)},intersectLine:function(p,o,m,l,k,r,q){return g.math.polygonIntersectLine(k,r,a.triangle.points,p,o,m/2,l/2,q)},intersectBox:function(m,s,k,q,l,u,p,o,r){var t=a.triangle.points;return g.math.boxIntersectPolygon(m,s,k,q,t,l,u,p,o,[0,-1],r)},checkPointRough:function(l,r,q,m,k,p,o){return g.math.checkInBoundingBox(l,r,a.triangle.points,q,m,k,p,o)},checkPoint:function(l,r,q,m,k,p,o){return g.math.pointInsidePolygon(l,r,a.triangle.points,p,o,m,k,[0,-1],q)
}};a.square={points:g.math.generateUnitNgonPoints(4,0),draw:function(l,p,o,m,k){c.drawPolygon(l,p,o,m,k,a.square.points)},drawPath:function(l,p,o,m,k){c.drawPolygonPath(l,p,o,m,k,a.square.points)},intersectLine:function(p,o,m,l,k,r,q){return g.math.polygonIntersectLine(k,r,a.square.points,p,o,m/2,l/2,q)},intersectBox:function(m,s,k,q,l,u,p,o,r){var t=a.square.points;return g.math.boxIntersectPolygon(m,s,k,q,t,l,u,p,o,[0,-1],r)},checkPointRough:function(l,r,q,m,k,p,o){return g.math.checkInBoundingBox(l,r,a.square.points,q,m,k,p,o)
},checkPoint:function(l,r,q,m,k,p,o){return g.math.pointInsidePolygon(l,r,a.square.points,p,o,m,k,[0,-1],q)}};a.rectangle=a.square;a.octogon={};a.roundrectangle={points:g.math.generateUnitNgonPoints(4,0),draw:function(l,p,o,m,k){c.drawRoundRectangle(l,p,o,m,k,10)},drawPath:function(l,p,o,m,k){c.drawRoundRectanglePath(l,p,o,m,k,10)},intersectLine:function(p,o,m,l,k,r,q){return g.math.roundRectangleIntersectLine(k,r,p,o,m,l,q)},intersectBox:function(m,s,k,q,l,t,p,o,r){return g.math.roundRectangleIntersectBox(m,s,k,q,l,t,p,o,r)
},checkPointRough:function(l,r,q,m,k,p,o){return g.math.checkInBoundingBox(l,r,a.roundrectangle.points,q,m,k,p,o)},checkPoint:function(s,q,r,k,t,o,l){var p=g.math.getRoundRectangleRadius(k,t);if(g.math.pointInsidePolygon(s,q,a.roundrectangle.points,o,l,k,t-2*p,[0,-1],r)){return true}if(g.math.pointInsidePolygon(s,q,a.roundrectangle.points,o,l,k-2*p,t,[0,-1],r)){return true}var m=function(v,C,B,z,w,u,A){v-=B;C-=z;v/=(w/2+A);C/=(u/2+A);return(Math.pow(v,2)+Math.pow(C,2)<=1)};if(m(s,q,o-k/2+p,l-t/2+p,p*2,p*2,r)){return true
}if(m(s,q,o+k/2-p,l-t/2+p,p*2,p*2,r)){return true}if(m(s,q,o+k/2-p,l+t/2-p,p*2,p*2,r)){return true}if(m(s,q,o-k/2+p,l+t/2-p,p*2,p*2,r)){return true}return false}};a.roundrectangle2={roundness:4.99,draw:function(m,l,k){if(l<=roundness*2){return}c.drawPolygon(m._private.position.x,m._private.position.y,l,k,nodeSapes.roundrectangle2.points)},intersectLine:function(o,m,l,k,p){return g.math.findPolygonIntersection(o,m,l,k,p,a.square.points)},intersectBox:function(m,s,k,q,l,u,p,o,r){var t=a.square.points
}};a.pentagon={points:g.math.generateUnitNgonPoints(5,0),draw:function(l,p,o,m,k){c.drawPolygon(l,p,o,m,k,a.pentagon.points)},drawPath:function(l,p,o,m,k){c.drawPolygonPath(l,p,o,m,k,a.pentagon.points)},intersectLine:function(p,o,m,l,k,r,q){return c.polygonIntersectLine(k,r,a.pentagon.points,p,o,m/2,l/2,q)},intersectBox:function(m,s,k,q,l,u,p,o,r){var t=a.pentagon.points;return g.math.boxIntersectPolygon(m,s,k,q,t,l,u,p,o,[0,-1],r)},checkPointRough:function(l,r,q,m,k,p,o){return g.math.checkInBoundingBox(l,r,a.pentagon.points,q,m,k,p,o)
},checkPoint:function(l,r,q,m,k,p,o){return g.math.pointInsidePolygon(l,r,a.pentagon.points,p,o,m,k,[0,-1],q)}};a.hexagon={points:g.math.generateUnitNgonPoints(6,0),draw:function(l,p,o,m,k){c.drawPolygon(l,p,o,m,k,a.hexagon.points)},drawPath:function(l,p,o,m,k){c.drawPolygonPath(l,p,o,m,k,a.hexagon.points)},intersectLine:function(p,o,m,l,k,r,q){return g.math.polygonIntersectLine(k,r,a.hexagon.points,p,o,m/2,l/2,q)},intersectBox:function(m,s,k,q,l,u,p,o,r){var t=a.hexagon.points;return g.math.boxIntersectPolygon(m,s,k,q,t,l,u,p,o,[0,-1],r)
},checkPointRough:function(l,r,q,m,k,p,o){return g.math.checkInBoundingBox(l,r,a.hexagon.points,q,m,k,p,o)},checkPoint:function(l,r,q,m,k,p,o){return g.math.pointInsidePolygon(l,r,a.hexagon.points,p,o,m,k,[0,-1],q)}};a.heptagon={points:g.math.generateUnitNgonPoints(7,0),draw:function(l,p,o,m,k){c.drawPolygon(l,p,o,m,k,a.heptagon.points)},drawPath:function(l,p,o,m,k){c.drawPolygonPath(l,p,o,m,k,a.heptagon.points)},intersectLine:function(p,o,m,l,k,r,q){return c.polygonIntersectLine(k,r,a.heptagon.points,p,o,m/2,l/2,q)
},intersectBox:function(m,s,k,q,l,u,p,o,r){var t=a.heptagon.points;return c.boxIntersectPolygon(m,s,k,q,t,l,u,p,o,[0,-1],r)},checkPointRough:function(l,r,q,m,k,p,o){return g.math.checkInBoundingBox(l,r,a.heptagon.points,q,m,k,p,o)},checkPoint:function(l,r,q,m,k,p,o){return g.math.pointInsidePolygon(l,r,a.heptagon.points,p,o,m,k,[0,-1],q)}};a.octagon={points:g.math.generateUnitNgonPoints(8,0),draw:function(l,p,o,m,k){c.drawPolygon(l,p,o,m,k,a.octagon.points)},drawPath:function(l,p,o,m,k){c.drawPolygonPath(l,p,o,m,k,a.octagon.points)
},intersectLine:function(p,o,m,l,k,r,q){return c.polygonIntersectLine(k,r,a.octagon.points,p,o,m/2,l/2,q)},intersectBox:function(m,s,k,q,l,u,p,o,r){var t=a.octagon.points;return c.boxIntersectPolygon(m,s,k,q,t,l,u,p,o,[0,-1],r)},checkPointRough:function(l,r,q,m,k,p,o){return g.math.checkInBoundingBox(l,r,a.octagon.points,q,m,k,p,o)},checkPoint:function(l,r,q,m,k,p,o){return g.math.pointInsidePolygon(l,r,a.octagon.points,p,o,m,k,[0,-1],q)}};var h=new Array(20);var f=g.math.generateUnitNgonPoints(5,0);
var j=g.math.generateUnitNgonPoints(5,Math.PI/5);var d=0.5*(3-Math.sqrt(5));d*=1.57;for(var b=0;b<j.length/2;b++){j[b*2]*=d;j[b*2+1]*=d}for(var b=0;b<20/4;b++){h[b*4]=f[b*2];h[b*4+1]=f[b*2+1];h[b*4+2]=j[b*2];h[b*4+3]=j[b*2+1]}a.star5={points:h,draw:function(l,p,o,m,k){c.drawPolygon(l,p,o,m,k,a.star5.points)},drawPath:function(l,p,o,m,k){c.drawPolygonPath(l,p,o,m,k,a.star5.points)},intersectLine:function(p,o,m,l,k,r,q){return c.polygonIntersectLine(k,r,a.star5.points,p,o,m/2,l/2,q)},intersectBox:function(m,s,k,q,l,u,p,o,r){var t=a.star5.points;
return c.boxIntersectPolygon(m,s,k,q,t,l,u,p,o,[0,-1],r)},checkPointRough:function(l,r,q,m,k,p,o){return g.math.checkInBoundingBox(l,r,a.star5.points,q,m,k,p,o)},checkPoint:function(l,r,q,m,k,p,o){return g.math.pointInsidePolygon(l,r,a.star5.points,p,o,m,k,[0,-1],q)}}})(cytoscape);(function(a){var b={ready:function(){},stop:function(){}};function c(d){this.options=a.util.extend(true,{},b,d)}c.prototype.run=function(){var d=this.options;var e=d.cy;e.nodes().positions(function(){return{x:0,y:0}});e.one("layoutready",d.ready);
e.trigger("layoutready");e.one("layoutstop",d.stop);e.trigger("layoutstop")};c.prototype.stop=function(){var d=this.options;cy.one("layoutstop",d.stop);cy.trigger("layoutstop")};a("layout","null",c)})(cytoscape);(function(a){var c={ready:undefined,stop:undefined,fit:true,padding:30};function b(d){this.options=a.util.extend(true,{},c,d)}b.prototype.run=function(){var h=this.options;var k=h.cy;var g=k.nodes();var f=k.edges();var e=k.container();var j=e.clientWidth;var d=e.clientHeight;g.positions(function(m,l){if(l.locked()){return false
}return{x:Math.round(Math.random()*j),y:Math.round(Math.random()*d)}});k.one("layoutready",h.ready);k.trigger("layoutready");if(h.fit){k.fit(h.padding)}k.one("layoutstop",h.stop);k.trigger("layoutstop")};b.prototype.stop=function(){};a("layout","random",b)})(cytoscape);(function(a){var c={fit:true,padding:30,rows:undefined,columns:undefined,position:function(d){},ready:undefined,stop:undefined};function b(d){this.options=a.util.extend({},c,d)}b.prototype.run=function(){var E=this.options;var h=E;
var g=E.cy;var z=g.nodes();var f=g.edges();var t=g.container();var w=t.clientWidth;var v=t.clientHeight;if(v==0||w==0){z.positions(function(){return{x:0,y:0}})}else{var j=z.size();var r=Math.sqrt(j*v/w);var q=Math.round(r);var s=Math.round(w/v*r);function o(G){if(G==undefined){return Math.min(q,s)}else{var F=Math.min(q,s);if(F==q){q=G}else{s=G}}}function e(G){if(G==undefined){return Math.max(q,s)}else{var F=Math.max(q,s);if(F==q){q=G}else{s=G}}}if(h.rows!=null&&h.columns!=null){q=h.rows;s=h.columns
}else{if(h.rows!=null&&h.columns==null){q=h.rows;s=Math.ceil(j/q)}else{if(h.rows==null&&h.columns!=null){s=h.columns;q=Math.ceil(j/s)}else{if(s*q>j){var D=o();var u=e();if((D-1)*u>=j){o(D-1)}else{if((u-1)*D>=j){e(u-1)}}}else{while(s*q<j){var D=o();var u=e();if((u+1)*D>=j){e(u+1)}else{o(D+1)}}}}}}var B=w/s;var d=v/q;var C={};function l(G,F){return C["c-"+G+"-"+F]?true:false}function A(G,F){C["c-"+G+"-"+F]=true}var m=0;var k=0;var p=false;z.positions(function(H,G){var F,K;if(G.locked()){return false
}var J=false;var I=h.position(G);if(I){if(I.row!==undefined||I.col!==undefined){if(I.row===undefined){I.row=m}if(I.col===undefined){I.col=k}}if(!l(I.row,I.col)){A(I.row,I.col);J=true;p=true;F=I.col*B+B/2;K=I.row*d+d/2}}if(!J){F=k*B+B/2;K=m*d+d/2;A(m,k);k++;if(k>=s){k=0;m++}}return{x:F,y:K}})}if(E.fit){g.fit(h.padding)}g.one("layoutready",E.ready);g.trigger("layoutready");g.one("layoutstop",E.stop);g.trigger("layoutstop")};b.prototype.stop=function(){};a("layout","grid",b)})(cytoscape);(function(a){var c={fit:true,ready:undefined,stop:undefined,positions:undefined,zoom:undefined,pan:undefined,padding:30};
function b(d){this.options=a.util.extend(true,{},c,d)}b.prototype.run=function(){var g=this.options;var j=g.cy;var f=j.nodes();var e=j.edges();var d=j.container();function h(k){if(g.positions==null){return null}if(g.positions[k._private.data.id]==null){return null}return g.positions[k._private.data.id]}f.positions(function(l,m){var k=h(m);if(m.locked()||k==null){return false}return k});if(g.pan!=null){j.pan(g.pan)}if(g.zoom!=null){j.zoom(g.zoom)}j.one("layoutready",g.ready);j.trigger("layoutready");
if(g.fit){j.fit(g.padding)}j.one("layoutstop",g.stop);j.trigger("layoutstop")};a("layout","preset",b);a("core","presetLayout",function(){var f=this;var d={};var e={};f.nodes().each(function(g,h){e[h.data("id")]=h.position()});d.positions=e;d.name="preset";d.zoom=f.zoom();d.pan=f.pan();return d})})(cytoscape);(function(a){var b={liveUpdate:true,ready:undefined,stop:undefined,maxSimulationTime:4000,fit:true,padding:[50,50,50,50],simulationBounds:undefined,ungrabifyWhileSimulating:true,repulsion:undefined,stiffness:undefined,friction:undefined,gravity:true,fps:undefined,precision:undefined,nodeMass:undefined,edgeLength:undefined,stepSize:1,stableEnergy:function(d){var f=d;
return(f.max<=0.5)||(f.mean<=0.3)}};function c(d){this.options=a.util.extend({},b,d)}c.prototype.run=function(){var l=this.options;var k=l.cy;var z=k.nodes();var j=k.edges();var r=k.container();var w=r.clientWidth;var t=r.clientHeight;var u=l.simulationBounds;if(l.simulationBounds){w=u[2]-u[0];t=u[3]-u[1]}else{l.simulationBounds=[0,0,w,t]}var B=l.simulationBounds;B.x1=B[0];B.y1=B[1];B.x2=B[2];B.y2=B[3];if(k.nodes().size()<=1){if(l.fit){k.reset()}k.nodes().position({x:Math.round((B.x1+B.x2)/2),y:Math.round((B.y1+B.y2)/2)});
k.one("layoutstop",l.stop);k.trigger("layoutstop");k.one("layoutstop",l.stop);k.trigger("layoutstop");return}var o=this.system=arbor.ParticleSystem(l.repulsion,l.stiffness,l.friction,l.gravity,l.fps,l.dt,l.precision);this.system=o;if(l.liveUpdate&&l.fit){k.reset()}var v=250;var h;var q=false;var g=+new Date;var s={init:function(C){},redraw:function(){var D=o.energy();if(l.stableEnergy!=null&&D!=null&&D.n>0&&l.stableEnergy(D)){o.stop();return}clearTimeout(h);h=setTimeout(A,v);var E=[];o.eachNode(function(K,F){var J=K.name;
var H=K.data;var G=H.element;if(G==null){return}var I=G._private.position;if(!G.locked()&&!G.grabbed()){I.x=B.x1+F.x;I.y=B.y1+F.y;E.push(G)}});var C=(+new Date-g)>=16;if(l.liveUpdate&&E.length>0&&C){new a.Collection(k,E).rtrigger("position");g=+new Date}if(!q){q=true;k.one("layoutready",l.ready);k.trigger("layoutready")}}};o.renderer=s;o.screenSize(w,t);o.screenPadding(l.padding[0],l.padding[1],l.padding[2],l.padding[3]);o.screenStep(l.stepSize);function p(C,D){if(D==null){return undefined}else{if(typeof D==typeof function(){}){return D.apply(C,[C._private.data,{nodes:z.length,edges:j.length,element:C}])
}else{return D}}}function d(G){var J=G.x;var H=G.y;var K=w;var E=t;var D=-2;var L=2;var I=-2;var C=2;var F=4;return{x:J/K*F+D,y:H/E*F+L}}var m=function(D){grabbed=this;var E=o.fromScreen(this.position());var C=arbor.Point(E.x,E.y);this.scratch().arbor.p=C;switch(D.type){case"grab":this.scratch().arbor.fixed=true;break;case"dragstop":this.scratch().arbor.fixed=false;this.scratch().arbor.tempMass=1000;break}};z.bind("grab drag dragstop",m);z.each(function(E,F){var H=this._private.data.id;var D=p(this,l.nodeMass);
var C=this._private.locked;var G=d({x:F.position().x,y:F.position().y});if(F.locked()){return}this.scratch().arbor=o.addNode(H,{element:this,mass:D,fixed:C,x:C?G.x:undefined,y:C?G.y:undefined})});j.each(function(){var F=this.id();var D=this.source().id();var E=this.target().id();var C=p(this,l.edgeLength);this.scratch().arbor=o.addEdge(D,E,{length:C})});function f(C){if(l.fit){k.fit()}C()}var e=z.filter(":grabbable");if(l.ungrabifyWhileSimulating){e.ungrabify()}var A=function(){if(window.isIE){f(function(){C()
})}else{C()}function C(){if(!l.liveUpdate){if(l.fit){k.reset()}k.nodes().rtrigger("position")}z.unbind("grab drag dragstop",m);if(l.ungrabifyWhileSimulating){e.grabify()}k.one("layoutstop",l.stop);k.trigger("layoutstop")}};o.start();setTimeout(function(){o.stop()},l.maxSimulationTime)};c.prototype.stop=function(){if(this.system!=null){system.stop()}};a("layout","arbor",c)})(cytoscape);(function(a){var c={fit:true,ready:undefined,stop:undefined,rStepSize:10,padding:30,startAngle:3/2*Math.PI,counterclockwise:false};
function b(d){this.options=a.util.extend({},c,d)}b.prototype.run=function(){var o=this.options;var w=o;var m=o.cy;var f=m.nodes();var p=m.edges();var g=m.container();var h=g.clientWidth;var v=g.clientHeight;var e={x:h/2,y:v/2};var u=50;var j=w.startAngle;var s=2*Math.PI/f.length;var t=0;for(var q=0;q<f.length;q++){var l=f[q];t=Math.max(l.outerWidth(),l.outerHeight())}var d=h/2-t;function k(){var z=0;var r=s;var C={x:e.x+d*Math.cos(z),y:e.y+d*Math.sin(z)};var A={x:e.x+d*Math.cos(r),y:e.y+d*Math.sin(r)};
var B=Math.sqrt((A.x-C.x)*(A.x-C.x)+(A.y-C.y)*(A.y-C.y));return B}while(k()<t&&!(f.length<2)){d+=w.rStepSize}var q=0;f.positions(function(){var r=this;var A=d*Math.cos(j);var z=d*Math.sin(j);var B={x:e.x+A,y:e.y+z};q++;j=w.counterclockwise?j-s:j+s;return B});if(o.fit){m.fit(w.padding)}m.one("layoutready",o.ready);m.trigger("layoutready");m.one("layoutstop",o.stop);m.trigger("layoutstop")};b.prototype.stop=function(){};a("layout","circle",b)})(cytoscape);(function(a){var b={fit:true,ready:undefined,stop:undefined,directed:true,padding:30,circle:false,roots:undefined,maximalAdjustments:0};
function c(d){this.options=a.util.extend({},b,d)}c.prototype.run=function(){var g=this.options;var G=g;var D=g.cy;var S=D.nodes();var u=D.edges();var O=D.container();var d=O.clientWidth;var l=O.clientHeight;var F;if(a.is.elementOrCollection(G.roots)){F=G.roots}else{if(a.is.array(G.roots)){var p=[];for(var V=0;V<G.roots.length;V++){var P=G.roots[V];var Z=D.getElementById(P);F.push(Z)}F=new a.Collection(D,p)}else{F=S.roots()}}var A=[];var aa={};var E={};F.bfs(function(h,w){var j=this[0];if(!A[w]){A[w]=[]
}A[w].push(j);aa[j.id()]=true;E[j.id()]=w},G.directed);var I=[];for(var V=0;V<S.length;V++){var Z=S[V];if(aa[Z.id()]){continue}else{I.push(Z)}}var v=I.length*3;var J=0;while(I.length!==0&&J<v){var M=I.shift();var R=M.neighborhood().nodes();var t=false;for(var V=0;V<R.length;V++){var q=E[R[V].id()];if(q!==undefined){A[q].push(M);t=true;break}}if(!t){I.push(M)}J++}while(I.length!==0){var M=I.shift();var N=M.bfs();var t=false;for(var V=0;V<N.length;V++){var q=E[N[V].id()];if(q!==undefined){A[q].push(M);
t=true;break}}if(!t){if(A.length===0){A.push([])}A[0].push(M)}}function L(){for(var ab=0;ab<A.length;ab++){var h=A[ab];for(var w=0;w<h.length;w++){var ac=h[w];ac._private.scratch.BreadthFirstLayout={depth:ab,index:w}}}}L();for(var f=0;f<G.maximalAdjustments;f++){function r(w){var af=w.connectedEdges('[target = "'+w.id()+'"]');var ad=w._private.scratch.BreadthFirstLayout;var ab=0;var h;for(var ag=0;ag<af.length;ag++){var j=af[ag];var ae=j.source()[0];var ac=ae._private.scratch.BreadthFirstLayout;if(ad.depth<ac.depth&&ab<ac.depth){ab=ac.depth;
h=ae}}return h}var m=A.length;var z=[];for(var V=0;V<m;V++){var q=A[V];var Q=q.length;for(var U=0;U<Q;U++){var Z=q[U];var Y=Z._private.scratch.BreadthFirstLayout;var C=r(Z);if(C){Y.intEle=C;z.push(Z)}}}for(var V=0;V<z.length;V++){var Z=z[V];var Y=Z._private.scratch.BreadthFirstLayout;var C=Y.intEle;var k=C._private.scratch.BreadthFirstLayout;A[Y.depth].splice(Y.index,1);var s=k.depth+1;while(s>A.length-1){A.push([])}A[s].push(Z);Y.depth=s;Y.index=A[s].length-1}L()}var o=0;for(var V=0;V<S.length;V++){var T=S[V].outerWidth();
var W=S[V].outerHeight();o=Math.max(o,T,W)}o*=1.75;var B={};function H(ai){if(B[ai.id()]){return B[ai.id()]}var w=ai._private.scratch.BreadthFirstLayout.depth;var ah=ai.neighborhood().nodes();var ac=0;var ad=0;for(var j=0;j<ah.length;j++){var af=ah[j];var ae=af.edgesWith(ai);var ab=af._private.scratch.BreadthFirstLayout.index;var h=af._private.scratch.BreadthFirstLayout.depth;var ag=A[h].length;if(w>h||w===0){ac+=ab/ag;ad++}}ad=Math.max(1,ad);ac=ac/ad;if(ad===0){ac=undefined}B[ai.id()]=ac;return ac
}for(var K=0;K<3;K++){for(var V=0;V<A.length;V++){var q=V;var X=[];A[V]=A[V].sort(function(j,h){var w=H(j);var ab=H(h);return w-ab})}L()}var e={x:d/2,y:l/2};S.positions(function(){var ag=this[0];var j=ag._private.scratch.BreadthFirstLayout;var w=j.depth;var ab=j.index;var af=Math.max(d/(A[w].length+1),o);var ae=Math.max(l/(A.length+1),o);var ad=Math.min(d/2/A.length,l/2/A.length);ad=Math.max(ad,o);if(G.circle){var ac=ad*w+ad-(A.length>0&&A[0].length<=3?ad/2:0);var h=2*Math.PI/A[w].length*ab;if(w===0&&A[0].length===1){ac=1
}return{x:e.x+ac*Math.cos(h),y:e.y+ac*Math.sin(h)}}else{return{x:(ab+1)*af,y:(w+1)*ae}}});if(g.fit){D.fit(G.padding)}D.one("layoutready",g.ready);D.trigger("layoutready");D.one("layoutstop",g.stop);D.trigger("layoutstop")};c.prototype.stop=function(){};a("layout","breadthfirst",c)})(cytoscape);(function(h){var f={ready:function(){},stop:function(){},refresh:0,fit:true,randomize:true,debug:false,nodeRepulsion:10000,nodeOverlap:10,idealEdgeLength:10,edgeElasticity:100,nestingFactor:5,gravity:250,numIter:100,initialTemp:200,coolingFactor:0.95,minTemp:1};
function a(z){this.options=h.util.extend({},f,z)}a.prototype.run=function(){var A=this.options;var E=A.cy;if(true==A.debug){DEBUG=true}else{DEBUG=false}var C=new Date();var D=o(E,A);if(DEBUG){j(D)}if(true==A.randomize){t(D,E);if(0<A.refresh){b(D,E,A)}}for(var B=0;B<A.numIter;B++){e(D,E,A,B);if(0<A.refresh&&0==(B%A.refresh)){b(D,E,A)}D.temperature=D.temperature*A.coolingFactor;r("New temperature: "+D.temperature);if(D.temperature<A.minTemp){r("Temperature drop below minimum threshold. Stopping computation in step "+B);
break}}b(D,E,A);if(true==A.fit){E.fit()}var z=new Date();console.info("Layout took "+(z-C)+" ms");E.one("layoutstop",A.stop);E.trigger("layoutstop")};a.prototype.stop=function(){var z=this.options;cy.one("layoutstop",z.stop);cy.trigger("layoutstop")};function o(B,C){var M={layoutNodes:[],idToIndex:{},nodeSize:B.nodes().size(),graphSet:[],indexToGraph:[],layoutEdges:[],edgeSize:B.edges().size(),temperature:C.initialTemp};var O=B.nodes();for(var V=0;V<M.nodeSize;V++){var W={};W.id=O[V].data("id");W.parentId=O[V].data("parent");
W.children=[];W.positionX=O[V].position("x");W.positionY=O[V].position("y");W.offsetX=0;W.offsetY=0;W.height=O[V].height();W.width=O[V].width();W.maxX=W.positionX+W.width/2;W.minX=W.positionX-W.width/2;W.maxY=W.positionY+W.height/2;W.minY=W.positionY-W.height/2;W.padLeft=O[V]._private.style["padding-left"].pxValue;W.padRight=O[V]._private.style["padding-right"].pxValue;W.padTop=O[V]._private.style["padding-top"].pxValue;W.padBottom=O[V]._private.style["padding-bottom"].pxValue;M.layoutNodes.push(W);
M.idToIndex[W.id]=V}var Q=[];var F=0;var D=-1;var I=[];for(var V=0;V<M.nodeSize;V++){var N=M.layoutNodes[V];var Y=N.parentId;if(undefined!=Y){M.layoutNodes[M.idToIndex[Y]].children.push(N.id)}else{Q[++D]=N.id;I.push(N.id)}}M.graphSet.push(I);while(F<=D){var aa=Q[F++];var L=M.idToIndex[aa];var P=M.layoutNodes[L];var E=P.children;if(E.length>0){M.graphSet.push(E);for(var V=0;V<E.length;V++){Q[++D]=E[V]}}}for(var V=0;V<M.graphSet.length;V++){var z=M.graphSet[V];for(var T=0;T<z.length;T++){var H=M.idToIndex[z[T]];
M.indexToGraph[H]=V}}var A=B.edges();for(var V=0;V<M.edgeSize;V++){var X=A[V];var K={};K.id=X.data("id");K.sourceId=X.data("source");K.targetId=X.data("target");var G=C.idealEdgeLength;var Z=M.idToIndex[K.sourceId];var S=M.idToIndex[K.targetId];var ac=M.indexToGraph[Z];var R=M.indexToGraph[S];if(ac!=R){var J=l(K.sourceId,K.targetId,M);var U=M.graphSet[J];var ab=0;var W=M.layoutNodes[Z];while(-1==$.inArray(W.id,U)){W=M.layoutNodes[M.idToIndex[W.parentId]];ab++}W=M.layoutNodes[S];while(-1==$.inArray(W.id,U)){W=M.layoutNodes[M.idToIndex[W.parentId]];
ab++}r("LCA of nodes "+K.sourceId+" and "+K.targetId+". Index: "+J+" Contents: "+U.toString()+". Depth: "+ab);G*=ab*C.nestingFactor}K.idealLength=G;M.layoutEdges.push(K)}return M}function l(A,z,C){var B=s(A,z,0,C);if(2>B.count){return 0}else{return B.graph}}function s(J,I,D,C){var H=C.graphSet[D];if(-1<$.inArray(J,H)&&-1<$.inArray(I,H)){return{count:2,graph:D}}var G=0;for(var F=0;F<H.length;F++){var B=H[F];var E=C.idToIndex[B];var A=C.layoutNodes[E].children;if(0==A.length){continue}var z=C.indexToGraph[C.idToIndex[A[0]]];
var K=s(J,I,z,C);if(0==K.count){continue}else{if(1==K.count){G++;if(2==G){break}}else{return K}}}return{count:G,graph:D}}function j(C){if(!DEBUG){return}console.debug("layoutNodes:");for(var z=0;z<C.nodeSize;z++){var E=C.layoutNodes[z];var A="\nindex: "+z+"\nId: "+E.id+"\nChildren: "+E.children.toString()+"\nparentId: "+E.parentId+"\npositionX: "+E.positionX+"\npositionY: "+E.positionY+"\nOffsetX: "+E.offsetX+"\nOffsetY: "+E.offsetY+"\npadLeft: "+E.padLeft+"\npadRight: "+E.padRight+"\npadTop: "+E.padTop+"\npadBottom: "+E.padBottom;
console.debug(A)}console.debug("idToIndex");for(var z in C.idToIndex){console.debug("Id: "+z+"\nIndex: "+C.idToIndex[z])}console.debug("Graph Set");var D=C.graphSet;for(var z=0;z<D.length;z++){console.debug("Set : "+z+": "+D[z].toString())}var A="IndexToGraph";for(var z=0;z<C.indexToGraph.length;z++){A+="\nIndex : "+z+" Graph: "+C.indexToGraph[z]}console.debug(A);A="Layout Edges";for(var z=0;z<C.layoutEdges.length;z++){var B=C.layoutEdges[z];A+="\nEdge Index: "+z+" ID: "+B.id+" SouceID: "+B.sourceId+" TargetId: "+B.targetId+" Ideal Length: "+B.idealLength
}console.debug(A);A="nodeSize: "+C.nodeSize;A+="\nedgeSize: "+C.edgeSize;A+="\ntemperature: "+C.temperature;console.debug(A);return}function t(D,F){var A=F.container();var C=A.clientWidth;var z=A.clientHeight;for(var B=0;B<D.nodeSize;B++){var E=D.layoutNodes[B];if(0==E.children.length){E.positionX=Math.random()*C;E.positionY=Math.random()*z}}}function b(E,F,B){var A=F.container();var D=A.clientWidth;var z=A.clientHeight;var C="Refreshing positions";r(C);F.nodes().positions(function(G,H){lnode=E.layoutNodes[E.idToIndex[H.data("id")]];
C="Node: "+lnode.id+". Refreshed position: ("+lnode.positionX+", "+lnode.positionY+").";r(C);return{x:lnode.positionX,y:lnode.positionY}});if(true!=E.ready){C="Triggering layoutready";r(C);E.ready=true;F.one("layoutready",B.ready);F.trigger("layoutready")}}function e(C,D,z,B){var A="\n\n###############################";A+="\nSTEP: "+B;A+="\n###############################\n";r(A);w(C,D,z);v(C,D,z);q(C,D,z);p(C,D,z);g(C,D,z)}function w(B,A,J){var I="calculateNodeForces";r(I);for(var E=0;E<B.graphSet.length;
E++){var G=B.graphSet[E];var z=G.length;I="Set: "+G.toString();r(I);for(var D=0;D<z;D++){var H=B.layoutNodes[B.idToIndex[G[D]]];for(var C=D+1;C<z;C++){var F=B.layoutNodes[B.idToIndex[G[C]]];k(H,F,B,A,J)}}}}function k(N,M,D,C,P){var O="Node repulsion. Node1: "+N.id+" Node2: "+M.id;var K=M.positionX-N.positionX;var I=M.positionY-N.positionY;O+="\ndirectionX: "+K+", directionY: "+I;if(0==K&&0==I){O+="\nNodes have the same position.";return}overlap=c(N,M,K,I);if(overlap>0){O+="\nNodes DO overlap.";O+="\nOverlap: "+overlap;
var B=P.nodeOverlap*overlap;var A=Math.sqrt(K*K+I*I);O+="\nDistance: "+A;var F=B*K/A;var E=B*I/A}else{O+="\nNodes do NOT overlap.";var H=d(N,K,I);var G=d(M,-1*K,-1*I);var L=G.x-H.x;var J=G.y-H.y;var z=L*L+J*J;var A=Math.sqrt(z);O+="\nDistance: "+A;var B=P.nodeRepulsion/z;var F=B*L/A;var E=B*J/A}N.offsetX-=F;N.offsetY-=E;M.offsetX+=F;M.offsetY+=E;O+="\nForceX: "+F+" ForceY: "+E;r(O);return}function d(C,F,E){var A=C.positionX;var z=C.positionY;var K=C.height;var B=C.width;var I=E/F;var D=K/B;var G=B/K;
var L="Computing clipping point of node "+C.id+" . Height:  "+K+", Width: "+B+"\nDirection "+F+", "+E;var J={};do{if(0==F&&0<E){J.x=A;L+="\nUp direction";J.y=z+K/2;break}if(0==F&&0>E){J.x=A;J.y=z+K/2;L+="\nDown direction";break}if(0<F&&-1*D<=I&&I<=D){J.x=A+B/2;J.y=z+(B*E/2/F);L+="\nRightborder";break}if(0>F&&-1*D<=I&&I<=D){J.x=A-B/2;J.y=z-(B*E/2/F);L+="\nLeftborder";break}if(0<E&&(I<=-1*D||I>=D)){J.x=A+(K*F/2/E);J.y=z+K/2;L+="\nTop border";break}if(0>E&&(I<=-1*D||I>=D)){J.x=A-(K*F/2/E);J.y=z-K/2;
L+="\nBottom border";break}}while(false);L+="\nClipping point found at "+J.x+", "+J.y;r(L);return J}function c(D,B,A,z){if(A>0){var E=D.maxX-B.minX}else{var E=B.maxX-D.minX}if(z>0){var C=D.maxY-B.minY}else{var C=B.maxY-D.minY}if(E>=0&&C>=0){return Math.sqrt(E*E+C*C)}else{return 0}}function v(M,C,G){for(var Q=0;Q<M.edgeSize;Q++){var K=M.layoutEdges[Q];var R=M.idToIndex[K.sourceId];var N=M.layoutNodes[R];var P=M.idToIndex[K.targetId];var S=M.layoutNodes[P];var A=S.positionX-N.positionX;var z=S.positionY-N.positionY;
if(0==A&&0==z){return}var E=d(N,A,z);var D=d(S,-1*A,-1*z);var J=D.x-E.x;var H=D.y-E.y;var O=Math.sqrt(J*J+H*H);var B=Math.pow(K.idealLength-O,2)/G.edgeElasticity;if(0!=O){var I=B*J/O;var F=B*H/O}else{var I=0;var F=0}N.offsetX+=I;N.offsetY+=F;S.offsetX-=I;S.offsetY-=F;var L="Edge force between nodes "+N.id+" and "+S.id;L+="\nDistance: "+O+" Force: ("+I+", "+F+")";r(L)}}function q(L,A,D){var K="calculateGravityForces";r(K);for(var P=0;P<L.graphSet.length;P++){var z=L.graphSet[P];var M=z.length;K="Set: "+z.toString();
r(K);if(0==P){var J=A.container();var F=J.clientHeight/2;var E=J.clientWidth/2}else{var Q=L.layoutNodes[L.idToIndex[z[0]]];var G=L.layoutNodes[L.idToIndex[Q.parentId]];var F=G.positionX;var E=G.positionY}K="Center found at: "+F+", "+E;r(K);for(var O=0;O<M;O++){var N=L.layoutNodes[L.idToIndex[z[O]]];K="Node: "+N.id;var I=F-N.positionX;var H=E-N.positionY;var R=Math.sqrt(I*I+H*H);if(R>1){var C=D.gravity*I/R;var B=D.gravity*H/R;N.offsetX+=C;N.offsetY+=B;K+=": Applied force: "+C+", "+B}else{K+=": skypped since it's too close to center"
}r(K)}}}function p(G,E,N){var J=[];var A=0;var H=-1;r("propagateForces");J.push.apply(J,G.graphSet[0]);H+=G.graphSet[0].length;while(A<=H){var C=J[A++];var F=G.idToIndex[C];var D=G.layoutNodes[F];var B=D.children;if(0<B.length){var L=D.offsetX;var K=D.offsetY;var M="Propagating offset from parent node : "+D.id+". OffsetX: "+L+". OffsetY: "+K;M+="\n Children: "+B.toString();r(M);for(var I=0;I<B.length;I++){var z=G.layoutNodes[G.idToIndex[B[I]]];z.offsetX+=L;z.offsetY+=K;J[++H]=B[I]}D.offsetX=0;D.offsetY=0
}}}function g(D,F,z){var C="Updating positions";r(C);for(var A=0;A<D.nodeSize;A++){var E=D.layoutNodes[A];if(0<E.children.length){r("Resetting boundaries of compound node: "+E.id);E.maxX=undefined;E.minX=undefined;E.maxY=undefined;E.minY=undefined}}for(var A=0;A<D.nodeSize;A++){var E=D.layoutNodes[A];if(0<E.children.length){r("Skipping position update of node: "+E.id);continue}C="Node: "+E.id+" Previous position: ("+E.positionX+", "+E.positionY+").";var B=u(E.offsetX,E.offsetY,D.temperature);E.positionX+=B.x;
E.positionY+=B.y;E.offsetX=0;E.offsetY=0;E.minX=E.positionX-E.width;E.maxX=E.positionX+E.width;E.minY=E.positionY-E.height;E.maxY=E.positionY+E.height;C+=" New Position: ("+E.positionX+", "+E.positionY+").";r(C);m(E,D)}for(var A=0;A<D.nodeSize;A++){var E=D.layoutNodes[A];if(0<E.children.length){E.positionX=(E.maxX+E.minX)/2;E.positionY=(E.maxY+E.minY)/2;E.width=E.maxX-E.minX;E.height=E.maxY-E.minY;C="Updating position, size of compound node "+E.id;C+="\nPositionX: "+E.positionX+", PositionY: "+E.positionY;
C+="\nWidth: "+E.width+", Height: "+E.height;r(C)}}}function u(E,C,z){var B="Limiting force: ("+E+", "+C+"). Max: "+z;var D=Math.sqrt(E*E+C*C);if(D>z){var A={x:z*E/D,y:z*C/D}}else{var A={x:E,y:C}}B+=".\nResult: ("+A.x+", "+A.y+")";r(B);return A}function m(B,D){var A="Propagating new position/size of node "+B.id;var E=B.parentId;if(undefined==E){A+=". No parent node.";r(A);return}var C=D.layoutNodes[D.idToIndex[E]];var z=false;if(undefined==C.maxX||B.maxX+C.padRight>C.maxX){C.maxX=B.maxX+C.padRight;
z=true;A+="\nNew maxX for parent node "+C.id+": "+C.maxX}if(undefined==C.minX||B.minX-C.padLeft<C.minX){C.minX=B.minX-C.padLeft;z=true;A+="\nNew minX for parent node "+C.id+": "+C.minX}if(undefined==C.maxY||B.maxY+C.padBottom>C.maxY){C.maxY=B.maxY+C.padBottom;z=true;A+="\nNew maxY for parent node "+C.id+": "+C.maxY}if(undefined==C.minY||B.minY-C.padTop<C.minY){C.minY=B.minY-C.padTop;z=true;A+="\nNew minY for parent node "+C.id+": "+C.minY}if(z){r(A);return m(C,D)}A+=". No changes in boundaries/position of parent node "+C.id;
r(A);return}function r(z){if(DEBUG){console.debug(z)}}h("layout","cose",a)})(cytoscape);